/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.components.pfd.PFDGroup;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.interfaces.PFDButtonCollection;
import java.util.Hashtable;

public class PFDButtonGroup
extends PFDGroup
implements PFDButtonCollection {
    private int innerButtonSpace = 4;

    public PFDButtonGroup() {
        this.setEditable(true);
        this.setDraggable(false);
        this.setSelectable(false);
        this.setResizable(false);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public void addButton(PFDAbstractButton button) {
        this.addPrimitive(button);
    }

    @Override
    public void addButton(int index, PFDAbstractButton button) {
        this.addPrimitive(index, button);
    }

    @Override
    public boolean removeButton(PFDAbstractButton button) {
        return this.removePrimitive(button);
    }

    @Override
    public PFDAbstractButton removeButton(int index) {
        return (PFDAbstractButton)this.removePrimitive(index);
    }

    @Override
    public void removeAllButtons() {
        this.removeAllPrimitives();
    }

    @Override
    public PFDAbstractButton getButton(int index) {
        return (PFDAbstractButton)this.getPrimitive(index);
    }

    @Override
    public boolean containsButton(PFDAbstractButton button) {
        return this.containsPrimitive(button);
    }

    @Override
    public int indexOfButton(PFDAbstractButton button) {
        return this.indexOfPrimitive(button);
    }

    @Override
    public int getNumButtons() {
        return this.getNumPrimitives();
    }

    @Override
    protected void update(String property, PFDView v) {
        if (property.equals("all") || property.equals("children")) {
            this.layoutButtons();
            if (this.getGroup() != null) {
                this.getGroup().firePropertyChange("children");
            }
        }
        super.update(property, v);
    }

    private void layoutButtons() {
        int x = this.bbox.x;
        int y = this.bbox.y;
        for (int i = 0; i < this.children.size(); ++i) {
            PFDAbstractButton button = (PFDAbstractButton)this.children.elementAt(i);
            button.setLocation(x, y);
            x += button.getRBBox().width + this.innerButtonSpace;
        }
        this.calculateBBox();
    }

    public int getButtonSpacing() {
        return this.innerButtonSpace;
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDButtonGroup clone = new PFDButtonGroup();
        table.put(this, clone);
        this.copyObject(clone);
        for (int i = 0; i < this.children.size(); ++i) {
            PFDPrimitive p = (PFDPrimitive)this.children.elementAt(i);
            PFDPrimitive np = (PFDPrimitive)p.cloneObject(table);
            clone.addPrimitive(np);
        }
        clone.calculateBBox();
        return clone;
    }

    public void copyObject(PFDButtonGroup toObject) {
        super.copyObject(toObject);
    }
}

