/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDAbstractButton;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PFDButton
extends PFDAbstractButton
implements PropertyInterface {
    protected transient PropertyList pending = new PropertyList();
    private static final long serialVersionUID = 1979632578790057059L;

    @Override
    public void setLocation(int x, int y) {
        this.icon.setLocation(x, y);
        Rectangle bounds = this.icon.getRBBox();
        int cx = bounds.x + bounds.width / 2;
        int cy = bounds.y + bounds.height / 2;
        bounds = this.rolloverIcon.getRBBox();
        int mox = cx - bounds.width / 2;
        int moy = cy - bounds.width / 2;
        this.rolloverIcon.setLocation(mox, moy);
        this.calculateBBox();
        this.firePropertyChange("bbox");
    }

    @Override
    protected void calculateBBox() {
        this.bbox.setBounds(this.icon.getRBBox());
        this.oldVisualBBox.setBounds(this.visualBBox);
        this.visualBBox.setBounds(this.icon.getVisualRBBox().union(this.rolloverIcon.getVisualRBBox()));
        this.bboxDirty = false;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.icon.isVisible()) {
            return this.icon.contains(x, y);
        }
        return this.rolloverIcon.contains(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
        if (this.enabled) {
            this.theView.setCursor(5);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.theView.getDragMode() != 9) {
            return;
        }
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
        if (this.enabled) {
            this.theView.setCursor(5);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
        int mouseMode = this.theView.getMouseExtendedMode();
        if (mouseMode == 4) {
            this.theView.clearSelections();
        }
        if (this.enabled) {
            this.theView.setCursor(5);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.theView.setMouseOverPrimitive(this, e);
        int mouseMode = this.theView.getMouseExtendedMode();
        if (this.enabled && mouseMode != 4) {
            this.theView.setCursor(5);
            ActionEvent ae = new ActionEvent(this, 1001, this.actionCommand, e.getModifiers());
            this.fireActionPerformed(ae);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.rolloverEnabled && this.rolloverIcon.getIcon() != null) {
            this.icon.setVisible(false);
            this.rolloverIcon.setVisible(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.icon.isVisible()) {
            this.icon.setVisible(true);
            this.rolloverIcon.setVisible(false);
        }
    }

    @Override
    public Object cloneObject(Hashtable table) {
        PFDButton clone = new PFDButton();
        table.put(this, clone);
        this.copyObject(clone);
        return clone;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        boolean rc = true;
        Vector changes = this.pending.getChangesBySource(source);
        if (changes.size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        switch (id) {
            case 800: {
                return this.icon.getResourceLocation();
            }
            case 801: {
                return this.rolloverIcon.getResourceLocation();
            }
            case 802: {
                return this.getToolTipText();
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean userSet = false;
        switch (id) {
            case 800: 
            case 801: 
            case 802: {
                userSet = true;
            }
        }
        return userSet;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 800: 
            case 801: 
            case 802: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.isPropertySupported(id)) {
            return this.pending.store(id, value);
        }
        return false;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 800: {
                URL imgURL;
                if (value instanceof Icon) {
                    this.setIcon((Icon)value);
                    break;
                }
                if (!(value instanceof String) || (imgURL = this.getClass().getResource((String)value)) == null) break;
                ImageIcon newIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));
                this.icon.setResourceLocation((String)value);
                this.setIcon(newIcon);
                break;
            }
            case 801: {
                URL imgURL;
                if (value instanceof Icon) {
                    this.setIcon((Icon)value);
                    break;
                }
                if (!(value instanceof String) || (imgURL = this.getClass().getResource((String)value)) == null) break;
                ImageIcon newIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL));
                this.rolloverIcon.setResourceLocation((String)value);
                this.setRolloverIcon(newIcon);
                this.setRolloverEnabled(true);
                break;
            }
            case 802: {
                if (!(value instanceof String)) break;
                this.setToolTipText((String)value);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pending = new PropertyList();
    }
}

