/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pfd;

import com.sas.graphics.components.pfd.PFDUtil;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.graphics.components.pfd.PFDViewEvent;
import com.sas.graphics.components.pfd.interfaces.PFDAnnotateInterface;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.styles.Style;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PFDAnnotate
implements Annotatable,
PFDAnnotateInterface,
PropertyChangeListener {
    protected static JToolBar annotationToolBar;
    protected PFDView view;
    protected JComponent annotateComponent;
    protected Document document = null;
    protected Annotate annotate;
    protected MouseListener[] mouseListeners;
    protected MouseMotionListener[] mouseMotionListeners;
    private Point prevMousePoint = new Point();
    private Rectangle annoBounds = new Rectangle();
    private boolean boundsDirty = false;
    private boolean useToolbar = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PFDAnnotate() {
    }

    public PFDAnnotate(PFDView v) {
        this();
        this.setView(v);
    }

    @Override
    public void setUseToolbar(boolean b) {
        this.useToolbar = b;
    }

    @Override
    public Object getAnnotateObject() {
        return this.annotate;
    }

    @Override
    public void clearSelections() {
        if (this.annotate != null) {
            this.annotate.unSelectAll();
        }
    }

    @Override
    public void setView(PFDView v) {
        if (v == this.view) {
            return;
        }
        this.view = v;
        this.initAnnotate();
    }

    @Override
    public void setAnnotateComponent(JComponent c) {
        if (c == this.annotateComponent) {
            return;
        }
        this.annotateComponent = c;
        this.initAnnotate();
    }

    @Override
    public void dispose() {
        if (this.annotate != null) {
            if (annotationToolBar != null && this.useToolbar) {
                Annotate.removeAnnotateFromToolBar((JToolBar)annotationToolBar, (Annotate)this.annotate);
            }
            this.annotate = null;
        }
        this.view = null;
        this.annotateComponent = null;
        this.document = null;
        this.prevMousePoint = null;
        this.annoBounds = null;
        if (this.propertyChangeSupport != null) {
            PropertyChangeListener[] listeners = this.propertyChangeSupport.getPropertyChangeListeners();
            for (int i = 0; i < listeners.length; ++i) {
                this.propertyChangeSupport.removePropertyChangeListener(listeners[i]);
            }
            this.propertyChangeSupport = null;
        }
    }

    @Override
    public JToolBar getAnnotationToolBar() {
        if (annotationToolBar == null) {
            annotationToolBar = new JToolBar();
            Annotate.addAnnotateMenuToToolbar((JToolBar)annotationToolBar, null);
        }
        return annotationToolBar;
    }

    private void initAnnotate() {
        if (this.annotate != null) {
            return;
        }
        if (this.view == null || this.annotateComponent == null) {
            return;
        }
        if (this.document == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = factory.newDocumentBuilder();
                this.document = db.newDocument();
                Element e = this.document.createElement("Annotation");
                this.document.appendChild(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.annotate = new Annotate((BaseAnnotatable)this);
        this.annotate.setInsertPopupEnabled(false);
        this.annotate.setImageAttachToDataEnabled(true);
        this.annotate.setClipToScreenEnabled(false);
        this.annotate.setContainer(this.annotateComponent);
        this.annotate.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.useToolbar) {
            Annotate.addAnnotateToToolBar((JToolBar)this.getAnnotationToolBar(), (Annotate)this.annotate);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.transform(this.view.getCurrentXfm());
        this.annotate.paint(g);
        if (this.boundsDirty) {
            this.boundsDirty = false;
            this.cropAnnotateBounds();
        }
    }

    @Override
    public void setDirty() {
        this.annotate.setDirty();
    }

    @Override
    public Element getAnnotationElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public void readFromXML(Element e) {
        Element current = this.getAnnotationElement();
        NodeList children = e.getChildNodes();
        int num = children.getLength();
        for (int i = 0; i < num; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Node e2 = this.document.importNode(child, true);
            current.appendChild(e2);
        }
        this.boundsDirty = true;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.annotate == null) {
            return false;
        }
        Point p = new Point(x, y);
        this.view.ViewToModel(p);
        return this.annotate.isAnnotateElementAt(p.x, p.y);
    }

    @Override
    public boolean isInSelectMode() {
        if (this.annotate == null) {
            return false;
        }
        return this.annotate.getType() == -1;
    }

    public Point2D convertDataToScreen(String overlayID, Object[] data) {
        if (overlayID == null) {
            return null;
        }
        if (data != null && data.length == 2 && data[0] instanceof Double && data[1] instanceof Double) {
            Point dataPoint = new Point(((Double)data[0]).intValue(), ((Double)data[1]).intValue());
            return dataPoint;
        }
        return null;
    }

    public Object[] convertScreenToData(String overlayID, Point2D p, Object[] data) {
        if (overlayID == null || p == null) {
            return null;
        }
        if (data == null || data.length != 2) {
            data = new Object[]{new Double(p.getX()), new Double(p.getY())};
        }
        return data;
    }

    public String getGraphIDAt(int x, int y) {
        return this.view.toString();
    }

    public Rectangle getDataBoundingBox(String id) {
        Rectangle bounds = new Rectangle();
        bounds.setSize(this.view.getDocumentSize());
        return bounds;
    }

    public Style getStyle() {
        return null;
    }

    public int getDPI() {
        return 0;
    }

    public double getDPIScaleFactor() {
        return 100.0;
    }

    public Dimension getAnnotationSize() {
        return this.view.getSize();
    }

    public void annotateRepaint() {
        this.annotateComponent.repaint();
    }

    public Document getDocument() {
        return this.document;
    }

    public FontRenderContext getFontRenderContext() {
        Graphics g = null;
        if (this.annotateComponent != null) {
            g = this.annotateComponent.getGraphics();
        }
        if (g instanceof Graphics2D) {
            return ((Graphics2D)g).getFontRenderContext();
        }
        return PFDUtil.getFontRenderContext();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevMousePoint.setLocation(e.getX(), e.getY());
        if (this.isInSelectMode() && !e.isControlDown()) {
            this.view.annotateClear(this);
        }
        this.annotate.mousePressed(this.transformMouseEvent(e));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.annotate.mouseReleased(this.transformMouseEvent(this.clipMouseEvent(e)));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.annotate.mouseClicked(this.transformMouseEvent(e));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.annotate.mouseEntered(this.transformMouseEvent(e));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.annotate.mouseExited(this.transformMouseEvent(e));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.view.calculateDragMovement(this.prevMousePoint, e.getPoint(), false);
        Point viewPos = this.view.getViewPosition();
        Point scrollPos = this.view.getViewScrollPosition();
        Dimension scrollDist = new Dimension(scrollPos.x - viewPos.x, scrollPos.y - viewPos.y);
        this.view.ModelToView(scrollDist);
        this.annotate.setDataValuesDirty();
        this.annotate.mouseDragged(this.transformMouseEvent(this.clipMouseEvent(e, scrollDist)));
        Object selectedElement = this.annotate.getAnnotateElementSelected();
        if (selectedElement != null) {
            this.updateAnnotateBounds(this.annotate.getAnnotateElementBounds(selectedElement));
        }
        this.view.firePFDViewChanged(new PFDViewEvent(this.view, 11, "autoscroll"));
        this.prevMousePoint.setLocation(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.annotate.mouseMoved(this.transformMouseEvent(e));
    }

    private MouseEvent transformMouseEvent(MouseEvent e) {
        Point p = e.getPoint();
        this.view.ViewToModel(p);
        MouseEvent transformedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return transformedEvent;
    }

    private MouseEvent clipMouseEvent(MouseEvent e) {
        return this.clipMouseEvent(e, null);
    }

    private MouseEvent clipMouseEvent(MouseEvent e, Dimension delta) {
        int x = Math.min(this.annotateComponent.getWidth() - 1, Math.max(0, e.getX()));
        int y = Math.min(this.annotateComponent.getHeight() - 1, Math.max(0, e.getY()));
        if (x == e.getX() && y == e.getY()) {
            return e;
        }
        if (delta != null) {
            x += delta.width;
            y += delta.height;
        }
        MouseEvent clippedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return clippedEvent;
    }

    @Override
    public Rectangle getAnnotateBounds() {
        return this.annoBounds;
    }

    private void updateAnnotateBounds(Rectangle2D bounds) {
        if (bounds == null) {
            return;
        }
        if (this.annoBounds.contains(bounds)) {
            return;
        }
        this.annoBounds.add(bounds);
        this.propertyChangeSupport.firePropertyChange("annotateBounds", null, null);
    }

    @Override
    public void cropAnnotateBounds() {
        Rectangle2D newBounds = this.annotate.getBounds();
        if (newBounds != null) {
            this.annoBounds.setFrame(newBounds);
        }
        this.propertyChangeSupport.firePropertyChange("annotateBounds", null, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("add")) {
            Object element = evt.getNewValue();
            Rectangle2D bounds = this.annotate.getAnnotateElementBounds(element);
            this.updateAnnotateBounds(bounds);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

