/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.util;

import com.sas.visuals.util.XMLAnyTag;
import com.sas.visuals.util.XMLButton;
import com.sas.visuals.util.XMLButtonAction;
import com.sas.visuals.util.XMLButtonGroup;
import com.sas.visuals.util.XMLDynamicItem;
import com.sas.visuals.util.XMLHelpListener;
import com.sas.visuals.util.XMLRadioButtonToolItem;
import com.sas.visuals.util.XMLResourceLocator;
import com.sas.visuals.util.XMLToolBar;
import com.sas.visuals.util.XMLToolParent;
import com.sas.visuals.util.XMLToolSeparator;
import com.sas.visuals.util.XMLTrickToolBar;
import com.sas.visuals.util.XMLVisualRuntimeException;
import java.awt.Component;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLToolFactory {
    private static DocumentBuilder docBuilder = null;
    private JToolBar toolBar = null;
    private XMLHelpListener ctrlObject = null;
    private XMLResourceLocator imageLocator = null;
    private XMLResourceLocator xmlLocator = null;
    ArrayList buttonList = null;
    Vector groupList = new Vector();
    ArrayList dynamicToolItemList = new ArrayList();

    public XMLToolFactory(URL stream, XMLResourceLocator iLocator, XMLResourceLocator xLocator, JToolBar tb, XMLHelpListener c) throws IOException, ParserConfigurationException, SAXException {
        this.toolBar = tb;
        this.ctrlObject = c;
        this.imageLocator = iLocator;
        this.xmlLocator = xLocator;
        this.buttonList = new ArrayList();
        this.parseXMLStream(stream, (XMLToolParent)((Object)this.toolBar));
    }

    public ArrayList getToolList() {
        return this.buttonList;
    }

    private void parseXMLStream(URL xmlStream, XMLToolParent logicalParent) throws IOException, SAXException, ParserConfigurationException {
        XMLToolBar t = (XMLToolBar)this.toolBar;
        int style = t.getToolbarStyle();
        this.setupDocumentBuilder();
        String itemId = null;
        String icon = null;
        String help = null;
        String tip = null;
        String command = null;
        Document doc = XMLToolFactory.parseXML(xmlStream);
        NodeList myNodeList = doc.getFirstChild().getChildNodes();
        block5: for (int i = 0; i < myNodeList.getLength(); ++i) {
            Node n = myNodeList.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    if (n.getNodeName().equalsIgnoreCase("toolitem")) {
                        AbstractButton b;
                        NodeList nodeList = n.getChildNodes();
                        command = null;
                        help = null;
                        icon = null;
                        tip = null;
                        itemId = null;
                        String text = null;
                        String visible = null;
                        String state = null;
                        String selected = null;
                        String transdesc = null;
                        String mnemonic = null;
                        String radiogroup = null;
                        String accessiblename = null;
                        String accessibledesc = null;
                        boolean toggleButton = false;
                        ArrayList<XMLAnyTag> anytagList = new ArrayList<XMLAnyTag>();
                        for (int j = 0; j < nodeList.getLength(); ++j) {
                            Node toolItemNode = nodeList.item(j);
                            if (null == toolItemNode.getChildNodes().item(0)) {
                                if (!toolItemNode.getNodeName().equalsIgnoreCase("togglebutton")) continue;
                                toggleButton = true;
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("togglebutton")) {
                                String box = null;
                                box = toolItemNode.getChildNodes().item(0).getNodeValue();
                                if ((box = box.trim()).equalsIgnoreCase("true")) {
                                    toggleButton = true;
                                    continue;
                                }
                                if (box.equalsIgnoreCase("false")) {
                                    toggleButton = false;
                                    continue;
                                }
                                toggleButton = true;
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("command")) {
                                command = toolItemNode.getChildNodes().item(0).getNodeValue();
                                command = command.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("icon")) {
                                icon = toolItemNode.getChildNodes().item(0).getNodeValue();
                                icon = icon.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("text")) {
                                text = toolItemNode.getChildNodes().item(0).getNodeValue();
                                text = text.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("help")) {
                                help = toolItemNode.getChildNodes().item(0).getNodeValue();
                                help = help.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("tip")) {
                                tip = toolItemNode.getChildNodes().item(0).getNodeValue();
                                tip = tip.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("itemid")) {
                                itemId = toolItemNode.getChildNodes().item(0).getNodeValue();
                                itemId = itemId.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("enabled")) {
                                state = toolItemNode.getChildNodes().item(0).getNodeValue();
                                if ((state = state.trim()).equalsIgnoreCase("true") || state.equalsIgnoreCase("false")) continue;
                                System.out.println(state + " not valid value for " + toolItemNode.getNodeName());
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("visible")) {
                                visible = toolItemNode.getChildNodes().item(0).getNodeValue();
                                if ((visible = visible.trim()).equalsIgnoreCase("true") || visible.equalsIgnoreCase("false")) continue;
                                System.out.println(visible + " not valid value for " + toolItemNode.getNodeName());
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("selected")) {
                                selected = toolItemNode.getChildNodes().item(0).getNodeValue();
                                if ((selected = selected.trim()).equalsIgnoreCase("true") || selected.equalsIgnoreCase("false")) continue;
                                System.out.println(selected + " not valid value for " + toolItemNode.getNodeName());
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("transdesc")) {
                                transdesc = toolItemNode.getChildNodes().item(0).getNodeValue();
                                if ((transdesc = transdesc.trim()) != null && (transdesc == null || !transdesc.equalsIgnoreCase(""))) continue;
                                System.out.println(toolItemNode.getNodeName() + " must have a value describing the function of this item for the translators.");
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("mnemonic")) {
                                mnemonic = toolItemNode.getChildNodes().item(0).getNodeValue();
                                mnemonic = mnemonic.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("radiogroup")) {
                                radiogroup = toolItemNode.getChildNodes().item(0).getNodeValue();
                                radiogroup = radiogroup.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("accessiblename")) {
                                accessiblename = toolItemNode.getChildNodes().item(0).getNodeValue();
                                accessiblename = accessiblename.trim();
                                continue;
                            }
                            if (toolItemNode.getNodeName().equalsIgnoreCase("accessibledesc")) {
                                accessibledesc = toolItemNode.getChildNodes().item(0).getNodeValue();
                                accessibledesc = accessibledesc.trim();
                                continue;
                            }
                            String anytag = toolItemNode.getNodeName();
                            String anytagvalue = toolItemNode.getChildNodes().item(0).getNodeValue();
                            anytagvalue = anytagvalue.trim();
                            XMLAnyTag a = new XMLAnyTag(anytag, anytagvalue);
                            anytagList.add(a);
                        }
                        if (command == null || icon == null && text == null || transdesc == null) {
                            if (command == null) {
                                System.out.println("A <command> tag is required on each tool item.");
                            }
                            if (transdesc == null) {
                                System.out.println("A <transdesc> tag is required on each tool item.");
                            }
                            if (icon != null) continue block5;
                            System.out.println("An <icon> or <text> tag is required on each tool item.");
                            continue block5;
                        }
                        if (accessiblename == null) {
                            accessiblename = tip;
                        }
                        if (accessibledesc == null) {
                            accessibledesc = help;
                        }
                        AbstractButton btn = null;
                        AbstractButton btnB = null;
                        ImageIcon ic = this.loadIcon(icon);
                        if (radiogroup != null || toggleButton) {
                            b = new XMLRadioButtonToolItem(command, help, tip, itemId, ic);
                            b.setFocusPainted(false);
                            if (style == 1) {
                                // empty if block
                            }
                            btn = b;
                            btnB = b;
                            ((XMLRadioButtonToolItem)b).addHelpListener(this.ctrlObject);
                            ((XMLRadioButtonToolItem)b).setXMLTag(anytagList);
                            if (radiogroup == null) {
                                if (selected != null && selected.equalsIgnoreCase("true")) {
                                    b.setSelected(true);
                                }
                            } else {
                                boolean found = false;
                                for (int k = 0; k < this.groupList.size() && !found; ++k) {
                                    if (!((XMLButtonGroup)this.groupList.get(k)).getName().equalsIgnoreCase(radiogroup)) continue;
                                    ((XMLButtonGroup)this.groupList.get(k)).add(b);
                                    if (selected != null && selected.equalsIgnoreCase("true")) {
                                        ((XMLButtonGroup)this.groupList.get(k)).getBtnGroup().setSelected(btnB.getModel(), true);
                                    }
                                    found = true;
                                }
                                if (!found) {
                                    XMLButtonGroup group = new XMLButtonGroup(radiogroup);
                                    group.add(btnB);
                                    if (selected != null && selected.equalsIgnoreCase("true")) {
                                        group.getBtnGroup().setSelected(b.getModel(), true);
                                    }
                                    this.groupList.add(group);
                                }
                            }
                        } else {
                            b = new XMLButton(command, help, tip, itemId, ic);
                            b.setFocusPainted(false);
                            if (style == 1) {
                                // empty if block
                            }
                            btn = b;
                            btnB = b;
                            ((XMLButton)b).addHelpListener(this.ctrlObject);
                            ((XMLButton)b).setXMLTag(anytagList);
                        }
                        if (visible != null && visible.equalsIgnoreCase("false")) {
                            btnB.setVisible(false);
                        }
                        if (state != null && state.equalsIgnoreCase("false")) {
                            btnB.setEnabled(false);
                        }
                        if (selected != null && selected.equalsIgnoreCase("false")) {
                            btnB.setSelected(false);
                        }
                        if (text != null) {
                            btnB.setText(text);
                        }
                        if (icon != null) {
                            btn.setIconTag(icon);
                        }
                        if (transdesc != null) {
                            btn.setTransDesc(transdesc);
                        }
                        if (text != null && icon != null) {
                            btnB.setHorizontalTextPosition(0);
                            btnB.setVerticalTextPosition(3);
                        }
                        if (mnemonic != null) {
                            try {
                                btnB.setMnemonic(Integer.parseInt(mnemonic));
                            }
                            catch (NumberFormatException numEx) {
                                if (mnemonic.length() == 1) {
                                    btnB.setMnemonic(mnemonic.charAt(0));
                                }
                                if (mnemonic.length() == 4 && mnemonic.substring(0, 3).equalsIgnoreCase("VK_")) {
                                    btnB.setMnemonic(mnemonic.charAt(3));
                                }
                                System.out.println("Mnemonic " + mnemonic + " is not valid.");
                            }
                        }
                        btnB.setMargin(new Insets(0, 0, 0, 0));
                        btnB.addActionListener(new XMLButtonAction(this.ctrlObject, command));
                        AccessibleContext aCtxt = btnB.getAccessibleContext();
                        if (aCtxt != null) {
                            if (accessiblename != null) {
                                aCtxt.setAccessibleName(accessiblename);
                            }
                            if (accessibledesc != null) {
                                aCtxt.setAccessibleDescription(accessibledesc);
                            }
                        }
                        logicalParent.addItem(btnB);
                        this.buttonList.add(btn);
                        continue block5;
                    }
                    if (n.getNodeName().equalsIgnoreCase("separator")) {
                        String visible = null;
                        NodeList nodeList = n.getChildNodes();
                        itemId = null;
                        for (int j = 0; j < nodeList.getLength(); ++j) {
                            Node toolItemNode = nodeList.item(j);
                            if (toolItemNode.getNodeName().equalsIgnoreCase("itemid")) {
                                itemId = toolItemNode.getChildNodes().item(0).getNodeValue();
                                itemId = itemId.trim();
                                continue;
                            }
                            if (!toolItemNode.getNodeName().equalsIgnoreCase("visible")) continue;
                            visible = toolItemNode.getChildNodes().item(0).getNodeValue();
                            visible = visible.trim();
                        }
                        XMLToolSeparator sep = new XMLToolSeparator(itemId, style);
                        if (visible != null && visible.equals("false")) {
                            sep.setVisible(false);
                        }
                        logicalParent.addItem(sep);
                        this.buttonList.add(sep);
                        continue block5;
                    }
                    if (n.getNodeName().equalsIgnoreCase("dynamictool")) {
                        boolean found = false;
                        String dyn = n.getChildNodes().item(0).getNodeValue();
                        dyn = dyn.trim();
                        for (int k = 0; k < this.dynamicToolItemList.size(); ++k) {
                            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(k);
                            if (!d.getDynamicId().equalsIgnoreCase(dyn)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            System.out.println("The <dynamictool> tag must be unique for each tool bar.");
                            System.out.println("<dynamictool> tag " + dyn + " is a duplicate name.");
                            continue block5;
                        }
                        XMLDynamicItem dynamicTool = new XMLDynamicItem(dyn, this.toolBar.getComponentCount());
                        this.dynamicToolItemList.add(dynamicTool);
                        continue block5;
                    }
                    if (!n.getNodeName().equalsIgnoreCase("isubtoolbar")) continue block5;
                    String xmlSource = n.getChildNodes().item(0).getNodeValue();
                    xmlSource = xmlSource.trim();
                    URL url = this.xmlLocator.getResource(xmlSource);
                    this.parseXMLStream(url, logicalParent);
                }
            }
        }
    }

    private static Document parseXML(URL inStream) throws SAXException, IOException {
        Document doc = null;
        doc = docBuilder.parse(inStream.openStream());
        return doc;
    }

    private void setupDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        docBuilder = dbf.newDocumentBuilder();
    }

    private static String getAttribute(String attributeName, NamedNodeMap node) {
        String returnValue = null;
        try {
            returnValue = node.getNamedItem(attributeName).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    private ImageIcon loadIcon(String icName) throws IOException {
        ImageIcon ic = null;
        URL icURL = null;
        if (this.imageLocator != null) {
            icURL = this.imageLocator.getResource(icName);
        }
        if (icURL != null) {
            ic = new ImageIcon(icURL);
        }
        return ic;
    }

    public void addDynamicTool(String dynamicId, Component toolItem) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            index += d.getIndex();
            if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
            this.toolBar.add(toolItem, d.getPosition() + index);
            d.setIndex(d.getIndex() + 1);
            return;
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void addDynamicTool(String dynamicId, String xmlStream) throws IOException, ParserConfigurationException, SAXException, XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            index += d.getIndex();
            if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
            XMLTrickToolBar trickBar = new XMLTrickToolBar((XMLToolBar)this.toolBar, dynamicId, d.getPosition() + index);
            this.parseXMLStream(this.xmlLocator.getResource(xmlStream), trickBar);
            return;
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void addDynamicTool(String dynamicId, Component toolItem, int pos) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                if (pos < d.getIndex()) {
                    this.toolBar.add(toolItem, d.getPosition() + index + pos);
                } else {
                    this.toolBar.add(toolItem, d.getPosition() + index);
                }
                d.setIndex(d.getIndex() + 1);
                return;
            }
            index += d.getIndex();
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void removeDynamicTool(String dynamicId) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    this.removeTool(this.toolBar.getComponent(d.getPosition() + index + h - 1));
                    this.toolBar.remove(d.getPosition() + index + h - 1);
                    d.setIndex(d.getIndex() - 1);
                }
                return;
            }
            index += d.getIndex();
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void removeDynamicTool(String dynamicId, JComponent component) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    JComponent jc = (JComponent)this.toolBar.getComponent(d.getPosition() + index + h - 1);
                    if (!jc.equals(component)) continue;
                    this.removeTool(jc);
                    this.toolBar.remove(d.getPosition() + index + h - 1);
                    d.setIndex(d.getIndex() - 1);
                    return;
                }
            }
            index += d.getIndex();
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public int getDynamicToolPos(String dynamicId, JComponent component) {
        int index = 0;
        for (int i = 0; i < this.dynamicToolItemList.size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)this.dynamicToolItemList.get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    JComponent jc = (JComponent)this.toolBar.getComponent(d.getPosition() + index + h - 1);
                    if (!jc.equals(component)) continue;
                    return h - 1;
                }
            }
            index += d.getIndex();
        }
        return -1;
    }

    private void removeTool(Object tool) {
        this.buttonList.remove(tool);
    }
}

