/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.util;

import com.sas.visuals.util.XMLCommandEvent;
import com.sas.visuals.util.XMLCommandListener;
import com.sas.visuals.util.XMLHelpEvent;
import com.sas.visuals.util.XMLHelpListener;
import com.sas.visuals.util.XMLMenu;
import com.sas.visuals.util.XMLMenuFactory;
import com.sas.visuals.util.XMLMenuItem;
import com.sas.visuals.util.XMLMenuParent;
import com.sas.visuals.util.XMLResourceLocator;
import com.sas.visuals.util.XMLSimpleLocator;
import com.sas.visuals.util.XMLUtility;
import com.sas.visuals.util.XMLVisualException;
import com.sas.visuals.util.XMLVisualRuntimeException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class XMLPopupMenu
extends JPopupMenu
implements XMLHelpListener,
XMLMenuParent {
    XMLMenuFactory menuFactory = null;
    EventListenerList listenerList = new EventListenerList();
    ArrayList dynamicMenuItemList = new ArrayList();
    int popupStyle = 0;

    public XMLPopupMenu(String xmlFile, String xmlPath, String imgPath) throws XMLVisualException {
        try {
            this.menuFactory = new XMLMenuFactory(XMLUtility.urlFromFile(xmlFile), new XMLSimpleLocator(imgPath), new XMLSimpleLocator(xmlPath), this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLPopupMenu(String xmlFile, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator) throws XMLVisualException {
        try {
            this.menuFactory = new XMLMenuFactory(XMLUtility.urlFromFile(xmlFile), imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLPopupMenu(URL xmlStream, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator) throws XMLVisualException {
        try {
            this.menuFactory = new XMLMenuFactory(xmlStream, imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLPopupMenu(String xmlFile, String xmlPath, String imgPath, int style) throws XMLVisualException {
        try {
            this.popupStyle = style;
            this.menuFactory = new XMLMenuFactory(XMLUtility.urlFromFile(xmlFile), new XMLSimpleLocator(imgPath), new XMLSimpleLocator(xmlPath), this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLPopupMenu(String xmlFile, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator, int style) throws XMLVisualException {
        try {
            this.popupStyle = style;
            this.menuFactory = new XMLMenuFactory(XMLUtility.urlFromFile(xmlFile), imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLPopupMenu(URL xmlStream, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator, int style) throws XMLVisualException {
        try {
            this.popupStyle = style;
            this.menuFactory = new XMLMenuFactory(xmlStream, imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    @Override
    public void displayHelp(XMLHelpEvent e) {
        this.fireHelpListener(e, e.getHelp(), true);
    }

    @Override
    public void unDisplayHelp(XMLHelpEvent e) {
        this.fireHelpListener(e, e.getHelp(), false);
    }

    public void processCommand(ActionEvent e, String cmd) {
        this.fireCommandListener(e, cmd);
    }

    public void addCommandListener(XMLCommandListener l) {
        this.listenerList.add(XMLCommandListener.class, l);
    }

    public void removeCommandListener(XMLCommandListener l) {
        this.listenerList.remove(XMLCommandListener.class, l);
    }

    protected void fireCommandListener(ActionEvent e, String cmd) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLCommandListener.class) continue;
            XMLCommandEvent ce = new XMLCommandEvent(e.getSource(), 0, cmd);
            ((XMLCommandListener)listeners[i + 1]).processCommand(ce);
        }
    }

    protected void fireHelpListener(ActionEvent e, String help, boolean display) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLHelpListener.class) continue;
            XMLHelpEvent helpEvent = new XMLHelpEvent(e.getSource(), 0, help);
            if (display) {
                ((XMLHelpListener)listeners[i + 1]).displayHelp(helpEvent);
                continue;
            }
            ((XMLHelpListener)listeners[i + 1]).unDisplayHelp(helpEvent);
        }
    }

    public void addHelpListener(XMLHelpListener l) {
        this.listenerList.add(XMLHelpListener.class, l);
    }

    public void removeHelpListener(XMLHelpListener l) {
        this.listenerList.remove(XMLHelpListener.class, l);
    }

    public boolean getSelectedItemsState(String itemid) throws XMLVisualRuntimeException {
        ArrayList victor = this.menuFactory.getMenuButtonList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)victor.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(itemid)) continue;
            return menuItem.getState();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public void setSelectedItemsState(String itemid, boolean flag) throws XMLVisualRuntimeException {
        boolean itemFound = false;
        ArrayList victor = this.menuFactory.getMenuButtonList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)victor.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(itemid)) continue;
            menuItem.setState(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
    }

    public boolean getItemsState(String itemid) throws XMLVisualRuntimeException {
        int i;
        ArrayList v = this.menuFactory.getMenuList();
        if (v == null) {
            return false;
        }
        for (i = 0; i < v.size(); ++i) {
            XMLMenu menu = (XMLMenu)v.get(i);
            if (menu.getItemId() == null || !menu.getItemId().equals(itemid)) continue;
            return menu.isEnabled();
        }
        v = this.menuFactory.getMenuButtonList();
        for (i = 0; i < v.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)v.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(itemid)) continue;
            return menuItem.getEnabled();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public void setItemsState(String id, boolean flag) throws XMLVisualRuntimeException {
        int i;
        boolean itemFound = false;
        ArrayList victor = this.menuFactory.getMenuList();
        if (victor == null) {
            return;
        }
        for (i = 0; i < victor.size(); ++i) {
            XMLMenu menu = (XMLMenu)victor.get(i);
            if (menu.getItemId() == null || !menu.getItemId().equals(id)) continue;
            menu.setEnabled(flag);
            itemFound = true;
        }
        victor = this.menuFactory.getMenuButtonList();
        for (i = 0; i < victor.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)victor.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(id)) continue;
            menuItem.setEnabled(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + id + " not found.");
        }
    }

    public ArrayList getMenuItems() {
        return this.menuFactory.getMenuButtonList();
    }

    public ArrayList getMenuItemsById(String itemid) {
        ArrayList<XMLMenuItem> menuItems = new ArrayList<XMLMenuItem>();
        ArrayList victor = this.menuFactory.getMenuButtonList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)victor.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(itemid)) continue;
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    public void addAction(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getMenuItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((AbstractButton)a.get(i)).addActionListener(action);
        }
    }

    public void addActionListener(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getMenuItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLMenuItem)a.get(i)).addActionListener(action);
        }
    }

    public void removeActionListener(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getMenuItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLMenuItem)a.get(i)).removeActionListener(action);
        }
    }

    public void addAction(String itemid, Action action) throws XMLVisualRuntimeException {
        ArrayList a = this.getMenuItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((AbstractButton)a.get(i)).setAction(action);
        }
    }

    public void addDynamicMenuItem(String dynamicId, Component menuItem) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.addDynamicMenuItem((XMLMenuParent)this, dynamicId, menuItem);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    @Override
    public void addDynamicMenuItem(String dynamicId, Component menuItem, int pos) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.addDynamicMenuItem(this, dynamicId, menuItem, pos);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicMenuItem(String dynamicId) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.removeDynamicMenu(this, dynamicId);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicMenuItem(String dynamicId, JComponent component) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.removeDynamicMenuItem(dynamicId, component);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public int getDynamicMenuItemPos(String dynamicId, JComponent component) {
        return this.menuFactory.getDynamicMenuItemPos(dynamicId, component);
    }

    public void addDynamicMenu(String dynamicid, JMenu item, int pos) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.addDynamicMenu(this, dynamicid, item, pos);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicMenu(String dynamicid) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.removeDynamicMenu(this, dynamicid);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicMenu(String dynamicid, JComponent item) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.removeDynamicMenu(this, dynamicid, item);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public int getDynamicMenuPos(String dynamicid, JComponent item) {
        return this.menuFactory.getDynamicMenuPos(this, dynamicid, item);
    }

    public void setItemsVisible(String id, boolean flag) throws XMLVisualRuntimeException {
        int i;
        boolean itemFound = false;
        ArrayList victor = this.menuFactory.getMenuList();
        if (victor == null) {
            return;
        }
        for (i = 0; i < victor.size(); ++i) {
            XMLMenu menu = (XMLMenu)victor.get(i);
            if (menu.getItemId() == null || !menu.getItemId().equals(id)) continue;
            menu.setVisible(flag);
            itemFound = true;
        }
        victor = this.menuFactory.getMenuButtonList();
        for (i = 0; i < victor.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)victor.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(id)) continue;
            menuItem.setVisible(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + id + " not found.");
        }
    }

    public boolean getItemsVisible(String itemid) throws XMLVisualRuntimeException {
        int i;
        ArrayList v = this.menuFactory.getMenuList();
        if (v == null) {
            return false;
        }
        for (i = 0; i < v.size(); ++i) {
            XMLMenu menu = (XMLMenu)v.get(i);
            if (menu.getItemId() == null || !menu.getItemId().equals(itemid)) continue;
            return menu.isVisible();
        }
        v = this.menuFactory.getMenuButtonList();
        for (i = 0; i < v.size(); ++i) {
            XMLMenuItem menuItem = (XMLMenuItem)v.get(i);
            if (menuItem.getItemId() == null || !menuItem.getItemId().equals(itemid)) continue;
            return menuItem.isVisible();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public void addDynamicMenuItem(String dynamicid, String xmlStream) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.addDynamicMenuItem((XMLMenuParent)this, dynamicid, xmlStream);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void addDynamicMenu(String dynamicid, String xmlSource) throws XMLVisualRuntimeException {
        try {
            this.menuFactory.addDynamicMenu((XMLMenuParent)this, dynamicid, xmlSource);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public int getPopupStyle() {
        return this.popupStyle;
    }

    @Override
    public int getMenuStyle() {
        return this.popupStyle;
    }

    @Override
    public void addMenuItem(Component mi) {
        this.add(mi);
    }

    @Override
    public void addMenu(JMenu m) {
        this.add(m);
    }

    @Override
    public ArrayList getDynamicMenuItemList() {
        return this.dynamicMenuItemList;
    }

    @Override
    public ArrayList getDynamicMenuList() {
        return this.dynamicMenuItemList;
    }

    @Override
    public JMenu getMenu(int pos) {
        return null;
    }

    @Override
    public Component getMenuComponentByIndex(int n) {
        return this.getComponent(n);
    }
}

