/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.util;

import com.sas.visuals.util.XMLAnyTag;
import com.sas.visuals.util.XMLButtonAction;
import com.sas.visuals.util.XMLButtonGroup;
import com.sas.visuals.util.XMLCheckBoxMenuItem;
import com.sas.visuals.util.XMLDynamicItem;
import com.sas.visuals.util.XMLHelpListener;
import com.sas.visuals.util.XMLMenu;
import com.sas.visuals.util.XMLMenuButton;
import com.sas.visuals.util.XMLMenuItem;
import com.sas.visuals.util.XMLMenuParent;
import com.sas.visuals.util.XMLMenuSeparator;
import com.sas.visuals.util.XMLPopupMenu;
import com.sas.visuals.util.XMLRadioButtonMenuItem;
import com.sas.visuals.util.XMLResourceLocator;
import com.sas.visuals.util.XMLTrickMenu;
import com.sas.visuals.util.XMLVisualRuntimeException;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLMenuFactory {
    private XMLMenuParent rootMenu = null;
    private static DocumentBuilder docBuilder = null;
    private URL xmlStream = null;
    private XMLHelpListener cntlObject = null;
    private XMLResourceLocator imageLocator = null;
    private XMLResourceLocator xmlLocator = null;
    ArrayList menuList = null;
    ArrayList menuItemList = null;
    int style;
    ImageIcon blankIcon = null;
    URL blankURL;

    public XMLMenuFactory(URL stream, XMLResourceLocator iLocator, XMLResourceLocator xLocator, XMLMenuParent mp, XMLHelpListener c) throws IOException, SAXException, ParserConfigurationException {
        if (this.getClass().getClassLoader() != null) {
            this.blankIcon = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/visuals/util/res/Blank.gif"));
        }
        this.rootMenu = mp;
        this.xmlStream = stream;
        this.cntlObject = c;
        this.imageLocator = iLocator;
        this.xmlLocator = xLocator;
        this.menuList = new ArrayList();
        this.menuItemList = new ArrayList();
        this.parseMenuStream(stream, mp, false);
    }

    public XMLMenuFactory(URL stream, XMLResourceLocator iLocator, XMLResourceLocator xLocator, XMLMenuParent mp, XMLHelpListener c, URL codeBase) throws IOException, SAXException, ParserConfigurationException {
        this.blankURL = new URL("jar:" + codeBase + "sas.swing.xml.jar!/com/sas/visuals/util/res/Blank.gif");
        this.blankIcon = new ImageIcon(this.blankURL);
        this.rootMenu = mp;
        this.xmlStream = stream;
        this.cntlObject = c;
        this.imageLocator = iLocator;
        this.xmlLocator = xLocator;
        this.menuList = new ArrayList();
        this.menuItemList = new ArrayList();
        this.parseMenuStream(stream, mp, false);
    }

    public ArrayList getMenuList() {
        return this.menuList;
    }

    public ArrayList getMenuButtonList() {
        return this.menuItemList;
    }

    private void parseMenuStream(URL inStream, XMLMenuParent parent, boolean fromBowels) throws IOException, SAXException, ParserConfigurationException {
        this.setupDocumentBuilder();
        int oldstyle = this.style;
        this.style = parent.getMenuStyle();
        if (this.style == -1) {
            this.style = oldstyle;
        }
        Document doc = XMLMenuFactory.parseXML(inStream);
        Vector groupList = new Vector();
        NodeList myNodeList = doc.getFirstChild().getChildNodes();
        Node p = doc.getFirstChild();
        if (fromBowels) {
            this.HandleMenu((XMLMenu)parent, p, false);
        } else {
            block3: for (int i = 0; i < myNodeList.getLength(); ++i) {
                Node n = myNodeList.item(i);
                switch (n.getNodeType()) {
                    case 1: {
                        if (n.getNodeName().equalsIgnoreCase("menu")) {
                            XMLMenu menu = new XMLMenu();
                            if (parent instanceof XMLPopupMenu) {
                                this.HandleMenu(menu, n, true);
                            } else {
                                this.HandleMenu(menu, n, false);
                            }
                            parent.addMenu(menu);
                            continue block3;
                        }
                        if (n.getNodeName().equalsIgnoreCase("isubmenubar")) {
                            String xmlSource = n.getChildNodes().item(0).getNodeValue();
                            xmlSource = xmlSource.trim();
                            URL url = this.xmlLocator.getResource(xmlSource);
                            this.parseMenuStream(url, parent, false);
                            continue block3;
                        }
                        if (n.getNodeName().equalsIgnoreCase("menuitem")) {
                            Component item = this.HandleMenuItem(n, groupList);
                            parent.addMenuItem(item);
                            continue block3;
                        }
                        if (n.getNodeName().equalsIgnoreCase("separator")) {
                            XMLMenuSeparator sep = this.HandleSeparator(n);
                            parent.addMenuItem(sep);
                            continue block3;
                        }
                        if (!n.getNodeName().equalsIgnoreCase("dynamicmenu")) continue block3;
                        boolean found = false;
                        String dyn = n.getChildNodes().item(0).getNodeValue();
                        dyn = dyn.trim();
                        for (int k = 0; k < this.rootMenu.getDynamicMenuList().size(); ++k) {
                            XMLDynamicItem d = (XMLDynamicItem)this.rootMenu.getDynamicMenuList().get(k);
                            if (!d.getDynamicId().equalsIgnoreCase(dyn)) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            System.out.println("The <dynamicmenu> tag must be unique for each popup menu.");
                            System.out.println("<dynamicmenu> tag " + dyn + " is a duplicate name.");
                            continue block3;
                        }
                        XMLDynamicItem dynamicMenu = new XMLDynamicItem(dyn, parent.getComponentCount());
                        this.rootMenu.getDynamicMenuList().add(dynamicMenu);
                        continue block3;
                    }
                }
            }
        }
    }

    private JMenu HandleMenu(XMLMenu menu, Node n, boolean isSubmenu) throws IOException, SAXException, ParserConfigurationException {
        AccessibleContext aCtxt;
        NodeList nodeList = n.getChildNodes();
        String text = null;
        String id = null;
        String icon = null;
        String help = null;
        Object dynamicmenu = null;
        String transdesc = null;
        String accessiblename = null;
        String accessibledesc = null;
        Vector groupList = new Vector();
        ArrayList<XMLAnyTag> anytagList = new ArrayList<XMLAnyTag>();
        boolean menuHasIcons = false;
        boolean menuMissingIcons = false;
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node menuItemNode = nodeList.item(j);
            if (null == menuItemNode.getChildNodes().item(0)) {
                if (!menuItemNode.getNodeName().equalsIgnoreCase("separator")) continue;
                XMLMenuSeparator sep = this.HandleSeparator(menuItemNode);
                menu.add(sep);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("separator")) {
                XMLMenuSeparator sep = this.HandleSeparator(menuItemNode);
                menu.add(sep);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("text")) {
                text = menuItemNode.getChildNodes().item(0).getNodeValue();
                text = text.trim();
                menu.setText(text);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("help")) {
                help = menuItemNode.getChildNodes().item(0).getNodeValue();
                help = help.trim();
                menu.setHelp(help);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("itemid")) {
                id = menuItemNode.getChildNodes().item(0).getNodeValue();
                id = id.trim();
                menu.setItemId(id);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("accessiblename")) {
                accessiblename = menuItemNode.getChildNodes().item(0).getNodeValue();
                accessiblename = accessiblename.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("accessibledesc")) {
                accessibledesc = menuItemNode.getChildNodes().item(0).getNodeValue();
                accessibledesc = accessibledesc.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("icon")) {
                icon = menuItemNode.getChildNodes().item(0).getNodeValue();
                icon = icon.trim();
                ImageIcon ic = this.loadIcon(icon);
                if (this.style == 2) continue;
                menu.setIcon(ic);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("transdesc")) {
                transdesc = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((transdesc = transdesc.trim()) != null && (transdesc == null || !transdesc.equalsIgnoreCase(""))) continue;
                System.out.println(menuItemNode.getNodeName() + " must have a value describing the function of this item for the translators.");
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("mnemonic")) {
                String mnemonic = menuItemNode.getChildNodes().item(0).getNodeValue();
                mnemonic = mnemonic.trim();
                try {
                    menu.setMnemonic(Integer.parseInt(mnemonic));
                }
                catch (NumberFormatException numEx) {
                    if (mnemonic.length() == 1) {
                        menu.setMnemonic(mnemonic.charAt(0));
                        continue;
                    }
                    if (mnemonic.length() == 4 && mnemonic.substring(0, 3).equalsIgnoreCase("VK_")) {
                        menu.setMnemonic(mnemonic.charAt(3));
                        continue;
                    }
                    System.out.println("Mnemonic " + mnemonic + " is not valid.");
                }
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("menuitem")) {
                Component item = this.HandleMenuItem(menuItemNode, groupList);
                if (item == null) continue;
                if (this.style == 3) {
                    XMLMenuItem mi = (XMLMenuItem)((Object)item);
                    if (mi.getIconTag() == null) {
                        menuMissingIcons = true;
                    } else {
                        menuHasIcons = true;
                    }
                }
                menu.add(item);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("enabled")) {
                String state = null;
                state = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((state = state.trim()).equalsIgnoreCase("true")) {
                    menu.setEnabled(true);
                    continue;
                }
                if (state.equalsIgnoreCase("false")) {
                    menu.setEnabled(false);
                    continue;
                }
                System.out.println(state + " not valid value for " + menuItemNode.getNodeName());
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("visible")) {
                String state = null;
                state = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((state = state.trim()).equalsIgnoreCase("true")) {
                    menu.setVisible(true);
                    continue;
                }
                if (state.equalsIgnoreCase("false")) {
                    menu.setVisible(false);
                    continue;
                }
                System.out.println(state + " not valid value for " + menuItemNode.getNodeName());
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("menu")) {
                XMLMenu submenu = new XMLMenu();
                this.HandleMenu(submenu, menuItemNode, true);
                if (submenu == null) continue;
                menu.add(submenu);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("isubmenubar")) {
                String xmlSource = menuItemNode.getChildNodes().item(0).getNodeValue();
                xmlSource = xmlSource.trim();
                URL url = this.xmlLocator.getResource(xmlSource);
                this.parseMenuStream(url, menu, false);
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("dynamicmenu")) {
                boolean found = false;
                String dyn = menuItemNode.getChildNodes().item(0).getNodeValue();
                dyn = dyn.trim();
                block3: for (int i = 0; i < this.menuList.size(); ++i) {
                    XMLMenu xmlmenu = (XMLMenu)this.menuList.get(i);
                    for (int k = 0; k < xmlmenu.getDynamicMenuItemList().size(); ++k) {
                        XMLDynamicItem d = (XMLDynamicItem)xmlmenu.getDynamicMenuItemList().get(k);
                        if (!d.getDynamicId().equalsIgnoreCase(dyn)) continue;
                        found = true;
                        continue block3;
                    }
                }
                if (!found) {
                    for (int k = 0; k < menu.getDynamicMenuItemList().size(); ++k) {
                        XMLDynamicItem d = (XMLDynamicItem)menu.getDynamicMenuItemList().get(k);
                        if (!d.getDynamicId().equalsIgnoreCase(dyn)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    System.out.println("The <dynamicmenu> tag must be unique for each menu bar.");
                    System.out.println("<dynamicmenu> tag " + dyn + " is a duplicate name.");
                    continue;
                }
                XMLDynamicItem dynamicMenu = new XMLDynamicItem(dyn, menu.getItemCount());
                menu.getDynamicMenuItemList().add(dynamicMenu);
                continue;
            }
            String anytag = menuItemNode.getNodeName();
            String anytagvalue = menuItemNode.getChildNodes().item(0).getNodeValue();
            anytagvalue = anytagvalue.trim();
            XMLAnyTag a = new XMLAnyTag(anytag, anytagvalue);
            anytagList.add(a);
        }
        if (text == null || transdesc == null) {
            if (!isSubmenu) {
                return null;
            }
            if (text == null) {
                System.out.println("A text tag is required on each menu.");
            }
            if (transdesc == null) {
                System.out.println("A <TRANSDESC> tag is required on each menu.");
                System.out.println("No <TRANSDESC> tag for the \"" + text + "\" <MENU>");
            }
            return null;
        }
        if (this.style == 3 && menuMissingIcons && menuHasIcons) {
            Component[] c = menu.getMenuComponents();
            for (int k = 0; k < c.length; ++k) {
                AbstractButton m = (AbstractButton)c[k];
                if (m.getIcon() != null) continue;
                m.setIcon(this.blankIcon);
            }
        }
        menu.setXMLTag(anytagList);
        this.menuList.add(menu);
        if (accessiblename == null) {
            accessiblename = text;
        }
        if (accessibledesc == null) {
            accessibledesc = help;
        }
        if ((aCtxt = menu.getAccessibleContext()) != null) {
            if (accessiblename != null) {
                aCtxt.setAccessibleName(accessiblename);
            }
            if (accessibledesc != null) {
                aCtxt.setAccessibleDescription(accessibledesc);
            }
        }
        if (isSubmenu && icon == null && this.style == 0) {
            menu.setIcon(this.blankIcon);
        }
        return menu;
    }

    private Component HandleMenuItem(Node n, Vector groupList) throws IOException {
        AccessibleContext aCtxt;
        JMenuItem m;
        NodeList nodeList = n.getChildNodes();
        String text = null;
        String itemId = null;
        String icon = null;
        String help = null;
        String command = null;
        String transdesc = null;
        String accelerator = null;
        String mnemonic = null;
        String radiogroup = null;
        String accessiblename = null;
        String accessibledesc = null;
        boolean checkbox = false;
        boolean enabled = true;
        boolean visible = true;
        boolean selected = false;
        ArrayList<XMLAnyTag> anytagList = new ArrayList<XMLAnyTag>();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            String state;
            Node menuItemNode = nodeList.item(j);
            if (null == menuItemNode.getChildNodes().item(0)) {
                if (!menuItemNode.getNodeName().equalsIgnoreCase("checkbox")) continue;
                checkbox = true;
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("text")) {
                text = menuItemNode.getChildNodes().item(0).getNodeValue();
                text = text.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("help")) {
                help = menuItemNode.getChildNodes().item(0).getNodeValue();
                help = help.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("id")) {
                itemId = menuItemNode.getChildNodes().item(0).getNodeValue();
                itemId = itemId.trim();
                System.out.println("The id tag is deprecated.  Change your xml menuitem to use itemid instead.");
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("itemid")) {
                itemId = menuItemNode.getChildNodes().item(0).getNodeValue();
                itemId = itemId.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("accessiblename")) {
                accessiblename = menuItemNode.getChildNodes().item(0).getNodeValue();
                accessiblename = accessiblename.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("accessibledesc")) {
                accessibledesc = menuItemNode.getChildNodes().item(0).getNodeValue();
                accessibledesc = accessibledesc.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("icon")) {
                icon = menuItemNode.getChildNodes().item(0).getNodeValue();
                icon = icon.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("command")) {
                command = menuItemNode.getChildNodes().item(0).getNodeValue();
                command = command.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("mnemonic")) {
                mnemonic = menuItemNode.getChildNodes().item(0).getNodeValue();
                mnemonic = mnemonic.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("accelerator")) {
                accelerator = menuItemNode.getChildNodes().item(0).getNodeValue();
                accelerator = accelerator.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("checkbox")) {
                String box = null;
                box = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((box = box.trim()).equalsIgnoreCase("true")) {
                    checkbox = true;
                    continue;
                }
                if (box.equalsIgnoreCase("false")) {
                    checkbox = false;
                    continue;
                }
                checkbox = true;
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("selected")) {
                state = null;
                state = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((state = state.trim()).equalsIgnoreCase("true")) {
                    selected = true;
                    continue;
                }
                if (state.equalsIgnoreCase("false")) {
                    selected = false;
                    continue;
                }
                System.out.println(state + " not valid value for " + menuItemNode.getNodeName());
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("transdesc")) {
                transdesc = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((transdesc = transdesc.trim()) != null && (transdesc == null || !transdesc.equalsIgnoreCase(""))) continue;
                System.out.println(menuItemNode.getNodeName() + " must have a value describing the function of this item for the translators.");
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("radiogroup")) {
                radiogroup = menuItemNode.getChildNodes().item(0).getNodeValue();
                radiogroup = radiogroup.trim();
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("enabled")) {
                state = null;
                state = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((state = state.trim()).equalsIgnoreCase("true")) {
                    enabled = true;
                    continue;
                }
                if (state.equalsIgnoreCase("false")) {
                    enabled = false;
                    continue;
                }
                System.out.println(state + " not valid value for " + menuItemNode.getNodeName());
                continue;
            }
            if (menuItemNode.getNodeName().equalsIgnoreCase("visible")) {
                state = null;
                state = menuItemNode.getChildNodes().item(0).getNodeValue();
                if ((state = state.trim()).equalsIgnoreCase("true")) {
                    visible = true;
                    continue;
                }
                if (state.equalsIgnoreCase("false")) {
                    visible = false;
                    continue;
                }
                System.out.println(state + " not valid value for " + menuItemNode.getNodeName());
                continue;
            }
            String anytag = menuItemNode.getNodeName();
            String anytagvalue = menuItemNode.getChildNodes().item(0).getNodeValue();
            anytagvalue = anytagvalue.trim();
            XMLAnyTag a = new XMLAnyTag(anytag, anytagvalue);
            anytagList.add(a);
        }
        if (text == null || transdesc == null || command == null) {
            if (text == null) {
                System.out.println("A text tag is required on each menu item.");
            }
            if (transdesc == null) {
                System.out.println("A transdesc tag is required on each menu item.");
            }
            if (command == null) {
                System.out.println("A command tag is required on each menu item.");
            }
            return null;
        }
        JMenuItem menuItem = null;
        JMenuItem menuItemB = null;
        if (radiogroup != null && !checkbox) {
            menuItem = m = new XMLRadioButtonMenuItem();
            menuItemB = m;
            ((XMLRadioButtonMenuItem)m).addHelpListener(this.cntlObject);
            ((XMLRadioButtonMenuItem)m).setXMLTag(anytagList);
            if (accelerator != null) {
                m.setAccelerator(KeyStroke.getKeyStroke(accelerator));
            }
        } else if (checkbox) {
            m = new XMLCheckBoxMenuItem();
            ((JCheckBoxMenuItem)m).setState(selected);
            menuItem = m;
            menuItemB = m;
            ((XMLCheckBoxMenuItem)m).addHelpListener(this.cntlObject);
            ((XMLCheckBoxMenuItem)m).setXMLTag(anytagList);
            if (accelerator != null) {
                m.setAccelerator(KeyStroke.getKeyStroke(accelerator));
            }
        } else {
            menuItem = m = new XMLMenuButton();
            menuItemB = m;
            ((XMLMenuButton)m).addHelpListener(this.cntlObject);
            ((XMLMenuButton)m).setXMLTag(anytagList);
            if (accelerator != null) {
                m.setAccelerator(KeyStroke.getKeyStroke(accelerator));
            }
            if (selected) {
                System.out.println("<selected> tag ignored.  This tag only applies to RadioButton and CheckBox menu items");
            }
        }
        if (radiogroup != null) {
            boolean found = false;
            for (int i = 0; i < groupList.size() && !found; ++i) {
                if (!((XMLButtonGroup)groupList.get(i)).getName().equalsIgnoreCase(radiogroup)) continue;
                ((XMLButtonGroup)groupList.get(i)).add(menuItemB);
                if (selected) {
                    ((XMLButtonGroup)groupList.get(i)).getBtnGroup().setSelected(menuItemB.getModel(), true);
                }
                found = true;
            }
            if (!found) {
                XMLButtonGroup group = new XMLButtonGroup(radiogroup);
                group.getBtnGroup().add(menuItemB);
                if (selected) {
                    group.getBtnGroup().setSelected(menuItemB.getModel(), true);
                }
                groupList.add(group);
            }
        }
        menuItem.setText(text);
        menuItem.setHelp(help);
        menuItem.setIconTag(icon);
        menuItem.setMnemonicTag(mnemonic);
        menuItem.setAcceleratorTag(accelerator);
        menuItem.setTransDesc(transdesc);
        menuItem.setCommand(command);
        menuItemB.addActionListener(new XMLButtonAction(this.cntlObject, command));
        ((AbstractButton)menuItemB).setEnabled(enabled);
        menuItemB.setVisible(visible);
        if (accessiblename == null) {
            accessiblename = text;
        }
        if (accessibledesc == null) {
            accessibledesc = help;
        }
        if ((aCtxt = ((Component)menuItemB).getAccessibleContext()) != null) {
            if (accessiblename != null) {
                aCtxt.setAccessibleName(accessiblename);
            }
            if (accessibledesc != null) {
                aCtxt.setAccessibleDescription(accessibledesc);
            }
        }
        if (mnemonic != null) {
            try {
                menuItemB.setMnemonic(Integer.parseInt(mnemonic));
            }
            catch (NumberFormatException numEx) {
                if (mnemonic.length() == 1) {
                    menuItemB.setMnemonic(mnemonic.charAt(0));
                }
                if (mnemonic.length() == 4 && mnemonic.substring(0, 3).equalsIgnoreCase("VK_")) {
                    menuItemB.setMnemonic(mnemonic.charAt(3));
                }
                System.out.println("Mnemonic " + mnemonic + " is not valid.");
            }
        }
        if (itemId != null) {
            menuItem.setItemId(itemId);
        }
        if (icon == null) {
            if (this.style == 0) {
                menuItemB.setIcon(this.blankIcon);
            }
        } else {
            ImageIcon ic = this.loadIcon(icon);
            if (this.style != 2) {
                menuItemB.setIcon(ic);
            }
        }
        this.menuItemList.add(menuItem);
        return menuItem;
    }

    private XMLMenuSeparator HandleSeparator(Node n) {
        NodeList nodeList = n.getChildNodes();
        String itemId = null;
        String visible = null;
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node menuItemNode = nodeList.item(j);
            if (menuItemNode.getNodeName().equalsIgnoreCase("itemid")) {
                itemId = menuItemNode.getChildNodes().item(0).getNodeValue();
                itemId = itemId.trim();
            }
            if (!menuItemNode.getNodeName().equalsIgnoreCase("visible")) continue;
            visible = menuItemNode.getChildNodes().item(0).getNodeValue();
            visible = visible.trim();
        }
        XMLMenuSeparator sep = new XMLMenuSeparator(itemId);
        if (visible != null && visible.equals("false")) {
            sep.setVisible(false);
        }
        this.menuItemList.add(sep);
        return sep;
    }

    private static Document parseXML(URL inStream) throws SAXException, IOException {
        Document doc = null;
        doc = docBuilder.parse(inStream.openStream());
        return doc;
    }

    private void setupDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        docBuilder = dbf.newDocumentBuilder();
    }

    private static String getAttribute(String attributeName, NamedNodeMap node) {
        String returnValue = null;
        try {
            returnValue = node.getNamedItem(attributeName).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return returnValue;
    }

    private ImageIcon loadIcon(String icName) throws IOException {
        ImageIcon ic = null;
        URL icURL = null;
        if (this.imageLocator != null) {
            icURL = this.imageLocator.getResource(icName);
        }
        if (icURL != null) {
            ic = new ImageIcon(icURL);
        }
        return ic;
    }

    public void addDynamicMenuItem(XMLMenuParent mp, String dynamicId, String xmlStream) throws IOException, SAXException, ParserConfigurationException, XMLVisualRuntimeException {
        int index = 0;
        if (mp != null) {
            for (int i = 0; i < mp.getDynamicMenuList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)mp.getDynamicMenuList().get(i);
                index += d.getIndex();
                if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
                XMLTrickMenu trickMenu = new XMLTrickMenu(this.rootMenu, dynamicId, d.getPosition() + index);
                this.parseMenuStream(this.xmlLocator.getResource(xmlStream), trickMenu, true);
                return;
            }
        }
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            index = 0;
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                index += d.getIndex();
                if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
                XMLTrickMenu trickMenu = new XMLTrickMenu(this.rootMenu, dynamicId, d.getPosition() + index);
                this.parseMenuStream(this.xmlLocator.getResource(xmlStream), trickMenu, true);
                return;
            }
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void addDynamicMenuItem(XMLMenuParent mp, String dynamicId, Component menuItem) throws XMLVisualRuntimeException {
        int index = 0;
        if (mp != null) {
            for (int i = 0; i < mp.getDynamicMenuList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)mp.getDynamicMenuList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    mp.add(menuItem, d.getPosition() + index);
                    d.setIndex(d.getIndex() + 1);
                    return;
                }
                index += d.getIndex();
            }
        }
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                index += d.getIndex();
                if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
                m.add(menuItem, d.getPosition() + index);
                d.setIndex(d.getIndex() + 1);
                return;
            }
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void addDynamicMenuItem(XMLMenuParent mp, String dynamicId, Component menuItem, int pos) throws XMLVisualRuntimeException {
        int index = 0;
        if (mp != null) {
            for (int i = 0; i < mp.getDynamicMenuList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)mp.getDynamicMenuList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    if (pos <= d.getIndex()) {
                        mp.add(menuItem, d.getPosition() + index + pos);
                    } else {
                        mp.add(menuItem, d.getPosition() + index);
                    }
                    d.setIndex(d.getIndex() + 1);
                    return;
                }
                index += d.getIndex();
            }
        }
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    if (pos <= d.getIndex()) {
                        m.add(menuItem, d.getPosition() + index + pos);
                    } else {
                        m.add(menuItem, d.getPosition() + index);
                    }
                    d.setIndex(d.getIndex() + 1);
                    return;
                }
                index += d.getIndex();
            }
        }
        throw new XMLVisualRuntimeException("Dynamic item " + dynamicId + " not found.");
    }

    public void removeDynamicMenuItem(String dynamicId) throws XMLVisualRuntimeException {
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            int index = 0;
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    for (int h = d.getIndex(); h > 0; --h) {
                        m.getMenuComponent(d.getPosition() + index + h - 1);
                        m.remove(d.getPosition() + index + h - 1);
                        d.setIndex(d.getIndex() - 1);
                    }
                    return;
                }
                index += d.getIndex();
            }
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void removeDynamicMenuItem(String dynamicId, JComponent component) throws XMLVisualRuntimeException {
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            int index = 0;
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    for (int h = d.getIndex(); h > 0; --h) {
                        JComponent jc = (JComponent)m.getMenuComponent(d.getPosition() + index + h - 1);
                        if (!jc.equals(component)) continue;
                        this.remove(jc);
                        m.remove(d.getPosition() + index + h - 1);
                        d.setIndex(d.getIndex() - 1);
                        return;
                    }
                }
                index += d.getIndex();
            }
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public int getDynamicMenuItemPos(String dynamicId, JComponent component) {
        for (int j = 0; j < this.menuList.size(); ++j) {
            XMLMenu m = (XMLMenu)this.menuList.get(j);
            int index = 0;
            for (int i = 0; i < m.getDynamicMenuItemList().size(); ++i) {
                XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuItemList().get(i);
                if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                    for (int h = d.getIndex(); h > 0; --h) {
                        JComponent jc = (JComponent)m.getMenuComponent(d.getPosition() + index + h - 1);
                        if (!jc.equals(component)) continue;
                        return h - 1;
                    }
                }
                index += d.getIndex();
            }
        }
        return -1;
    }

    public void addDynamicMenu(XMLMenuParent m, String dynamicId, JMenu menuItem) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            index += d.getIndex();
            if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
            m.add(menuItem, d.getPosition() + index);
            d.setIndex(d.getIndex() + 1);
            return;
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void addDynamicMenu(XMLMenuParent m, String dynamicId, String xmlStream) throws IOException, SAXException, ParserConfigurationException, XMLVisualRuntimeException {
        int i;
        int index = 0;
        for (i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            index += d.getIndex();
            if (!dynamicId.equalsIgnoreCase(d.getDynamicId())) continue;
            XMLMenu newMenu = new XMLMenu();
            this.parseMenuStream(this.xmlLocator.getResource(xmlStream), newMenu, true);
            m.add(newMenu, d.getPosition() + index);
            d.setIndex(d.getIndex() + 1);
            return;
        }
        for (i = 0; i < this.menuList.size(); ++i) {
            XMLMenu xmlmenu = (XMLMenu)this.menuList.get(i);
            for (int k = 0; k < xmlmenu.getDynamicMenuItemList().size(); ++k) {
                XMLDynamicItem d = (XMLDynamicItem)xmlmenu.getDynamicMenuItemList().get(k);
                index += d.getIndex();
                if (!d.getDynamicId().equalsIgnoreCase(dynamicId)) continue;
                XMLMenu newMenu = new XMLMenu();
                this.parseMenuStream(this.xmlLocator.getResource(xmlStream), newMenu, true);
                xmlmenu.add((Component)newMenu, d.getPosition() + index);
                d.setIndex(d.getIndex() + 1);
                if (this.style == 0) {
                    newMenu.setIcon(this.blankIcon);
                }
                return;
            }
        }
        throw new XMLVisualRuntimeException("Dynamic item " + dynamicId + " not found.");
    }

    public void addDynamicMenu(XMLMenuParent m, String dynamicId, JMenu menuItem, int pos) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                if (pos < d.getIndex()) {
                    m.add(menuItem, d.getPosition() + index + pos);
                } else {
                    m.add(menuItem, d.getPosition() + index);
                }
                d.setIndex(d.getIndex() + 1);
                return;
            }
            index += d.getIndex();
        }
        throw new XMLVisualRuntimeException("Dynamic id " + dynamicId + " not found.");
    }

    public void removeDynamicMenu(XMLMenuParent m, String dynamicId) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    this.remove(m.getMenuComponentByIndex(d.getPosition() + index + h - 1));
                    m.remove(d.getPosition() + index + h - 1);
                    d.setIndex(d.getIndex() - 1);
                }
                return;
            }
            index += d.getIndex();
        }
        try {
            this.removeDynamicMenuItem(dynamicId);
            return;
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicMenu(XMLMenuParent m, String dynamicId, JComponent component) throws XMLVisualRuntimeException {
        int index = 0;
        for (int i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    JMenu jc = m.getMenu(d.getPosition() + index + h - 1);
                    if (!jc.equals(component)) continue;
                    this.remove(jc);
                    m.remove(d.getPosition() + index + h - 1);
                    d.setIndex(d.getIndex() - 1);
                    return;
                }
            }
            index += d.getIndex();
        }
        try {
            this.removeDynamicMenuItem(dynamicId, component);
            return;
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public int getDynamicMenuPos(XMLMenuParent m, String dynamicId, JComponent component) {
        int index = 0;
        for (int i = 0; i < m.getDynamicMenuList().size(); ++i) {
            XMLDynamicItem d = (XMLDynamicItem)m.getDynamicMenuList().get(i);
            if (dynamicId.equalsIgnoreCase(d.getDynamicId())) {
                for (int h = d.getIndex(); h > 0; --h) {
                    JMenu jc = m.getMenu(d.getPosition() + index + h - 1);
                    if (!jc.equals(component)) continue;
                    return h - 1;
                }
            }
            index += d.getIndex();
        }
        return -1;
    }

    private void remove(Object obj) {
        this.menuItemList.remove(obj);
        this.menuList.remove(obj);
    }
}

