/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.GetSystemPropertyAction;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class FilePluginData
implements Comparable {
    private static final boolean USE_PLUGIN_TIMESTAMP = true;
    static final boolean DEBUG_INDEX;
    private static final byte F_WAS_DIR = 1;
    private static final byte F_HAS_VERSION = 2;
    private static final byte F_HAS_BUNDLE_CLASSPATH = 4;
    private static final byte F_HAS_REQUIRE_BUNDLE = 8;
    private static final byte F_HAS_FRAGMENT_HOST = 16;
    private static final byte F_HAS_BUNDLE_NATIVE_CODE = 32;
    private static final byte F_TAINTED = 64;
    private static Attributes.Name[] s_fallbackKeys;
    String m_filename;
    private long m_timestamp;
    private boolean m_wasDir;
    String m_idName;
    VersionSpec m_version;
    private String m_propBundleClasspath;
    private String m_propRequireBundles;
    String m_fragmentHost;
    private String m_propBundleNativeCode;
    private boolean m_tainted;
    private File m_file;

    private static synchronized Attributes.Name[] s_fallbackKeys() {
        Attributes.Name[] rc = s_fallbackKeys;
        if (rc == null) {
            rc = new Attributes.Name[]{new Attributes.Name("Bundle-ClassPath"), PickList.ATTR_NAME_REQUIRE_BUNDLE, new Attributes.Name("Bundle-SymbolicName"), new Attributes.Name("Bundle-Name"), new Attributes.Name("Bundle-Version"), new Attributes.Name("SAS-Cycle-Require-Bundle"), new Attributes.Name("Fragment-Host"), new Attributes.Name("Bundle-NativeCode"), new Attributes.Name("Tainted")};
            s_fallbackKeys = rc;
        }
        return rc;
    }

    static FilePluginData readFrom(DataInput s, String idName) throws IOException {
        VersionSpec version;
        boolean wasDir;
        String filename = s.readUTF();
        long stamp = s.readLong();
        byte flags = s.readByte();
        boolean bl = wasDir = (flags & 1) != 0;
        if ((flags & 2) != 0) {
            version = VersionSpec.readFrom(s);
            if (version.isRange()) {
                throw new IOException();
            }
        } else {
            version = null;
        }
        String propBundleClasspath = (flags & 4) != 0 ? s.readUTF() : null;
        String propRequireBundles = (flags & 8) != 0 ? s.readUTF() : null;
        String propFragmentHost = (flags & 0x10) != 0 ? s.readUTF() : null;
        String propBundleNativeCode = (flags & 0x20) != 0 ? s.readUTF() : null;
        boolean tainted = (flags & 0x40) != 0;
        return new FilePluginData(filename, stamp, wasDir, idName, version, propBundleClasspath, propRequireBundles, propFragmentHost, propBundleNativeCode, tainted);
    }

    static Plugin readPluginFrom(DataInput s, String idName, File pluginsDir) throws IOException {
        String fragmentHost;
        VersionSpec version;
        assert (idName != null);
        assert (pluginsDir != null);
        String filename = s.readUTF();
        s.readLong();
        byte flags = s.readByte();
        if ((flags & 2) != 0) {
            version = VersionSpec.readFrom(s);
            if (version.isRange()) {
                throw new IOException();
            }
        } else {
            throw new IOException();
        }
        String propBundleClasspath = (flags & 4) != 0 ? s.readUTF() : null;
        String propRequireBundles = (flags & 8) != 0 ? s.readUTF() : null;
        if ((flags & 0x10) != 0) {
            fragmentHost = s.readUTF();
            if (fragmentHost.trim().length() <= 0) {
                assert (false);
                throw new IllegalStateException("Fragment-Host");
            }
        } else {
            fragmentHost = null;
        }
        String propBundleNativeCode = null;
        if ((flags & 0x20) != 0 && (propBundleNativeCode = s.readUTF()).trim().length() <= 0) {
            assert (false);
            throw new IllegalStateException("Bundle-NativeCode");
        }
        boolean tainted = (flags & 0x40) != 0;
        return new Plugin(pluginsDir, filename, null, idName, version, propBundleClasspath, propRequireBundles, propBundleNativeCode, fragmentHost, tainted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FilePluginData refresh(File pluginsDir, String filename, FilePluginData old, AttrScanner scanner) {
        String tainted;
        String nativeCode;
        String fragmentHost;
        String sasCycle;
        String rb;
        String cp;
        String version;
        String name;
        String symName;
        long stamp;
        boolean dir;
        block16: {
            File f;
            block17: {
                f = old != null ? old.getFile(pluginsDir) : new File(pluginsDir, filename);
                dir = f.isDirectory();
                if (DEBUG_INDEX) {
                    System.out.println("Updating index for " + f + "(" + (dir ? "dir" : "file") + ") in " + pluginsDir);
                }
                File mf = dir ? new File(f, "META-INF/MANIFEST.MF") : null;
                stamp = Util.lastMod(dir ? mf : f);
                if (old != null && dir == old.m_wasDir && stamp == old.m_timestamp) {
                    if (DEBUG_INDEX) {
                        System.out.println("\tre-using old data based on unchanged plugin timestamp of " + new Date() + " for " + (dir ? mf : f));
                    }
                    return old;
                }
                if (!dir) break block17;
                FileInputStream s = null;
                try {
                    s = new FileInputStream(mf);
                    scanner.parse(s);
                    symName = FilePluginData.toString(scanner.bundleSymbolicName);
                    name = FilePluginData.toString(scanner.bundleName);
                    version = FilePluginData.toString(scanner.bundleVersion);
                    cp = FilePluginData.toString(scanner.bundleClassPath);
                    rb = FilePluginData.toString(scanner.requireBundle);
                    sasCycle = FilePluginData.toString(scanner.sasCycleRequireBundle);
                    fragmentHost = FilePluginData.toString(scanner.fragmentHost);
                    nativeCode = FilePluginData.toString(scanner.bundleNativeCode);
                    tainted = FilePluginData.toString(scanner.tainted);
                }
                catch (IOException e) {
                    try {
                        if (DEBUG_INDEX) {
                            System.out.println("Unable to open " + mf + ".");
                            e.printStackTrace();
                        }
                        tainted = null;
                        nativeCode = null;
                        fragmentHost = null;
                        sasCycle = null;
                        rb = null;
                        cp = null;
                        version = null;
                        name = null;
                        symName = null;
                    }
                    catch (Throwable throwable) {
                        Util.close(s);
                        throw throwable;
                    }
                    Util.close(s);
                    break block16;
                }
                Util.close(s);
                break block16;
            }
            FilePluginData.parseValuesFromJar(f, scanner);
            try {
                symName = FilePluginData.toString(scanner.bundleSymbolicName);
                name = FilePluginData.toString(scanner.bundleName);
                version = FilePluginData.toString(scanner.bundleVersion);
                cp = FilePluginData.toString(scanner.bundleClassPath);
                rb = FilePluginData.toString(scanner.requireBundle);
                sasCycle = FilePluginData.toString(scanner.sasCycleRequireBundle);
                fragmentHost = FilePluginData.toString(scanner.fragmentHost);
                nativeCode = FilePluginData.toString(scanner.bundleNativeCode);
                tainted = FilePluginData.toString(scanner.tainted);
            }
            catch (UnsupportedEncodingException e) {
                tainted = null;
                nativeCode = null;
                fragmentHost = null;
                sasCycle = null;
                rb = null;
                cp = null;
                version = null;
                name = null;
                symName = null;
            }
        }
        if (fragmentHost != null && fragmentHost.trim().length() <= 0) {
            fragmentHost = null;
        }
        if (nativeCode != null && nativeCode.trim().length() <= 0) {
            nativeCode = null;
        }
        String combinedRB = sasCycle != null && sasCycle.length() > 0 ? (rb != null && rb.length() > 0 ? rb + ',' + sasCycle : sasCycle) : rb;
        if (DEBUG_INDEX) {
            System.out.print("Plugin: filename " + filename + ", last mod " + new Date(stamp) + ", dir? " + dir + ", symbolic name " + FilePluginData.calcIdName(symName, name) + ", version " + VersionSpec.parseVersion(version) + ", cp " + cp);
            if (combinedRB != null && combinedRB.trim().length() > 0) {
                System.out.print(", combinedRB " + combinedRB);
            }
            if (fragmentHost != null && fragmentHost.trim().length() > 0) {
                System.out.print(", fragmentHost " + fragmentHost);
            }
            if (nativeCode != null && nativeCode.trim().length() > 0) {
                System.out.print(", nativeCode " + nativeCode);
            }
            System.out.print(", tainted? " + (tainted != null));
            System.out.println();
        }
        return new FilePluginData(filename, stamp, dir, FilePluginData.calcIdName(symName, name), VersionSpec.parseVersion(version), cp, combinedRB, fragmentHost, nativeCode, tainted != null);
    }

    private static String calcIdName(String symbolicNameAttr, String nameAttr) {
        String name = symbolicNameAttr;
        if ((name == null || name.trim().length() <= 0) && (name = nameAttr) == null) {
            return null;
        }
        int n = name.indexOf(59);
        if (n >= 0) {
            name = name.substring(0, n);
        }
        return (name = name.trim()).length() > 0 ? name : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseValuesFromJar(File jar, AttrScanner scanner) throws IllegalArgumentException {
        block18: {
            if (jar == null) {
                throw Util.illegalNull("jar");
            }
            FileInputStream s = null;
            ZipInputStream zis = null;
            try {
                s = new FileInputStream(jar);
                zis = new ZipInputStream(s);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null && entry.isDirectory()) {
                    entry = zis.getNextEntry();
                }
                if (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.startsWith("./")) {
                        entryName = entryName.substring(2);
                    } else if (entryName.startsWith("/")) {
                        entryName = entryName.substring(1);
                    }
                    if ("META-INF/MANIFEST.MF".equalsIgnoreCase(entryName)) {
                        scanner.parse(zis);
                        Util.close(zis);
                        zis = null;
                        Util.close(s);
                        return;
                    }
                }
                Util.close(zis);
                zis = null;
            }
            catch (IOException e) {
                if (DEBUG_INDEX) {
                    System.out.println("Unable to fast scan jar manifest for jar " + jar);
                    e.printStackTrace();
                }
                break block18;
            }
            finally {
                Util.close(zis);
                zis = null;
                Util.close(s);
                s = null;
            }
            Util.close(s);
            s = null;
        }
        JarFile j = null;
        try {
            j = new JarFile(jar, true);
            String[] rc = FilePluginData.fallback(j);
            scanner.reset(rc[0], rc[1], rc[2], rc[3], rc[4], rc[5], rc[6], rc[7], rc[8]);
        }
        catch (IOException e) {
            try {
                if (DEBUG_INDEX) {
                    System.out.println("Fall-back to java.util.jar.JarFile unable to parse manifest for jar " + jar);
                    e.printStackTrace();
                }
                scanner.reset();
            }
            catch (Throwable throwable) {
                Util.close(j);
                throw throwable;
            }
            Util.close(j);
            return;
        }
        Util.close(j);
        return;
    }

    private static String[] fallback(JarFile jf) throws IOException {
        Attributes.Name[] fallbackKeys = FilePluginData.s_fallbackKeys();
        String[] rc = new String[fallbackKeys.length];
        Manifest mf = jf.getManifest();
        if (mf == null) {
            return rc;
        }
        Attributes attr = mf.getMainAttributes();
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = attr.getValue(fallbackKeys[i]);
        }
        return rc;
    }

    private static String toString(byte[] utfBytes) throws UnsupportedEncodingException {
        if (utfBytes == null) {
            return null;
        }
        if (utfBytes.length <= 0) {
            return "";
        }
        return new String(utfBytes, "UTF-8");
    }

    FilePluginData() {
        throw new IllegalArgumentException("Do not call this constructor");
    }

    private FilePluginData(String filename, long timestamp, boolean wasDir, String idName, VersionSpec version, String propBundleClasspath, String propRequireBundles, String fragmentHost, String nativeCode, boolean tainted) {
        this.m_filename = filename;
        this.m_timestamp = timestamp;
        this.m_wasDir = wasDir;
        this.m_idName = idName;
        this.m_version = version;
        this.m_propBundleClasspath = propBundleClasspath;
        this.m_propRequireBundles = propRequireBundles;
        this.m_fragmentHost = fragmentHost;
        this.m_propBundleNativeCode = nativeCode;
        this.m_tainted = tainted;
        boolean debug = false;
        try {
            debug = Boolean.getBoolean("com.sas.app.AppClassLoader.DEBUG");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println(this.m_filename + " " + this.m_propBundleClasspath);
        }
    }

    File getFile(File pluginsDir) {
        File f = this.m_file;
        if (f == null) {
            this.m_file = f = new File(pluginsDir, this.m_filename);
        }
        return f;
    }

    Plugin toPlugin(File pluginsDir) {
        if (this.m_idName == null || this.m_version == null) {
            return null;
        }
        return new Plugin(pluginsDir, this.m_filename, this.m_file, this.m_idName, this.m_version, this.m_propBundleClasspath, this.m_propRequireBundles, this.m_propBundleNativeCode, this.m_fragmentHost, this.m_tainted);
    }

    void writeTo(DataOutput s) throws IOException {
        int flags;
        s.writeUTF(this.m_filename);
        s.writeLong(this.m_timestamp);
        int n = flags = this.m_wasDir ? 1 : 0;
        if (this.m_tainted) {
            flags = (byte)(flags | 0x40);
        }
        if (this.m_version != null) {
            if (this.m_version.isRange()) {
                assert (false);
                throw new IllegalStateException();
            }
            flags = (byte)(flags | 2);
        }
        if (this.m_propBundleClasspath != null) {
            flags = (byte)(flags | 4);
        }
        if (this.m_propRequireBundles != null) {
            flags = (byte)(flags | 8);
        }
        if (this.m_fragmentHost != null) {
            flags = (byte)(flags | 0x10);
        }
        if (this.m_propBundleNativeCode != null) {
            flags = (byte)(flags | 0x20);
        }
        s.writeByte(flags);
        if (this.m_version != null) {
            this.m_version.writeTo(s);
        }
        if (this.m_propBundleClasspath != null) {
            s.writeUTF(this.m_propBundleClasspath);
        }
        if (this.m_propRequireBundles != null) {
            s.writeUTF(this.m_propRequireBundles);
        }
        if (this.m_fragmentHost != null) {
            s.writeUTF(this.m_fragmentHost);
        }
        if (this.m_propBundleNativeCode != null) {
            s.writeUTF(this.m_propBundleNativeCode);
        }
    }

    public int compareTo(Object o) throws ClassCastException, IllegalArgumentException {
        if (o == this) {
            return 0;
        }
        return -this.m_version.compareTo(((FilePluginData)o).m_version);
    }

    static {
        boolean debug_index = false;
        try {
            String temp = (String)AccessController.doPrivileged(new GetSystemPropertyAction("com.sas.app.Repository.DEBUG.INDEX"));
            debug_index = Boolean.parseBoolean(temp);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG_INDEX = debug_index;
    }

    static final class AttrScanner {
        static final byte[] ZERO_BYTES = new byte[0];
        private InputStream m_stream;
        private final byte[] m_buffer = new byte[67584];
        private int m_start;
        private int m_end;
        byte[] bundleClassPath;
        byte[] requireBundle;
        byte[] bundleSymbolicName;
        byte[] bundleName;
        byte[] bundleVersion;
        byte[] sasCycleRequireBundle;
        byte[] fragmentHost;
        byte[] bundleNativeCode;
        byte[] tainted;
        private static final char[] EXPECTED = "*EQUIRE-BUNDLE: $UNDLE-*LASSPATH: $YMBOLICNAME: $AME: $ERSION: $AS-CYCLE-REQUIRE-BUNDLE: $RAGMENT-HOST: $IVECODE: $AINTED: $".toCharArray();
        private static final int MAX_KEY_STATE = 123;

        private static byte[] toBytes(String s) {
            if (s == null) {
                return null;
            }
            if (s.length() <= 0) {
                return ZERO_BYTES;
            }
            try {
                return s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        AttrScanner() {
        }

        void reset() {
            this.m_start = 0;
            this.m_end = 0;
            this.bundleClassPath = null;
            this.requireBundle = null;
            this.bundleSymbolicName = null;
            this.bundleName = null;
            this.bundleVersion = null;
            this.sasCycleRequireBundle = null;
            this.fragmentHost = null;
            this.bundleNativeCode = null;
            this.tainted = null;
        }

        void reset(String cp, String rb, String symName, String name, String version, String sasCycle, String fragHost, String nativeCode, String taint) {
            this.m_start = 0;
            this.m_end = 0;
            this.bundleClassPath = AttrScanner.toBytes(cp);
            this.requireBundle = AttrScanner.toBytes(rb);
            this.bundleSymbolicName = AttrScanner.toBytes(symName);
            this.bundleName = AttrScanner.toBytes(name);
            this.bundleVersion = AttrScanner.toBytes(version);
            this.sasCycleRequireBundle = AttrScanner.toBytes(sasCycle);
            this.fragmentHost = AttrScanner.toBytes(fragHost);
            this.bundleNativeCode = AttrScanner.toBytes(nativeCode);
            this.tainted = AttrScanner.toBytes(taint);
        }

        void parse(InputStream stream) throws IOException, IllegalArgumentException {
            if (stream == null) {
                throw Util.illegalNull("stream");
            }
            this.reset();
            this.m_stream = stream;
            while (this.parseAnotherAttribute()) {
            }
            this.m_stream = null;
        }

        private boolean parseAnotherAttribute() throws IOException {
            int pos = this.m_start;
            boolean copy = false;
            boolean inValue = false;
            int copyPos = -1;
            int limit = this.m_end < pos ? this.m_buffer.length : this.m_end;
            int state = 0;
            int keyState = 0;
            byte expectedKey = -1;
            int numContinuationBytesNeeded = 0;
            while (true) {
                if (pos >= limit) {
                    if (this.m_end < pos) {
                        assert (limit == this.m_buffer.length);
                        if (this.m_end <= 0) {
                            if (inValue) {
                                if (this.m_start <= 1) {
                                    throw new IOException();
                                }
                            } else {
                                this.m_start = 0;
                            }
                            if (!this.fill()) break;
                        }
                        pos = 0;
                        limit = this.m_end;
                    } else {
                        assert (limit == this.m_end);
                        if (inValue) {
                            if (this.m_end + 1 >= this.m_buffer.length) {
                                throw new IOException();
                            }
                        } else {
                            this.m_start = 0;
                            this.m_end = 0;
                            pos = 0;
                        }
                        if (!this.fill()) break;
                        int n = limit = this.m_end < pos ? this.m_buffer.length : this.m_end;
                        if (pos >= this.m_buffer.length) {
                            pos = 0;
                        }
                    }
                }
                byte b = this.m_buffer[pos++];
                if (numContinuationBytesNeeded > 0) {
                    if ((b & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    --numContinuationBytesNeeded;
                } else {
                    if (!inValue && keyState >= 0) {
                        if (keyState == 0) {
                            if (b == 82 || b == 114) {
                                keyState = 1;
                            } else if (b == 66 || b == 98) {
                                keyState = 17;
                            } else if (b == 83 || b == 115) {
                                keyState = 64;
                            } else if (b == 70 || b == 102) {
                                keyState = 90;
                            } else if (b == 84 || b == 116) {
                                keyState = 115;
                            } else {
                                if (b == 13 || b == 10) {
                                    return false;
                                }
                                keyState = -1;
                            }
                        } else if (keyState == 23) {
                            keyState = b == 67 || b == 99 ? 24 : (b == 83 || b == 115 ? 35 : (b == 78 || b == 110 ? 49 : (b == 86 || b == 118 ? 55 : -1)));
                        } else if (keyState == 50) {
                            keyState = b == 77 || b == 109 ? 51 : (b == 84 || b == 116 ? 105 : -1);
                        } else if (keyState > 0 && keyState <= 123) {
                            if (b >= 97 && b <= 122) {
                                b = (byte)(b - 32);
                            }
                            keyState = b == expectedKey ? ++keyState : -1;
                        } else {
                            throw new IllegalStateException();
                        }
                        if (keyState >= 0) {
                            expectedKey = EXPECTED[keyState];
                            if (expectedKey != 36) continue;
                            inValue = true;
                            if (pos >= this.m_buffer.length) {
                                pos = 0;
                            }
                            this.m_start = pos;
                            continue;
                        }
                        if (b == 10) {
                            state = 2;
                            this.m_start = pos;
                            break;
                        }
                        if (b == 13) {
                            state = 1;
                            continue;
                        }
                    }
                    if (state != 0) {
                        if (state == 1) {
                            state = 2;
                            if (!inValue) {
                                this.m_start = b == 10 ? pos : pos - 1;
                                break;
                            }
                            if (b == 10) continue;
                        }
                        if (state == 2) {
                            if (b == 32) {
                                state = 0;
                                copy = true;
                                continue;
                            }
                            --pos;
                            break;
                        }
                    }
                    if (b >= 0) {
                        if (b == 10) {
                            state = 2;
                            if (!inValue) {
                                this.m_start = pos;
                                break;
                            }
                            if (copy) continue;
                            copyPos = pos - 1;
                            continue;
                        }
                        if (b == 13) {
                            state = 1;
                            if (copy) continue;
                            copyPos = pos - 1;
                            continue;
                        }
                    } else if ((b & 0xE0) == 192) {
                        numContinuationBytesNeeded = 1;
                    } else if ((b & 0xF0) == 224) {
                        numContinuationBytesNeeded = 2;
                    } else {
                        throw new UTFDataFormatException();
                    }
                }
                if (!copy) continue;
                if (copyPos >= this.m_buffer.length) {
                    copyPos = 0;
                }
                this.m_buffer[copyPos++] = b;
            }
            if (numContinuationBytesNeeded > 0) {
                throw new UTFDataFormatException();
            }
            if (inValue) {
                byte[] value;
                int end;
                int n = end = copyPos > 0 ? copyPos : pos;
                if (end < this.m_start) {
                    int n1 = this.m_buffer.length - this.m_start;
                    int n2 = n1 + end;
                    if (n2 > 0) {
                        value = new byte[n2];
                        System.arraycopy(this.m_buffer, this.m_start, value, 0, n1);
                        System.arraycopy(this.m_buffer, 0, value, n2, end);
                    } else {
                        value = ZERO_BYTES;
                    }
                } else {
                    int n3 = end - this.m_start;
                    if (n3 > 0) {
                        value = new byte[n3];
                        System.arraycopy(this.m_buffer, this.m_start, value, 0, n3);
                    } else {
                        value = ZERO_BYTES;
                    }
                }
                this.m_start = pos;
                switch (keyState) {
                    case 16: {
                        this.requireBundle = value;
                        break;
                    }
                    case 34: {
                        this.bundleClassPath = value;
                        break;
                    }
                    case 48: {
                        this.bundleSymbolicName = value;
                        break;
                    }
                    case 54: {
                        this.bundleName = value;
                        break;
                    }
                    case 63: {
                        this.bundleVersion = value;
                        break;
                    }
                    case 89: {
                        this.sasCycleRequireBundle = value;
                        break;
                    }
                    case 104: {
                        this.fragmentHost = value;
                        break;
                    }
                    case 114: {
                        this.bundleNativeCode = value;
                        break;
                    }
                    case 123: {
                        this.tainted = value;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return state == 2;
        }

        private boolean fill() throws IOException {
            int len;
            if (this.m_end < this.m_start) {
                len = this.m_start - 1 - this.m_end;
                if (len <= 0) {
                    return false;
                }
            } else {
                len = this.m_buffer.length - this.m_end;
                if (len <= 0) {
                    len = this.m_start - 1;
                    if (len <= 0) {
                        return false;
                    }
                    this.m_end = 0;
                }
            }
            assert (len > 0);
            int nRead = this.m_stream.read(this.m_buffer, this.m_end, len);
            if (nRead <= 0) {
                return false;
            }
            this.m_end += nRead;
            return true;
        }
    }
}

