/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.uiconfig;

import com.sas.prompts.util.AttributeValue;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BaseUIConfiguration
extends BaseAbstractPersistence
implements UIConfigurationInterface {
    private static final long serialVersionUID = 7571309874348610527L;
    private String styleName;
    private Map<String, Object> styles;
    private Map<String, Object> options;

    public String getUIFactoryKey() {
        return "BaseUIConfiguration";
    }

    public String getDefinitionElementName() {
        return "BaseUIConfiguration";
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public Map<String, Object> getStyles() {
        if (this.styles == null) {
            this.styles = new HashMap<String, Object>();
        }
        return this.styles;
    }

    public void setStyles(Map<String, Object> newStyles) {
        this.styles = newStyles;
    }

    public Map<String, Object> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        return this.options;
    }

    public void setOptions(Map<String, Object> newOptions) {
        this.options = newOptions;
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        AttributeValue sc;
        Set<Map.Entry<String, Object>> entries;
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"styleName", (String)this.styleName);
        if (this.styles != null && !this.styles.isEmpty()) {
            this.getLogger2().debug("Writing styles.");
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            entries = this.styles.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                sc = new AttributeValue();
                sc.setName(entry.getKey());
                sc.setValue(entry.getValue());
                list.add(sc);
            }
            BaseUIConfiguration.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Styles");
        }
        if (this.options != null && !this.options.isEmpty()) {
            this.getLogger2().debug("Writing uiconfig options.");
            ArrayList<AttributeValue> optionList = new ArrayList<AttributeValue>();
            entries = this.options.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                sc = new AttributeValue();
                sc.setName(entry.getKey());
                sc.setValue(entry.getValue());
                optionList.add(sc);
            }
            BaseUIConfiguration.writeRelatedObjects(optionList, (Node)element, (PromptsWritingContext)writingContext, (String)"UIConfigOptions");
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList uiOptionsList;
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Styles");
        if (!list.isEmpty()) {
            for (AttributeValue sc : list) {
                this.getStyles().put(sc.getName(), sc.getValue());
            }
        }
        if (!(uiOptionsList = roHolder.consumeObjects("UIConfigOptions")).isEmpty()) {
            for (AttributeValue sc : uiOptionsList) {
                this.getOptions().put(sc.getName(), sc.getValue());
            }
        }
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setStyleName(provider.consumeAttr("styleName"));
    }
}

