/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.simplesqlmodel;

import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.simplesqlmodel.SQLModelPromptUtil;
import com.sas.storage.simplesqlmodel.BaseOperator;
import com.sas.storage.simplesqlmodel.MultiValueOperandInterface;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.StringOperand;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PromptValueOperand
extends AbstractPersistence
implements OperandInterface,
MultiValueOperandInterface,
ResourceReferencesInterface,
ValueOperandV2Interface {
    public static final String PROMPT_VALUES_OPERAND_CONTEXT = "PROMPT_VALUES_OPERAND_CONTEXT";
    public static final String PRINT_OPERAND_CONTEXT = "PRINT_OPERAND_CONTEXT";
    private static final long serialVersionUID = -8526511160296812388L;
    private PromptDefinitionInterface promptDefinition;

    public PromptValueOperand() {
    }

    public PromptValueOperand(PromptDefinitionInterface promptDefinition) {
        this.setPromptDefinition(promptDefinition);
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }

    public void setPromptDefinition(PromptDefinitionInterface promptDefinition) {
        this.promptDefinition = promptDefinition;
        this.getLogger2().debug("setPromptDefinition() to:", this.promptDefinition.getPromptName());
    }

    public String getOperandAsString(Map context) {
        throw new IllegalStateException("Use getVariableOperands");
    }

    public List getVariableOperands(Map context) {
        ValidateArg.notNull((Object)context, (String)"context");
        PromptValuesInterface promptValues = (PromptValuesInterface)context.get(PROMPT_VALUES_OPERAND_CONTEXT);
        if (promptValues == null) {
            if (context.containsKey(PRINT_OPERAND_CONTEXT)) {
                String name = "no prompt set";
                if (this.promptDefinition != null) {
                    name = this.promptDefinition.getPromptName() != null ? this.promptDefinition.getPromptName() : this.promptDefinition.getPromptLabel(Locale.US);
                }
                ArrayList<StringOperand> retList = new ArrayList<StringOperand>(1);
                retList.add(new StringOperand("<Value of prompt : " + name + ">"));
                return retList;
            }
            throw new IllegalStateException("Context does not contain a PromptValuesInterface with key PROMPT_VALUES_OPERAND_CONTEXT");
        }
        try {
            Object promptValue = promptValues.getPromptValue(this.promptDefinition);
            List operandList = SQLModelPromptUtil.createOperandsFromPromptValue(null, promptValue, this.promptDefinition);
            return operandList;
        }
        catch (PromptValueNotFoundException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Unable to get prompt value");
        }
    }

    public int compareTo(ValueOperandInterface o, Locale locale) {
        return 0;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public boolean evaluateOperandAsBoolean(Locale locale, Map context) {
        if (this.getPromptDefinition() == null) {
            return false;
        }
        List tempOperandList = new ArrayList<PromptValueOperand>(1);
        tempOperandList.add(this);
        tempOperandList = BaseOperator.expandOperandsInList(tempOperandList, (Map)context);
        if (tempOperandList == null || tempOperandList.size() == 0) {
            return false;
        }
        if (tempOperandList.size() == 1 && tempOperandList.get(0) instanceof ValueOperandV2Interface) {
            return ((ValueOperandV2Interface)tempOperandList.get(0)).evaluateOperandAsBoolean(locale, context);
        }
        return true;
    }

    public Object evaluateOperand(Locale locale, Map context) {
        if (this.getPromptDefinition() == null) {
            return false;
        }
        List tempOperandList = new ArrayList<PromptValueOperand>(1);
        tempOperandList.add(this);
        tempOperandList = BaseOperator.expandOperandsInList(tempOperandList, (Map)context);
        if (tempOperandList == null || tempOperandList.size() == 0) {
            return false;
        }
        if (tempOperandList.size() == 1 && tempOperandList.get(0) instanceof ValueOperandV2Interface) {
            return ((ValueOperandV2Interface)tempOperandList.get(0)).evaluateOperand(locale, context);
        }
        return true;
    }

    public String getDefinitionElementName() {
        return "PromptValueOperand";
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList promptDefList = roHolder.consumeObjects("PromptDefinition");
        if (promptDefList != null && promptDefList.size() != 0) {
            PromptDefinitionInterface promptDef = (PromptDefinitionInterface)promptDefList.get(0);
            this.setPromptDefinition(promptDef);
            this.getLogger2().debug("consuming related objects, setPromptDefn to:", this.getPromptDefinition().getPromptName());
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        ArrayList<PromptDefinitionInterface> list = new ArrayList<PromptDefinitionInterface>(1);
        list.add(this.getPromptDefinition());
        PromptValueOperand.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"PromptDefinition");
    }

    public List getReferencedResources(Class type, boolean recursive) {
        ArrayList<PromptDefinitionInterface> list = new ArrayList<PromptDefinitionInterface>(1);
        if (this.promptDefinition != null) {
            if (null != type && PromptDefinitionInterface.class.isAssignableFrom(type)) {
                list.add(this.promptDefinition);
            } else if (null == type) {
                list.add(this.promptDefinition);
            }
        }
        return list;
    }
}

