/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.datatypes.BooleanType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.prompts.definitions.vr.PersistableColumnDefinition;
import com.sas.prompts.util.MapText;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.storage.vr.dto.WSColumnDefinition;
import com.sas.storage.vr.dto.WSProperty;
import com.sas.storage.vr.dto.WSPropertyKeyEnum;
import com.sas.storage.vr.dto.WSSiteProperty;
import com.sas.storage.vr.dto.WSValueRetrieverConfiguration;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class WebServiceValueRetrieverSupport
extends ValueRetrieverDefinitionSupport {
    private static final long serialVersionUID = 1L;
    public static final String RB_KEY = "WebServiceValueRetrieverSupport.";
    public static final String contextKeyPrefix = "contextKeyPrefix";
    public static final String QueryValues = "QueryValues";
    public static final String Namespaces = "Namespaces";
    public static final String Columns = "Columns";
    public static final String isSOAP = "soap";
    public static final String isDynamicSource = "dynamicSource";
    public static final String soapAction = "soapAction";
    public static final String soapEndpointReference = "soapEndpointReference";
    public static final String soapMessage = "soapMessage";
    public static final String endpointURL = "endpointURL";
    public static final String httpMethod = "httpMethod";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String period = ".";
    private WSValueRetrieverConfiguration vrConfig = new WSValueRetrieverConfiguration();
    private List<PersistableColumnDefinition> columnList = Collections.synchronizedList(new LinkedList());

    public WebServiceValueRetrieverSupport() {
        this.vrConfig.setDynamicSource(true);
        this.vrConfig.setHttpMethod(GET);
    }

    @Override
    public void addLocalizedPropertiesFromValueRetriever(Locale locale, PropertyList list) {
        if (!this.vrConfig.getWSColumnDefinitions().isEmpty()) {
            this.getLogger2().debug("addLocalizedPropertiesFromValueRetriever for column headers.");
            list.addComment("This is for columns of the WebServiceValueRetrieverConfiguration.");
            list.addComment("The value is the column header text.");
            int i = 0;
            for (PersistableColumnDefinition col : this.columnList) {
                list.addProperty("Column", i, col.getLocalizableProperties(locale));
                ++i;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WebServiceValueRetrieverSupport clone = (WebServiceValueRetrieverSupport)((Object)super.clone());
        for (PersistableColumnDefinition def : this.columnList) {
            clone.columnList.add(def);
        }
        clone.vrConfig = this.vrConfig;
        return clone;
    }

    @Override
    public void setLocalizedPropertiesOnValueRetriever(Locale locale, PropertyMap map) {
        int i = 0;
        for (PersistableColumnDefinition def : this.columnList) {
            PropertyMap subMap = map.getNestedProperties("Column", i);
            if (null != subMap) {
                def.setLocalizableProperties(locale, subMap);
            }
            ++i;
        }
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        this.getLogger2().debug("configureAttributes starting");
        this.vrConfig.setDynamicSource(true);
        List colAttrName = (List)options.get("WebServiceValueRetrieverSupport.Columns.attribute");
        List colHeader = (List)options.get("WebServiceValueRetrieverSupport.Columns.headerText");
        List colType = (List)options.get("WebServiceValueRetrieverSupport.Columns.dataType");
        List colValueCol = (List)options.get("WebServiceValueRetrieverSupport.Columns.valueColumn");
        List colXPath = (List)options.get("WebServiceValueRetrieverSupport.Columns.xPath");
        if (null != colValueCol && null != colAttrName && null != colType && null != colHeader && null != colXPath) {
            int i;
            if (colValueCol.size() != colAttrName.size() || colAttrName.size() != colType.size() || colType.size() != colXPath.size() || colXPath.size() != colHeader.size()) {
                this.throwException("The lists for column definitions are of different sizes.");
            }
            this.vrConfig.getWSColumnDefinitions().clear();
            for (i = 0; i < colAttrName.size(); ++i) {
                WSColumnDefinition column = new WSColumnDefinition();
                PersistableColumnDefinition def = new PersistableColumnDefinition();
                column.setAttributeName((String)colAttrName.get(i));
                column.setHeaderText((String)colHeader.get(i));
                column.setLocale((String)context.get("__SAS_Locale"));
                column.setValueColumn(((Boolean)BooleanType.DEFAULT_INSTANCE.coerceValue(colValueCol.get(i), Locale.US)).booleanValue());
                column.setXPath((String)colXPath.get(i));
                column.setDataType(ValueDataTypeEnum.valueOf((String)((String)colType.get(i))));
                this.vrConfig.getWSColumnDefinitions().add(column);
                def.setColumnDefinition(column);
                this.columnList.add(def);
                this.getLogger2().debug("added WSColumnDefinition with header:", column.getHeaderText());
            }
            i = 0;
            for (PersistableColumnDefinition def : this.columnList) {
                if (!def.getColumnDefinition(null).isValueColumn()) continue;
                ++i;
            }
            if (i != 1 && !this.columnList.isEmpty()) {
                String msg = "There is either no value column or more than one value column.";
                this.throwException(msg);
            }
        }
        List queryPropKeys = (List)options.get("WebServiceValueRetrieverSupport.QueryValues.key");
        List queryPropValues = (List)options.get("WebServiceValueRetrieverSupport.QueryValues.value");
        if (null != queryPropKeys && null != queryPropValues) {
            this.getLogger2().debug("processing query values");
            if (queryPropKeys.size() != queryPropValues.size()) {
                this.throwException("The lists for query values are of different sizes.");
            }
            for (int i = 0; i < queryPropKeys.size(); ++i) {
                this.testForNull((String)queryPropKeys.get(i));
                this.testForDelimiter((String)queryPropKeys.get(i));
                WSProperty prop = new WSProperty();
                prop.setName((String)queryPropKeys.get(i));
                prop.setValue((String)queryPropValues.get(i));
                this.vrConfig.getQueryValues().add(prop);
                this.getLogger2().debug("added query for field:", prop.getName());
            }
        }
        List namespaceKeys = (List)options.get("WebServiceValueRetrieverSupport.Namespaces.key");
        List namespaceValues = (List)options.get("WebServiceValueRetrieverSupport.Namespaces.value");
        if (null != namespaceKeys && null != namespaceValues) {
            this.getLogger2().debug("processing namespaces");
            if (namespaceKeys.size() != namespaceValues.size()) {
                this.throwException("The lists for namespaces are of different sizes.");
            }
            for (int i = 0; i < namespaceKeys.size(); ++i) {
                this.testForNull((String)namespaceKeys.get(i));
                WSProperty prop = new WSProperty();
                prop.setName((String)namespaceKeys.get(i));
                prop.setValue((String)namespaceValues.get(i));
                this.vrConfig.getQueryValues().add(prop);
                this.getLogger2().debug("added namespace:", prop.getName());
            }
        }
        this.vrConfig.setContextKeyPrefix((String)options.get("WebServiceValueRetrieverSupport.contextKeyPrefix"));
        this.vrConfig.setEndpointURL((String)options.get("WebServiceValueRetrieverSupport.endpointURL"));
        this.vrConfig.setHttpMethod((String)options.get("WebServiceValueRetrieverSupport.httpMethod"));
        this.vrConfig.setSoapAction((String)options.get("WebServiceValueRetrieverSupport.soapAction"));
        this.vrConfig.setSoapEndpointReference((String)options.get("WebServiceValueRetrieverSupport.soapEndpointReference"));
        this.vrConfig.setSoapMessage((String)options.get("WebServiceValueRetrieverSupport.soapMessage"));
        if (null != this.vrConfig.getSoapEndpointReference()) {
            this.vrConfig.setSOAP(true);
        }
        if (null != this.vrConfig.getHttpMethod() && !GET.equals(this.vrConfig.getHttpMethod()) && !POST.equals(this.vrConfig.getHttpMethod())) {
            this.throwException("The HTTP method value may only be GET or POST.");
        }
    }

    private void throwException(String msg) {
        this.getLogger2().error("configureAttributes() - " + msg);
        throw new IllegalArgumentException(msg);
    }

    private void testForNull(String string) {
        if (null == string) {
            this.throwException("Keys may not be null.");
        }
    }

    private void testForDelimiter(String string) {
        if (!string.startsWith("^")) {
            this.throwException("Keys for query values must start with '^'.");
        }
    }

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        if (null != this.getApplicationContext()) {
            Map map = this.getApplicationContext().getOptions();
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                WSPropertyKeyEnum name;
                block6: {
                    name = null;
                    try {
                        name = WSPropertyKeyEnum.valueOf((String)((String)entry.getKey()));
                    }
                    catch (IllegalArgumentException e) {
                        String prefix = this.vrConfig.getContextKeyPrefix();
                        if (null == prefix || prefix.length() <= 0 || !((String)entry.getKey()).startsWith(prefix)) break block6;
                        String key = ((String)entry.getKey()).substring(prefix.length());
                        try {
                            name = WSPropertyKeyEnum.valueOf((String)key);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                if (null == name) continue;
                WSSiteProperty property = new WSSiteProperty();
                property.setName(name);
                property.setValue((String)entry.getValue());
                this.vrConfig.getSiteProperties().add(property);
                this.getLogger2().debug("app context has a site property named:", property.getName().toString());
            }
        }
        return this.vrConfig;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        if (null != config && config instanceof WSValueRetrieverConfiguration) {
            this.vrConfig = (WSValueRetrieverConfiguration)config;
            this.vrConfig.setDynamicSource(true);
            this.columnList.clear();
            for (WSColumnDefinition def : this.vrConfig.getWSColumnDefinitions()) {
                PersistableColumnDefinition pcd = new PersistableColumnDefinition();
                pcd.setColumnDefinition(def);
                this.columnList.add(pcd);
            }
        } else {
            throw new IllegalArgumentException("This method only accepts a WSValueRetrieverConfiguration!");
        }
    }

    @Override
    public Collection<ValidationEntry> validateDefinitionWithDefinition(PromptDefinitionInterface definition, Locale locale) {
        return Collections.emptyList();
    }

    @Override
    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        MapText text;
        ArrayList<PersistableColumnDefinition> list;
        List list0;
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)contextKeyPrefix, (String)this.vrConfig.getContextKeyPrefix());
        XmlUtil.setAttr((Element)element, (String)endpointURL, (String)this.vrConfig.getEndpointURL());
        XmlUtil.setAttr((Element)element, (String)httpMethod, (String)this.vrConfig.getHttpMethod());
        XmlUtil.setBooleanAttr((Element)element, (String)isSOAP, (boolean)this.vrConfig.isSOAP(), (boolean)false);
        XmlUtil.setAttr((Element)element, (String)soapAction, (String)this.vrConfig.getSoapAction());
        XmlUtil.setAttr((Element)element, (String)soapEndpointReference, (String)this.vrConfig.getSoapEndpointReference());
        XmlUtil.setAttr((Element)element, (String)soapMessage, (String)this.vrConfig.getSoapMessage());
        if (null != this.vrConfig.getWSColumnDefinitions() && !this.vrConfig.getWSColumnDefinitions().isEmpty()) {
            this.getLogger2().debug("Writing column definitions.");
            list0 = this.vrConfig.getWSColumnDefinitions();
            list = new ArrayList<PersistableColumnDefinition>();
            for (WSColumnDefinition def : list0) {
                PersistableColumnDefinition pcd = new PersistableColumnDefinition();
                pcd.setColumnDefinition(def);
                list.add(pcd);
            }
            WebServiceValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)Columns);
        }
        if (null != this.vrConfig.getNamespaces() && !this.vrConfig.getNamespaces().isEmpty()) {
            this.getLogger2().debug("Writing namespaces.");
            list0 = this.vrConfig.getNamespaces();
            list = new ArrayList();
            for (WSProperty prop : list0) {
                text = new MapText();
                text.setKey(prop.getName());
                text.setText(prop.getValue());
                list.add((PersistableColumnDefinition)text);
            }
            WebServiceValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)Namespaces);
        }
        if (null != this.vrConfig.getQueryValues() && !this.vrConfig.getQueryValues().isEmpty()) {
            this.getLogger2().debug("Writing query values.");
            list0 = this.vrConfig.getQueryValues();
            list = new ArrayList();
            for (WSProperty prop : list0) {
                text = new MapText();
                text.setKey(prop.getName());
                text.setText(prop.getValue());
                list.add((PersistableColumnDefinition)text);
            }
            WebServiceValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)QueryValues);
        }
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.vrConfig.setDynamicSource(true);
        this.vrConfig.setSOAP(provider.consumeBooleanAttr(isSOAP, false));
        this.vrConfig.setContextKeyPrefix(provider.consumeAttr(contextKeyPrefix));
        this.vrConfig.setSoapEndpointReference(provider.consumeAttr(soapEndpointReference));
        this.vrConfig.setSoapAction(provider.consumeAttr(soapAction));
        this.vrConfig.setEndpointURL(provider.consumeAttr(endpointURL));
        this.setHTTPMethod(provider.consumeAttr(httpMethod));
        this.vrConfig.setSoapMessage(provider.consumeAttr(soapMessage));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setHTTPMethod(String method) {
        if (null != method && !"".equals(method)) {
            String meth = method.toUpperCase();
            if (!GET.equals(meth) && !POST.equals(meth)) throw new IllegalArgumentException("The HTTP method must be GET or POST.");
            this.vrConfig.setHttpMethod(meth);
            return;
        } else {
            this.vrConfig.setHttpMethod(GET);
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList namespaceL;
        ArrayList query;
        super.consumeRelatedObjects(roHolder);
        ArrayList cols = roHolder.consumeObjects(Columns);
        if (cols.size() > 0) {
            this.getLogger2().debug("consuming one or more ColumnDefs");
            for (Object bean : cols) {
                this.columnList.add((PersistableColumnDefinition)((Object)bean));
                this.vrConfig.getWSColumnDefinitions().add(((PersistableColumnDefinition)((Object)bean)).getColumnDefinition(null));
            }
        }
        if ((query = roHolder.consumeObjects(QueryValues)).size() > 0) {
            this.getLogger2().debug("consuming query values");
            for (MapText text : query) {
                WSProperty prop = new WSProperty();
                prop.setName(text.getKey());
                prop.setValue(text.getText());
                this.vrConfig.getQueryValues().add(prop);
            }
        }
        if ((namespaceL = roHolder.consumeObjects(Namespaces)).size() > 0) {
            this.getLogger2().debug("consuming namespaces");
            for (MapText text : namespaceL) {
                WSProperty prop = new WSProperty();
                prop.setName(text.getKey());
                prop.setValue(text.getText());
                this.vrConfig.getNamespaces().add(prop);
            }
        }
    }

    @Override
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        return super.getDependentPrompts(locale, dynamicValueContext);
    }

    public String getDefinitionElementName() {
        return "WebServiceValueRetrieverSupport";
    }
}

