/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.prompts.definitions.vr.PersistableMetadataItem;
import com.sas.prompts.definitions.vr.PersistableQueryItem;
import com.sas.prompts.definitions.vr.PersistableSearch;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.util.MapText;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.MetadataItem;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class DynamicValueRetrieverSupport
extends ValueRetrieverDefinitionSupport {
    private static final String SearchCriteria = "SearchCriteria";
    private DynamicValueRetrieverConfiguration vrConfig = new DynamicValueRetrieverConfiguration();
    private static final long serialVersionUID = 1L;
    public static final String MetadataItems = "MetadataItems";
    public static final String QueryItems = "QueryItems";
    public static final String QueryProperties = "QueryProperties";
    private static final String period = ".";
    public static final String RB_KEY = "DynamicValueRetrieverSupport.";

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        return this.vrConfig;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        if (!(config instanceof DynamicValueRetrieverConfiguration)) {
            throw new IllegalArgumentException("This method only accepts a DynamicValueRetrieverConfiguration!");
        }
        this.vrConfig = (DynamicValueRetrieverConfiguration)config;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        this.getLogger2().debug("configureAttributes starting");
        this.vrConfig.setDynamicSource(true);
        List metadataLoc = (List)options.get("DynamicValueRetrieverSupport.MetadataItems.dataSourceLocation");
        List metadataDSType = (List)options.get("DynamicValueRetrieverSupport.MetadataItems.dataSourceType");
        List metadataType = (List)options.get("DynamicValueRetrieverSupport.MetadataItems.dataType");
        if (null != metadataLoc && null != metadataDSType && null != metadataType) {
            if (metadataLoc.size() != metadataDSType.size() || metadataDSType.size() != metadataType.size()) {
                String msg = "The lists for metadata items are of different sizes.";
                this.getLogger2().error("configureAttributes() - " + msg);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 0; i < metadataLoc.size(); ++i) {
                MetadataItem item = new MetadataItem();
                DataSource source = new DataSource();
                source.setDataSourceLocation((String)metadataLoc.get(i));
                source.setDataSourceType(Long.parseLong((String)metadataDSType.get(i)));
                item.setDataSource(source);
                item.setItemTypeToRetrieve(ValueDataTypeEnum.valueOf((String)((String)metadataType.get(i))));
                this.vrConfig.getMetadataItems().add(item);
                this.getLogger2().debug("added MetadataItem for location:", source.getDataSourceLocation());
            }
        }
        List queryPropKeys = (List)options.get("DynamicValueRetrieverSupport.QueryProperties.key");
        List queryPropValues = (List)options.get("DynamicValueRetrieverSupport.QueryProperties.value");
        if (null != queryPropKeys && null != queryPropValues) {
            if (queryPropKeys.size() != queryPropValues.size()) {
                String msg = "The lists for query properties are of different sizes.";
                this.getLogger2().error("configureAttributes() - " + msg);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 0; i < queryPropKeys.size(); ++i) {
                QueryProperty prop = new QueryProperty();
                prop.setName((String)queryPropKeys.get(i));
                prop.setValue((String)queryPropValues.get(i));
                this.vrConfig.getQueryProperties().add(prop);
                this.getLogger2().debug("added QueryProperty for name:", prop.getName());
            }
        }
    }

    @Override
    public Collection<ValidationEntry> validateDefinitionWithDefinition(PromptDefinitionInterface definition, Locale locale) {
        return Collections.emptyList();
    }

    @Override
    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        List qList;
        AbstractPersistence pItem;
        super.writeDefinition(element, writingContext);
        ArrayList<Object> list = new ArrayList<Object>();
        if (!this.vrConfig.getMetadataItems().isEmpty()) {
            List mList = this.vrConfig.getMetadataItems();
            for (MetadataItem item : mList) {
                pItem = new PersistableMetadataItem();
                pItem.setMetadataItem(item);
                list.add(pItem);
            }
            this.getLogger2().debug("Writing metadata items.");
            DynamicValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)MetadataItems);
            list.clear();
        }
        if (!this.vrConfig.getQueryItems().isEmpty()) {
            qList = this.vrConfig.getQueryItems();
            for (MetadataItem item : qList) {
                pItem = new PersistableQueryItem();
                pItem.setQueryItem((QueryItem)item);
                list.add(pItem);
            }
            this.getLogger2().debug("Writing query items.");
            DynamicValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)QueryItems);
            list.clear();
        }
        if (!this.vrConfig.getQueryProperties().isEmpty()) {
            qList = this.vrConfig.getQueryProperties();
            for (MetadataItem item : qList) {
                MapText property = new MapText();
                property.setKey(item.getName());
                property.setText(item.getValue());
                list.add(property);
            }
            this.getLogger2().debug("Writing query props.");
            DynamicValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)QueryProperties);
            list.clear();
        }
        if (null != this.vrConfig.getSearch()) {
            PersistableSearch pSearch = new PersistableSearch();
            pSearch.setSearch(this.vrConfig.getSearch());
            list.add((Object)pSearch);
            this.getLogger2().debug("Writing search.");
            DynamicValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)SearchCriteria);
            list.clear();
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.vrConfig.setDynamicSource(true);
        ArrayList qItems = roHolder.consumeObjects(QueryItems);
        if (!qItems.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, for query items");
        }
        for (Object item : qItems) {
            QueryItem q = ((PersistableQueryItem)((Object)item)).getQueryItem();
            this.vrConfig.getQueryItems().add(q);
        }
        ArrayList mItems = roHolder.consumeObjects(MetadataItems);
        if (!mItems.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, for metadata items");
        }
        for (Object item : mItems) {
            MetadataItem q = ((PersistableMetadataItem)((Object)item)).getMetadataItem();
            this.vrConfig.getMetadataItems().add(q);
        }
        ArrayList mapText = roHolder.consumeObjects(QueryProperties);
        if (!mapText.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, for query properties");
        }
        for (MapText text : mapText) {
            QueryProperty q = new QueryProperty();
            q.setName(text.getKey());
            q.setValue(text.getText());
            this.vrConfig.getQueryProperties().add(q);
        }
        PersistableSearch pSearch = (PersistableSearch)roHolder.consumeObject(SearchCriteria);
        if (null != pSearch) {
            this.getLogger2().debug("consumeRelatedObjs: got a Search object");
            this.vrConfig.setSearch(pSearch.getSearch());
        }
    }

    public String getDefinitionElementName() {
        return "DynamicValueRetrieverSupport";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DynamicValueRetrieverSupport retVal = (DynamicValueRetrieverSupport)((Object)super.clone());
        retVal.vrConfig = this.vrConfig;
        return retVal;
    }

    @Override
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        Search search = this.vrConfig.getSearch();
        if (null != search) {
            List list = search.getSearchCriteriaList();
            ArrayList<PromptDefinitionInterface> retVal = new ArrayList<PromptDefinitionInterface>();
            for (QueryItemSearchCriteria item : list) {
                PromptValueOperand pvo = (PromptValueOperand)((Object)item.getRightExpression());
                if (null == pvo) continue;
                retVal.add(pvo.getPromptDefinition());
                this.getLogger2().debug("getDependentPrompts(), added prompt to return:", pvo.getPromptDefinition().getPromptName());
            }
            return retVal;
        }
        return super.getDependentPrompts(locale, dynamicValueContext);
    }

    @Override
    public List<?> getReferencedResources(Class type, boolean recursive) {
        Search search = this.vrConfig.getSearch();
        if (null != search) {
            List list = search.getSearchCriteriaList();
            ArrayList retVal = new ArrayList();
            for (QueryItemSearchCriteria item : list) {
                PromptValueOperand pvo = (PromptValueOperand)((Object)item.getRightExpression());
                if (null == pvo) continue;
                List resources = pvo.getReferencedResources(type, recursive);
                retVal.addAll(resources);
            }
            return retVal;
        }
        return Collections.emptyList();
    }
}

