/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringRangeType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.MutableStringRangeDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class StringRangeDefinition
extends BaseDefinitionRange
implements MutableStringRangeDefinitionInterface {
    public static final String RB_KEY = "StringRangeDefinition.";
    private static final long serialVersionUID = -840943403715394886L;
    private String minimum;
    private String maximum;
    private int minimumLength;
    private int maximumLength;

    public StringRangeDefinition() {
        this.init();
    }

    public StringRangeDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.maximum = null;
        this.minimum = null;
        this.minimumLength = -1;
        this.maximumLength = -1;
    }

    @Override
    protected String getDefaultMaxLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "maxLabel.txt", locale);
    }

    @Override
    protected String getDefaultMinLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "minLabel.txt", locale);
    }

    @Override
    public String getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    @Override
    public String getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    @Override
    public int getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    private long validateMinMaxValue(String min, String max, Object value) {
        long returnValue = 0L;
        if (value != null) {
            if (value instanceof Object[] && ((Object[])value).length == 2) {
                Object[] objArray = (Object[])value;
                if (objArray[0] instanceof String && objArray[1] instanceof String) {
                    String minValue = (String)objArray[0];
                    String maxValue = (String)objArray[1];
                    if (min != null && minValue != null && min.compareTo(minValue) > 0) {
                        returnValue |= 0x100000L;
                    }
                    if (min != null && maxValue != null && min.compareTo(maxValue) > 0) {
                        returnValue |= 0x400000L;
                    }
                    if (max != null && minValue != null && max.compareTo(minValue) < 0) {
                        returnValue |= 0x200000L;
                    }
                    if (max != null && maxValue != null && max.compareTo(maxValue) < 0) {
                        returnValue |= 0x800000L;
                    }
                    int minLen = this.getMinimumLength();
                    int maxLen = this.getMaximumLength();
                    if (minLen > 0) {
                        if (minValue != null && minValue.length() < minLen) {
                            returnValue |= 0x200L;
                        }
                        if (maxValue != null && maxValue.length() < minLen) {
                            returnValue |= 0x1000000L;
                        }
                    }
                    if (maxLen >= 0) {
                        if (minValue != null && minValue.length() > maxLen) {
                            returnValue |= 0x400L;
                        }
                        if (maxValue != null && maxValue.length() > maxLen) {
                            returnValue |= 0x80L;
                        }
                    }
                    if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
                        returnValue |= 0x800L;
                    }
                } else {
                    returnValue |= 1L;
                }
            } else {
                returnValue |= 1L;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value)) == 0L;
    }

    public Collection getPromptValueValidationErrors(Object value, Locale locale) {
        Collection errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    public Collection validateDefinition(Locale locale) {
        Collection errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        String min = this.getMinimum();
        String max = this.getMaximum();
        long returnValue = 0L;
        if (min != null && max != null && min.compareTo(max) > 0) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        int minLen = this.getMinimumLength();
        int maxLen = this.getMaximumLength();
        if (minLen >= 0 && maxLen > 0 && minLen > maxLen) {
            errors = PromptUtil.addError(errors, 65536L, RB.getStringResource(RB_KEY, "minLengthAboveMaxLength.txt"));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(min, max, dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection populateMapWithErrors(Collection errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        errors = this.populateMapWithErrorsForValue(errors, errorCode, value, defaultValue, locale);
        if ((errorCode & 0x200L) == 512L) {
            errors = defaultValue ? PromptUtil.addError(errors, 512L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMinValueBelowMinLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale))) : PromptUtil.addError(errors, 512L, Message.format((String)RB.getStringResource(RB_KEY, "minValueBelowMinLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale)));
        }
        if ((errorCode & 0x1000000L) == 0x1000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x1000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMaxValueBelowMinLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale))) : PromptUtil.addError(errors, 0x1000000L, Message.format((String)RB.getStringResource(RB_KEY, "maxValueBelowMinLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale)));
        }
        if ((errorCode & 0x400L) == 1024L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1024L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMinValueAboveMaxLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale))) : PromptUtil.addError(errors, 1024L, Message.format((String)RB.getStringResource(RB_KEY, "minValueAboveMaxLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale)));
        }
        if ((errorCode & 0x80L) == 128L) {
            errors = defaultValue ? PromptUtil.addError(errors, 128L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMaxValueAboveMaxLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale))) : PromptUtil.addError(errors, 128L, Message.format((String)RB.getStringResource(RB_KEY, "maxValueAboveMaxLength.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale)));
        }
        errors = this.populateErrorsForMinMax(errors, errorCode, defaultValue, locale, value, this.getMinimum(), this.getMaximum());
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return StringRangeType.DEFAULT_INSTANCE;
    }

    @SASScope
    public String getDefinitionElementName() {
        return "StringRangeDefinition";
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String maxAttr = provider.consumeAttr("max");
        this.setMaximum(maxAttr);
        String minAttr = provider.consumeAttr("min");
        this.setMinimum(minAttr);
        this.setMinimumLength(provider.consumeIntAttr("minLength", -1));
        this.setMaximumLength(provider.consumeIntAttr("maxLength", -1));
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        List attributeList = super.getAttributeDescriptors(locale);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        attributeList.add(typeAttribute);
        attributeList.add(new AttributeDescriptor("min", "min", "String", (Object)this.getMinimum(), null, true, true));
        attributeList.add(new AttributeDescriptor("max", "max", "String", (Object)this.getMaximum(), null, true, true));
        attributeList.add(new AttributeDescriptor("minLength", "minLength", "int", (Object)this.getMinimumLength(), (Object)-1, true, true));
        attributeList.add(new AttributeDescriptor("maxLength", "maxLength", "int", (Object)this.getMaximumLength(), (Object)-1, true, true));
        return attributeList;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("minLength")) {
            this.setMinimumLength(PromptConfigurationFactory.getIntOption((String)"minLength", options, context));
        }
        if (options.containsKey("maxLength")) {
            this.setMaximumLength(PromptConfigurationFactory.getIntOption((String)"maxLength", options, context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getStringOption((String)"min", options, context));
        }
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getStringOption((String)"max", options, context));
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"max", (String)this.getMaximum());
        XmlUtil.setAttr((Element)element, (String)"min", (String)this.getMinimum());
        XmlUtil.setIntAttr((Element)element, (String)"minLength", (int)this.getMinimumLength(), (int)-1);
        XmlUtil.setIntAttr((Element)element, (String)"maxLength", (int)this.getMaximumLength(), (int)-1);
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", this.getMinimum());
        retVal.put("MAXIMUM", this.getMaximum());
        retVal.put("MINIMUM_LENGTH", numFormat.format(this.getMinimumLength()));
        retVal.put("MAXIMUM_LENGTH", numFormat.format(this.getMaximumLength()));
        return retVal;
    }
}

