/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionV2Interface;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class SelectableDefinitionSupport
extends AbstractPersistence {
    private static final long serialVersionUID = -7754629383342793994L;
    public static final String RB_KEY = "SelectableDefinitionSupport.";
    private int minimumValueCount;
    private int maximumValueCount;
    private boolean selectionOrdered;
    private String macroVariableDelimiter;
    private String macroVariableQuote;
    private int macroVariableListFormat;
    private static final int SPECIAL_COUNT = -4444;
    private SelectableDefinitionInterface definition;

    public SelectableDefinitionSupport() {
    }

    public SelectableDefinitionSupport(SelectableDefinitionInterface definition) {
        this.definition = definition;
        this.init();
    }

    private void init() {
        this.minimumValueCount = -1;
        this.maximumValueCount = 1;
        this.macroVariableDelimiter = null;
        this.macroVariableQuote = null;
        this.macroVariableListFormat = 2;
    }

    public int getMaximumValueCount() {
        return this.maximumValueCount;
    }

    public void setMaximumValueCount(int maximumValueCount) {
        if (maximumValueCount < -1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "maxValueCountLow.txt"));
        }
        this.maximumValueCount = maximumValueCount;
    }

    public int getMinimumValueCount() {
        return this.minimumValueCount;
    }

    public void setMinimumValueCount(int minimumValueCount) {
        if (minimumValueCount < -1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "minValueCountLow.txt"));
        }
        this.minimumValueCount = minimumValueCount;
    }

    private long validateMinMaxValueCount(int min, int max, Object value) {
        long returnValue = 0L;
        if (value != null) {
            returnValue |= this.validMinValueCountFor(value, min);
            returnValue |= this.validMaxValueCountFor(value, max);
        }
        return returnValue;
    }

    public int getSelectionType() {
        if (this.maximumValueCount == 1) {
            return 300;
        }
        if (this.isSelectionOrdered()) {
            return 302;
        }
        return 301;
    }

    public boolean isRequired() {
        return this.getMinimumValueCount() > 0;
    }

    public boolean isPromptValueValid(Object value) {
        long returnValue;
        return this.valueValid(value) && (returnValue = this.validValueCount(value)) == 0L;
    }

    private boolean valueValid(Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || this.validIndividualValue(array[i])) continue;
                return false;
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                if (element == null || this.validIndividualValue(element)) continue;
                return false;
            }
        } else {
            return this.validIndividualValue(value);
        }
        return this.valueValidForSpecialValues(value);
    }

    private boolean valueValidForSpecialValues(Object value) {
        return true;
    }

    private long validValueCount(Object value) {
        return this.validateMinMaxValueCount(this.getMinimumValueCount(), this.getMaximumValueCount(), value);
    }

    private long validMinValueCountFor(Object value, int count) {
        if (count <= 0) {
            return 0L;
        }
        if (value == null) {
            return 16L;
        }
        int valueCount = this.getValidValueCountFor(value);
        if (valueCount != -4444 && valueCount < count) {
            return 16L;
        }
        return 0L;
    }

    private long validMaxValueCountFor(Object value, int count) {
        int valueCount;
        if (count <= 0 || count == Integer.MAX_VALUE) {
            return 0L;
        }
        if (value != null && (valueCount = this.getValidValueCountFor(value)) != -4444 && valueCount > count) {
            return 32L;
        }
        return 0L;
    }

    private int getValidValueCountFor(Object value) {
        int valueCount = 0;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] instanceof SpecialValues) {
                    return -4444;
                }
                if (array[i] == null) continue;
                ++valueCount;
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                if (element instanceof SpecialValues) {
                    return -4444;
                }
                if (element == null) continue;
                ++valueCount;
            }
        } else {
            ++valueCount;
        }
        return valueCount;
    }

    protected boolean validIndividualValue(Object value) {
        return this.definition.validIndividualValue(value);
    }

    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = null;
        long returnValue = this.validValueCount(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    public Collection<ValidationEntry> validateDefinition(Object dv, Locale locale) {
        Collection<ValidationEntry> errors = new ArrayList<ValidationEntry>();
        long returnValue = 0L;
        if (this.getMinimumValueCount() > 0 && this.getMaximumValueCount() > 0 && this.getMinimumValueCount() > this.getMaximumValueCount()) {
            returnValue |= 0x40L;
        }
        if ((returnValue & 0x40L) == 64L) {
            errors = PromptUtil.addError(errors, 64L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.minValueCountAboveMax.fmt.txt", locale), (Object)Integer.toString(this.getMinimumValueCount()), (Object)Integer.toString(this.getMaximumValueCount())));
        }
        if (returnValue == 0L) {
            errors = this.populateMapWithErrors(errors, returnValue |= this.validValueCount(dv), dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 0x10L) == 16L) {
            errors = defaultValue ? PromptUtil.addError(errors, 16L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.minValueCountNotDefault.fmt.txt", locale), (Object)Integer.toString(this.getMinimumValueCount()))) : PromptUtil.addError(errors, 16L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.minValueCountNotValue.fmt.txt", locale), (Object)Integer.toString(this.getMinimumValueCount())));
        }
        if ((errorCode & 0x20L) == 32L) {
            errors = defaultValue ? PromptUtil.addError(errors, 32L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.maxValueCountAboveDefault.fmt.txt", locale), (Object)Integer.toString(this.getMaximumValueCount()))) : PromptUtil.addError(errors, 32L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.maxValueCountAboveValue.fmt.txt", locale), (Object)Integer.toString(this.getMaximumValueCount())));
        }
        return errors;
    }

    public int getMacroVariableListFormat() {
        return this.macroVariableListFormat;
    }

    public void setMacroVariableListFormat(int listFormat) {
        this.macroVariableListFormat = listFormat;
    }

    public String getMacroVariableQuote() {
        return this.macroVariableQuote;
    }

    public void setMacroVariableQuote(String quote) {
        this.macroVariableQuote = quote;
    }

    public String getMacroVariableListDelimiter() {
        return this.macroVariableDelimiter;
    }

    public void setMacroVariableListDelimiter(String delimiter) {
        this.macroVariableDelimiter = delimiter;
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        int newMinValueCount = provider.consumeIntAttr("minValueCount", -1);
        int newMaxValueCount = provider.consumeIntAttr("maxValueCount", 1);
        if (newMinValueCount > this.getMaximumValueCount()) {
            this.setMaximumValueCount(newMaxValueCount);
            this.setMinimumValueCount(newMinValueCount);
        } else {
            this.setMinimumValueCount(newMinValueCount);
            this.setMaximumValueCount(newMaxValueCount);
        }
        this.setSelectionOrdered(provider.consumeBooleanAttr("selectionOrdered", false));
        this.setMacroVariableListDelimiter(provider.consumeAttr("macroVarListDelimiter"));
        this.setMacroVariableQuote(provider.consumeAttr("macroVarListQuote"));
        this.setMacroVariableListFormat(provider.consumeIntAttr("macroVarListFormat", 2));
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
    }

    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setIntAttr((Element)element, (String)"maxValueCount", (int)this.getMaximumValueCount(), (int)1);
        XmlUtil.setIntAttr((Element)element, (String)"minValueCount", (int)this.getMinimumValueCount(), (int)-1);
        XmlUtil.setBooleanAttr((Element)element, (String)"selectionOrdered", (boolean)this.isSelectionOrdered(), (boolean)false);
        XmlUtil.setIntAttr((Element)element, (String)"macroVarListFormat", (int)this.getMacroVariableListFormat(), (int)2);
        XmlUtil.setAttr((Element)element, (String)"macroVarListDelimiter", (String)this.getMacroVariableListDelimiter());
        XmlUtil.setAttr((Element)element, (String)"macroVarListQuote", (String)this.getMacroVariableQuote());
    }

    public void configurePrompt(MutableSelectableDefinitionInterface prompt, Map options, Map context) {
        if (options.containsKey("maxValueCount")) {
            prompt.setMaximumValueCount(PromptConfigurationFactory.getIntOption((String)"maxValueCount", (Map)options, (Map)context));
        }
        if (options.containsKey("minValueCount")) {
            prompt.setMinimumValueCount(PromptConfigurationFactory.getIntOption((String)"minValueCount", (Map)options, (Map)context));
        }
        if (options.containsKey("selectionOrdered")) {
            prompt.setSelectionOrdered(PromptConfigurationFactory.getBoolOption((String)"selectionOrdered", (Map)options, (Map)context));
        }
        if (options.containsKey("macroVarListFormat")) {
            prompt.setMacroVariableListFormat(PromptConfigurationFactory.getIntOption((String)"macroVarListFormat", (Map)options, (Map)context));
        }
        if (options.containsKey("macroVarListDelimiter")) {
            prompt.setMacroVariableListDelimiter(PromptConfigurationFactory.getStringOption((String)"macroVarListDelimiter", (Map)options, (Map)context));
        }
        if (options.containsKey("macroVarListQuote")) {
            prompt.setMacroVariableQuote(PromptConfigurationFactory.getStringOption((String)"macroVarListQuote", (Map)options, (Map)context));
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        ArrayList<AttributeDescriptor> attributeList = new ArrayList<AttributeDescriptor>();
        attributeList.add(new AttributeDescriptor("maxValueCount", "maxValueCount", "int", (Object)this.getMaximumValueCount(), (Object)1, true, true));
        attributeList.add(new AttributeDescriptor("minValueCount", "minValueCount", "int", (Object)this.getMinimumValueCount(), (Object)-1, true, true));
        attributeList.add(new AttributeDescriptor("selectionOrdered", "selectionOrdered", "boolean", (Object)this.isSelectionOrdered(), (Object)false, true, true));
        return attributeList;
    }

    public boolean isSelectionOrdered() {
        if (this.maximumValueCount != 1) {
            return this.selectionOrdered;
        }
        return false;
    }

    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectionOrdered = selectionOrdered;
    }

    public List getReferencedResources(Class type, boolean recursive) {
        return Collections.EMPTY_LIST;
    }

    void addConstraints(Map<String, String> map, NumberFormat numberFormat) {
        map.put("MAXIMUM_VALUE_COUNT", numberFormat.format(this.getMaximumValueCount()));
        map.put("MINIMUM_VALUE_COUNT", numberFormat.format(this.getMinimumValueCount()));
    }

    public boolean validIndividualValue(Object value, Locale locale) {
        if (this.definition instanceof SelectableDefinitionV2Interface) {
            return ((SelectableDefinitionV2Interface)this.definition).validIndividualValue(value, locale);
        }
        return this.definition.validIndividualValue(value);
    }
}

