/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.SASLibraryLocationType;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableSASLibraryDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class SASLibraryDefinition
extends PromptDefinition
implements MutableSASLibraryDefinitionInterface {
    public static final String RB_KEY = "SASLibraryDefinition.";
    private static final long serialVersionUID = -955340333046428048L;
    private boolean required;

    public SASLibraryDefinition() {
    }

    public SASLibraryDefinition(String promptName) {
        super(promptName);
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return SASLibraryLocationType.DEFAULT_INSTANCE;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof SASLibraryLocationInterface)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotASASLibrary.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notASASLibrary.fmt.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
    }

    @SASScope
    public String getDefinitionElementName() {
        return "SASLibraryDefinition";
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
    }

    public List getAttributeDescriptors(Locale myLocale) {
        List<?> attributeList = super.getAttributeDescriptors(myLocale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        attributeList.add(new AttributeDescriptor("required", "required", "Boolean", (Object)this.isRequired(), (Object)false, true, true));
        return attributeList;
    }
}

