/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.ObjectType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableObjectDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope
public class ObjectDefinition
extends PromptDefinition
implements MutableObjectDefinitionInterface {
    public static final String RB_KEY = "ObjectDefinition.";
    private static final long serialVersionUID = -2564663046407199303L;
    private boolean required;

    public ObjectDefinition() {
        this.init();
    }

    public ObjectDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return ObjectType.DEFAULT_INSTANCE;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        boolean tempDefaultValueSet = this.isDefaultValueSet();
        Object tempDefaultValue = null;
        if (tempDefaultValueSet) {
            tempDefaultValue = this.getDefaultValue();
            this.clearDefaultValue();
        }
        super.writeDefinition(element, writingContext);
        if (tempDefaultValueSet) {
            this.setDefaultValue(tempDefaultValue);
        }
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
    }

    public String getDefinitionElementName() {
        return "ObjectDefinition";
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
    }

    public List getAttributeDescriptors(Locale myLocale) {
        List<?> attributeList = super.getAttributeDescriptors(myLocale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        attributeList.add(new AttributeDescriptor("required", "required", "Boolean", (Object)this.isRequired(), (Object)false, true, true));
        return attributeList;
    }
}

