/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerRangeType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.MutableIntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class IntegerRangeDefinition
extends BaseDefinitionRange
implements MutableIntegerRangeDefinitionInterface {
    public static final String RB_KEY = "IntegerRangeDefinition.";
    private static final long serialVersionUID = -2267646520053586700L;
    private int minimum;
    private int maximum;

    public IntegerRangeDefinition() {
        this.init();
    }

    public IntegerRangeDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.maximum = Integer.MAX_VALUE;
        this.minimum = Integer.MIN_VALUE;
    }

    @Override
    protected String getDefaultMaxLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "maxLabel.txt", locale);
    }

    @Override
    protected String getDefaultMinLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "minLabel.txt", locale);
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    private long validateMinMaxValue(int min, int max, Object value) {
        long returnValue = 0L;
        if (value != null) {
            if (value instanceof Object[] && ((Object[])value).length == 2) {
                Object[] objArray = (Object[])value;
                if (objArray[0] instanceof Integer && objArray[1] instanceof Integer) {
                    int minValue = (Integer)objArray[0];
                    int maxValue = (Integer)objArray[1];
                    if (min > minValue) {
                        returnValue |= 0x100000L;
                    }
                    if (min > maxValue) {
                        returnValue |= 0x400000L;
                    }
                    if (max < minValue) {
                        returnValue |= 0x200000L;
                    }
                    if (max < maxValue) {
                        returnValue |= 0x800000L;
                    }
                    if (minValue > maxValue) {
                        returnValue |= 0x800L;
                    }
                } else {
                    returnValue |= 1L;
                }
            } else {
                returnValue |= 1L;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value)) == 0L;
    }

    public Collection getPromptValueValidationErrors(Object value, Locale locale) {
        Collection errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    public Collection validateDefinition(Locale locale) {
        Collection errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        int min = this.getMinimum();
        int max = this.getMaximum();
        long returnValue = 0L;
        if (min != Integer.MIN_VALUE && max != Integer.MAX_VALUE && min > max) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(min, max, dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection populateMapWithErrors(Collection errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        errors = this.populateMapWithErrorsForValue(errors, errorCode, value, defaultValue, locale);
        errors = this.populateErrorsForMinMax(errors, errorCode, defaultValue, locale, value, new Integer(this.getMinimum()), new Integer(this.getMaximum()));
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return IntegerRangeType.DEFAULT_INSTANCE;
    }

    @SASScope
    public String getDefinitionElementName() {
        return "IntegerRangeDefinition";
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        int value = provider.consumeIntAttr("max", Integer.MAX_VALUE);
        this.setMaximum(value);
        value = provider.consumeIntAttr("min", Integer.MIN_VALUE);
        this.setMinimum(value);
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        List attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", (List)attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", (List)attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)Integer.MIN_VALUE, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)Integer.MAX_VALUE, true, true));
        return attributeList;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setIntAttr((Element)element, (String)"max", (int)this.getMaximum(), (int)Integer.MAX_VALUE);
        XmlUtil.setIntAttr((Element)element, (String)"min", (int)this.getMinimum(), (int)Integer.MIN_VALUE);
    }

    public void configureAttributes(Map options, Map context) {
        super.configureAttributes(options, context);
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getIntOption((String)"max", (Map)options, (Map)context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getIntOption((String)"min", (Map)options, (Map)context));
        }
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = NumberFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", numFormat.format(this.minimum));
        retVal.put("MAXIMUM", numFormat.format(this.maximum));
        return retVal;
    }
}

