/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableIntegerDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.prompts.definitions.SupportedSpecialValuesDefinitionSupport;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class IntegerDefinition
extends PromptDefinition
implements MutableIntegerDefinitionV2Interface {
    public static final String RB_KEY = "IntegerDefinition.";
    private static final long serialVersionUID = -5218860506138828932L;
    private int minimum;
    private int maximum;
    private SelectableDefinitionSupport selectableSupport;
    private ValueProviderDefinitionSupport valueProviderSupport;
    private SupportedSpecialValuesDefinitionSupport specialValueSupport;
    private ValueRetrieverDefinitionSupport vrDefSupport;

    public IntegerDefinition() {
        this.init();
    }

    public IntegerDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.maximum = Integer.MAX_VALUE;
        this.minimum = Integer.MIN_VALUE;
        this.selectableSupport = new SelectableDefinitionSupport(this);
        this.valueProviderSupport = new ValueProviderDefinitionSupport();
        this.specialValueSupport = new SupportedSpecialValuesDefinitionSupport();
        this.vrDefSupport = new ValueRetrieverDefinitionSupport();
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    @Override
    @SASScope
    public int getPageSize() {
        return this.valueProviderSupport.getPageSize();
    }

    @Override
    @SASScope
    public void setPageSize(int pageSize) {
        this.valueProviderSupport.setPageSize(pageSize);
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return super.isPromptValueValid(value, locale) && this.specialValueSupport.isPromptValueValid(value) && this.selectableSupport.isPromptValueValid(value);
    }

    @Override
    @SASScope
    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    @SASScope
    public Collection getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        if (returnValue == 0L) {
            return this.specialValueSupport.getPromptValueValidationErrors(value, locale);
        }
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateMinMaxIndividualValue(int min, int max, Object value) {
        long returnValue = 0L;
        if (value instanceof Number) {
            int numberValue = ((Number)value).intValue();
            if (min > numberValue) {
                returnValue |= 2L;
            }
            if (max < numberValue) {
                returnValue |= 4L;
            }
        }
        if (value != null && !(value instanceof Number) && !PromptUtil.isValueSupported(this, value)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    private long validateMinMaxValue(int min, int max, Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, element);
            }
        } else {
            returnValue |= this.validateMinMaxIndividualValue(min, max, value);
        }
        return returnValue;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors(errors, this.selectableSupport.getPromptValueValidationErrors(value, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        if (null == (errors = this.populateMapWithErrors(errors, returnValue, value, false, locale))) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors(errors, this.selectableSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.valueProviderSupport.validateDefinition(this, null, locale));
        errors = PromptUtil.addErrors(errors, this.vrDefSupport.validateDefinitionWithDefinition(this, locale));
        long returnValue = 0L;
        if (this.getMinimum() > this.getMaximum()) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAnInteger.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAnInteger.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 2L) == 2L) {
            errors = defaultValue ? PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "defaultValueBelowMin.fmt.txt", locale), (Object)new Integer(this.getMinimum()))) : PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "valueBelowMin.fmt.txt", locale), (Object)new Integer(this.getMinimum())));
        }
        if ((errorCode & 4L) == 4L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "defaultValueAboveMax.fmt.txt", locale), (Object)new Integer(this.getMaximum()))) : PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "valueAboveMax.fmt.txt", locale), (Object)new Integer(this.getMaximum())));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            return IntegerType.DEFAULT_INSTANCE;
        }
        return CollectionType.DEFAULT_INSTANCE_INTEGER;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.valueProviderSupport.consumeAttributes(provider);
        this.specialValueSupport.consumeAttributes(provider);
        int value = provider.consumeIntAttr("max", Integer.MAX_VALUE);
        this.setMaximum(value);
        value = provider.consumeIntAttr("min", Integer.MIN_VALUE);
        this.setMinimum(value);
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)Integer.MIN_VALUE, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)Integer.MAX_VALUE, true, true));
        attributeList.addAll(this.valueProviderSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.selectableSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.vrDefSupport.getAttributeDescriptors(locale));
        return attributeList;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        this.valueProviderSupport.writeDefinition(element, writingContext);
        this.specialValueSupport.writeDefinition(element, writingContext);
        if (null != this.vrDefSupport.getValueRetrieverConfiguration()) {
            ArrayList<ValueRetrieverDefinitionSupport> list = new ArrayList<ValueRetrieverDefinitionSupport>();
            list.add(this.vrDefSupport);
            this.getLogger2().debug("Writing value retriever element.");
            IntegerDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueRetrieverConfiguration");
        }
        XmlUtil.setIntAttr((Element)element, (String)"max", (int)this.getMaximum(), (int)Integer.MAX_VALUE);
        XmlUtil.setIntAttr((Element)element, (String)"min", (int)this.getMinimum(), (int)Integer.MIN_VALUE);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.selectableSupport.consumeRelatedObjects(roHolder);
        this.valueProviderSupport.consumeRelatedObjects(roHolder);
        this.specialValueSupport.consumeRelatedObjects(roHolder);
        ValueRetrieverDefinitionSupport temp = ValueRetrieverDefinitionSupport.newInstanceFromPersistence(roHolder);
        if (null != temp) {
            this.vrDefSupport = temp;
        }
        this.specialValueSupport.setAllowMissing(false);
        if (this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() != null && this.vrDefSupport.getValueRetrieverConfiguration().isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        }
        if (this.valueProviderSupport.getValueProvider() != null && !(this.valueProviderSupport.getValueProvider() instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        }
    }

    @SASScope
    public String getDefinitionElementName() {
        return "IntegerDefinition";
    }

    @Override
    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        List list1 = this.vrDefSupport.getReferencedResources(type, recursive);
        if (list1.isEmpty()) {
            List list2 = this.valueProviderSupport.getReferencedResources(type, recursive);
            return list2;
        }
        return list1;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        this.selectableSupport.configurePrompt(this, options, context);
        this.specialValueSupport.configurePrompt(this, options, context);
        super.configureAttributes(options, context);
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getIntOption((String)"max", options, context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getIntOption((String)"min", options, context));
        }
        this.valueProviderSupport.configurePrompt(this, options, context);
        this.vrDefSupport = ValueRetrieverDefinitionSupport.changeInstanceType(this.vrDefSupport, options);
        this.vrDefSupport.configureAttributes(options, context);
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    @SASScope
    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    @SASScope
    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @SASScope
    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    @SASScope
    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    @SASScope
    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @SASScope
    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    @Override
    public ValueProviderInterface getValueProvider() {
        return this.valueProviderSupport.getValueProvider();
    }

    public boolean isAllowUserValues() {
        return this.valueProviderSupport.isAllowUserValues();
    }

    @Override
    public void setValueProvider(ValueProviderInterface valueProvider) {
        this.valueProviderSupport.setValueProvider(valueProvider);
        if (valueProvider != null && !(valueProvider instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        } else if (this.vrDefSupport == null) {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public void setAllowUserValues(boolean allowValues) {
        this.valueProviderSupport.setAllowUserValues(allowValues);
    }

    @Override
    @SASScope
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.valueProviderSupport.getValueProvider() instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.valueProviderSupport.getValueProvider()).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return this.vrDefSupport.getDependentPrompts(locale, dynamicValueContext);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValueSupport.getSupportedSpecialValues();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValueSupport.setSupportedSpecialValues(specialValuesSupported);
    }

    @Override
    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        PromptUtil.addLocalizedPropertiesFromValueProvider(list, this.valueProviderSupport, locale);
        this.vrDefSupport.addLocalizedPropertiesFromValueRetriever(locale, list);
        return list;
    }

    @Override
    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        PromptUtil.setLocalizedPropertiesOnValueProvider(map, this.valueProviderSupport, locale);
        this.vrDefSupport.setLocalizedPropertiesOnValueRetriever(locale, map);
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", numFormat.format(this.minimum));
        retVal.put("MAXIMUM", numFormat.format(this.maximum));
        this.selectableSupport.addConstraints(retVal, numFormat);
        return retVal;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        this.vrDefSupport = ValueRetrieverDefinitionSupport.newInstance(config);
        if (config != null && config.isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        } else {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        this.vrDefSupport.setApplicationContext(this.getApplicationContext());
        ValueRetrieverConfiguration vrc = this.vrDefSupport.getValueRetrieverConfiguration();
        return vrc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        IntegerDefinition clone = (IntegerDefinition)super.clone();
        if (null != this.vrDefSupport) {
            clone.vrDefSupport = (ValueRetrieverDefinitionSupport)((Object)this.vrDefSupport.clone());
        }
        return clone;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getValueRetrieverConfiguration()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }

    @Override
    public boolean validIndividualValue(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        return returnValue == 0L ? this.specialValueSupport.isPromptValueValid(value) : false;
    }
}

