/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableDateDefinitionV3Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.prompts.definitions.SupportedSpecialValuesDefinitionSupport;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class DateDefinition
extends PromptDefinition
implements MutableDateDefinitionV3Interface {
    public static final String RB_KEY = "DateDefinition.";
    private static final long serialVersionUID = -5637682423256739422L;
    private DateTypes dateType;
    private Date minimum;
    private Date maximum;
    private ValueRetrieverDefinitionSupport vrDefSupport;
    private String dateRelativity;
    public static final Date minimumMinimum;
    public static final Date maximumMaximum;
    public static final DatePeriod periodInThePast;
    public static final DatePeriod periodInTheFuture;
    private SelectableDefinitionSupport selectableSupport;
    private ValueProviderDefinitionSupport valueProviderSupport;
    private SupportedSpecialValuesDefinitionSupport specialValueSupport;
    private Date minMin;
    private Date maxMax;

    public DateDefinition() {
        this.init();
    }

    public DateDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.dateType = DateTypes.DATE;
        this.minimum = minimumMinimum;
        this.maximum = maximumMaximum;
        this.dateRelativity = "All";
        this.selectableSupport = new SelectableDefinitionSupport(this);
        this.valueProviderSupport = new ValueProviderDefinitionSupport();
        this.specialValueSupport = new SupportedSpecialValuesDefinitionSupport();
        this.vrDefSupport = new ValueRetrieverDefinitionSupport();
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DateDefinition";
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        boolean isDateRelativityValid;
        boolean bl = isDateRelativityValid = this.isRelativeAllowed() && this.isValidRelativeValue(value);
        if (!this.isRelativeAllowed()) {
            isDateRelativityValid = true;
            if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
                isDateRelativityValid = false;
            }
        }
        return super.isPromptValueValid(value, locale) && isDateRelativityValid && this.specialValueSupport.isPromptValueValid(value) && this.selectableSupport.isPromptValueValid(value);
    }

    @Override
    @SASScope
    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    @Override
    @SASScope
    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        if (this.isRelativeAllowed() && value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), value);
        }
        if (returnValue == 0L) {
            return this.specialValueSupport.getPromptValueValidationErrors(value, locale);
        }
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateMinMaxValue(Date min, Date max, Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, element);
            }
        } else {
            returnValue |= this.validateMinMaxIndividualValue(min, max, value);
        }
        return returnValue;
    }

    private long validateMinMaxIndividualValue(Date min, Date max, Object value) {
        long defaultTime;
        long returnValue = 0L;
        if (min != null && value instanceof Date) {
            long minTime = -1L;
            defaultTime = -1L;
            minTime = min instanceof DatePeriod ? ((DatePeriod)min).getStartOfPeriod().getTime() : min.getTime();
            if (value instanceof DatePeriod) {
                defaultTime = ((DatePeriod)value).getStartOfPeriod().getTime();
            } else if (value != null) {
                defaultTime = ((Date)value).getTime();
            }
            if (minTime > defaultTime) {
                returnValue |= 2L;
            }
            if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
                returnValue |= DateDefinition.validatePastRelativeDate((DatePeriod)value, returnValue, this.getLogger2());
            }
        }
        if (max != null && value instanceof Date) {
            long maxTime = -1L;
            defaultTime = -1L;
            maxTime = max instanceof DatePeriod ? ((DatePeriod)max).getEndOfPeriod().getTime() : max.getTime();
            if (value instanceof DatePeriod) {
                defaultTime = ((DatePeriod)value).getEndOfPeriod().getTime();
            } else if (value != null) {
                defaultTime = ((Date)value).getTime();
            }
            if (maxTime < defaultTime) {
                returnValue |= 4L;
            }
            if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
                returnValue |= DateDefinition.validateFutureRelativeDate((DatePeriod)value, returnValue, this.getLogger2());
            }
        }
        if (value != null && !(value instanceof Date) && !PromptUtil.isValueSupported(this, value)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors(errors, this.selectableSupport.getPromptValueValidationErrors(value, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        if (this.isRelativeAllowed() && value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            returnValue |= this.validateRelativeValue(value);
        }
        if (null == (errors = this.populateMapWithErrors(errors, returnValue, value, false, locale))) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors(errors, this.selectableSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.valueProviderSupport.validateDefinition(this, null, locale));
        errors = PromptUtil.addErrors(errors, this.vrDefSupport.validateDefinitionWithDefinition(this, locale));
        Date min = this.getMinimum();
        Date max = this.getMaximum();
        long returnValue = 0L;
        long minTime = -1L;
        long maxTime = -1L;
        if (min instanceof DatePeriod) {
            minTime = ((DatePeriod)min).getStartOfPeriod().getTime();
        }
        minTime = min.getTime();
        if (max instanceof DatePeriod) {
            maxTime = ((DatePeriod)max).getEndOfPeriod().getTime();
        }
        if (minTime > (maxTime = max.getTime())) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(min, max, dv);
            if (this.isRelativeAllowed() && dv instanceof DatePeriod && ((DatePeriod)dv).isRelativeDate()) {
                returnValue |= this.validateRelativeValue(dv);
            }
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotADate.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notADate.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 2L) == 2L) {
            errors = defaultValue ? PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueBelowMin.txt", locale), (Object)DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()).getDisplayString((Object)this.getMinimum(), locale))) : PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource(RB_KEY, "valueBelowMin.txt", locale), (Object)DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()).getDisplayString((Object)this.getMinimum(), locale)));
        }
        if ((errorCode & 4L) == 4L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueAboveMax.txt", locale), (Object)DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()).getDisplayString((Object)this.getMaximum(), locale))) : PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource(RB_KEY, "valueAboveMax.txt", locale), (Object)DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()).getDisplayString((Object)this.getMaximum(), locale)));
        }
        if ((errorCode & 0x40000L) == 262144L) {
            errors = PromptUtil.addError(errors, 262144L, RB.getStringResource("DateDefinition.periodStarts200.txt", locale));
        }
        if ((errorCode & 0x80000L) == 524288L) {
            errors = PromptUtil.addError(errors, 524288L, RB.getStringResource("DateDefinition.periodEnds200.txt", locale));
        }
        if ((errorCode & 0x100000000000L) == 0x100000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x100000000000L, RB.getStringResource("DateDefinition.incorrectDefaultRelativeValue.txt", locale)) : PromptUtil.addError(errors, 0x100000000000L, RB.getStringResource("DateDefinition.incorrectRelativeValue.txt", locale));
        }
        return errors;
    }

    @Override
    public Date getMinMin() {
        if (this.minMin != null) {
            return (Date)this.minMin.clone();
        }
        return null;
    }

    @Override
    public void setMinMin(Date minMin) {
        if (minMin != null) {
            this.minMin = minMin;
        }
        if (this.minimum.equals(minimumMinimum)) {
            this.minimum = this.minMin;
        }
    }

    @Override
    public Date getMaxMax() {
        if (this.maxMax != null) {
            return (Date)this.maxMax.clone();
        }
        return null;
    }

    @Override
    public void setMaxMax(Date maxMax) {
        if (maxMax != null) {
            this.maxMax = maxMax;
        }
        if (this.maximum.equals(maximumMaximum)) {
            this.maximum = this.maxMax;
        }
    }

    @Override
    public Date getMaximum() {
        if (this.maximum != null) {
            return (Date)this.maximum.clone();
        }
        return null;
    }

    @Override
    public void setMaximum(Date maximum) {
        if (maximum != null) {
            this.validateMaximumV3(maximum, this.getLogger2());
            this.maximum = (Date)maximum.clone();
        } else {
            this.maximum = maximumMaximum;
        }
    }

    @Override
    public Date getMinimum() {
        if (this.minimum != null) {
            return (Date)this.minimum.clone();
        }
        return null;
    }

    @Override
    public void setMinimum(Date minimum) {
        if (minimum != null) {
            this.validateMinimumV3(minimum, this.getLogger2());
            this.minimum = (Date)minimum.clone();
        } else {
            this.minimum = minimumMinimum;
        }
    }

    private Date minMinValue() {
        if (this.minMin != null) {
            return (Date)this.minMin.clone();
        }
        return minimumMinimum;
    }

    private Date maxMaxValue() {
        if (this.maxMax != null) {
            return (Date)this.maxMax.clone();
        }
        return maximumMaximum;
    }

    boolean validateMinimumV3(Date minimum, CommonLoggerInterface logger) {
        if (minimum.before(this.minMinValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minMin.txt"));
        }
        if (minimum.after(this.maxMaxValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maxMax.txt"));
        }
        if (minimum instanceof DatePeriod) {
            DatePeriod min = (DatePeriod)minimum;
            if (min.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodEnds200.txt"));
                }
            } else {
                Date compareMaxMaxValue;
                Date compareMinMinValue = this.minMinValue() instanceof DatePeriod ? ((DatePeriod)this.minMinValue()).getStartOfPeriod() : this.minMinValue();
                Date date = compareMaxMaxValue = this.maxMaxValue() instanceof DatePeriod ? ((DatePeriod)this.maxMaxValue()).getEndOfPeriod() : this.maxMaxValue();
                if (min.getStartOfPeriod().before(compareMinMinValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minMin.txt"));
                }
                if (min.getEndOfPeriod().after(compareMaxMaxValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maxMax.txt"));
                }
            }
        }
        return true;
    }

    boolean validateMaximumV3(Date maximum, CommonLoggerInterface logger) {
        if (maximum.after(this.maxMaxValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maxMax.txt"));
        }
        if (maximum.before(this.minMinValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minMin.txt"));
        }
        if (maximum instanceof DatePeriod) {
            DatePeriod max = (DatePeriod)maximum;
            if (max.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodEnds200.txt"));
                }
            } else {
                Date compareMaxMaxValue;
                Date compareMinMinValue = this.minMinValue() instanceof DatePeriod ? ((DatePeriod)this.minMinValue()).getStartOfPeriod() : this.minMinValue();
                Date date = compareMaxMaxValue = this.maxMaxValue() instanceof DatePeriod ? ((DatePeriod)this.maxMaxValue()).getEndOfPeriod() : this.maxMaxValue();
                if (max.getStartOfPeriod().before(compareMinMinValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minMin.txt"));
                }
                if (max.getEndOfPeriod().after(compareMaxMaxValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maxMax.txt"));
                }
            }
        }
        return true;
    }

    static final boolean validateMinimum(Date minimum, CommonLoggerInterface logger) {
        if (minimum.before(minimumMinimum)) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minimumMinimum.txt"));
        }
        if (minimum.after(maximumMaximum)) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maximumMaximum.txt"));
        }
        if (minimum instanceof DatePeriod) {
            DatePeriod min = (DatePeriod)minimum;
            if (min.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodEnds200.txt"));
                }
            } else {
                if (min.getStartOfPeriod().before(minimumMinimum)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minimumMinimum.txt"));
                }
                if (min.getEndOfPeriod().after(maximumMaximum)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maximumMaximum.txt"));
                }
            }
        }
        return true;
    }

    static final boolean validateMaximum(Date maximum, CommonLoggerInterface logger) {
        if (maximum.after(maximumMaximum)) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maximumMaximum.txt"));
        }
        if (maximum.before(minimumMinimum)) {
            throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minimumMinimum.txt"));
        }
        if (maximum instanceof DatePeriod) {
            DatePeriod max = (DatePeriod)maximum;
            if (max.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.periodEnds200.txt"));
                }
            } else {
                if (max.getStartOfPeriod().before(minimumMinimum)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.minimumMinimum.txt"));
                }
                if (max.getEndOfPeriod().after(maximumMaximum)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateDefinition.maximumMaximum.txt"));
                }
            }
        }
        return true;
    }

    @Override
    public DateTypes getDateType() {
        return this.dateType;
    }

    @Override
    public void setDateType(DateTypes dateType) {
        this.dateType = dateType;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            if (this.dateType == DateTypes.DATE) {
                return DateType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.TIME) {
                return TimeType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.TIMESTAMP) {
                return TimeStampType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.WEEK) {
                return WeekType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.MONTH) {
                return MonthType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.QUARTER) {
                return QuarterType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.YEAR) {
                return YearType.DEFAULT_INSTANCE;
            }
            if (this.dateType == DateTypes.WEEKDAY) {
                return WeekdayType.DEFAULT_INSTANCE;
            }
            throw new IllegalStateException(new MessageFormat(RB.getStringResource(RB_KEY, "unknownDateType.fmt.txt")).format(new Object[]{this.dateType}));
        }
        if (this.dateType == DateTypes.DATE) {
            return CollectionType.DEFAULT_INSTANCE_DATE;
        }
        if (this.dateType == DateTypes.TIME) {
            return CollectionType.DEFAULT_INSTANCE_TIME;
        }
        if (this.dateType == DateTypes.TIMESTAMP) {
            return CollectionType.DEFAULT_INSTANCE_TIMESTAMP;
        }
        if (this.dateType == DateTypes.WEEK) {
            return CollectionType.DEFAULT_INSTANCE_WEEK;
        }
        if (this.dateType == DateTypes.MONTH) {
            return CollectionType.DEFAULT_INSTANCE_MONTH;
        }
        if (this.dateType == DateTypes.QUARTER) {
            return CollectionType.DEFAULT_INSTANCE_QUARTER;
        }
        if (this.dateType == DateTypes.YEAR) {
            return CollectionType.DEFAULT_INSTANCE_YEAR;
        }
        if (this.dateType == DateTypes.WEEKDAY) {
            return CollectionType.DEFAULT_INSTANCE_WEEKDAY;
        }
        throw new IllegalStateException(new MessageFormat(RB.getStringResource(RB_KEY, "unknownDateType.fmt.txt")).format(new Object[]{this.dateType}));
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.selectableSupport.consumeRelatedObjects(roHolder);
        this.valueProviderSupport.consumeRelatedObjects(roHolder);
        this.specialValueSupport.consumeRelatedObjects(roHolder);
        ValueRetrieverDefinitionSupport temp = ValueRetrieverDefinitionSupport.newInstanceFromPersistence(roHolder);
        if (null != temp) {
            this.vrDefSupport = temp;
        }
        this.getLogger2().debug("consumeRelObjects on ", this.getPromptName());
        this.specialValueSupport.setAllowMissing(false);
        if (this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() != null && this.vrDefSupport.getValueRetrieverConfiguration().isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        }
        if (this.valueProviderSupport.getValueProvider() != null && !(this.valueProviderSupport.getValueProvider() instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        String value;
        super.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.valueProviderSupport.consumeAttributes(provider);
        this.specialValueSupport.consumeAttributes(provider);
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
        String out = provider.consumeAttr("dateType");
        if (null != out) {
            DateTypes d = DateTypes.valueOf((String)out);
            this.getLogger2().debug("setting date type to ", out);
            this.setDateType(d);
        }
        if (null != (value = provider.consumeAttr("dateRelativity"))) {
            this.setDateRelativity(value);
        }
        this.consumeStringAttr(provider);
    }

    private void consumeStringAttr(AttributesProvider provider) {
        String maxM = provider.consumeAttr("maxMax");
        String out = provider.consumeAttr("max");
        if (null != maxM) {
            this.getLogger2().debug("setMaxMax to :", maxM);
            this.setMaxMax((Date)this.getPromptDataType().coerceValueFromPersistedString(maxM));
            if (null == out) {
                this.setMaximum(this.getMaxMax());
            }
        }
        if (null != out) {
            this.getLogger2().debug("setMaximum to :", out);
            this.setMaximum((Date)this.getPromptDataType().coerceValueFromPersistedString(out));
        }
        String minM = provider.consumeAttr("minMin");
        String min = provider.consumeAttr("min");
        if (null != minM) {
            this.getLogger2().debug("setMinMin to :", minM);
            this.setMinMin((Date)this.getPromptDataType().coerceValueFromPersistedString(minM));
            if (null == min) {
                this.setMinimum(this.getMinMin());
            }
        }
        if (null != min) {
            this.getLogger2().debug("setMinimum to :", min);
            this.setMinimum((Date)this.getPromptDataType().coerceValueFromPersistedString(min));
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        String value2;
        String value1;
        super.writeDefinition(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        this.valueProviderSupport.writeDefinition(element, writingContext);
        this.specialValueSupport.writeDefinition(element, writingContext);
        if (DateTypes.DATE != this.getDateType()) {
            XmlUtil.setAttr((Element)element, (String)"dateType", (String)this.getDateType().toString());
        }
        if (null != this.getMaxMax() && !this.getMaxMax().equals(maximumMaximum)) {
            value1 = this.getPromptDataType().getPersistanceString((Object)this.maxMaxValue());
            XmlUtil.setAttr((Element)element, (String)"maxMax", (String)value1);
        }
        if (null != this.getMinMin() && !this.getMinMin().equals(minimumMinimum)) {
            value2 = this.getPromptDataType().getPersistanceString((Object)this.minMinValue());
            XmlUtil.setAttr((Element)element, (String)"minMin", (String)value2);
        }
        if (null != this.getMaximum() && !this.getMaximum().equals(this.maxMaxValue())) {
            value1 = this.getPromptDataType().getPersistanceString((Object)this.getMaximum());
            XmlUtil.setAttr((Element)element, (String)"max", (String)value1);
        }
        if (null != this.getMinimum() && !this.getMinimum().equals(this.minMinValue())) {
            value2 = this.getPromptDataType().getPersistanceString((Object)this.getMinimum());
            XmlUtil.setAttr((Element)element, (String)"min", (String)value2);
        }
        if (null != this.getDateRelativity() && !"All".equals(this.getDateRelativity())) {
            XmlUtil.setAttr((Element)element, (String)"dateRelativity", (String)this.getDateRelativity());
        }
        if (null != this.vrDefSupport.getValueRetrieverConfiguration()) {
            ArrayList<ValueRetrieverDefinitionSupport> list = new ArrayList<ValueRetrieverDefinitionSupport>();
            list.add(this.vrDefSupport);
            this.getLogger2().debug("Writing value retriever element.");
            DateDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueRetrieverConfiguration");
        }
    }

    @Override
    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        List list1 = this.vrDefSupport.getReferencedResources(type, recursive);
        if (list1.isEmpty()) {
            List list2 = this.valueProviderSupport.getReferencedResources(type, recursive);
            return list2;
        }
        return list1;
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    @SASScope
    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    @SASScope
    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @SASScope
    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    @SASScope
    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    @SASScope
    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @SASScope
    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    @Override
    public ValueProviderInterface getValueProvider() {
        return this.valueProviderSupport.getValueProvider();
    }

    public boolean isAllowUserValues() {
        return this.valueProviderSupport.isAllowUserValues();
    }

    @Override
    public void setValueProvider(ValueProviderInterface valueProvider) {
        this.valueProviderSupport.setValueProvider(valueProvider);
        if (valueProvider != null && !(valueProvider instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        } else if (this.vrDefSupport == null) {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public void setAllowUserValues(boolean allowValues) {
        this.valueProviderSupport.setAllowUserValues(allowValues);
    }

    @Override
    public int getPageSize() {
        return this.valueProviderSupport.getPageSize();
    }

    @Override
    public void setPageSize(int pageSize) {
        this.valueProviderSupport.setPageSize(pageSize);
    }

    @SASScope
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.valueProviderSupport.getValueProvider() instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.valueProviderSupport.getValueProvider()).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return this.vrDefSupport.getDependentPrompts(locale, dynamicValueContext);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValueSupport.getSupportedSpecialValues();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValueSupport.setSupportedSpecialValues(specialValuesSupported);
    }

    private static Date[] initMinMax() {
        Date maximum;
        Date minimum;
        Date[] retVal = new Date[4];
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1600, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        retVal[0] = minimum = cal.getTime();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(2400, 11, 31, 23, 59, 59);
        cal.set(14, 999);
        retVal[1] = maximum = cal.getTime();
        DatePeriod past200Years = new DatePeriod(null, DateTypes.YEAR, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        past200Years.setNYears(-200);
        retVal[2] = past200Years;
        DatePeriod next200Years = new DatePeriod(null, DateTypes.YEAR, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        next200Years.setNYears(200);
        retVal[3] = next200Years;
        return retVal;
    }

    static final long validatePastRelativeDate(DatePeriod input, long returnValue, CommonLoggerInterface logger) {
        logger.debug("validatePastRelativeDate(), the StartOfPeriod is:", input.getStartOfPeriod().toString());
        if (input.getStartOfPeriod().before(periodInThePast.getStartOfPeriod())) {
            logger.debug("validatePastRelativeDate(), validation failed");
            returnValue |= 0x40000L;
        } else {
            logger.debug("validatePastRelativeDate(), validation succeeded");
        }
        return returnValue;
    }

    static final long validateFutureRelativeDate(DatePeriod input, long returnValue, CommonLoggerInterface logger) {
        logger.debug("validateFutureRelativeDate(), the EndOfPeriod is:", input.getEndOfPeriod().toString());
        if (input.getEndOfPeriod().after(periodInTheFuture.getEndOfPeriod())) {
            logger.debug("validateFutureRelativeDate(), validation failed");
            returnValue |= 0x80000L;
        } else {
            logger.debug("validateFutureRelativeDate(), validation succeeded");
        }
        return returnValue;
    }

    @Override
    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        PromptUtil.addLocalizedPropertiesFromValueProvider(list, this.valueProviderSupport, locale);
        this.vrDefSupport.addLocalizedPropertiesFromValueRetriever(locale, list);
        return list;
    }

    @Override
    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        PromptUtil.setLocalizedPropertiesOnValueProvider(map, this.valueProviderSupport, locale);
        this.vrDefSupport.setLocalizedPropertiesOnValueRetriever(locale, map);
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        if (options.containsKey("dateType")) {
            this.setDateType(DateTypes.valueOf((String)((String)options.get("dateType"))));
        }
        this.selectableSupport.configurePrompt(this, options, context);
        this.specialValueSupport.configurePrompt(this, options, context);
        super.configureAttributes(options, context);
        this.getLogger2().debug("configureAttributes() running");
        if (options.containsKey("minMin")) {
            this.setMinMin(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "minMin", options, context));
        }
        if (options.containsKey("maxMax")) {
            this.setMaxMax(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "maxMax", options, context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "min", options, context));
        }
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "max", options, context));
        }
        if (options.containsKey("dateRelativity")) {
            this.setDateRelativity(PromptConfigurationFactory.getStringOption((String)"dateRelativity", options, context));
        }
        this.valueProviderSupport.configurePrompt(this, options, context);
        this.vrDefSupport = ValueRetrieverDefinitionSupport.changeInstanceType(this.vrDefSupport, options);
        this.vrDefSupport.configureAttributes(options, context);
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)this.minMinValue(), true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)this.maxMaxValue(), true, true));
        AttributeDescriptor dateTypeDescrip = new AttributeDescriptor("dateType", "dateType", "String", (Object)this.getDateType().toString(), null, true, true);
        ArrayList<ValueItem> possibleDateTypeValues = new ArrayList<ValueItem>();
        possibleDateTypeValues.add(new ValueItem((Object)"Date", (Object)DateTypes.DATE.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Year", (Object)DateTypes.YEAR.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Quarter", (Object)DateTypes.QUARTER.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Month", (Object)DateTypes.MONTH.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Week", (Object)DateTypes.WEEK.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Weekday", (Object)DateTypes.WEEKDAY.toString()));
        dateTypeDescrip.setPossibleValues(possibleDateTypeValues);
        constraints.getAttributes().add(dateTypeDescrip);
        AttributeDescriptor dateRelativityDescrip = new AttributeDescriptor("dateRelativity", "dateRelativity", "String", (Object)this.getDateRelativity(), null, true, true);
        ArrayList<ValueItem> possibleRelativeValues = new ArrayList<ValueItem>();
        possibleRelativeValues.add(new ValueItem((Object)"All", (Object)"All"));
        possibleRelativeValues.add(new ValueItem((Object)"None", (Object)"None"));
        possibleRelativeValues.add(new ValueItem((Object)"Past and current", (Object)"relativeToPastAndCurrent"));
        possibleRelativeValues.add(new ValueItem((Object)"Past", (Object)"relativeToPast"));
        possibleRelativeValues.add(new ValueItem((Object)"Future", (Object)"relativeToFuture"));
        possibleRelativeValues.add(new ValueItem((Object)"Current and future", (Object)"relativeToCurrentAndFuture"));
        possibleRelativeValues.add(new ValueItem((Object)"Current", (Object)"relativeToCurrent"));
        dateRelativityDescrip.setPossibleValues(possibleRelativeValues);
        constraints.getAttributes().add(dateRelativityDescrip);
        attributeList.addAll(this.valueProviderSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.selectableSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.vrDefSupport.getAttributeDescriptors(locale));
        return attributeList;
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        DataTypeInterface dt = DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType());
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", dt.getDisplayString((Object)this.getMinimum(), locale));
        retVal.put("MAXIMUM", dt.getDisplayString((Object)this.getMaximum(), locale));
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        this.selectableSupport.addConstraints(retVal, numFormat);
        return retVal;
    }

    @Override
    public void setDateRelativity(String dateRelativity) {
        if ("None".equals(dateRelativity) || "relativeToCurrent".equals(dateRelativity) || "All".equals(dateRelativity) || "relativeToFuture".equals(dateRelativity) || "relativeToPast".equals(dateRelativity) || "relativeToCurrentAndFuture".equals(dateRelativity) || "relativeToPastAndCurrent".equals(dateRelativity)) {
            this.dateRelativity = dateRelativity;
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidDateRelativityConstraint.txt", Locale.getDefault()));
    }

    @Override
    public String getDateRelativity() {
        return this.dateRelativity;
    }

    public boolean isRelativeAllowed() {
        return !"None".equals(this.dateRelativity);
    }

    private boolean isValidRelativeValue(Object value) {
        long returnValue = 0L;
        return returnValue == this.validateRelativeValue(value);
    }

    private long validateRelativeValue(Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), element);
            }
        } else {
            returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), value);
        }
        return returnValue;
    }

    private long validateIndividualRelativeValue(String relativity, Object value) {
        long returnValue = 0L;
        if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            DatePeriod currentDatePeriod = new DatePeriod(null, this.getDateType(), TimeZone.getTimeZone("GMT"), Locale.getDefault());
            DatePeriod datePeriodToBeCompared = (DatePeriod)value;
            if ("relativeToCurrent".equals(relativity)) {
                if (!currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToPast".equals(relativity)) {
                if (currentDatePeriod.before((Date)datePeriodToBeCompared) | currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToFuture".equals(relativity)) {
                if (currentDatePeriod.after((Date)datePeriodToBeCompared) | currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToPastAndCurrent".equals(relativity)) {
                if (currentDatePeriod.before((Date)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToCurrentAndFuture".equals(relativity) && currentDatePeriod.after((Date)datePeriodToBeCompared)) {
                returnValue |= 0x100000000000L;
            }
        }
        return returnValue;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        this.vrDefSupport = ValueRetrieverDefinitionSupport.newInstance(config);
        if (config != null && config.isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        } else {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        this.vrDefSupport.setApplicationContext(this.getApplicationContext());
        ValueRetrieverConfiguration vrc = this.vrDefSupport.getValueRetrieverConfiguration();
        return vrc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DateDefinition clone = (DateDefinition)super.clone();
        if (null != this.vrDefSupport) {
            clone.vrDefSupport = (ValueRetrieverDefinitionSupport)((Object)this.vrDefSupport.clone());
        }
        return clone;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getValueRetrieverConfiguration() || !"All".equals(this.getDateRelativity()) || null != this.getMinMin() || null != this.getMaxMax()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }

    @Override
    public boolean validIndividualValue(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        if (this.isRelativeAllowed() && value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), value);
        }
        return returnValue == 0L ? this.specialValueSupport.isPromptValueValid(value) : false;
    }

    static {
        Date[] retVal = DateDefinition.initMinMax();
        minimumMinimum = retVal[0];
        maximumMaximum = retVal[1];
        periodInThePast = (DatePeriod)retVal[2];
        periodInTheFuture = (DatePeriod)retVal[3];
    }
}

