/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.models.FileLocationInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.BaseFileDefinition;
import com.sas.prompts.definitions.MutableFileUploadInterface;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope
public abstract class BaseFileUploadDefinition
extends BaseFileDefinition
implements MutableFileUploadInterface {
    private String basePathToUpload;
    private static final long serialVersionUID = -2939476486834717183L;
    private static final String RB_KEY = "BaseFileUploadDefinition.";

    public BaseFileUploadDefinition() {
    }

    public BaseFileUploadDefinition(String promptName) {
        super(promptName);
    }

    @Override
    protected void init() {
        this.setRequired(false);
    }

    @Override
    public void setBasePathToUpload(String basePathToUpload) {
        this.basePathToUpload = basePathToUpload;
    }

    @Override
    public String getBasePathToUpload() {
        return this.basePathToUpload;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return (!PromptUtil.isPromptValuesEqual(value, null) || !this.isRequired()) && (returnValue = this.validateValue(value)) == 0L;
    }

    private long validateIndividualValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof FileLocationInterface)) {
            returnValue |= 1L;
        } else if (value != null) {
            FileLocationInterface fli = (FileLocationInterface)value;
            if (!fli.isFile()) {
                returnValue |= 0x2000000000L;
            } else if (!this.isFileAllowed(fli.getFileLocation())) {
                returnValue |= 0x1000000000L;
            }
        }
        return returnValue;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateIndividualValue(array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateIndividualValue(element);
            }
        } else {
            returnValue |= this.validateIndividualValue(value);
        }
        return returnValue;
    }

    private boolean isFileAllowed(String path) {
        List<String> ft = this.getFileTypes();
        if (ft == null || ft.isEmpty()) {
            return true;
        }
        int index = path.lastIndexOf(46);
        if (index != -1) {
            String ext = path.substring(index).trim();
            String extWithDot = path.substring(index + 1).trim();
            for (String type : ft) {
                if (!type.equalsIgnoreCase(ext) && !type.equalsIgnoreCase(extWithDot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAFile.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAFile.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x1000000000L) == 0x1000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x1000000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedFileType.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x1000000000L, Message.format((String)RB.getStringResource(RB_KEY, "disallowedFileType.txt", locale), (Object)value));
        }
        if ((errorCode & 0x2000000000L) == 0x2000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x2000000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueIsADirectory.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x2000000000L, Message.format((String)RB.getStringResource(RB_KEY, "isADirectory.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (this.getBasePathToUpload() != null) {
            XmlUtil.setAttr((Element)element, (String)"basePathToUpload", (String)this.getBasePathToUpload());
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String basePathToUpload1 = provider.consumeAttr("basePathToUpload");
        if (basePathToUpload1 != null) {
            this.setBasePathToUpload(basePathToUpload1);
        }
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("basePathToUpload")) {
            this.setBasePathToUpload(PromptConfigurationFactory.getStringOption((String)"basePathToUpload", options, context));
        }
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        List attributeList = super.getAttributeDescriptors(locale);
        if (this.getBasePathToUpload() != null) {
            attributeList.add(new AttributeDescriptor("basePathToUpload", "basePathToUpload", "String", (Object)this.getBasePathToUpload(), true, true));
        }
        return attributeList;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        try {
            if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                tempVersion = "2.0";
            }
        }
        catch (ParseException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

