/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.ThresholdInterface;
import com.sas.prompts.DynamicListSearchInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.ListSearchInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

@SASScope
public class PromptDynamicValueProviderWrapper
implements DynamicValueProviderInterface,
ListSearchInterface,
AllowUserValuesInterface,
ThresholdInterface {
    private ValueProviderInterface valueProvider;
    private DynamicPromptValueContextInterface dynamicValueContext;
    private PromptViewInterface promptView;

    public PromptDynamicValueProviderWrapper(ValueProviderInterface valueProvider, DynamicPromptValueContextInterface dynamicValueContext) {
        this(valueProvider, dynamicValueContext, null);
    }

    public PromptDynamicValueProviderWrapper(ValueProviderInterface valueProvider, DynamicPromptValueContextInterface dynamicValueContext, PromptViewInterface promptView) {
        this.valueProvider = valueProvider;
        this.dynamicValueContext = dynamicValueContext;
        this.promptView = promptView;
    }

    public ValueProviderInterface getValueProvider() {
        return this.valueProvider;
    }

    public boolean isValueDisplayed() {
        return this.valueProvider.isValueDisplayed();
    }

    public int getThreshold() {
        if (this.valueProvider instanceof ThresholdInterface) {
            return ((ThresholdInterface)this.valueProvider).getThreshold();
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        PromptDynamicValueProviderWrapper clone = (PromptDynamicValueProviderWrapper)super.clone();
        return clone;
    }

    public boolean isSearchable() throws ValueProviderException {
        return this.isSearchable(Locale.getDefault(), this.dynamicValueContext);
    }

    public boolean isSearchable(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicListSearchInterface) {
            return ((DynamicListSearchInterface)this.valueProvider).isSearchable(locale, dynamicPromptValueContext);
        }
        if (this.valueProvider instanceof ListSearchInterface) {
            return ((ListSearchInterface)this.valueProvider).isSearchable();
        }
        return false;
    }

    public DataTypeInterface getDataType() throws ValueProviderException {
        return this.getDataType(this.dynamicValueContext);
    }

    @Override
    public DataTypeInterface getDataType(DynamicPromptValueContextInterface dynamicContext) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return ((DynamicValueProviderInterface)this.valueProvider).getDataType(dynamicContext);
        }
        return this.valueProvider.getDataType();
    }

    public Object getValues(Locale locale) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return this.getValues(locale, this.dynamicValueContext, ValueType.TREETHENLIST);
        }
        return this.valueProvider.getValues(locale);
    }

    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return this.getValues(locale, this.dynamicValueContext, ValueType.TREETHENLIST, index, count);
        }
        return this.valueProvider.getValues(locale, index, count);
    }

    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return this.getValues(locale, this.dynamicValueContext, returnType);
        }
        return this.getValues(locale);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return this.getValues(locale, this.dynamicValueContext, returnType, index, count);
        }
        return this.getValues(locale, index, count);
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicListSearchInterface) {
            return ((DynamicListSearchInterface)this.valueProvider).getValues(locale, this.promptView, this.dynamicValueContext, searchCriterion, 0, this.getThreshold());
        }
        if (this.valueProvider instanceof ListSearchInterface) {
            return ((ListSearchInterface)this.valueProvider).getValues(locale, searchCriterion);
        }
        return Collections.EMPTY_LIST;
    }

    public Object getValues(Locale locale, SearchCriteria searchCriterion, int index, int count) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicListSearchInterface) {
            if (this.promptView != null) {
                return ((DynamicListSearchInterface)this.valueProvider).getValues(locale, this.promptView, this.dynamicValueContext, searchCriterion, index, count);
            }
            return ((DynamicListSearchInterface)this.valueProvider).getValues(locale, this.dynamicValueContext, searchCriterion, index, count);
        }
        if (this.valueProvider instanceof ListSearchInterface) {
            return ((ListSearchInterface)this.valueProvider).getValues(locale, searchCriterion, index, count);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValuesContext) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            return ((DynamicValueProviderInterface)this.valueProvider).getDependentPrompts(locale, dynamicValuesContext);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            if (this.promptView != null) {
                return ((DynamicValueProviderInterface)this.valueProvider).getValues(locale, this.promptView, dynamicPromptValueContext, returnType);
            }
            return ((DynamicValueProviderInterface)this.valueProvider).getValues(locale, dynamicPromptValueContext, returnType);
        }
        return this.getValues(locale, returnType);
    }

    @Override
    public Object getValues(Locale locale, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        if (this.valueProvider instanceof DynamicValueProviderInterface) {
            if (this.promptView != null) {
                return ((DynamicValueProviderInterface)this.valueProvider).getValues(locale, this.promptView, dynamicPromptValueContext, returnType, index, count);
            }
            return ((DynamicValueProviderInterface)this.valueProvider).getValues(locale, dynamicPromptValueContext, returnType, index, count);
        }
        return this.getValues(locale, returnType, index, count);
    }

    @Override
    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType);
    }

    @Override
    public Object getValues(Locale locale, PromptViewInterface promptView, DynamicPromptValueContextInterface dynamicPromptValueContext, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(locale, dynamicPromptValueContext, returnType, index, count);
    }

    public boolean isAllowUserValues() {
        if (this.valueProvider instanceof AllowUserValuesInterface) {
            return ((AllowUserValuesInterface)this.valueProvider).isAllowUserValues();
        }
        return false;
    }
}

