/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.models.EncodingInterface;
import com.sas.prompts.PromptException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.RB;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionV2Interface;
import com.sas.text.Message;
import com.sas.util.ListFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class InvalidPromptValueException
extends PromptException {
    private static final long serialVersionUID = 3617011949096088880L;
    private PromptDefinitionInterface promptDefinition;
    private Object value;
    private Locale locale;
    private Collection<ValidationEntry> promptValueValidationErrors;
    private String log;

    public InvalidPromptValueException(PromptDefinitionInterface promptDefinition, Object value, Locale inputLocale, Collection<ValidationEntry> promptValueValidationErrors) {
        super(Message.format((String)RB.getStringResource("InvalidPromptValueException.fmt.txt", inputLocale), (Object)promptDefinition.getPromptLabel(inputLocale), (Object)InvalidPromptValueException.formatValueForDisplay(value), (Object)PromptUtil.formatErrorMessages(promptValueValidationErrors)));
        this.promptDefinition = promptDefinition;
        this.value = value;
        this.locale = inputLocale;
        if (promptValueValidationErrors != null) {
            this.promptValueValidationErrors = ListFactory.newList(promptValueValidationErrors);
        }
    }

    private static Object formatValueForDisplay(Object value) {
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        } else if (value instanceof EncodingInterface) {
            value = ((EncodingInterface)value).getEncodedValue();
        }
        return value;
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }

    public Object getValue() {
        return this.value;
    }

    public Locale getInputLocale() {
        return this.locale;
    }

    public Collection<ValidationEntry> getPromptValueValidationErrors() {
        return this.promptValueValidationErrors;
    }

    @Override
    public String getMessage() {
        String retVal = super.getMessage();
        StringBuilder sb = new StringBuilder(retVal);
        if (null != this.promptDefinition && this.promptDefinition instanceof PromptDefinitionV2Interface && !"".equals(((PromptDefinitionV2Interface)this.promptDefinition).getCustomErrorMessage(this.locale))) {
            String msg = ((PromptDefinitionV2Interface)this.promptDefinition).getCustomErrorMessage(this.locale);
            sb.append("\n");
            sb.append(msg.trim());
            retVal = sb.toString();
        }
        if (null != this.log && this.log.length() > 0) {
            sb.append("\n");
            retVal = sb.append(this.log.trim()).toString();
        }
        return retVal;
    }

    public final void setLogOutput(String log) {
        this.log = log;
    }
}

