/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.AttributeDependencyClearOperand;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.AttributeConfigurationInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class ConfigurePromptVisitor
implements PromptValuesVisitorInterface {
    private Map<AttributeConfigurationInterface, List<String>> configuredObjects;
    private Map<AttributeDependencyInterface, Exception> configurationExceptions;
    private PromptDefinitionInterface changedPrompt;
    private Object changedPromptValue;

    public ConfigurePromptVisitor(PromptDefinitionInterface changedPrompt, Object changedPromptValue) {
        this.changedPrompt = changedPrompt;
        this.changedPromptValue = changedPromptValue;
    }

    @Override
    public void accept(PromptValuesInterface promptValues) {
        ArrayList<PromptGroupInterface> promptsAndSubgroups = new ArrayList<PromptGroupInterface>();
        promptsAndSubgroups.add(promptValues.getPromptGroup());
        promptValues.getPromptGroup().getPromptDefinitionsAndSubgroups(promptsAndSubgroups, true, true, true);
        for (Object e : promptsAndSubgroups) {
            List<AttributeDependencyInterface> dependencies;
            if (e instanceof MutablePromptDefinitionV2Interface) {
                MutablePromptDefinitionV2Interface prompt = (MutablePromptDefinitionV2Interface)e;
                dependencies = prompt.getDependentPromptsForAttributes();
                this.configureDependencies(promptValues, prompt, dependencies);
                continue;
            }
            if (!(e instanceof PromptGroupV2Interface)) continue;
            PromptGroupV2Interface group = (PromptGroupV2Interface)e;
            dependencies = group.getDependentPromptsForAttributes();
            this.configureDependencies(promptValues, group, dependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDependencies(PromptValuesInterface promptValues, AttributeConfigurationInterface objectToConfigure, List dependencies) {
        HashMap<String, PromptValuesInterface> context = new HashMap<String, PromptValuesInterface>(1);
        context.put("PROMPT_VALUES_OPERAND_CONTEXT", promptValues);
        if (dependencies != null) {
            for (AttributeDependencyInterface dependency : dependencies) {
                if (dependency.getPromptAttributeIsDependentOn() != this.changedPrompt) continue;
                ValueOperandV2Interface valueOperand = null;
                valueOperand = dependency.isConditionMet(promptValues) ? dependency.getValueOperand() : dependency.getElseValueOperand();
                if (valueOperand == null) continue;
                Object valueOperandValue = valueOperand.evaluateOperand(Locale.US, context);
                String attName = dependency.getPromptAttributeName();
                Object attValue = dependency.transformAttributeValue(valueOperandValue);
                boolean addConfiguredObject = true;
                if (objectToConfigure instanceof PromptDefinitionInterface && "value".equalsIgnoreCase(attName)) {
                    if (valueOperand instanceof AttributeDependencyClearOperand) {
                        promptValues.clearPromptValue((PromptDefinitionInterface)objectToConfigure);
                    } else {
                        addConfiguredObject = false;
                        PromptDefinitionInterface pdi = (PromptDefinitionInterface)objectToConfigure;
                        MyPromptValueChangeListener listener = new MyPromptValueChangeListener();
                        try {
                            promptValues.addPromptValueChangeListener(listener);
                            promptValues.setPromptValue(pdi, attValue, Locale.US);
                        }
                        catch (InvalidPromptValueException e) {
                            this.addConfigurationException(dependency, e);
                        }
                        finally {
                            addConfiguredObject = listener.eventFired;
                            promptValues.removePromptValueChangeListener(listener);
                        }
                    }
                } else {
                    HashMap<String, Object> options = new HashMap<String, Object>(1);
                    options.put(attName, attValue);
                    objectToConfigure.configureAttributes(options, Collections.EMPTY_MAP);
                }
                if (!addConfiguredObject) continue;
                this.addConfiguredObject(objectToConfigure, attName);
            }
        }
    }

    @Override
    public boolean shouldContinue() {
        return true;
    }

    public Map<AttributeConfigurationInterface, List<String>> getConfiguredObjects() {
        return this.configuredObjects;
    }

    private void addConfiguredObject(AttributeConfigurationInterface configuredObject, String attName) {
        List<Object> attributes;
        if (this.configuredObjects == null) {
            this.configuredObjects = new HashMap<AttributeConfigurationInterface, List<String>>();
        }
        if (!this.configuredObjects.containsKey(configuredObject)) {
            attributes = new ArrayList();
            this.configuredObjects.put(configuredObject, attributes);
        } else {
            attributes = this.configuredObjects.get(configuredObject);
        }
        if (!attributes.contains(attName)) {
            attributes.add(attName);
        }
    }

    public Map<AttributeDependencyInterface, Exception> getConfigurationExceptions() {
        return this.configurationExceptions;
    }

    private void addConfigurationException(AttributeDependencyInterface dependency, Exception e) {
        if (this.configurationExceptions == null) {
            this.configurationExceptions = new HashMap<AttributeDependencyInterface, Exception>();
        }
        this.configurationExceptions.put(dependency, e);
    }

    @SASScope
    private class MyPromptValueChangeListener
    implements PromptValueChangeListener {
        public boolean eventFired = false;

        private MyPromptValueChangeListener() {
        }

        @Override
        public void promptValueChanged(PromptValueChangeEventInterface event) {
            if (event != null) {
                this.eventFired = true;
            }
        }
    }
}

