/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.mgmt;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import com.sas.codepolicy.SASScope;
import com.sas.iom.ObjectSpawner.ISpawnedServer;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.mgmt.RB;
import com.sas.services.connection.platform.mgmt.ServerMBean;
import com.sas.text.Message;
import java.util.ResourceBundle;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class SpawnedServerMBean
extends ServerMBean
implements NotificationListener {
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("SpawnedServerMBean.mBeanDesc.txt");
    private static final String VOID_TYPE_NAME = "void";
    private String _uuid = null;
    private ObjectName _spawnerObjectName;
    private ISpawnedServer _iSpawnedServer = null;
    private Logger _logger = null;

    public SpawnedServerMBean(ISpawnedServer spawnedServer, String instanceId, ObjectName spawnerObjectName, ConnectionInterface topConn) throws Exception {
        super(MBEAN_DESCRIPTION, topConn, spawnedServer);
        this._uuid = instanceId;
        this._spawnerObjectName = spawnerObjectName;
        this._iSpawnedServer = spawnedServer;
        this.addMBeanOperation("killServer", RB.getStringResource("SpawnedServerMBean.kill.txt"), null, VOID_TYPE_NAME, 1);
        this._logger = LogManager.getLogger(SpawnedServerMBean.class);
    }

    @Override
    protected Object getTargetObject() {
        return this;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        block7: {
            if (registrationDone.booleanValue()) {
                block6: {
                    ObjectName on = null;
                    try {
                        on = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                        filter.enableObjectName(this._spawnerObjectName);
                        filter.enableType("JMX.mbean.unregistered");
                        this.getMBeanServer().addNotificationListener(on, this, (NotificationFilter)filter, null);
                    }
                    catch (Exception e) {
                        if (null == this._logger) break block6;
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnedServerMBean.notifErr.fmt.txt", (Object)this._objectNameCanonicalName), (Throwable)e);
                    }
                }
                if (registrationDone.booleanValue()) {
                    try {
                        this.getMBeanServer().addNotificationListener(this._spawnerObjectName, this, null, null);
                    }
                    catch (Exception e) {
                        if (null == this._logger) break block7;
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnedServerMBean.notifErr.fmt.txt", (Object)this._objectNameCanonicalName), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mbsN = (MBeanServerNotification)notification;
            if (mbsN.getType().equals("JMX.mbean.unregistered") && this._spawnerObjectName.equals(mbsN.getMBeanName())) {
                this.unRegister();
                this.cleanup();
            }
        } else if (notification.getType().equals("Spawner.serverEnd") && notification.getUserData().equals(this._uuid)) {
            this.unRegister();
            this.cleanup();
        }
    }

    public void killServer() throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnedServerMBean.killServer.fmt.txt", (Object)this._uuid));
        }
        if (null != this._iSpawnedServer) {
            Executor ex = this.getExecutor();
            FutureResult fr = new FutureResult();
            Runnable myrun = fr.setter(new Callable(){

                public Object call() {
                    try {
                        SpawnedServerMBean.this._iSpawnedServer.KillServer();
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }
            });
            ex.execute(myrun);
            this.handleThrowable((Throwable)fr.get(), "SpawnedServerMBean.killErr.fmt.txt");
        }
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("SpawnedServerMBean.killReturn.txt"));
        }
    }

    @Override
    public void stop() throws Exception {
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SpawnedServerMBean.stop.fmt.txt", (Object)this._uuid));
        }
        if (null != this._iServerAdministration) {
            Executor ex = this.getExecutor();
            FutureResult fr = new FutureResult();
            Runnable myrun = fr.setter(new Callable(){

                public Object call() {
                    try {
                        SpawnedServerMBean.this._iServerAdministration.StopServer();
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }
            });
            ex.execute(myrun);
            this.handleThrowable((Throwable)fr.get(), "SpawnedServerMBean.stopErr.fmt.txt");
            if (null != this._logger && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("SpawnedServerMBean.stopReturn.txt"));
            }
        } else {
            super.stop();
        }
    }

    @Override
    void closeConnection() {
        if (null != this._iSpawnedServer) {
            try {
                this._iSpawnedServer.Close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._iSpawnedServer = null;
        }
    }

    @Override
    protected void cleanup() {
        this.closeConnection();
        super.cleanup();
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.closeConnection();
        }
        finally {
            super.finalize();
        }
    }
}

