/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.mgmt;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.sas.codepolicy.SASScope;
import com.sas.iom.ObjectSpawner.ISpawnedServer;
import com.sas.iom.SASIOMCommon.IClusterAdministration;
import com.sas.iom.SASIOMCommon.IClusterAdministrationHelper;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IIOMServerAppenderView;
import com.sas.iom.SASIOMCommon.IIOMServerAppenderViewPackage.MapEOF;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMCommon.IServerLogHelper;
import com.sas.iom.SASIOMCommon.IServerSessions;
import com.sas.iom.SASIOMCommon.IServerSessionsHelper;
import com.sas.iom.SASIOMCommon.ISessionAdministration;
import com.sas.iom.SASIOMCommon.ISessionAdministrationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.BooleanSeqHelper;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.DateTimeSeqHelper;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.orb.UUIDConverter;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.net.util.DateConverter;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.mgmt.RB;
import com.sas.services.connection.platform.mgmt.ServerMBeanUtil;
import com.sas.services.connection.platform.mgmt.SpawnedServerMBean;
import com.sas.services.util.AbstractMBean;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@SASScope
public class ServerMBean
extends AbstractMBean
implements MBeanRegistration {
    static final String AUTOMATIC_MBEAN_REGISTRATION = "AutomaticMBeanRegistration";
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("ServerMBean.mBeanDesc.txt");
    private final String VOID_TYPE_NAME = "void";
    private final String LOGGERS_CATEGORY_NAME = "Loggers";
    private final String STRING_CLASS_NAME = String.class.getName();
    private final String SESSION_ID_PARM_NAME = "InstanceId";
    private final String SESSION_ID_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.sessionsId.txt");
    public static final String SESSION_DATA_NAME_INSTANCEID = "Instance Identifier";
    public static final String SESSION_DATA_NAME_OWNER = "Owner";
    public static final String SESSION_DATA_NAME_INACTIVE_TIME = "Inactive Time";
    private final String[] SESSIONS_DATA_NAMES = new String[]{"Instance Identifier", "Owner", "Inactive Time"};
    private final String[] LOGGERS_DATA_NAMES = new String[]{"Name", "Level"};
    private final String APPENDER_FILTER_ID_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.appenderFilterDesc.txt");
    private final String LOGGER_FILTER_ID_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.loggerFilterDesc.txt");
    private final String FILENAME_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.filenameDesc.txt");
    private final String FILTER_ID_PARM_NAME = RB.getStringResource("ServerMBean.filterParm.txt");
    private final String FILENAME_PARM_NAME = RB.getStringResource("ServerMBean.filenameParm.txt");
    private final String LOGGER_PARM_NAME = RB.getStringResource("ServerMBean.loggerParm.txt");
    private final String LOGGER_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.loggerParmDesc.txt");
    private final String LOGGER_LEVEL_PARM_NAME = RB.getStringResource("ServerMBean.priorityParm.txt");
    private final String LOGGER_LEVEL_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.priorityParmDesc.txt");
    private final String[] CLIENT_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("ServerMBean.clientIdxDesc.txt"), RB.getStringResource("ServerMBean.clientIdDesc.txt"), RB.getStringResource("ServerMBean.clientHostDesc.txt"), RB.getStringResource("ServerMBean.enterTimeDesc.txt")};
    private final OpenType[] CLIENT_DATA_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    public static final String CLIENT_DATA_NAME_HOST = "Client Host";
    public static final String CLIENT_DATA_NAME_ID = "Client Identifier";
    public static final String CLIENT_DATA_NAME_ENTERTIME = "Enter Time";
    public static final String CLIENT_DATA_NAME_INDEX = "Table Index";
    public static final String[] CLIENT_DATA_NAMES = new String[]{"Table Index", "Client Identifier", "Client Host", "Enter Time"};
    private static final String[] CLIENT_DATA_INDEX_NAMES = new String[]{"Table Index"};
    private static final String CLIENT_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("ServerMBean.clientCompositeDesc.txt");
    protected static final String CLIENT_TABULARTYPE_DESCRIPTION = RB.getStringResource("ServerMBean.clientTabularDesc.txt");
    private static final String CLIENT_TABULARTYPE_NAME = "com.sas.services.connection.platform.ClientTt";
    private static final String NUMLINES_PARM_NAME = "NumLinesToRead";
    private final String NUMLINES_PARM_DESCRIPTION = RB.getStringResource("ServerMBean.numLines.txt");
    protected IServerAdministration _iServerAdministration;
    private IServerInformation _iServerInformation;
    private IServerSessions _iServerSessions;
    private IClusterAdministration _iClusterAdministration;
    private ConnectionInterface _connection;
    private IServer _iServer;
    private Map _attrNamesMap = null;
    private Map _filteredListMap = null;
    private MBeanServer _mbeanServer;
    protected ObjectName _objectName;
    protected String _objectNameCanonicalName;
    private CompositeType _clientCt;
    protected TabularType _clientTt;
    private CompositeType _sessionsCt;
    private TabularType _sessionsTt;
    private CompositeType _loggersCt;
    private TabularType _loggersTt;
    private Logger _logger;
    private Executor _pooledExecutor;
    private int _eventsHandle;
    private ConnectionPoint _connectionPoint;
    private IServerLog _iServerLog;
    private IIOMServerAppenderView _iomServerAppenderView;

    public ServerMBean(String desc, ConnectionInterface connection, ISpawnedServer spawnedServer) throws Exception {
        super(null != desc ? desc : MBEAN_DESCRIPTION);
        this._connection = connection;
        this._logger = LogManager.getLogger(ServerMBean.class);
        try {
            if (null != connection) {
                Object obj = connection.getObject();
                this._iServerSessions = IServerSessionsHelper.narrow((Object)obj);
                this._iServerAdministration = IServerAdministrationHelper.narrow((Object)obj);
                this._iServerInformation = IServerInformationHelper.narrow((Object)obj);
                this._iServerLog = IServerLogHelper.narrow((Object)obj);
                this._iServer = IServerHelper.narrow((Object)obj);
                this._iClusterAdministration = IClusterAdministrationHelper.narrow((Object)obj);
            } else {
                this._iServerAdministration = IServerAdministrationHelper.narrow((Object)spawnedServer);
                this._iServerInformation = IServerInformationHelper.narrow((Object)spawnedServer);
                this._iServerLog = IServerLogHelper.narrow((Object)spawnedServer);
            }
            this.initialize();
        }
        catch (Exception e) {
            if (null != this._logger) {
                String on = null;
                on = null != this._objectName ? this._objectName.getCanonicalName() : "";
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.initErr.fmt.txt", (java.lang.Object)on), (Throwable)e);
            }
            throw new Exception(e.getLocalizedMessage());
        }
    }

    protected ConnectionInterface getConnection() {
        return this._connection;
    }

    private void initialize() throws GenericError, OpenDataException, BadKind, MBeanException, InterruptedException, InvocationTargetException {
        this.addMBeanOperation("stop", RB.getStringResource("ServerMBean.stopDesc.txt"), null, "void", 1);
        this.addMBeanOperation("deferredStop", RB.getStringResource("ServerMBean.deferredDesc.txt"), null, "void", 1);
        this.addMBeanOperation("pause", RB.getStringResource("ServerMBean.pauseDesc.txt"), null, "void", 1);
        this.addMBeanOperation("continueServer", RB.getStringResource("ServerMBean.continueDesc.txt"), null, "void", 1);
        this.addMBeanOperation("resetCounters", RB.getStringResource("ServerMBean.resetCountersDesc.txt"), null, "void", 1);
        this.addMBeanOperation("flush", RB.getStringResource("ServerMBean.flushDesc.txt"), null, "void", 1);
        this.addMBeanOperation("isAdministrator", RB.getStringResource("ServerMBean.isAdminDesc.txt"), null, Boolean.class.getName(), 0);
        this.createClientTypes();
        this.addMBeanOperation("listClients", RB.getStringResource("ServerMBean.clientListDesc.txt"), null, "javax.management.openmbean.TabularData", 0);
        this.addMBeanOperation("listLoggers", RB.getStringResource("ServerMBean.listLoggersDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.FILTER_ID_PARM_NAME, this.STRING_CLASS_NAME, this.LOGGER_FILTER_ID_PARM_DESCRIPTION)}, "javax.management.openmbean.TabularData", 0);
        this.createLoggerTypes();
        this.addMBeanOperation("changeLoggerPriority", RB.getStringResource("ServerMBean.changeLogPriorityDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.LOGGER_PARM_NAME, this.STRING_CLASS_NAME, this.LOGGER_PARM_DESCRIPTION), new MBeanParameterInfo(this.LOGGER_LEVEL_PARM_NAME, this.STRING_CLASS_NAME, this.LOGGER_LEVEL_PARM_DESCRIPTION)}, "void", 1);
        this.defineAttributes();
        if (null != this._iServerLog) {
            this._iomServerAppenderView = this._iServerLog.GetIOMServerAppenderView("");
            this.addMBeanOperation("clearLog", RB.getStringResource("ServerMBean.clearAppender.txt"), null, "void", 1);
            this.addMBeanOperation("readLogEntries", RB.getStringResource("ServerMBean.read.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(NUMLINES_PARM_NAME, Integer.class.getName(), this.NUMLINES_PARM_DESCRIPTION)}, String[].class.getName(), 0);
            this.addMBeanOperation("setLogFilter", RB.getStringResource("ServerMBean.setFilter.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.FILTER_ID_PARM_NAME, this.STRING_CLASS_NAME, this.APPENDER_FILTER_ID_PARM_DESCRIPTION)}, "void", 1);
            this.addMBeanOperation("setLoggingConfiguration", RB.getStringResource("ServerMBean.setLogConfigDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(this.FILENAME_PARM_NAME, this.STRING_CLASS_NAME, this.FILENAME_PARM_DESCRIPTION)}, "void", 1);
            this.addMBeanOperation("getLoggingConfiguration", RB.getStringResource("ServerMBean.getLogConfigDesc.txt"), null, this.STRING_CLASS_NAME, 0);
        }
        if (null != this._iServerSessions) {
            this.addMBeanOperation("listSessionProperties", RB.getStringResource("ServerMBean.listSessionPropDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("InstanceId", this.STRING_CLASS_NAME, this.SESSION_ID_PARM_DESCRIPTION)}, "javax.management.openmbean.CompositeData", 0);
            this.addMBeanOperation("endSession", RB.getStringResource("ServerMBean.endSessionDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("InstanceId", this.STRING_CLASS_NAME, this.SESSION_ID_PARM_DESCRIPTION)}, "void", 1);
            this.addMBeanOperation("resetSessionCounters", RB.getStringResource("ServerMBean.sessionResetDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo("InstanceId", this.STRING_CLASS_NAME, this.SESSION_ID_PARM_DESCRIPTION)}, "void", 1);
            this.createSessionTypes();
            this.addMBeanOperation("listSessions", RB.getStringResource("ServerMBean.listSessionsDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(RB.getStringResource("ServerMBean.sessionsUserFilterParmName.txt"), this.STRING_CLASS_NAME, RB.getStringResource("ServerMBean.sessionsUserFilterParmDesc.txt"))}, "javax.management.openmbean.TabularData", 0);
        }
        if (null != this._iServer) {
            this.addMBeanOperation("pause", RB.getStringResource("ServerMBean.pauseDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(RB.getStringResource("ServerMBean.pauseMetaParmName.txt"), this.STRING_CLASS_NAME, RB.getStringResource("ServerMBean.pauseMetaParmDesc.txt"))}, "void", 1);
        }
        if (null != this._iClusterAdministration) {
            this.addMBeanOperation("stopCluster", RB.getStringResource("ServerMBean.stopClusterDesc.txt"), null, "void", 1);
            this.addMBeanOperation("deferredStopCluster", RB.getStringResource("ServerMBean.deferredStopClusterDesc.txt"), null, "void", 1);
            this.addMBeanOperation("pauseCluster", RB.getStringResource("ServerMBean.pauseClusterDesc.txt"), null, "void", 1);
            this.addMBeanOperation("continueCluster", RB.getStringResource("ServerMBean.continueClusterDesc.txt"), null, "void", 1);
        }
    }

    public java.lang.Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if (this._attrNamesMap.containsKey(attribute)) {
                return this.getProperty(attribute);
            }
            return super.getAttribute(attribute);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList returnList;
        block10: {
            returnList = new AttributeList(attributes.length);
            ArrayList<String> flAttrsList = new ArrayList<String>();
            try {
                for (int i = 0; i < attributes.length; ++i) {
                    if (attributes[i].equals(AUTOMATIC_MBEAN_REGISTRATION)) {
                        String[] attrs = new String[]{attributes[i]};
                        try {
                            AttributeList l = super.getAttributes(attrs);
                            if (l.size() <= 0) continue;
                            returnList.addAll(l);
                        }
                        catch (Exception e) {
                            if (this._logger == null) continue;
                            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.attrErr.fmt.txt", (java.lang.Object)attributes[i], (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
                        }
                        continue;
                    }
                    flAttrsList.add(attributes[i]);
                }
                if (flAttrsList.size() > 0) {
                    if (flAttrsList.size() > 1) {
                        String[] flAttrs = new String[flAttrsList.size()];
                        flAttrs = flAttrsList.toArray(flAttrs);
                        java.lang.Object[] values = new java.lang.Object[flAttrs.length];
                        this.getProperties(flAttrs, values);
                        for (int i = 0; i < flAttrs.length; ++i) {
                            returnList.add(new Attribute(flAttrs[i], values[i]));
                        }
                    } else {
                        String attr = (String)flAttrsList.get(0);
                        returnList.add(new Attribute(attr, this.getProperty(attr)));
                    }
                }
            }
            catch (Exception e) {
                if (this._logger == null) break block10;
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.getAttributesErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
            }
        }
        return returnList;
    }

    public void setAttribute(Attribute attribute) throws MBeanException, AttributeNotFoundException, ReflectionException, InvalidAttributeValueException {
        if (this._attrNamesMap.containsKey(attribute.getName())) {
            this.setMBeanAttribute(attribute.getName(), attribute.getValue());
        } else {
            super.setAttribute(attribute);
        }
    }

    protected java.lang.Object getTargetObject() {
        return this;
    }

    protected java.lang.Object getProperty(final String attribute) throws Exception {
        final ReturnValue prop = new ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    if (ServerMBean.this._attrNamesMap != null && ServerMBean.this._attrNamesMap.containsKey(attribute)) {
                        IFilteredList fl = (IFilteredList)ServerMBean.this._filteredListMap.get(ServerMBean.this._attrNamesMap.get(attribute));
                        AnySeqHolder anySeqHolder = new AnySeqHolder();
                        fl.GetAttribute(attribute, "value", anySeqHolder);
                        Any[] values = anySeqHolder.value;
                        if (values.length >= 1) {
                            prop.setValue(ServerMBeanUtil.anyObjectToObject(values[0]));
                        }
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.getAttributeErr.fmt.txt");
        return prop.getValue();
    }

    protected void setMBeanAttribute(final String attribute, final java.lang.Object value) throws MBeanException, AttributeNotFoundException, ReflectionException, InvalidAttributeValueException {
        if (this._attrNamesMap.containsKey(attribute)) {
            if (this._iServerInformation != null) {
                Executor ex = this.getExecutor();
                FutureResult fr = new FutureResult();
                Runnable myrun = fr.setter(new Callable(){

                    public java.lang.Object call() {
                        try {
                            IFilteredList fl = (IFilteredList)ServerMBean.this._filteredListMap.get(ServerMBean.this._attrNamesMap.get(attribute));
                            ORB orb = ((ObjectImpl)ServerMBean.this._iServerInformation)._orb();
                            Any any = ServerMBeanUtil.objectToAny(value, orb);
                            fl.SetValue(attribute, any);
                        }
                        catch (Throwable t) {
                            return t;
                        }
                        return null;
                    }
                });
                Throwable t = null;
                try {
                    ex.execute(myrun);
                    t = (Throwable)fr.get();
                }
                catch (InterruptedException e) {
                    throw new MBeanException(e);
                }
                catch (InvocationTargetException e) {
                    throw new MBeanException(e);
                }
                if (t != null) {
                    if (t instanceof COMM_FAILURE) {
                        if (this._logger != null) {
                            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.unrecoverErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), t);
                        }
                        this.unRegister();
                        this.cleanup();
                        throw new MBeanException(new Exception(t.getLocalizedMessage()));
                    }
                    if (this._logger != null) {
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.setAttributeErr.fmt.txt", (java.lang.Object)attribute, (java.lang.Object)this._objectNameCanonicalName), t);
                    }
                    throw new MBeanException(new Exception(t.getLocalizedMessage()));
                }
            }
        } else {
            throw new AttributeNotFoundException(attribute);
        }
    }

    protected void getProperties(final String[] attributes, final java.lang.Object[] values) throws Exception {
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                IFilteredList fl = null;
                HashMap currentMap = new HashMap(ServerMBean.this._attrNamesMap);
                HashMap tempMap = new HashMap(ServerMBean.this._filteredListMap);
                try {
                    for (String categoryName : tempMap.keySet()) {
                        int i;
                        if (categoryName.equals("Loggers")) continue;
                        fl = (IFilteredList)ServerMBean.this._filteredListMap.get(categoryName);
                        AnySeqHolder anySeqHolder = new AnySeqHolder();
                        fl.GetAttributes("name value", anySeqHolder);
                        Any[] retValues = anySeqHolder.value;
                        Any[] theValues = AnySeqHelper.extract((Any)retValues[1]);
                        String[] names = StringSeqHelper.extract((Any)retValues[0]);
                        String attrname = null;
                        block3: for (i = 0; i < attributes.length; ++i) {
                            attrname = attributes[i];
                            for (int b = 0; b < names.length; ++b) {
                                if (!names[b].equals(attrname)) continue;
                                values[i] = ServerMBeanUtil.anyObjectToObject(theValues[b]);
                                continue block3;
                            }
                        }
                        for (i = 0; i < names.length; ++i) {
                            if (ServerMBean.this._attrNamesMap.get(names[i]) == null) {
                                ServerMBean.this.registerSingleFilteredListAttribute(fl, names[i], categoryName);
                                continue;
                            }
                            currentMap.remove(names[i]);
                        }
                    }
                    for (String key : currentMap.keySet()) {
                        ServerMBean.this._attrNamesMap.remove(key);
                        ServerMBean.this.removeMBeanAttribute(key);
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.getAttributesErr.fmt.txt");
    }

    public void pause() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pause.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pauseNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.PauseServer();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.pauseErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.pauseReturn.txt"));
        }
    }

    public void pause(final String pauseOptions) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pause.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServer == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pauseNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        if (this._iServer != null) {
            Executor ex = this.getExecutor();
            FutureResult fr = new FutureResult();
            Runnable myrun = fr.setter(new Callable(){

                public java.lang.Object call() {
                    try {
                        ServerMBean.this._iServer.Pause(pauseOptions);
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }
            });
            ex.execute(myrun);
            this.handleThrowable((Throwable)fr.get(), "ServerMBean.pauseErr.fmt.txt");
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(RB.getStringResource("ServerMBean.pauseReturn.txt"));
            }
        }
    }

    public void continueServer() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.continue.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.continueNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.ContinueServer();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.continueErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.continueReturn.txt"));
        }
    }

    public void stop() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.stop.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.stopNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.StopServer();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.stopErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.stopReturn.txt"));
        }
    }

    public void flush() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.flush.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.flushNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.CacheFlush();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.flushErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.flushReturn.txt"));
        }
    }

    public void deferredStop() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.deferredStop.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.deferredNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.DeferredStopServer();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.deferredStopErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.deferredReturn.txt"));
        }
    }

    public void resetCounters() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.resetCounters.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.resetNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerAdministration.ResetPerformanceCounters();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.resetCountersErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.resetReturn.txt"));
        }
    }

    public boolean isAdministrator() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.isAdmin.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        final ReturnValue prop = new ReturnValue();
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    prop.setValue(ServerMBean.this._iServerInformation.IsAdministrator());
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.isAdminErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.isAdminReturn.txt"));
        }
        return (Boolean)prop.getValue();
    }

    private void defineAttributes() throws MBeanException, InterruptedException, InvocationTargetException {
        if (this._iServerInformation != null) {
            Executor ex = this.getExecutor();
            FutureResult fr = new FutureResult();
            Runnable myrun = fr.setter(new Callable(){

                public java.lang.Object call() {
                    try {
                        String[] cats = ServerMBean.this._iServerInformation.ListCategories();
                        ServerMBean.this._filteredListMap = new HashMap(cats.length);
                        ServerMBean.this._attrNamesMap = new HashMap(cats.length - 1);
                        IFilteredList fl = null;
                        for (int i = 0; i < cats.length; ++i) {
                            if (cats[i].equals("Loggers")) {
                                fl = ServerMBean.this._iServerInformation.UseCategory(cats[i], "");
                                ServerMBean.this._filteredListMap.put(cats[i], fl);
                                continue;
                            }
                            fl = ServerMBean.this._iServerInformation.UseCategory(cats[i], "");
                            ServerMBean.this._filteredListMap.put(cats[i], fl);
                            ServerMBean.this.registerFilteredListAttributes(fl, cats[i]);
                        }
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }
            });
            ex.execute(myrun);
            try {
                this.handleThrowable((Throwable)fr.get(), "ServerMBean.getAttributesErr.fmt.txt");
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    private void registerFilteredListAttributes(IFilteredList fl, String cat) throws GenericError, BadKind {
        AnySeqHolder anySeqHolder = new AnySeqHolder();
        fl.GetAttributes("name description writeable value", anySeqHolder);
        Any[] values = anySeqHolder.value;
        java.lang.Object[] lists = new java.lang.Object[4];
        for (int i = 0; i < values.length; ++i) {
            Any anyValue = values[i];
            TypeCode typecode = anyValue.type();
            TCKind kind = typecode.kind();
            int kindType = kind.value();
            if (kindType != 21) continue;
            if (typecode.name().equals(StringSeqHelper.type().name())) {
                lists[i] = StringSeqHelper.extract((Any)anyValue);
                continue;
            }
            if (typecode.name().equals(AnySeqHelper.type().name())) {
                lists[i] = AnySeqHelper.extract((Any)anyValue);
                continue;
            }
            if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
            lists[i] = BooleanSeqHelper.extract((Any)anyValue);
        }
        String[] names = (String[])lists[0];
        String[] descs = (String[])lists[1];
        boolean[] writeables = (boolean[])lists[2];
        Any[] theValues = (Any[])lists[3];
        String className = null;
        for (int i = 0; i < names.length; ++i) {
            className = ServerMBeanUtil.anyToJavaClassName(theValues[i]);
            this.addMBeanAttribute(names[i], className, true, writeables[i], false, descs[i]);
            this._attrNamesMap.put(names[i], cat);
        }
    }

    MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    private void registerSingleFilteredListAttribute(IFilteredList fl, String attrName, String categoryName) throws Exception {
        AnySeqHolder anySeqHolder = new AnySeqHolder();
        fl.GetAttribute(attrName, "name description writeable value", anySeqHolder);
        Any[] values = anySeqHolder.value;
        String desc = (String)ServerMBeanUtil.anyObjectToObject(values[1]);
        boolean writeable = (Boolean)ServerMBeanUtil.anyObjectToObject(values[2]);
        String className = ServerMBeanUtil.anyToJavaClassName(values[3]);
        this.addMBeanAttribute(attrName, className, true, writeable, false, desc);
        this._attrNamesMap.put(attrName, categoryName);
    }

    public TabularData listClients() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.listClients.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iServerAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.clientsNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noAdmin.ex.txt"));
        }
        final TabularDataSupport td = new TabularDataSupport(this._clientTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    StringSeqHolder clientHolder = new StringSeqHolder();
                    StringSeqHolder hostHolder = new StringSeqHolder();
                    DateTimeSeqHolder timeHolder = new DateTimeSeqHolder();
                    ServerMBean.this._iServerAdministration.ListClients(clientHolder, hostHolder, timeHolder);
                    String[] clients = clientHolder.value;
                    String[] clientHosts = hostHolder.value;
                    long[] enterTimes = timeHolder.value;
                    Date d = null;
                    SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z");
                    s.setTimeZone(TimeZone.getTimeZone("GMT"));
                    for (int i = 0; i < clients.length; ++i) {
                        d = DateConverter.corbaToJavaGMT((long)enterTimes[i]);
                        java.lang.Object[] itemValues = new java.lang.Object[]{i + 1, clients[i], clientHosts[i], s.format(d)};
                        td.put(new CompositeDataSupport(ServerMBean.this._clientCt, CLIENT_DATA_NAMES, itemValues));
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.clientsErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.clientsReturn.txt"));
        }
        return td;
    }

    public TabularData listSessions(final String filter) throws Exception {
        if (this._iServerSessions == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.sessionsNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noSessions.ex.txt"));
        }
        final TabularDataSupport td = new TabularDataSupport(this._sessionsTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    StringSeqHolder ownerHolder = new StringSeqHolder();
                    UUIDSeqHolder uuidHolder = new UUIDSeqHolder();
                    DoubleSeqHolder inactiveHolder = new DoubleSeqHolder();
                    ServerMBean.this._iServerSessions.SessionList(filter, uuidHolder, ownerHolder, inactiveHolder);
                    String[] owners = ownerHolder.value;
                    double[] inactiveTimes = inactiveHolder.value;
                    UUID[] sessionIds = uuidHolder.value;
                    for (int i = 0; i < owners.length; ++i) {
                        java.lang.Object[] itemValues = new java.lang.Object[]{UUIDConverter.uuidToString((UUID)sessionIds[i]), owners[i], inactiveTimes[i]};
                        td.put(new CompositeDataSupport(ServerMBean.this._sessionsCt, ServerMBean.this.SESSIONS_DATA_NAMES, itemValues));
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.listSessionsErr.fmt.txt");
        return td;
    }

    public void changeLoggerPriority(final String loggerContext, final String priority) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.changeLogger.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    IFilteredList fl = (IFilteredList)ServerMBean.this._filteredListMap.get("Loggers");
                    if (fl == null) {
                        return null;
                    }
                    ORB orb = ((ObjectImpl)ServerMBean.this._iServerInformation)._orb();
                    Any any = ServerMBeanUtil.objectToAny(priority, orb);
                    fl.SetValue(loggerContext, any);
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.setPriorityLoggersErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.changeLoggerReturn.txt"));
        }
    }

    public TabularData listLoggers(final String filter) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.listLoggers.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        final TabularDataSupport td = new TabularDataSupport(this._loggersTt);
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public java.lang.Object call() {
                IFilteredList fl = null;
                try {
                    AnySeqHolder anySeqHolder22 = new AnySeqHolder();
                    fl = ServerMBean.this._iServerInformation.UseCategory("Loggers", filter != null ? filter : "");
                    fl.GetAttributes("name value", anySeqHolder22);
                    Any[] values = anySeqHolder22.value;
                    java.lang.Object[] lists = new java.lang.Object[2];
                    for (int i = 0; i < values.length; ++i) {
                        Any anyValue = values[i];
                        TypeCode typecode = anyValue.type();
                        TCKind kind = typecode.kind();
                        int kindType = kind.value();
                        if (kindType != 21) continue;
                        if (typecode.name().equals(StringSeqHelper.type().name())) {
                            lists[i] = StringSeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (!typecode.name().equals(AnySeqHelper.type().name())) continue;
                        lists[i] = AnySeqHelper.extract((Any)anyValue);
                    }
                    String[] names = (String[])lists[0];
                    Any[] theValues = (Any[])lists[1];
                    String value = null;
                    for (int i = 0; i < names.length; ++i) {
                        value = (String)ServerMBeanUtil.anyObjectToObject(theValues[i]);
                        java.lang.Object[] itemValues = new java.lang.Object[]{names[i], value};
                        td.put(new CompositeDataSupport(ServerMBean.this._loggersCt, ServerMBean.this.LOGGERS_DATA_NAMES, itemValues));
                    }
                    if (fl == null) return null;
                }
                catch (Throwable t) {
                    try {
                        Throwable throwable = t;
                        return throwable;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (fl != null) {
                            try {
                                fl.Close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                try {
                    fl.Close();
                    return null;
                }
                catch (Exception anySeqHolder22) {
                    return null;
                }
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.listLoggersErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.listLoggersReturn.txt"));
        }
        return td;
    }

    public void setLoggingConfiguration(final String filename) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.setLogConfig.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public java.lang.Object call() {
                ByteArrayOutputStream baos;
                block20: {
                    FileInputStream fis = null;
                    baos = new ByteArrayOutputStream();
                    try {
                        File f2332 = new File(filename);
                        fis = new FileInputStream(f2332);
                        byte[] buf = new byte[4096];
                        int len = 0;
                        while ((len = fis.read(buf)) != -1) {
                            baos.write(buf, 0, len);
                        }
                        ServerMBean.this._iServerLog.SetStreamLogCfg(baos.toByteArray());
                        if (fis == null) break block20;
                    }
                    catch (Throwable t) {
                        try {
                            Throwable throwable = t;
                            return throwable;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (baos != null) {
                                try {
                                    baos.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    try {
                        fis.close();
                    }
                    catch (Exception f2332) {
                        // empty catch block
                    }
                }
                if (baos == null) return null;
                try {
                    baos.close();
                    return null;
                }
                catch (Exception f2332) {
                    return null;
                }
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.setLogConfigErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.setLogConfigReturn.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoggingConfiguration() throws Exception {
        String config;
        block13: {
            config = "";
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.getLogConfig.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Executor ex = this.getExecutor();
                FutureResult fr = new FutureResult();
                Runnable myrun = fr.setter(new Callable(){

                    public java.lang.Object call() {
                        try {
                            byte[] buf = ServerMBean.this._iServerLog.GetStreamLogCfg();
                            baos.write(buf);
                        }
                        catch (Throwable t) {
                            return t;
                        }
                        return null;
                    }
                });
                ex.execute(myrun);
                this.handleThrowable((Throwable)fr.get(), "ServerMBean.getLogConfigErr.fmt.txt");
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(RB.getStringResource("ServerMBean.getLogConfigReturn.txt"));
                }
                if (baos.size() <= 0) break block13;
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(new ByteArrayInputStream(baos.toByteArray()));
                    config = XMLUtil.convertNodeToString((Node)document);
                }
                catch (Exception e) {
                    if (this._logger != null) {
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.getLogConfigErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
                    }
                    throw new Exception(e.getLocalizedMessage());
                }
            }
            finally {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return config;
    }

    public void clearLog() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.clear.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iServerLog.ClearIOMServerAppender();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.clearErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.clearReturn.txt"));
        }
    }

    public void setLogFilter(final String filter) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.setFilter.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    if (ServerMBean.this._iomServerAppenderView != null) {
                        ServerMBean.this._iomServerAppenderView.Filter(filter);
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        Throwable t = (Throwable)fr.get();
        if (t != null) {
            if (t instanceof COMM_FAILURE) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.unrecoverErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), t);
                }
                this.unRegister();
                this.cleanup();
                throw new Exception(t.getLocalizedMessage());
            }
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.setFilterErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), t);
            }
            throw new Exception(t.getLocalizedMessage());
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.setFilterReturn.txt"));
        }
    }

    public String[] readLogEntries(Integer num) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.read.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        final int numToRead = num;
        final String[] retArray = new String[numToRead];
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    int i;
                    IntHolder numRead = new IntHolder();
                    AnySeqHolder entries = new AnySeqHolder();
                    int total = 0;
                    ServerMBean.this._iomServerAppenderView.ReadEntries(numToRead, entries, numRead);
                    Any[] anyValues = entries.value;
                    if (anyValues.length == 0 || numRead.value == 0) {
                        return null;
                    }
                    int longIdx = -1;
                    java.lang.Object[] lists = new java.lang.Object[4];
                    for (int i2 = 0; i2 < anyValues.length; ++i2) {
                        Any anyValue = anyValues[i2];
                        TypeCode typecode = anyValue.type();
                        TCKind kind = typecode.kind();
                        int kindType = kind.value();
                        if (kindType != 21) continue;
                        if (typecode.name().equals(StringSeqHelper.type().name())) {
                            lists[i2] = StringSeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (!typecode.name().equals(DateTimeSeqHelper.type().name())) continue;
                        lists[i2] = DateTimeSeqHelper.extract((Any)anyValue);
                        longIdx = i2;
                    }
                    java.lang.Object[] values = new java.lang.Object[4];
                    for (i = 0; i < values.length; ++i) {
                        values[i] = "       ";
                    }
                    for (i = 0; i < numRead.value; ++i) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("{0}   \t{1}   \t{2}   \t{3}");
                        for (int c = 0; c < anyValues.length; ++c) {
                            java.lang.Object[] objs;
                            if (c == longIdx) {
                                objs = (long[])lists[c];
                                Date d = DateConverter.corbaToJavaGMT((long)objs[i]);
                                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z");
                                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                                values[c] = sdf.format(d);
                                continue;
                            }
                            objs = (java.lang.Object[])lists[c];
                            values[c] = objs[i];
                        }
                        String s = MessageFormat.format(buf.toString(), values[0], values[1], values[2], values[3]);
                        retArray[total++] = s;
                    }
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        Throwable t = (Throwable)fr.get();
        if (t != null) {
            if (t instanceof COMM_FAILURE) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.unrecoverErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), t);
                }
                this.unRegister();
                this.cleanup();
                throw new Exception(t.getLocalizedMessage());
            }
            if (t instanceof MapEOF) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.readEOF.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), t);
                }
                throw new Exception(RB.getStringResource("ServerMBean.eof.txt"));
            }
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.readErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), t);
            }
            throw new Exception(t.getLocalizedMessage());
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.readReturn.txt"));
        }
        return retArray;
    }

    public CompositeData listSessionProperties(final String uuid) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.listSessionProps.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName(), (java.lang.Object)uuid));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        final ReturnValue rv = new ReturnValue();
        Runnable myrun = fr.setter(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public java.lang.Object call() {
                try {
                    UUID theUUID = null;
                    try {
                        theUUID = UUIDConverter.stringToUUID((String)uuid);
                    }
                    catch (Exception e) {
                        Exception ex = new Exception(RB.getStringResource("ServerMBean.invalidId.ex.txt"));
                        return ex;
                    }
                    Object obj = ServerMBean.this._iServerSessions.UseSession(theUUID);
                    ISessionAdministration iSessionAdmin = ISessionAdministrationHelper.narrow((Object)obj);
                    String[] cats = iSessionAdmin.ListCategories();
                    ArrayList<String> nameList = new ArrayList<String>();
                    ArrayList<java.lang.Object> valueList = new ArrayList<java.lang.Object>();
                    ArrayList<OpenType> openList = new ArrayList<OpenType>();
                    ArrayList<String> descList = new ArrayList<String>();
                    for (int c = 0; c < cats.length; ++c) {
                        IFilteredList fl = null;
                        try {
                            AnySeqHolder anySeqHolder = new AnySeqHolder();
                            fl = iSessionAdmin.UseCategory(cats[c], "");
                            fl.GetAttributes("name description writeable value", anySeqHolder);
                            Any[] values = anySeqHolder.value;
                            java.lang.Object[] lists = new java.lang.Object[4];
                            for (int i = 0; i < values.length; ++i) {
                                Any anyValue = values[i];
                                TypeCode typecode = anyValue.type();
                                TCKind kind = typecode.kind();
                                int kindType = kind.value();
                                if (kindType != 21) continue;
                                if (typecode.name().equals(StringSeqHelper.type().name())) {
                                    lists[i] = StringSeqHelper.extract((Any)anyValue);
                                    continue;
                                }
                                if (typecode.name().equals(AnySeqHelper.type().name())) {
                                    lists[i] = AnySeqHelper.extract((Any)anyValue);
                                    continue;
                                }
                                if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                                lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                            }
                            String[] names = (String[])lists[0];
                            if (names.length == 0) continue;
                            String[] descs = (String[])lists[1];
                            boolean[] writeables = (boolean[])lists[2];
                            Any[] theValues = (Any[])lists[3];
                            java.lang.Object[] javaValues = new java.lang.Object[theValues.length];
                            OpenType[] otTypes = new OpenType[theValues.length];
                            for (int i = 0; i < names.length; ++i) {
                                javaValues[i] = ServerMBeanUtil.anyObjectToObject(theValues[i]);
                                otTypes[i] = ServerMBeanUtil.objectToOpenType(javaValues[i]);
                                nameList.add(names[i]);
                                valueList.add(javaValues[i]);
                                openList.add(otTypes[i]);
                                descList.add(descs[i]);
                            }
                            continue;
                        }
                        finally {
                            if (fl != null) {
                                fl.Close();
                                fl = null;
                            }
                        }
                    }
                    String[] names = nameList.toArray(new String[nameList.size()]);
                    String[] descs = descList.toArray(new String[descList.size()]);
                    OpenType[] oTypes = openList.toArray(new OpenType[openList.size()]);
                    CompositeType ct = new CompositeType(RB.getStringResource("ServerMBean.sessionSummaryCtDesc.txt"), RB.getStringResource("ServerMBean.sessionSummaryDesc.txt"), names, descs, oTypes);
                    CompositeDataSupport cd = new CompositeDataSupport(ct, names, valueList.toArray());
                    rv.setValue(cd);
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.listSessionPropsErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.listSessionPropsReturn.txt"));
        }
        return (CompositeData)rv.getValue();
    }

    public void endSession(final String uuid) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.endSession.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName(), (java.lang.Object)uuid));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    UUID theUUID = null;
                    try {
                        theUUID = UUIDConverter.stringToUUID((String)uuid);
                    }
                    catch (Exception e) {
                        Exception ex = new Exception(RB.getStringResource("ServerMBean.invalidId.ex.txt"));
                        return ex;
                    }
                    Object obj = ServerMBean.this._iServerSessions.UseSession(theUUID);
                    ISessionAdministration iSessionAdmin = ISessionAdministrationHelper.narrow((Object)obj);
                    iSessionAdmin.EndSession();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.endSessionErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.endSessionReturn.txt"));
        }
    }

    public void resetSessionCounters(final String uuid) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.sessionReset.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName(), (java.lang.Object)uuid));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    UUID theUUID = null;
                    try {
                        theUUID = UUIDConverter.stringToUUID((String)uuid);
                    }
                    catch (Exception e) {
                        Exception ex = new Exception(RB.getStringResource("ServerMBean.invalidId.ex.txt"));
                        return ex;
                    }
                    Object obj = ServerMBean.this._iServerSessions.UseSession(theUUID);
                    ISessionAdministration iSessionAdmin = ISessionAdministrationHelper.narrow((Object)obj);
                    iSessionAdmin.ResetPerformanceCounters();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.sessionResetErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.sessionResetReturn.txt"));
        }
    }

    public void pauseCluster() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pauseCluster.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iClusterAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.pauseClusterNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noClusterAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iClusterAdministration.PauseCluster();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.pauseClusterErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.pauseClusterReturn.txt"));
        }
    }

    public void continueCluster() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.continueCluster.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iClusterAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.continueClusterNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noClusterAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iClusterAdministration.ContinueCluster();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.continueClusterErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.continueClusterReturn.txt"));
        }
    }

    public void stopCluster() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.stopCluster.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iClusterAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.stopClusterNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noClusterAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iClusterAdministration.StopCluster();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.stopClusterErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.stopClusterReturn.txt"));
        }
    }

    public void deferredStopCluster() throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.deferredStopCluster.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._iClusterAdministration == null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.deferredStopClusterNoAdmin.fmt.txt", (java.lang.Object)this._objectNameCanonicalName));
            }
            throw new Exception(RB.getStringResource("ServerMBean.noClusterAdmin.ex.txt"));
        }
        Executor ex = this.getExecutor();
        FutureResult fr = new FutureResult();
        Runnable myrun = fr.setter(new Callable(){

            public java.lang.Object call() {
                try {
                    ServerMBean.this._iClusterAdministration.DeferredStopCluster();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }
        });
        ex.execute(myrun);
        this.handleThrowable((Throwable)fr.get(), "ServerMBean.deferredStopClusterErr.fmt.txt");
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerMBean.deferredStopClusterReturn.txt"));
        }
    }

    private void createClientTypes() throws OpenDataException {
        String CLIENT_COMPOSITETYPE_NAME = "com.sas.services.connection.platform.ClientCt";
        this._clientCt = new CompositeType(CLIENT_COMPOSITETYPE_NAME, CLIENT_COMPOSITETYPE_DESCRIPTION, CLIENT_DATA_NAMES, this.CLIENT_DATA_DESCRIPTIONS, this.CLIENT_DATA_TYPES);
        this._clientTt = new TabularType(CLIENT_TABULARTYPE_NAME, CLIENT_TABULARTYPE_DESCRIPTION, this._clientCt, CLIENT_DATA_INDEX_NAMES);
    }

    private void createSessionTypes() throws OpenDataException {
        String[] SESSIONS_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("ServerMBean.sessionsId.txt"), RB.getStringResource("ServerMBean.sessionsOwner.txt"), RB.getStringResource("ServerMBean.sessionsInactive.txt")};
        String SESSIONS_COMPOSITETYPE_NAME = "com.sas.services.connection.platform.SessionsCt";
        OpenType[] SESSIONS_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.DOUBLE};
        this._sessionsCt = new CompositeType(SESSIONS_COMPOSITETYPE_NAME, RB.getStringResource("ServerMBean.sessionsCompositeDesc.txt"), this.SESSIONS_DATA_NAMES, SESSIONS_DATA_DESCRIPTIONS, SESSIONS_DATA_TYPES);
        String[] SESSIONS_DATA_INDEX_NAME = new String[]{SESSION_DATA_NAME_INSTANCEID};
        String SESSIONS_TABULARTYPE_NAME = "com.sas.services.connection.platform.SessionTt";
        this._sessionsTt = new TabularType(SESSIONS_TABULARTYPE_NAME, RB.getStringResource("ServerMBean.sessionsTabularDesc.txt"), this._sessionsCt, SESSIONS_DATA_INDEX_NAME);
    }

    private void createLoggerTypes() throws OpenDataException {
        String[] LOGGERS_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("ServerMBean.loggerName.txt"), RB.getStringResource("ServerMBean.loggerLevel.txt")};
        String LOGGERS_COMPOSITETYPE_NAME = "com.sas.services.connection.platform.LoggersCt";
        OpenType[] LOGGERS_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        this._loggersCt = new CompositeType(LOGGERS_COMPOSITETYPE_NAME, RB.getStringResource("ServerMBean.loggersCompositeDesc.txt"), this.LOGGERS_DATA_NAMES, LOGGERS_DATA_DESCRIPTIONS, LOGGERS_DATA_TYPES);
        String[] LOGGERS_DATA_INDEX_NAME = new String[]{"Name"};
        String LOGGERS_TABULARTYPE_NAME = "com.sas.services.connection.platform.LoggersTt";
        this._loggersTt = new TabularType(LOGGERS_TABULARTYPE_NAME, RB.getStringResource("ServerMBean.loggersTabularDesc.txt"), this._loggersCt, LOGGERS_DATA_INDEX_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Executor getExecutor() {
        ServerMBean serverMBean = this;
        synchronized (serverMBean) {
            if (this._pooledExecutor == null) {
                this._pooledExecutor = new PooledExecutor();
            }
        }
        return this._pooledExecutor;
    }

    void handleThrowable(Throwable t, String msgKey) throws Exception {
        if (t != null) {
            if (t instanceof COMM_FAILURE) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.unrecoverErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), t);
                }
                this.unRegister();
                this.cleanup();
                if (this instanceof SpawnedServerMBean) {
                    throw new Exception(t.getLocalizedMessage());
                }
                throw new IllegalStateException(t.getLocalizedMessage());
            }
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)msgKey, (java.lang.Object)this._objectNameCanonicalName), t);
            }
            throw new Exception(t.getLocalizedMessage());
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this._objectName = name;
        this._objectNameCanonicalName = name.getCanonicalName();
        this._mbeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.closeConnection();
    }

    protected void unRegister() {
        block3: {
            try {
                this.getMBeanServer().unregisterMBean(this._objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException e) {
                if (this._logger == null) break block3;
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.unRegErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
            }
        }
    }

    void closeConnection() {
        if (this._iomServerAppenderView != null) {
            block8: {
                try {
                    this._iomServerAppenderView.Close();
                }
                catch (Exception e) {
                    if (this._logger == null) break block8;
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.closeErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
                }
            }
            this._iomServerAppenderView = null;
        }
        if (this._filteredListMap != null) {
            Iterator itor = this._filteredListMap.keySet().iterator();
            IFilteredList fl = null;
            while (itor.hasNext()) {
                block9: {
                    fl = (IFilteredList)this._filteredListMap.get(itor.next());
                    try {
                        fl.Close();
                    }
                    catch (Exception e) {
                        if (this._logger == null) break block9;
                        this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerMBean.closeFilterErr.fmt.txt", (java.lang.Object)this._objectNameCanonicalName), (Throwable)e);
                    }
                }
                fl = null;
            }
        }
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
        }
        this._iServerAdministration = null;
        this._iServerInformation = null;
        this._iServerSessions = null;
        this._iServerLog = null;
    }

    protected void cleanup() {
        if (this._connectionPoint != null) {
            try {
                this._connectionPoint.Unadvise(this._eventsHandle);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                // empty catch block
            }
            this._connectionPoint = null;
        }
        this.closeConnection();
    }

    protected void finalize() throws Throwable {
        try {
            this.closeConnection();
        }
        finally {
            super.finalize();
        }
    }

    @SASScope
    protected class ReturnValue {
        private java.lang.Object _object = null;

        protected ReturnValue() {
        }

        public void setValue(java.lang.Object obj) {
            this._object = obj;
        }

        public java.lang.Object getValue() {
            return this._object;
        }
    }
}

