/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform.mgmt;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.connection.platform.mgmt.RB;
import com.sas.services.connection.platform.mgmt.ServerMBean;
import com.sas.services.connection.platform.mgmt.ServerMBeanUtil;
import com.sas.services.connection.platform.mgmt.SpawnerMBean;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.security.login.OMILoginModule;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SASScope
public class ServerFactoryMBean
extends AbstractMBean
implements MBeanRegistration {
    private static final String SERVICES_DEPLOYMENT_FILE = "jmx_foundation_services.xml";
    private static final String MBEAN_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.mBeanDesc.txt");
    private static final String VOID_TYPE_NAME = "void";
    private final String STRING_CLASS_NAME = String.class.getName();
    private static final String SERVER_NAME_PARM_NAME = RB.getStringResource("ServerFactoryMBean.ServerNameParmName.txt");
    private final String SERVER_NAME_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.NameParmDesc.txt");
    private final String SERVER_HOST_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.HostParmByNameDesc.txt");
    private static final String HOST_PARM_NAME = RB.getStringResource("ServerFactoryMBean.HostParmName.txt");
    private final String HOST_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.HostParmDesc.txt");
    private static final String PORT_PARM_NAME = RB.getStringResource("ServerFactoryMBean.PortParmName.txt");
    private final String PORT_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.PortParmDesc.txt");
    private static final String USERNAME_PARM_NAME = RB.getStringResource("ServerFactoryMBean.UserParmName.txt");
    private final String USERNAME_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.UsernameParmDesc.txt");
    private static final String PASSWORD_PARM_NAME = RB.getStringResource("ServerFactoryMBean.PasswordParmName.txt");
    private final String PASSWORD_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.PasswordParmDesc.txt");
    private final String SERVER_USER_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.UserParmDesc.txt");
    private final String SERVER_PASSWORD_PARM_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.ServerPasswordParmDesc.txt");
    private static final String SPN_PROPERTY_NAME = "SPN";
    private static final String SECURITYPACKAGE_PROPERTY_NAME = "SecurityPackage";
    private static final String SECURITYPACKAGELIST_PROPERTY_NAME = "SecurityPackageList";
    private static final String DEFAULTVALUE_PROPERTY_NAME = "DefaultValue";
    public static final String DEFINED_SERVER_DATA_NAME_HOST = "Host";
    public static final String DEFINED_SERVER_DATA_NAME_NAME = "Name";
    public static final String DEFINED_SERVER_DATA_NAME_PORT = "Port";
    public static final String DEFINED_SERVER_DATA_NAME_LOGICAL_SERVER = "Logical Server";
    public static final String DEFINED_SERVER_DATA_NAME_TYPE = "Server Type";
    public static final String DEFINED_SERVER_DATA_NAME_CLASSID = "Class Identifier";
    private static final String[] DEFINED_SERVER_DATA_NAMES = new String[]{"Name", "Server Type", "Logical Server", "Host", "Port", "Class Identifier"};
    private static final String INFORMATION_CATEGORY = "Information";
    private static final String IOM_CLASS_BASE_PROPERTY = "IOM.ClassBase";
    private static final String IOM_LOGICAL_SERVERNAME_PROPERTY = "IOM.LogicalServerName";
    private static final String IOM_SERVER_COMPONENT_NAME_PROPERTY = "IOM.ServerComponentName";
    private static final String IOM_UNIQUEID_PROPERTY = "IOM.UniqueIdentifier";
    private MBeanServer _mbeanServer = null;
    private ObjectName _objectName = null;
    private String _user = null;
    private String _password = null;
    private String _domain = null;
    private String _host = null;
    private Integer _port = null;
    private ServerInterface _omrServer = null;
    private UserContextInterface _userContext = null;
    private Logger _logger = LogManager.getLogger(ServerFactoryMBean.class);
    private TabularType _definedTt = null;
    private CompositeType _definedCt = null;
    private ArrayType _hostArray = null;
    private boolean _areWeConnected = false;
    private Environment _environment = null;
    private String _securityPackage = null;
    private String _securityPackageList = null;
    private String _spn = null;
    private UserServiceInterface _userService = null;

    public ServerFactoryMBean(String user, String password, String domain, UserServiceInterface userService) throws Exception {
        super(MBEAN_DESCRIPTION);
        this._user = user;
        this._password = password;
        this._domain = domain;
        this._userService = userService;
        this.initialize();
    }

    public ServerFactoryMBean(String xmlConfigFile) throws Exception {
        super(MBEAN_DESCRIPTION);
        this.parseConfig(xmlConfigFile);
        this.initialize();
    }

    public ServerFactoryMBean(UserContextInterface userContext) throws Exception {
        super(MBEAN_DESCRIPTION);
        this._userContext = userContext;
        this.initialize();
    }

    private void initialize() throws Exception {
        if (null == this._userContext) {
            this.initializeServices();
        }
        if (null != this._securityPackage || null != this._user && !this._user.equals("") && null != this._password && !this._password.equals("")) {
            this.initializeConnection();
        }
        if (null != this._userContext) {
            block6: {
                try {
                    this._omrServer = this._userContext.getAuthServer();
                }
                catch (ServiceException e) {
                    if (null == this._logger) break block6;
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.userInitErr.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
                }
            }
            this._areWeConnected = true;
        } else {
            this.addMBeanOperation("connect", RB.getStringResource("ServerFactoryMBean.connectToMeta.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(USERNAME_PARM_NAME, this.STRING_CLASS_NAME, this.SERVER_USER_PARM_DESCRIPTION), new MBeanParameterInfo(PASSWORD_PARM_NAME, this.STRING_CLASS_NAME, this.SERVER_PASSWORD_PARM_DESCRIPTION)}, VOID_TYPE_NAME, 1);
        }
        this.createDefinedServerTypes();
        this.addMBeanOperation("listDefinedServers", RB.getStringResource("ServerFactoryMBean.definedDesc.txt"), null, "javax.management.openmbean.TabularData", 0);
        this.addMBeanOperation("manageServerByName", RB.getStringResource("ServerFactoryMBean.manageByNameDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(SERVER_NAME_PARM_NAME, this.STRING_CLASS_NAME, this.SERVER_NAME_PARM_DESCRIPTION), new MBeanParameterInfo(HOST_PARM_NAME, this.STRING_CLASS_NAME, this.SERVER_HOST_PARM_DESCRIPTION)}, this.STRING_CLASS_NAME, 1);
        this.addMBeanOperation("manageServer", RB.getStringResource("ServerFactoryMBean.manageDesc.txt"), new MBeanParameterInfo[]{new MBeanParameterInfo(HOST_PARM_NAME, this.STRING_CLASS_NAME, this.HOST_PARM_DESCRIPTION), new MBeanParameterInfo(PORT_PARM_NAME, Integer.class.getName(), this.PORT_PARM_DESCRIPTION), new MBeanParameterInfo(USERNAME_PARM_NAME, this.STRING_CLASS_NAME, this.USERNAME_PARM_DESCRIPTION), new MBeanParameterInfo(PASSWORD_PARM_NAME, this.STRING_CLASS_NAME, this.PASSWORD_PARM_DESCRIPTION)}, VOID_TYPE_NAME, 1);
    }

    public TabularData listDefinedServers() throws Exception {
        TabularDataSupport td = null;
        String type = null;
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.listDefined.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (!this._areWeConnected) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.listDefinedNotConnected.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
            }
            throw new Exception(RB.getStringResource("ServerFactoryMBean.notConnected.txt"));
        }
        try {
            ServerFilter filter = new ServerFilter();
            td = new TabularDataSupport(this._definedTt);
            String logicalServerName = null;
            java.lang.Object servedObj = null;
            for (com.sas.services.information.metadata.ServerInterface server : this._omrServer.search((FilterInterface)filter)) {
                String classid = server.getClassIdentifier();
                Iterator servedIt = server.getServed().iterator();
                logicalServerName = "";
                while (servedIt.hasNext()) {
                    servedObj = servedIt.next();
                    if (!(servedObj instanceof LogicalServerInterface)) continue;
                    logicalServerName = ((LogicalServerInterface)servedObj).getName();
                    break;
                }
                if ((type = ServerMBeanUtil.getLocalizedServerType(classid)).equals("")) continue;
                List hList = this.getHosts(server);
                int i = 0;
                String[] hosts = new String[hList.size()];
                Iterator itor = hList.iterator();
                while (itor.hasNext()) {
                    hosts[i] = (String)itor.next();
                    ++i;
                }
                java.lang.Object[] itemValues = new java.lang.Object[]{server.getName(), type, logicalServerName, hosts, Integer.toString(server.getTcpPort()), classid};
                td.put(new CompositeDataSupport(this._definedCt, DEFINED_SERVER_DATA_NAMES, itemValues));
            }
        }
        catch (ServiceException e) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.listDefinedErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.listDefinedErr.ex.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
        }
        if (null != this._logger && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerFactoryMBean.definedReturn.txt"));
        }
        return td;
    }

    public String manageServerByName(String name, String host) throws Exception {
        com.sas.services.information.metadata.ServerInterface server = null;
        String domain = null;
        List l = null;
        ObjectName on = null;
        String theHost = null;
        if (!this._areWeConnected) {
            if (null != this._logger) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageNotConnected.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
            }
            throw new Exception(RB.getStringResource("ServerFactoryMBean.notConnected.txt"));
        }
        if (name == null) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource("ServerFactoryMBean.manageServerNullErr.txt"));
            }
            throw new Exception(RB.getStringResource("ServerFactoryMBean.nullName.ex.txt"));
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageServer.fmt.txt", (java.lang.Object)name, (java.lang.Object)this._objectName.getCanonicalName()));
        }
        LogicalServerInterface logicalServer = null;
        ServerFilter filter = new ServerFilter();
        filter.setName(name);
        try {
            Iterator itor = this._omrServer.search((FilterInterface)filter).iterator();
            if (itor.hasNext()) {
                server = (com.sas.services.information.metadata.ServerInterface)itor.next();
            }
            if (server == null) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.serverNotFound.ex.fmt.txt", (java.lang.Object)name));
                }
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.serverNotFound.ex.fmt.txt", (java.lang.Object)name));
            }
            String classid = server.getClassIdentifier();
            if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("cf7bc7e6-c7e8-11d5-87e3-00c04f38f9f6") || classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.directNosup.ex.fmt.txt", (java.lang.Object)name));
                }
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.directNosup.ex.fmt.txt", (java.lang.Object)name));
            }
            l = server.getDomains();
            if (l.size() > 0) {
                domain = (String)l.get(0);
            }
            theHost = host != null && !host.equals("") ? host : server.getHost();
            String logicalServerName = null;
            Iterator it = server.getServed().iterator();
            java.lang.Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                if (!(obj instanceof LogicalServerInterface)) continue;
                logicalServer = obj;
                logicalServerName = logicalServer.getName();
                break;
            }
            on = ServerMBeanUtil.createObjectName(server.getName(), logicalServerName, server.getClassIdentifier(), theHost, server.getTcpPort(), null);
        }
        catch (ServiceException e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageServerErr.fmt.txt", (java.lang.Object)name, (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageErr.ex.fmt.txt", (java.lang.Object)name, (java.lang.Object)e.getLocalizedMessage()));
        }
        ConnectionInterface connection = null;
        try {
            if (!this._mbeanServer.isRegistered(on)) {
                if (logicalServer != null) {
                    PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(logicalServer, theHost, server.getTcpPort());
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(config);
                    connection = cxf.getConnection(this._userContext);
                } else {
                    PlatformConnectionFactoryInterface cxf;
                    ManualConnectionFactoryConfiguration cxfConfig;
                    BridgeServer bserver = new BridgeServer("00000000-0000-0000-0000-000000000000", theHost, server.getTcpPort());
                    bserver.setDomain(domain);
                    boolean useIWA = false;
                    for (com.sas.services.information.metadata.ConnectionInterface ci : server.getSourceConnections()) {
                        if (!(ci instanceof TCPIPConnectionInterface)) continue;
                        String atype = ((TCPIPConnectionInterface)ci).getAuthenticationType();
                        if (atype == null || !atype.equals("IWA")) break;
                        useIWA = true;
                        break;
                    }
                    if (useIWA) {
                        bserver.setSecurityPackage("Negotiate");
                        cxfConfig = new ManualConnectionFactoryConfiguration((Server)bserver);
                        cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                        SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                        connection = cxf.getConnection((Credential)cred);
                    } else {
                        cxfConfig = new ManualConnectionFactoryConfiguration((Server)bserver);
                        cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                        UserIdentityInterface identity = this._userContext.getAuthServer().generatePassword(null);
                        String user = null;
                        String password = null;
                        if (identity != null) {
                            user = (String)identity.getPrincipal();
                            password = (String)identity.getCredential();
                        }
                        connection = cxf.getConnection(user, password, domain);
                    }
                }
                this.createMBean(on, connection);
                connection = null;
            }
        }
        catch (InstanceAlreadyExistsException e) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.useExisting.fmt.txt", (java.lang.Object)on.getCanonicalName()));
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        catch (ConnectionFactoryException e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageServerErr.fmt.txt", (java.lang.Object)name, (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectionErr.ex.fmt.txt", (java.lang.Object)name, (java.lang.Object)e.getLocalizedMessage()));
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageServerErr.fmt.txt", (java.lang.Object)name, (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
            throw e;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerFactoryMBean.manageServerReturn.txt"));
        }
        return on.getCanonicalName();
    }

    public void createMBean(ObjectName on, ConnectionInterface connection) throws Exception {
        if (on.getKeyProperty("serverType").equals("Spawner")) {
            SpawnerMBean smb = new SpawnerMBean(connection, this._userContext);
            this._mbeanServer.registerMBean(smb, on);
        } else {
            ServerMBean smb = new ServerMBean(null, connection, null);
            this._mbeanServer.registerMBean(smb, on);
        }
    }

    public String manageServer(String host, Integer port, String username, String password) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageServerHost.fmt.txt", (java.lang.Object)host, (java.lang.Object)port, (java.lang.Object)this._objectName.getCanonicalName()));
        }
        ObjectName on = null;
        ConnectionInterface connection = null;
        try {
            BridgeServer bserver = new BridgeServer("00000000-0000-0000-0000-000000000000", host, port.intValue());
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)bserver);
            ConnectionFactoryInterface cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            connection = cxf.getConnection(username, password, null);
            Object obj = connection.getObject();
            IServerInformation iServerInformation = IServerInformationHelper.narrow((Object)obj);
            if (iServerInformation == null) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageHostNoInfo.ex.fmt.txt", (java.lang.Object)host, (java.lang.Object)port));
            }
            IFilteredList fl = iServerInformation.UseCategory(INFORMATION_CATEGORY, "");
            AnySeqHolder anySeqHolder = new AnySeqHolder();
            fl.GetAttribute(IOM_CLASS_BASE_PROPERTY, "value", anySeqHolder);
            Any[] values = anySeqHolder.value;
            String serverClass = null;
            if (values.length >= 1) {
                serverClass = (String)ServerMBeanUtil.anyObjectToObject(values[0]);
            }
            String logicalServerName = null;
            try {
                anySeqHolder = new AnySeqHolder();
                fl.GetAttribute(IOM_LOGICAL_SERVERNAME_PROPERTY, "value", anySeqHolder);
                values = anySeqHolder.value;
                if (values.length >= 1) {
                    logicalServerName = (String)ServerMBeanUtil.anyObjectToObject(values[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String serverName = null;
            try {
                anySeqHolder = new AnySeqHolder();
                fl.GetAttribute(IOM_SERVER_COMPONENT_NAME_PROPERTY, "value", anySeqHolder);
                values = anySeqHolder.value;
                if (values.length >= 1) {
                    serverName = (String)ServerMBeanUtil.anyObjectToObject(values[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String instanceId = null;
            try {
                anySeqHolder = new AnySeqHolder();
                fl.GetAttribute(IOM_UNIQUEID_PROPERTY, "value", anySeqHolder);
                values = anySeqHolder.value;
                if (values.length >= 1) {
                    instanceId = (String)ServerMBeanUtil.anyObjectToObject(values[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            on = ServerMBeanUtil.createObjectName(serverName, logicalServerName, serverClass, host, port, instanceId);
            if (this._mbeanServer.isRegistered(on)) {
                connection.close();
                connection = null;
                return on.getCanonicalName();
            }
            this.createMBean(on, connection);
            connection = null;
        }
        catch (InstanceAlreadyExistsException e) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.useExisting.fmt.txt", (java.lang.Object)on.getCanonicalName()));
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
        }
        catch (ConnectionFactoryException e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageHostErr.fmt.txt", (java.lang.Object)host, (java.lang.Object)port), (Throwable)e);
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectionErrHostPort.ex.fmt.txt", (java.lang.Object)host, (java.lang.Object)port, (java.lang.Object)e.getLocalizedMessage()));
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
                connection = null;
            }
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageHostErr.fmt.txt", (java.lang.Object)host, (java.lang.Object)port), (Throwable)e);
            }
            throw e;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerFactoryMBean.manageServerReturn.txt"));
        }
        return on.getCanonicalName();
    }

    public String manageServer(String host, Integer port, String domain) throws Exception {
        UserIdentityInterface identity = null;
        try {
            identity = this._userContext.getIdentityByDomain(domain);
        }
        catch (RemoteException e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.manageHostErr.fmt.txt", (java.lang.Object)host, (java.lang.Object)port), (Throwable)e);
            }
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectionErrHostPort.ex.fmt.txt", (java.lang.Object)host, (java.lang.Object)port, (java.lang.Object)e.getLocalizedMessage()));
        }
        return this.manageServer(host, (int)port, (String)identity.getPrincipal(), (String)identity.getCredential());
    }

    protected java.lang.Object getTargetObject() {
        return this;
    }

    public void connect(String user, String password) throws Exception {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectOperation.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
        }
        if (this._areWeConnected) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectedAlready.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()));
            }
            return;
        }
        this._user = user;
        this._password = password;
        try {
            this.initializeConnection();
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.connectOperationErr.fmt.txt", (java.lang.Object)this._objectName.getCanonicalName()), (Throwable)e);
            }
            this._user = null;
            this._password = null;
            throw e;
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("ServerFactoryMBean.connectReturn.txt"));
        }
    }

    private void createDefinedServerTypes() throws OpenDataException {
        String SERVER_NAME_DESC = RB.getStringResource("ServerFactoryMBean.serverNameDesc.txt");
        String SERVER_TYPE_DESC = RB.getStringResource("ServerFactoryMBean.serverTypeDesc.txt");
        String HOST_DESC = RB.getStringResource("ServerFactoryMBean.serverHostDesc.txt");
        String PORT_DESC = RB.getStringResource("ServerFactoryMBean.serverPortDesc.txt");
        String LOGICAL_DESC = RB.getStringResource("ServerFactoryMBean.logicalDesc.txt");
        String CLASSID_DESC = RB.getStringResource("ServerFactoryMBean.classIdDesc.txt");
        String[] DEFINED_SERVER_DATA_DESCRIPTIONS = new String[]{SERVER_NAME_DESC, SERVER_TYPE_DESC, LOGICAL_DESC, HOST_DESC, PORT_DESC, CLASSID_DESC};
        String[] SERVER_INDEX_NAME = new String[]{DEFINED_SERVER_DATA_NAME_NAME};
        String SERVER_LIST_COMPOSITETYPE_NAME = "com.sas.services.connection.platform.DefinedServersCt";
        String SERVER_LIST_TABULARTYPE_NAME = "com.sas.services.connection.platform.DefinedServersTt";
        String SERVER_LIST_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.serverListCompositeDesc.txt");
        String SERVER_LIST_TABULARTYPE_DESCRIPTION = RB.getStringResource("ServerFactoryMBean.serverTabularDesc.txt");
        this._hostArray = new ArrayType(1, SimpleType.STRING);
        OpenType[] DEFINED_SERVER_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, this._hostArray, SimpleType.STRING, SimpleType.STRING};
        this._definedCt = new CompositeType(SERVER_LIST_COMPOSITETYPE_NAME, SERVER_LIST_COMPOSITETYPE_DESCRIPTION, DEFINED_SERVER_DATA_NAMES, DEFINED_SERVER_DATA_DESCRIPTIONS, DEFINED_SERVER_DATA_TYPES);
        this._definedTt = new TabularType(SERVER_LIST_TABULARTYPE_NAME, SERVER_LIST_TABULARTYPE_DESCRIPTION, this._definedCt, SERVER_INDEX_NAME);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("com.sas.services:");
        buf.append("type");
        buf.append("=");
        buf.append("ServerFactory");
        if (this._host != null) {
            buf.append(",");
            buf.append("host");
            buf.append("=");
            buf.append(this._host);
            buf.append(",");
            buf.append("port");
            buf.append("=");
            buf.append(this._port.toString());
        }
        this._objectName = new ObjectName(buf.toString());
        this._mbeanServer = server;
        return this._objectName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private void initializeServices() throws Exception {
        LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
        if (this._userService == null) {
            try {
                URL defaultServiceDeploymentUrl = ServerFactoryMBean.class.getResource(SERVICES_DEPLOYMENT_FILE);
                URLMetadataSource localServiceDeployment = new URLMetadataSource(defaultServiceDeploymentUrl);
                this._environment = new Environment();
                ServiceLoader.deployServices((MetadataSourceInterface)localServiceDeployment, (Environment)this._environment, (DiscoveryServiceInterface)discoveryService);
                Class[] desiredCapabilities = new Class[]{UserServiceInterface.class};
                this._userService = (UserServiceInterface)discoveryService.findService(new ServiceTemplate(desiredCapabilities, null));
            }
            catch (Exception e) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.deployErr.ex.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
            }
        }
    }

    private void initializeConnection() throws Exception {
        if (this._environment != null) {
            AppConfigurationEntry appConfigurationEntry;
            AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
            HashMap<String, String> optionsMap = new HashMap<String, String>(4);
            optionsMap.put("host", this._host);
            optionsMap.put("port", this._port.toString());
            optionsMap.put("domain", this._domain);
            optionsMap.put("debug", "false");
            if (this._securityPackage != null) {
                if (this._spn != null) {
                    optionsMap.put("sspispn", this._spn);
                }
                if (this._securityPackageList != null) {
                    optionsMap.put("securitypackagelist", this._securityPackageList);
                }
                if (this._securityPackage.equals("Kerberos")) {
                    optionsMap.put("idpropagation", "sspi");
                    optionsMap.put("sspisecuritypackagelist", "Kerberos");
                } else if (this._securityPackage.equals("NTLM")) {
                    optionsMap.put("idpropagation", "sspi");
                    optionsMap.put("sspisecuritypackagelist", "NTLM");
                } else if (this._securityPackage.equals("Negotiate")) {
                    optionsMap.put("idpropagation", "sspi");
                }
            }
            entries[0] = appConfigurationEntry = new AppConfigurationEntry(OMILoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, optionsMap);
            this._environment.setAppConfigurationEntry(entries);
        }
        try {
            this._userContext = this._user == null || this._user.equals("") ? this._userService.newUser(null, this.getClass().getName()) : this._userService.newUser(this._user, this._password, this._domain);
        }
        catch (UserInitializationException e) {
            this._userContext = e.getUser();
            if (this._logger != null) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.userInitErr.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
            }
        }
        catch (ServiceException e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.userInit.ex.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
        }
    }

    private List getHosts(com.sas.services.information.metadata.ServerInterface server) throws RemoteException, ServiceException {
        ArrayList<String> l = new ArrayList<String>();
        for (java.lang.Object o : server.getSoftwareTrees()) {
            FolderInterface f;
            if (!(o instanceof FolderInterface) || !(f = (FolderInterface)o).getName().equals("MachineGroup")) continue;
            List items = f.getItems();
            if (items.size() <= 0) break;
            for (MetadataInterface m : items) {
                l.add(m.getName());
            }
        }
        if (l.size() == 0) {
            l.add(server.getHost());
        }
        return l;
    }

    private void parseConfig(String filename) throws Exception {
        if (filename == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(filename));
            NodeList nodeList = document.getElementsByTagName("Redirect");
            if (nodeList.getLength() == 0) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErr.ex.fmt.txt", (java.lang.Object)"Redirect"));
            }
            Element element = (Element)nodeList.item(0);
            if ((nodeList = element.getElementsByTagName("LogicalServer")).getLength() == 0) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErr.ex.fmt.txt", (java.lang.Object)"LogicalServer"));
            }
            element = (Element)nodeList.item(0);
            NodeList children = element.getChildNodes();
            for (int c = 0; c < children.getLength(); ++c) {
                Node l = children.item(c);
                if (!l.getNodeName().equals("Properties")) continue;
                Element propertiesElement = (Element)l;
                NodeList properties = propertiesElement.getChildNodes();
                if (properties == null || properties.getLength() <= 0) break;
                NodeList props = element.getElementsByTagName("Property");
                for (int i = 0; i < props.getLength(); ++i) {
                    Element propElement = (Element)props.item(i);
                    if (propElement.getAttribute("PropertyName").equals(SECURITYPACKAGE_PROPERTY_NAME)) {
                        this._securityPackage = propElement.getAttribute(DEFAULTVALUE_PROPERTY_NAME);
                        continue;
                    }
                    if (propElement.getAttribute("PropertyName").equals(SPN_PROPERTY_NAME)) {
                        this._spn = propElement.getAttribute(DEFAULTVALUE_PROPERTY_NAME);
                        continue;
                    }
                    if (!propElement.getAttribute("PropertyName").equals(SECURITYPACKAGELIST_PROPERTY_NAME)) continue;
                    this._securityPackageList = propElement.getAttribute(DEFAULTVALUE_PROPERTY_NAME);
                }
                break;
            }
            if ((nodeList = element.getElementsByTagName("UsingComponents")).getLength() == 0) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErr.ex.fmt.txt", (java.lang.Object)"UsingComponents"));
            }
            element = (Element)nodeList.item(0);
            if ((nodeList = element.getElementsByTagName("ServerComponent")).getLength() == 0) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErr.ex.fmt.txt", (java.lang.Object)"ServerComponent"));
            }
            element = (Element)nodeList.item(0);
            if ((nodeList = element.getElementsByTagName("TCPIPConnection")).getLength() == 0) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErr.ex.fmt.txt", (java.lang.Object)"TCPIPConnection"));
            }
            Element tcpipElement = (Element)nodeList.item(0);
            String port = tcpipElement.getAttribute(DEFINED_SERVER_DATA_NAME_PORT);
            if (port != null) {
                this._port = Integer.valueOf(port);
            }
            this._host = tcpipElement.getAttribute("HostName");
            nodeList = tcpipElement.getElementsByTagName("Domain");
            if (nodeList.getLength() > 0 && (nodeList = (element = (Element)nodeList.item(0)).getElementsByTagName("AuthenticationDomain")).getLength() > 0) {
                element = (Element)nodeList.item(0);
                this._domain = element.getAttribute(DEFINED_SERVER_DATA_NAME_NAME);
            }
            if ((nodeList = document.getElementsByTagName("AuthenticationDomain")).getLength() > 0) {
                element = (Element)nodeList.item(0);
                this._domain = element.getAttribute(DEFINED_SERVER_DATA_NAME_NAME);
                nodeList = element.getElementsByTagName("Logins");
                if (nodeList.getLength() > 0 && (nodeList = (element = (Element)nodeList.item(0)).getElementsByTagName("Login")).getLength() > 0) {
                    element = (Element)nodeList.item(0);
                    this._user = element.getAttribute("UserID");
                    this._password = element.getAttribute("Password");
                }
            }
        }
        catch (IOException e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErrEx.ex.fmt.txt", (java.lang.Object)e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErrEx.ex.fmt.txt", (java.lang.Object)e.getMessage()));
        }
        catch (SAXException e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ServerFactoryMBean.parseErrEx.ex.fmt.txt", (java.lang.Object)e.getMessage()));
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this._omrServer != null) {
                this._omrServer.destroy();
            }
            if (this._userContext != null) {
                try {
                    this._userContext.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            super.finalize();
        }
    }
}

