/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.information.RepositoryEvent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

@SASScope
public final class RepositoryListener
extends UnicastRemoteObject
implements RepositoryListenerInterface {
    private static final long serialVersionUID = 2242446516418261708L;
    private WeakReference _kernelRef;
    private RepositoryInterface _repository;
    private boolean _called;
    private boolean _unexported;

    protected RepositoryListener(ConnectionFactoryKernel kernel, RepositoryInterface repository) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, RepositoryListener.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(RepositoryListener.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(RepositoryListener.class));
        this._kernelRef = new WeakReference<ConnectionFactoryKernel>(kernel);
        this._repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void repositoryCallback(RepositoryEvent repositoryEvent) throws RemoteException {
        if (repositoryEvent == null) {
            return;
        }
        int eventType = repositoryEvent.getEvent();
        if (eventType != 3 && eventType != 1) {
            return;
        }
        try {
            this._called = true;
            ConnectionFactoryKernel kernel = (ConnectionFactoryKernel)this._kernelRef.get();
            if (kernel != null) {
                kernel.shutdown();
            }
        }
        finally {
            this.unexport();
        }
    }

    protected RepositoryInterface getRepository() {
        return this._repository;
    }

    protected synchronized boolean wasCalled() {
        return this._called;
    }

    protected synchronized void unexport() throws RemoteException {
        if (this._unexported) {
            return;
        }
        this._unexported = true;
        UnicastRemoteObject.unexportObject(this, true);
    }
}

