/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactory;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryEvent;
import com.sas.services.connection.ConnectionFactoryEventListener;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.LoggerFactory;
import com.sas.services.connection.omr.OMRConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactory;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.RepositoryListener;
import com.sas.services.deployment.Environment;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.RepositoryListenerInterface;
import com.sas.services.util.ServicesLoggerFactory;
import java.rmi.RemoteException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class PlatformConnectionFactoryManager
extends ConnectionFactoryManager {
    public static PlatformConnectionFactoryManager defaultManager = new PlatformConnectionFactoryManager();

    public PlatformConnectionFactoryManager() {
        ServicesLoggerFactory loggerFactory = new ServicesLoggerFactory();
        Environment environment = loggerFactory.getEnvironment();
        this.setConnectionResources((ConnectionResources)environment);
    }

    public PlatformConnectionFactoryInterface getPlatformFactory(ConnectionFactoryConfiguration cxfConfig) throws ConnectionFactoryException {
        PlatformConnectionFactoryInterface cxf = (PlatformConnectionFactoryInterface)this.getFactory(cxfConfig);
        return cxf;
    }

    public static String getPlatformConnectionFactoryLoggerName(ConnectionFactoryConfiguration cxfConfig) {
        return defaultManager.getFactoryLoggerName(cxfConfig);
    }

    public static PlatformConnectionFactoryInterface getPlatformConnectionFactory(ConnectionFactoryConfiguration cxfConfig) throws ConnectionFactoryException {
        return defaultManager.getPlatformFactory(cxfConfig);
    }

    @SASScope
    protected final ConnectionFactory createShell(ConnectionFactoryConfiguration cxfConfig) {
        PlatformConnectionFactory shell = new PlatformConnectionFactory();
        return shell;
    }

    @SASScope
    protected final void shellActivated(ConnectionFactoryConfiguration cxfConfig, ConnectionFactory shell, LoggerFactory loggerFactory) throws ConnectionFactoryException {
        super.shellActivated(cxfConfig, shell, loggerFactory);
        PlatformConnectionFactory pShell = (PlatformConnectionFactory)shell;
        if (cxfConfig instanceof PlatformConnectionFactoryConfiguration || cxfConfig instanceof OMRConnectionFactoryConfiguration) {
            pShell.configIsInOMR();
        }
        if (cxfConfig instanceof PlatformConnectionFactoryConfiguration) {
            PlatformConnectionFactoryConfiguration pcxfConfig = (PlatformConnectionFactoryConfiguration)cxfConfig;
            RepositoryInterface targetRepos = pcxfConfig.getTargetRepos();
            RepositoryInterface foundationRepos = pcxfConfig.getFoundationRepos();
            if (targetRepos != null && foundationRepos != null) {
                try {
                    ConnectionFactoryKernel kernel = pShell.getKernel();
                    RepositoryListener reposListener = new RepositoryListener(kernel, foundationRepos);
                    foundationRepos.addListener((RepositoryListenerInterface)reposListener);
                    UnexportListener uxpListener = new UnexportListener(pShell, reposListener);
                    pShell.addConnectionFactoryEventListener(uxpListener);
                }
                catch (RemoteException re) {
                    throw new ConnectionFactoryException((Throwable)re);
                }
                catch (ServiceException se) {
                    throw new ConnectionFactoryException((Throwable)se);
                }
            }
        }
    }

    @SASScope
    private static class UnexportListener
    implements ConnectionFactoryEventListener {
        private PlatformConnectionFactory _cxf;
        private RepositoryListener _reposListener;

        private UnexportListener(PlatformConnectionFactory cxf, RepositoryListener reposListener) {
            this._cxf = cxf;
            this._reposListener = reposListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleConnectionFactoryEvent(ConnectionFactoryEvent event) {
            int type = event.getType();
            if (type == 1) {
                this._cxf.removeConnectionFactoryEventListener(this);
                RepositoryListener repositoryListener = this._reposListener;
                synchronized (repositoryListener) {
                    ConnectionFactoryRequest cxfReq;
                    try {
                        if (!this._reposListener.wasCalled()) {
                            RepositoryInterface targetRepository = this._reposListener.getRepository();
                            targetRepository.removeListener((RepositoryListenerInterface)this._reposListener);
                        }
                    }
                    catch (RemoteException re) {
                        cxfReq = this._cxf.getRequest();
                        cxfReq.logFINEST("Exception while removing repository listener", (Throwable)re);
                    }
                    catch (ServiceException se) {
                        ConnectionFactoryRequest cxfReq2 = this._cxf.getRequest();
                        cxfReq2.logFINEST("Exception while removing repository listener", (Throwable)se);
                    }
                    finally {
                        try {
                            this._reposListener.unexport();
                        }
                        catch (RemoteException re) {
                            cxfReq = this._cxf.getRequest();
                            cxfReq.logFINEST("Exception while unexporting repository listener", (Throwable)re);
                        }
                    }
                }
            }
        }
    }
}

