/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.connection.AggregationKernel;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.PoolingKernel;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.Server;
import com.sas.services.connection.TCPIPServer;
import com.sas.services.connection.omr.LocalUtil;
import com.sas.services.connection.omr.RemoteUtil;
import com.sas.services.connection.platform.PlatformOMRAuthServer;
import com.sas.services.connection.platform.RB;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.text.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class PlatformConnectionFactoryConfiguration
extends ConnectionFactoryConfiguration {
    public static final String PRIVILEGED_USER_NAME_KEY = "com.sas.services.connection.platform.privilegedUserNameKey";
    public static final String PROPERTYNAME_POOL_ADMIN = "com.sas.services.connection.platform.privilegedUserNameKey";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_PREF_CLIENT_POOLING = "com.sas.services.connection.platform.factoryPrefClientPooling";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_PREF_SERVER_POOLING = "com.sas.services.connection.platform.factoryPrefServerPooling";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_PREF_STANDARD = "com.sas.services.connection.platform.factoryPrefStandard";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_REQ_CLIENT_POOLING = "com.sas.services.connection.platform.factoryReqClientPooling";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_REQ_SERVER_POOLING = "com.sas.services.connection.platform.factoryReqServerPooling";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_REQ_POOLING = "com.sas.services.connection.platform.factoryReqPooling";
    @SASScope
    public static final String PROPERTYNAME_FACTORY_REQ_STANDARD = "com.sas.services.connection.platform.factoryReqStandard";
    private static final String _typeSuffix = "/LogicalServer";
    private static final int _omrSearchFlags = -2147481212;
    private static final Logger _logger = LogManager.getLogger(PlatformConnectionFactoryConfiguration.class);
    private LogicalServerInterface _logicalServer;
    private RepositoryInterface _repository;
    private String _repositoryID;
    private String _privilegedUser;
    private UserContextInterface _privilegedUserContext;
    private UserServiceInterface _userService;
    private RepositoryInterface _canonRepos;
    private String _canonReposID;
    private String _canonReposURL;
    private String _canonPrivUser;
    private Cluster[] _clusters;
    private Puddle[] _puddles;
    private String _poolDomain;
    private String _targetHost;
    private String _machineName;
    private Integer _overridePort;
    private String _logicalServerName;
    private RepositoryInterface _targetRepos;
    private RepositoryInterface _foundationRepos;
    private static final int _fcsClassStandard = 1;
    private static final int _fcsClassPoolingServer = 2;
    private static final int _fcsClassPoolingClient = 4;
    private static final int _fcsPreferStandard = 8;
    private static final int _fcsPreferPoolingServer = 16;
    private static final int _fcsPreferPoolingClient = 32;
    private static final int _fcsRequireStandard = 64;
    private static final int _fcsRequirePooling = 128;
    private static final int _fcsRequirePoolingServer = 192;
    private static final int _fcsRequirePoolingClient = 256;
    private static final int _fcsTriedMask = 7;
    private static final int _fcsPreferenceShift = 3;
    private static final int _fcsPreferenceMask = 56;
    private static final int _fcsRequirementShift = 6;
    private static final int _fcsRequirementMask = 448;
    private static Object[][] _fcsInitTable;
    private static int[][][] _fcsMachine;

    @SASScope
    public static synchronized PlatformConnectionFactoryConfiguration createFactoryConfiguration(LogicalServerInterface logicalServer, SessionContextInterface sessionContext) throws ConnectionFactoryException, ServiceException, RemoteException {
        String classID = logicalServer.getClassIdentifier();
        int serverType = Server.clsidToServerType((String)classID);
        if (serverType != 1) {
            PlatformConnectionFactoryConfiguration cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer);
            return cxfConfig;
        }
        String fcsPoolAdminName = (String)sessionContext.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey");
        List serverContextLst = logicalServer.getServed();
        if (serverContextLst == null || serverContextLst.size() == 0) {
            PlatformConnectionFactoryConfiguration cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer, fcsPoolAdminName);
            return cxfConfig;
        }
        ServerContextInterface serverContext = (ServerContextInterface)serverContextLst.get(0);
        int fcsInit = PlatformConnectionFactoryConfiguration.initFactoryConfigurationState(sessionContext, fcsPoolAdminName);
        PlatformConnectionFactoryConfiguration cxfConfig = PlatformConnectionFactoryConfiguration.createWorkspaceServerFactoryConfiguration(serverContext, fcsInit, fcsPoolAdminName);
        return cxfConfig;
    }

    @SASScope
    public static synchronized PlatformConnectionFactoryConfiguration createWorkspaceServerFactoryConfiguration(ServerContextInterface serverContext, SessionContextInterface sessionContext) throws ConnectionFactoryException, ServiceException, RemoteException {
        String fcsPoolAdminName = (String)sessionContext.getAttribute("com.sas.services.connection.platform.privilegedUserNameKey");
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("got pool admin name from session context: " + fcsPoolAdminName);
        }
        int fcsInit = PlatformConnectionFactoryConfiguration.initFactoryConfigurationState(sessionContext, fcsPoolAdminName);
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("initial state: " + fcsInit);
        }
        PlatformConnectionFactoryConfiguration cxfConfig = PlatformConnectionFactoryConfiguration.createWorkspaceServerFactoryConfiguration(serverContext, fcsInit, fcsPoolAdminName);
        return cxfConfig;
    }

    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer) {
        this(logicalServer, null, null);
    }

    public PlatformConnectionFactoryConfiguration(RepositoryInterface repository, String repositoryID) {
        this(repository, repositoryID, null, null);
    }

    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String privilegedUser) {
        this(logicalServer, privilegedUser, null);
    }

    public PlatformConnectionFactoryConfiguration(RepositoryInterface repository, String repositoryID, String privilegedUser) {
        this(repository, repositoryID, privilegedUser, null);
    }

    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String privilegedUser, UserServiceInterface userService) {
        if (logicalServer == null) {
            throw new IllegalArgumentException("\"logicalServer\" cannot be null.");
        }
        this._logicalServer = logicalServer;
        this._privilegedUser = privilegedUser;
        this._userService = userService;
        try {
            this._canonRepos = logicalServer.getRepository();
            this._canonReposID = logicalServer.getReposId() + _typeSuffix;
            this._canonReposURL = this._canonRepos.getUrl();
            this._canonPrivUser = privilegedUser;
            if (privilegedUser == null) {
                UserContextInterface user = this._canonRepos.getUserContext();
                this._foundationRepos = PlatformConnectionFactoryConfiguration.getFoundationReposForUser(user);
            }
        }
        catch (RemoteException re) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
        catch (ServiceException re) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
    }

    public PlatformConnectionFactoryConfiguration(RepositoryInterface repository, String repositoryID, String privilegedUser, UserServiceInterface userService) {
        if (repository == null) {
            throw new IllegalArgumentException("\"repository\" cannot be null.");
        }
        if (repositoryID == null) {
            throw new IllegalArgumentException("\"repositoryID\" cannot be null.");
        }
        this._repository = repository;
        this._repositoryID = repositoryID;
        this._privilegedUser = privilegedUser;
        this._userService = userService;
        try {
            this._canonRepos = repository;
            this._canonReposID = repositoryID;
            this._canonReposURL = repository.getUrl();
            this._canonPrivUser = privilegedUser;
            if (privilegedUser == null) {
                UserContextInterface user = this._canonRepos.getUserContext();
                this._foundationRepos = PlatformConnectionFactoryConfiguration.getFoundationReposForUser(user);
            }
        }
        catch (RemoteException re) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
        catch (ServiceException se) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
    }

    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String privilegedUser, UserServiceInterface userService, boolean monitorEnabled) {
        this(logicalServer, privilegedUser, userService);
    }

    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, UserContextInterface privilegedUserContext, UserServiceInterface userService, boolean monitorEnabled) {
        this(logicalServer, privilegedUserContext, userService, monitorEnabled, false);
    }

    public PlatformConnectionFactoryConfiguration(RepositoryInterface repository, String repositoryID, String privilegedUser, UserServiceInterface userService, boolean monitorEnabled) {
        this(repository, repositoryID, privilegedUser, userService);
    }

    @SASScope
    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String targetHost, int overridePort) {
        this(logicalServer, targetHost, overridePort, false);
    }

    @SASScope
    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String targetHost, int overridePort, boolean noRedirect) {
        this(logicalServer, targetHost, null, overridePort, noRedirect);
    }

    @SASScope
    public PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, String targetHost, String machineName, int overridePort, boolean noRedirect) {
        this(logicalServer, null, null, false, noRedirect);
        this._targetHost = targetHost;
        this._machineName = machineName;
        this._overridePort = overridePort;
    }

    private PlatformConnectionFactoryConfiguration(LogicalServerInterface logicalServer, UserContextInterface privilegedUserContext, UserServiceInterface userService, boolean monitorEnabled, boolean noRedirect) {
        super(noRedirect);
        if (logicalServer == null) {
            throw new IllegalArgumentException("\"logicalServer\" cannot be null.");
        }
        this._logicalServer = logicalServer;
        this._privilegedUserContext = privilegedUserContext;
        this._userService = userService;
        try {
            this._canonRepos = logicalServer.getRepository();
            this._canonReposID = logicalServer.getReposId() + _typeSuffix;
            this._canonReposURL = this._canonRepos.getUrl();
            if (privilegedUserContext != null) {
                this._canonPrivUser = privilegedUserContext.getName();
            } else {
                UserContextInterface user = this._canonRepos.getUserContext();
                this._foundationRepos = PlatformConnectionFactoryConfiguration.getFoundationReposForUser(user);
            }
        }
        catch (RemoteException re) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
        catch (ServiceException se) {
            this._canonRepos = null;
            this._canonReposID = null;
            this._canonReposURL = null;
            this._canonPrivUser = null;
            this._foundationRepos = null;
        }
    }

    public LogicalServerInterface getLogicalServer() {
        return this._logicalServer;
    }

    public RepositoryInterface getRepository() {
        return this._repository;
    }

    public String getRepositoryID() {
        return this._repositoryID;
    }

    public String getPrivilegedUser() {
        return this._privilegedUser;
    }

    public UserContextInterface getPrivilegedUserContext() {
        return this._privilegedUserContext;
    }

    public UserServiceInterface getUserService() {
        return this._userService;
    }

    public boolean isMonitorEnabled() {
        return false;
    }

    public boolean equals(Object that) {
        RepositoryInterface thatFoundRepos;
        RepositoryInterface thisFoundRepos;
        boolean thatMonitorEnabled;
        if (this == that) {
            return true;
        }
        if (that == null || !((Object)((Object)this)).getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        PlatformConnectionFactoryConfiguration thatConfig = (PlatformConnectionFactoryConfiguration)((Object)that);
        boolean thisMonitorEnabled = this.isMonitorEnabled();
        if (thisMonitorEnabled != (thatMonitorEnabled = thatConfig.isMonitorEnabled())) {
            return false;
        }
        String thisTargetHost = this.getTargetHost();
        String thatTargetHost = thatConfig.getTargetHost();
        if (thisTargetHost != null ? !thisTargetHost.equals(thatTargetHost) : thatTargetHost != null) {
            return false;
        }
        String thisMachineName = this.getMachineName();
        String thatMachineName = thatConfig.getMachineName();
        if (thisMachineName != null ? !thisMachineName.equals(thatMachineName) : thatMachineName != null) {
            return false;
        }
        Integer thisOverridePort = this.getOverridePort();
        Integer thatOverridePort = thatConfig.getOverridePort();
        if (thisOverridePort != null ? !thisOverridePort.equals(thatOverridePort) : thatOverridePort != null) {
            return false;
        }
        RepositoryInterface thisRepos = this.getCanonRepos();
        String thisReposID = this.getCanonReposID();
        String thisReposURL = this.getCanonReposURL();
        if (thisRepos == null && thisReposID == null && thisReposURL == null) {
            return false;
        }
        RepositoryInterface thatRepos = thatConfig.getCanonRepos();
        String thatReposID = thatConfig.getCanonReposID();
        String thatReposURL = thatConfig.getCanonReposURL();
        if (thatRepos == null && thatReposID == null && thatReposURL == null) {
            return false;
        }
        String thisPrivUser = this.getCanonPrivUser();
        String thatPrivUser = thatConfig.getCanonPrivUser();
        UserServiceInterface thisUserService = this.getUserService();
        UserServiceInterface thatUserService = thatConfig.getUserService();
        if (thisPrivUser == null ? (thisFoundRepos = this.getFoundationRepos()) != (thatFoundRepos = thatConfig.getFoundationRepos()) : (thisReposURL == null ? thatReposURL != null : !thisReposURL.equals(thatReposURL))) {
            return false;
        }
        if (thisReposID == null ? thatReposID != null : !thisReposID.equals(thatReposID)) {
            return false;
        }
        if (thisPrivUser == null ? thatPrivUser != null : !thisPrivUser.equals(thatPrivUser)) {
            return false;
        }
        return !(thisUserService == null ? thatUserService != null : !thisUserService.equals((Object)thatUserService));
    }

    public int hashCode() {
        Integer thisOverridePort;
        String thisMachineName;
        String thisURI;
        int hc = ((Object)((Object)this)).getClass().getName().hashCode();
        boolean thisMonitorEnabled = this.isMonitorEnabled();
        if (thisMonitorEnabled) {
            ++hc;
        }
        if ((thisURI = this.getTargetHost()) != null) {
            hc ^= thisURI.hashCode();
        }
        if ((thisMachineName = this.getMachineName()) != null) {
            hc ^= thisMachineName.hashCode();
        }
        if ((thisOverridePort = this.getOverridePort()) != null) {
            hc ^= thisOverridePort.hashCode();
        }
        String thisReposID = this.getCanonReposID();
        String thisReposURL = this.getCanonReposURL();
        String thisPrivUser = this.getCanonPrivUser();
        UserServiceInterface thisUserService = this.getUserService();
        if (thisPrivUser == null) {
            RepositoryInterface thisFoundRepos = this.getFoundationRepos();
            if (thisFoundRepos != null) {
                hc ^= System.identityHashCode(thisFoundRepos);
            }
        } else if (thisReposURL != null) {
            hc ^= thisReposURL.hashCode();
        }
        if (thisReposID != null) {
            hc ^= thisReposID.hashCode();
        }
        if (thisPrivUser != null) {
            hc ^= thisPrivUser.hashCode();
        }
        if (thisUserService != null) {
            hc ^= thisUserService.hashCode();
        }
        return hc;
    }

    public String toString() {
        HashSet<String[]> nvPairSet = new HashSet<String[]>(4);
        if (this._canonReposURL != null) {
            String[] nvPairURL = new String[]{"reposURL", this._canonReposURL};
            nvPairSet.add(nvPairURL);
        }
        if (this._canonPrivUser != null) {
            String[] nvPairAdmin = new String[]{"poolAdmin", this._canonPrivUser};
            nvPairSet.add(nvPairAdmin);
        }
        int nvPairSetL = nvPairSet.size();
        String[][] nvPairArr = new String[nvPairSetL][];
        nvPairArr = (String[][])nvPairSet.toArray((T[])nvPairArr);
        String str = ConnectionFactoryUtil.nvPairsToString((String[][])nvPairArr);
        return str;
    }

    @SASScope
    protected ConnectionFactoryKernel doGetKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        try {
            UserContextInterface privUserContext = this.getPrivUser();
            RepositoryInterface targetRepository = this._canonRepos;
            String targetURL = this._canonReposURL;
            String targetID = this._canonReposID;
            if (privUserContext != null) {
                RepositoryInterface repos = null;
                List repositories = privUserContext.getRepositories();
                for (RepositoryInterface candidate : repositories) {
                    String candidateURL = candidate.getUrl();
                    if (!targetURL.equals(candidateURL)) continue;
                    repos = candidate;
                    break;
                }
                if (repos == null) {
                    String messageIndex = "cxp.103.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (Object)this._privilegedUser, (Object)targetURL);
                    throw new ConnectionFactoryException(message);
                }
                targetRepository = repos;
                this._foundationRepos = PlatformConnectionFactoryConfiguration.getFoundationReposForUser(privUserContext);
            }
            this._targetRepos = targetRepository;
            if (this._clusters == null && this._puddles == null) {
                this._poolDomain = targetRepository.getDomain();
                LogicalServerInterface targetServer = null;
                int slashIndex = targetID.lastIndexOf(_typeSuffix);
                String fqid = targetID.substring(0, slashIndex);
                String serverRepos = "A0000001." + fqid.substring(0, 8);
                Filter filter = new Filter("ID", 0, fqid);
                filter.setOMRFlags(-2147481212);
                filter.setOMRTemplate("<Templates><LogicalServer Name=\"\" ClassIdentifier=\"\" UsageVersion=\"\"><ServiceTypes/><InitProcesses/><SoftwareTrees/><UsingComponents/><Properties/></LogicalServer><ServiceType Name=\"\"/><Transformation TransformRole=\"\"><TransformationSources/></Transformation><Tree TreeType=\"\"><Members/></Tree><ServerComponent Name=\"\" PublicType=\"\"><AssociatedMachine/><ServiceTypes/><SoftwareTrees/><SourceConnections/><Properties/></ServerComponent><Group><Members/><Properties/></Group><Login Password=\"\" UserID=\"\"><Domain/><AssociatedIdentity/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup Name=\"\"><Logins/></IdentityGroup><Property PropertyName=\"\" DefaultValue=\"\"/><ServiceType Name=\"\"/><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" ApplicationProtocol=\"\" HostName=\"\" Port=\"\"><Properties/><Domain/></TCPIPConnection><Machine Name=\"\"><Implementors/></Machine><Implementor PublicType=\"\"><SourceConnections/></Implementor></Templates>");
                filter.setType(_typeSuffix.substring(1));
                filter.setOMRRepository(serverRepos);
                List resultList = targetRepository.search((FilterInterface)filter);
                if (resultList == null || resultList.size() == 0) {
                    String messageIndex = "cxp.104.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (Object)targetID, (Object)targetURL);
                    throw new ConnectionFactoryException(message);
                }
                targetServer = (LogicalServerInterface)resultList.get(0);
                Object repositoryEntity = targetServer.getRepositoryEntity();
                Object resolvedEntity = null;
                if (repositoryEntity instanceof LogicalServer) {
                    LogicalServer remoteEntity = (LogicalServer)repositoryEntity;
                    resolvedEntity = RemoteUtil.resolve(remoteEntity, cxfReq);
                } else if (repositoryEntity instanceof com.sas.metadata.LogicalServer) {
                    com.sas.metadata.LogicalServer localEntity = (com.sas.metadata.LogicalServer)repositoryEntity;
                    resolvedEntity = LocalUtil.resolve(localEntity, cxfReq);
                } else {
                    String messageIndex = "cxp.100.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (Object)repositoryEntity.getClass().getName());
                    throw new ConnectionFactoryException(message);
                }
                if (resolvedEntity instanceof Cluster[]) {
                    this._clusters = (Cluster[])resolvedEntity;
                } else {
                    this._puddles = (Puddle[])resolvedEntity;
                }
                this._logicalServerName = targetServer.getName();
                if (this._overridePort != null) {
                    if (this._puddles != null) {
                        this._clusters = PlatformConnectionFactoryConfiguration.convertPuddlesToClusters(this._puddles);
                        this._puddles = null;
                    }
                    this._clusters = PlatformConnectionFactoryConfiguration.findAndOverrideServer(this._clusters, this._targetHost, this._machineName, this._overridePort);
                }
            }
            AggregationKernel kernel = null;
            if (this._clusters != null) {
                kernel = new AggregationKernel(cxfReq, this._clusters);
            } else {
                PuddleEnvelope[] envs = new PuddleEnvelope[this._puddles.length];
                for (int i = 0; i < this._puddles.length; ++i) {
                    envs[i] = new PuddleEnvelope(this._puddles[i]);
                }
                UserServiceInterface userSvc = this.getUserSvc();
                PlatformOMRAuthServer authServer = null;
                PlatformOMRAuthServer omrAuthServer = new PlatformOMRAuthServer(envs, targetRepository, this._poolDomain);
                omrAuthServer.setUserService(userSvc);
                authServer = omrAuthServer;
                kernel = new PoolingKernel(cxfReq, envs, (AuthServer)authServer);
            }
            return kernel;
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new ConnectionFactoryException((Throwable)se);
        }
    }

    @SASScope
    protected String doGetLogicalServerName() {
        return this._logicalServerName;
    }

    protected RepositoryInterface getCanonRepos() {
        return this._canonRepos;
    }

    protected String getCanonReposID() {
        return this._canonReposID;
    }

    protected String getCanonReposURL() {
        return this._canonReposURL;
    }

    protected String getCanonPrivUser() {
        return this._canonPrivUser;
    }

    @SASScope
    protected String getTargetHost() {
        return this._targetHost;
    }

    @SASScope
    protected String getMachineName() {
        return this._machineName;
    }

    @SASScope
    protected Integer getOverridePort() {
        return this._overridePort;
    }

    protected UserContextInterface getPrivUser() throws ServiceException, RemoteException, ConnectionFactoryException {
        if (this._privilegedUserContext != null) {
            return this._privilegedUserContext;
        }
        if (this._privilegedUser == null) {
            return null;
        }
        final UserServiceInterface userSvc = this.getUserSvc();
        final UserContextInterface requestingUser = this._canonRepos.getUserContext();
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return userSvc.getUser(requestingUser, PlatformConnectionFactoryConfiguration.this._privilegedUser);
            }
        };
        UserContextInterface privUserContext = null;
        try {
            privUserContext = (UserContextInterface)AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            throw new ConnectionFactoryException(t);
        }
        if (privUserContext == null) {
            String messageIndex = "cxp.102.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)this._privilegedUser);
            throw new ConnectionFactoryException(message);
        }
        return privUserContext;
    }

    protected RepositoryInterface getTargetRepos() {
        return this._targetRepos;
    }

    protected RepositoryInterface getFoundationRepos() {
        return this._foundationRepos;
    }

    private UserServiceInterface getUserSvc() throws ServiceException, RemoteException, ConnectionFactoryException {
        UserServiceInterface userSvc = this._userService;
        if (userSvc == null) {
            LocalDiscoveryServiceInterface discoService = DiscoveryService.defaultInstance();
            Class[] desiredCapabilities = new Class[]{UserServiceInterface.class};
            ServiceTemplate serviceTemplate = new ServiceTemplate(desiredCapabilities, null);
            userSvc = (UserServiceInterface)discoService.findService(serviceTemplate);
            if (userSvc == null) {
                String messageIndex = "cxp.101.ex.txt";
                String message = RB.getStringResource(messageIndex);
                throw new ConnectionFactoryException(message);
            }
        }
        return userSvc;
    }

    private static Cluster[] convertPuddlesToClusters(Puddle[] puddleArr) {
        if (puddleArr.length == 1) {
            Puddle puddle = puddleArr[0];
            Cluster[] clusterArr = puddle.getClusterArray();
            return clusterArr;
        }
        Cluster[] clusterArr = new Cluster[puddleArr.length];
        for (int i = 0; i < puddleArr.length; ++i) {
            Puddle puddle = puddleArr[i];
            Cluster[] puddleClusterArr = puddle.getClusterArray();
            ArrayList<Server> puddleServerLst = new ArrayList<Server>(16);
            for (int j = 0; j < puddleClusterArr.length; ++j) {
                Cluster puddleCluster = puddleClusterArr[j];
                Server[] puddleClusterServerArr = puddleCluster.getServerArray();
                for (int k = 0; k < puddleClusterServerArr.length; ++k) {
                    Server puddleClusterServer = puddleClusterServerArr[k];
                    puddleServerLst.add(puddleClusterServer);
                }
            }
            int puddleServerLstL = puddleServerLst.size();
            Server[] puddleServerArr = new Server[puddleServerLstL];
            puddleServerArr = puddleServerLst.toArray(puddleServerArr);
            clusterArr[i] = Cluster.getInstance((Server[])puddleServerArr, (int)1);
        }
        return clusterArr;
    }

    private static Cluster[] findAndOverrideServer(Cluster[] clusterArr, String targetHost, String machineName, Integer overridePort) throws ConnectionFactoryException {
        if (overridePort == null) {
            return clusterArr;
        }
        for (int i = 0; i < clusterArr.length; ++i) {
            Cluster cluster = clusterArr[i];
            int clusterType = cluster.getClusterType();
            Server[] serverArr = cluster.getServerArray();
            for (int j = 0; j < serverArr.length; ++j) {
                Server server = serverArr[j];
                try {
                    TCPIPServer tcpipServer = (TCPIPServer)server;
                    String uri = tcpipServer.getServerComponentURI();
                    String host = tcpipServer.getHost();
                    if (!uri.equalsIgnoreCase(targetHost) && !PlatformConnectionFactoryConfiguration.compareHosts(targetHost, host) || machineName != null && !PlatformConnectionFactoryConfiguration.compareHosts(machineName, host)) continue;
                    int oPort = overridePort;
                    if (oPort >= 1) {
                        tcpipServer.setPort(oPort);
                    }
                    Server[] oServerArr = new Server[]{tcpipServer};
                    Cluster oCluster = Cluster.getInstance((Server[])oServerArr, (int)clusterType);
                    Cluster[] oClusterArr = new Cluster[]{oCluster};
                    return oClusterArr;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        String msgIndex = "cxp.110.ex.fmt";
        String msgPattern = RB.getStringResource("cxp.110.ex.fmt");
        String msg = Message.format((String)msgPattern, (Object)targetHost);
        throw new ConnectionFactoryException(msg);
    }

    private static boolean compareHosts(String h1, String h2) {
        if (h1 == h2) {
            return true;
        }
        if (h1 == null || h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        try {
            InetAddress a1 = InetAddress.getByName(h1);
            InetAddress a2 = InetAddress.getByName(h2);
            boolean result = a1.equals(a2);
            return result;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    private static PlatformConnectionFactoryConfiguration createWorkspaceServerFactoryConfiguration(ServerContextInterface serverContext, int fcsInit, String fcsPoolAdminName) throws ConnectionFactoryException, ServiceException, RemoteException {
        String paName;
        LogicalServerInterface logicalServer;
        int fcsClass;
        int fcs = fcsInit;
        boolean repopulated = false;
        while (true) {
            if ((fcsClass = PlatformConnectionFactoryConfiguration.classifyFactoryConfigurationState(fcs)) == 4 && fcsPoolAdminName == null) {
                if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                    PlatformConnectionFactoryConfiguration.debug("continuing because class is client side pooling and there is no pool admin name");
                }
                fcs |= fcsClass;
                continue;
            }
            logicalServer = PlatformConnectionFactoryConfiguration.getLogicalServer(serverContext, fcsClass, fcsPoolAdminName);
            if (logicalServer == null && !repopulated) {
                repopulated = true;
                Object jomaServerContext = serverContext.getRepositoryEntity();
                if (jomaServerContext != null && jomaServerContext instanceof ServerContext) {
                    if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                        PlatformConnectionFactoryConfiguration.debug("repopulating logical server cache and repeating search");
                    }
                    try {
                        ((ServerContext)jomaServerContext).getUsingComponents(true);
                    }
                    catch (MdException mde) {
                        throw new ConnectionFactoryException((Throwable)mde);
                    }
                    logicalServer = PlatformConnectionFactoryConfiguration.getLogicalServer(serverContext, fcsClass, fcsPoolAdminName);
                } else if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                    String className = jomaServerContext != null ? jomaServerContext.getClass().getName() : "null";
                    PlatformConnectionFactoryConfiguration.debug("cannot repopulate logical server cache because repository entity is a " + className);
                }
            }
            if (logicalServer != null) break;
            if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                PlatformConnectionFactoryConfiguration.debug("continuing because an acceptable server was not found");
            }
            fcs |= fcsClass;
        }
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("acceptable server found: " + logicalServer.getName() + "[" + logicalServer.getReposId() + "]");
        }
        String string = paName = fcsClass == 4 ? fcsPoolAdminName : null;
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("pool admin name passed to PCFC: " + paName);
        }
        PlatformConnectionFactoryConfiguration config = new PlatformConnectionFactoryConfiguration(logicalServer, paName);
        return config;
    }

    private static int initFactoryConfigurationState(SessionContextInterface sessionContext, String paName) throws ConnectionFactoryException, RemoteException {
        int state = 0;
        Object[][] fcsInitTable = PlatformConnectionFactoryConfiguration.getFactoryConfigurationStateInitTable();
        for (int i = 0; i < fcsInitTable.length; ++i) {
            Boolean val;
            String name = (String)fcsInitTable[i][0];
            String valS = (String)sessionContext.getAttribute(name);
            Boolean bl = val = valS != null ? Boolean.valueOf(valS) : Boolean.FALSE;
            if (!val.booleanValue()) continue;
            if ((name.equals(PROPERTYNAME_FACTORY_PREF_CLIENT_POOLING) || name.equals(PROPERTYNAME_FACTORY_REQ_CLIENT_POOLING)) && paName == null) {
                String msgIndex = "cxp.107.ex.txt";
                String msg = RB.getStringResource("cxp.107.ex.txt");
                throw new IllegalArgumentException(msg);
            }
            int flag = (Integer)fcsInitTable[i][1];
            if ((flag & 0x1C0) != 0 && (state & 0x1C0) != 0) {
                String msgIndex = "cxp.108.ex.txt";
                String msg = RB.getStringResource("cxp.108.ex.txt");
                throw new IllegalArgumentException(msg);
            }
            if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                PlatformConnectionFactoryConfiguration.debug("got requirement or preference from session context: " + name);
            }
            state |= flag;
        }
        return state;
    }

    private static int classifyFactoryConfigurationState(int currentState) throws ConnectionFactoryException {
        int fcsClass;
        int fcsTried = currentState & 7;
        int fcsPreferences = (currentState & 0x38) >> 3;
        int fcsRequirements = (currentState & 0x1C0) >> 6;
        int[][][] fcsMachine = PlatformConnectionFactoryConfiguration.getFactoryConfigurationStateTransitionMachine();
        int n = fcsClass = fcsTried != 7 ? fcsMachine[fcsTried][fcsPreferences][fcsRequirements] : 0;
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("tried=" + fcsTried + " preferences=" + fcsPreferences + " requirements=" + fcsRequirements + " class=" + fcsClass);
        }
        if (fcsClass == 0) {
            String msgIndex = "cxp.109.ex.txt";
            String msg = RB.getStringResource("cxp.109.ex.txt");
            throw new ConnectionFactoryException(msg);
        }
        return fcsClass;
    }

    private static LogicalServerInterface getLogicalServer(ServerContextInterface serverContext, int fcsClass, String paName) throws ServiceException, RemoteException {
        List serverLst;
        int serverLstL;
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("searching server context for acceptable logical server: " + serverContext.getName() + "[" + serverContext.getReposId() + "]");
        }
        int n = serverLstL = (serverLst = serverContext.getServers()) != null ? serverLst.size() : 0;
        if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
            PlatformConnectionFactoryConfiguration.debug("search returned " + serverLstL + " server(s)");
        }
        for (LogicalServerInterface server : serverLst) {
            String classID;
            int serverType;
            if (PlatformConnectionFactoryConfiguration.isDebugEnabled()) {
                PlatformConnectionFactoryConfiguration.debug("checking server: " + server.getName() + "[" + server.getReposId() + "]");
            }
            if ((serverType = Server.clsidToServerType((String)(classID = server.getClassIdentifier()))) != 1) {
                if (!PlatformConnectionFactoryConfiguration.isDebugEnabled()) continue;
                PlatformConnectionFactoryConfiguration.debug("skipping server because it is neither a workspace server nor a pooled workspace server");
                continue;
            }
            String normClassID = classID.toLowerCase();
            if (fcsClass == 2) {
                if (normClassID.equals("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                    return server;
                }
                if (!PlatformConnectionFactoryConfiguration.isDebugEnabled()) continue;
                PlatformConnectionFactoryConfiguration.debug("skipping server because it is not a pooled workspace server");
                continue;
            }
            if (!normClassID.equals("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                return server;
            }
            if (!PlatformConnectionFactoryConfiguration.isDebugEnabled()) continue;
            PlatformConnectionFactoryConfiguration.debug("skipping server because it is not a workspace server");
        }
        return null;
    }

    private static synchronized Object[][] getFactoryConfigurationStateInitTable() {
        if (_fcsInitTable != null) {
            return _fcsInitTable;
        }
        _fcsInitTable = new Object[][]{{PROPERTYNAME_FACTORY_PREF_CLIENT_POOLING, 32}, {PROPERTYNAME_FACTORY_PREF_SERVER_POOLING, 16}, {PROPERTYNAME_FACTORY_PREF_STANDARD, 8}, {PROPERTYNAME_FACTORY_REQ_CLIENT_POOLING, 256}, {PROPERTYNAME_FACTORY_REQ_POOLING, 128}, {PROPERTYNAME_FACTORY_REQ_SERVER_POOLING, 192}, {PROPERTYNAME_FACTORY_REQ_STANDARD, 64}};
        return _fcsInitTable;
    }

    private static synchronized int[][][] getFactoryConfigurationStateTransitionMachine() {
        if (_fcsMachine != null) {
            return _fcsMachine;
        }
        boolean fcsN = true;
        int fcsS = 2;
        int fcsC = 4;
        boolean fcsX = false;
        _fcsMachine = new int[][][]{new int[][]{{4, 1, 4, 2, 4}, {1, 1, 4, 2, 4}, {2, 1, 2, 2, 4}, {2, 1, 2, 2, 4}, {4, 1, 4, 2, 4}, {4, 1, 4, 2, 4}, {4, 1, 4, 2, 4}, {4, 1, 4, 2, 4}}, new int[][]{{0, 0, 0, 0, 0}, {4, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {2, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {4, 0, 4, 0, 0}, {1, 0, 4, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {4, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{2, 0, 2, 0, 0}, {0, 0, 2, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {2, 0, 2, 0, 0}, {1, 0, 2, 0, 0}, {2, 0, 2, 0, 0}, {2, 0, 2, 0, 0}}, new int[][]{{0, 0, 0, 0, 0}, {2, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {2, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{1, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {1, 0, 0, 0, 0}}};
        return _fcsMachine;
    }

    private static RepositoryInterface getFoundationReposForUser(UserContextInterface user) throws ServiceException, RemoteException {
        ServerInterface authServer = user.getAuthServer();
        if (authServer == null) {
            throw new IllegalStateException("no authentication server associated with user context");
        }
        RepositoryInterface foundationRepos = authServer.getFoundationRepository();
        if (foundationRepos == null) {
            throw new IllegalStateException("no foundation repository associated with authentication server");
        }
        return foundationRepos;
    }

    private static boolean isDebugEnabled() {
        return _logger.isDebugEnabled();
    }

    private static void debug(String message) {
        _logger.debug(message);
    }
}

