/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.platform;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactory;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.LoginException;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.PoolingKernel;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.connection.platform.MissingIdentityException;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformPasswordCredential;
import com.sas.services.connection.platform.PlatformUserCacheUtil;
import com.sas.services.connection.platform.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.ServicesConnectionFactory;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@SASScope
public class PlatformConnectionFactory
extends ConnectionFactory
implements PlatformConnectionFactoryInterface {
    private static final String _cacheKey = "com.sas.services.connection.platform.cacheKey";
    private boolean _useOMRShortcut;

    @Override
    public ConnectionInterface getConnection(UserContextInterface userContext) throws ConnectionFactoryException {
        return this.getConnection(userContext, 0L);
    }

    @Override
    public ConnectionInterface getConnection(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        if (userContext == null) {
            return this.getConnection(waitMilliseconds);
        }
        String authService = this.getAuthService();
        ConnectionInterface cx = null;
        cx = "Host".equals(authService) || "Prompt".equals(authService) ? this.getConnectionHost(userContext, waitMilliseconds) : ("Metadata".equals(authService) ? this.getConnectionMetadata(userContext, waitMilliseconds) : this.getConnectionNone(userContext, waitMilliseconds));
        return cx;
    }

    protected void configIsInOMR() {
        if (this.getKernel() instanceof PoolingKernel) {
            this._useOMRShortcut = true;
        }
    }

    protected ConnectionFactoryKernel getKernel() {
        ConnectionFactoryKernel kernel = super.getKernel();
        return kernel;
    }

    protected ConnectionFactoryRequest getRequest() {
        ConnectionFactoryRequest cxfReq = super.getRequest();
        return cxfReq;
    }

    private ConnectionInterface getConnectionHost(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        String idp;
        Throwable lastException;
        HashSet<String> emptyDomainSet;
        HashSet<String> triedDomainSet;
        int cxfDomainListSize;
        ConnectionFactoryRequest cxfReq;
        List cxfDomainList;
        Locale locale;
        String name;
        block35: {
            String msg;
            name = ServicesConnectionFactory.getEffectiveDisplayName((UserContextInterface)userContext);
            locale = null;
            try {
                locale = userContext.getLocale();
            }
            catch (ServiceException se) {
                throw new ConnectionFactoryException((Throwable)se);
            }
            catch (RemoteException re) {
                throw new ConnectionFactoryException((Throwable)re);
            }
            cxfDomainList = this.getDomains();
            if (this._useOMRShortcut) {
                String spoofDomain = (String)cxfDomainList.get(0);
                ConnectionFactoryKernel kernel = this.getKernel();
                PlatformPasswordCredential login = new PlatformPasswordCredential(null, null, spoofDomain, userContext, null, cxfDomainList);
                login.setLocale(locale);
                ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)login, (long)waitMilliseconds);
                ConnectionInterface cx = this.getConnection(cxReq);
                this.addToCacheUtil(userContext, (Credential)login);
                return cx;
            }
            cxfReq = this.getRequest();
            cxfDomainListSize = cxfDomainList.size();
            triedDomainSet = new HashSet<String>(cxfDomainListSize);
            emptyDomainSet = new HashSet<String>(cxfDomainListSize);
            lastException = null;
            for (String cxfDomain : cxfDomainList) {
                List identityList;
                block34: {
                    IdentityGetterAction action = new IdentityGetterAction(userContext, cxfDomain, false);
                    identityList = null;
                    try {
                        identityList = (List)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        lastException = e;
                        if (!cxfReq.isLoggableFINE()) break block34;
                        int l = name.length() + cxfDomain.length() + 50;
                        StringBuffer buf = new StringBuffer(l);
                        buf.append("Unable to obtain identity for user ");
                        buf.append(name).append(" in domain ").append(cxfDomain).append(":");
                        cxfReq.logFINE(buf.toString(), (Throwable)e);
                    }
                }
                if (identityList == null || identityList.size() <= 0) continue;
                for (UserIdentityInterface identity : identityList) {
                    String password = (String)identity.getCredential();
                    if (password == null || password.length() == 0) {
                        if (triedDomainSet.contains(cxfDomain)) continue;
                        emptyDomainSet.add(cxfDomain);
                        continue;
                    }
                    triedDomainSet.add(cxfDomain);
                    emptyDomainSet.remove(cxfDomain);
                    String userName = (String)identity.getPrincipal();
                    PlatformPasswordCredential login = new PlatformPasswordCredential(userName, password, cxfDomain, userContext, identity, cxfDomainList);
                    login.setLocale(locale);
                    ConnectionFactoryKernel kernel = this.getKernel();
                    try {
                        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)login, (long)waitMilliseconds);
                        ConnectionInterface cx = this.getConnection(cxReq);
                        this.addToCacheUtil(userContext, (Credential)login);
                        return cx;
                    }
                    catch (LoginException le) {
                        lastException = le;
                        if (cxfReq.isLoggableFINE()) {
                            int l = userName.length() + cxfDomain.length() + name.length() + 200;
                            StringBuffer buf = new StringBuffer(l);
                            buf.append("Attempt to authorize identity ");
                            buf.append(userName).append(" for user ").append(name).append(" in domain ");
                            buf.append(cxfDomain).append(" failed. The following traceback is for information only. ");
                            buf.append("The user may have another identity which may be valid for this factory.");
                            cxfReq.logFINE(buf.toString(), (Throwable)le);
                        }
                        if (!(le instanceof InvalidCredentialsException)) continue;
                        try {
                            userContext.removeIdentity(identity);
                        }
                        catch (RemoteException l) {}
                    }
                }
            }
            idp = null;
            try {
                idp = userContext.getIDPropagation();
            }
            catch (RemoteException re) {
                lastException = re;
                if (cxfReq.isLoggableFINE()) {
                    msg = "Unable to determine if connection factory user was authenticated with SSPI";
                    cxfReq.logFINE(msg, (Throwable)re);
                }
            }
            catch (ServiceException se) {
                lastException = se;
                if (!cxfReq.isLoggableFINE()) break block35;
                msg = "Unable to determine if connection factory user was authenticated with SSPI";
                cxfReq.logFINE(msg, (Throwable)se);
            }
        }
        SecurityPackageCredential cred = null;
        if ("sspi".equals(idp) && this.isSecurityPackageAllowed()) {
            cred = SecurityPackageCredential.getInstance();
        } else if ("trustedpeer".equals(idp) && this.isTrustedPeerAllowed()) {
            cred = TrustedPeerCredential.getInstance();
        }
        if (cred != null) {
            cred.setLocale(locale);
            ConnectionFactoryKernel kernel = this.getKernel();
            ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
            ConnectionInterface cx = this.getConnection(cxReq);
            return cx;
        }
        for (String cxfDomain : cxfDomainList) {
            List identityList;
            block36: {
                if (triedDomainSet.contains(cxfDomain) && !emptyDomainSet.contains(cxfDomain)) continue;
                IdentityGetterAction action = new IdentityGetterAction(userContext, cxfDomain, true);
                identityList = null;
                try {
                    identityList = (List)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    lastException = e;
                    if (!cxfReq.isLoggableFINE()) break block36;
                    int l = name.length() + cxfDomain.length() + 80;
                    StringBuffer buf = new StringBuffer(l);
                    buf.append("Unable to obtain identity for user ");
                    buf.append(name).append(" by executing login callback in domain ").append(cxfDomain).append(":");
                    cxfReq.logFINE(buf.toString(), (Throwable)e);
                }
            }
            if (identityList == null || identityList.size() <= 0) continue;
            triedDomainSet.add(cxfDomain);
            Iterator identityItor = identityList.iterator();
            while (identityItor.hasNext()) {
                ConnectionFactoryKernel kernel = this.getKernel();
                UserIdentityInterface identity = (UserIdentityInterface)identityItor.next();
                String userName = (String)identity.getPrincipal();
                String password = (String)identity.getCredential();
                PlatformPasswordCredential login = new PlatformPasswordCredential(userName, password, cxfDomain, userContext, identity, cxfDomainList);
                login.setLocale(locale);
                try {
                    ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)login, (long)waitMilliseconds);
                    ConnectionInterface cx = this.getConnection(cxReq);
                    this.addToCacheUtil(userContext, (Credential)login);
                    return cx;
                }
                catch (LoginException le) {
                    le.setLoginCallbackError(true);
                    lastException = le;
                    if (cxfReq.isLoggableFINE()) {
                        int l = userName.length() + name.length() + cxfDomain.length() + 200;
                        StringBuffer buf = new StringBuffer(l);
                        buf.append("Attempt to authorize identity ");
                        buf.append(userName).append(" for user ").append(name).append(" in domain ");
                        buf.append(cxfDomain).append(" failed. The following traceback is for information only. ");
                        buf.append("The user may have another identity which may be valid for this factory.");
                        cxfReq.logFINE(buf.toString(), (Throwable)le);
                    }
                    if (!(le instanceof InvalidCredentialsException)) continue;
                    try {
                        userContext.removeIdentity(identity);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
        }
        int triedDomainSetSize = triedDomainSet.size();
        String serverName = this.getLogicalServerName();
        if (triedDomainSetSize > 0) {
            String messageIndex = "cxp.200.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)name, (Object)serverName);
            throw new LoginException(message, lastException);
        }
        if (cxfDomainListSize == 1) {
            String cxfDomain = (String)cxfDomainList.get(0);
            String messageIndex = "cxp.201.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)name, (Object)serverName, (Object)cxfDomain);
            throw new MissingIdentityException(message, lastException, cxfDomainList);
        }
        int l = cxfDomainListSize * 65 + 21;
        StringBuffer cxfDomainStrBuf = new StringBuffer(l);
        cxfDomainStrBuf.append('<');
        for (String cxfDomain : cxfDomainList) {
            cxfDomainStrBuf.append(cxfDomain).append(',');
        }
        int cxfDomainStrL = cxfDomainStrBuf.length();
        cxfDomainStrBuf.setCharAt(cxfDomainStrL - 1, '>');
        String cxfDomainStr = cxfDomainStrBuf.toString();
        String messageIndex = "cxp.202.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex, locale);
        String message = Message.format((String)messagePattern, (Object)name, (Object)serverName, (Object)cxfDomainStr);
        throw new MissingIdentityException(message, lastException, cxfDomainList);
    }

    private ConnectionInterface getConnectionMetadata(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        List domainLst = this.getDomains();
        String spoofDomain = (String)domainLst.get(0);
        ServicesConnectionFactory.PasswordGeneratingCredential cred = new ServicesConnectionFactory.PasswordGeneratingCredential(userContext, spoofDomain);
        ConnectionFactoryKernel kernel = this.getKernel();
        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
        try {
            ConnectionInterface cx = this.getConnection(cxReq);
            return cx;
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause != null && cause instanceof ConnectionFactoryException) {
                throw (ConnectionFactoryException)cause;
            }
            throw re;
        }
    }

    private ConnectionInterface getConnectionNone(UserContextInterface userContext, long waitMilliseconds) throws ConnectionFactoryException {
        ConnectionFactoryKernel kernel = this.getKernel();
        String userName = "";
        String password = "";
        List domainLst = this.getDomains();
        String spoofDomain = (String)domainLst.get(0);
        PasswordCredential cred = new PasswordCredential(userName, password, spoofDomain);
        try {
            Locale locale = userContext.getLocale();
            cred.setLocale(locale);
        }
        catch (ServiceException se) {
            throw new ConnectionFactoryException((Throwable)se);
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
        ConnectionRequest cxReq = ConnectionRequest.wrap((ConnectionFactoryKernel)kernel, (Credential)cred, (long)waitMilliseconds);
        ConnectionInterface cx = this.getConnection(cxReq);
        return cx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCacheUtil(UserContextInterface userContext, Credential login) {
        ConnectionFactoryKernel kernel = this.getKernel();
        try {
            SessionContextInterface sessionContext = userContext.getSessionContext();
            if (sessionContext == null) {
                return;
            }
            Object sessionLock = null;
            try {
                sessionLock = sessionContext.lock(this.getClass().getName());
            }
            catch (IllegalStateException ise) {
                PlatformUserCacheUtil.remove(kernel, login);
                return;
            }
            try {
                PlatformUserCacheUtil util = null;
                SessionContextInterface sessionContextInterface = sessionContext;
                synchronized (sessionContextInterface) {
                    util = (PlatformUserCacheUtil)((Object)sessionContext.getAttribute(_cacheKey));
                    if (util == null) {
                        util = new PlatformUserCacheUtil();
                        sessionContext.setAttribute(_cacheKey, (Object)util);
                    }
                }
                util.add(kernel, login);
            }
            finally {
                sessionContext.unlock(sessionLock);
            }
        }
        catch (RemoteException re) {
            PlatformUserCacheUtil.remove(kernel, login);
        }
    }

    @SASScope
    private class IdentityGetterAction
    implements PrivilegedExceptionAction {
        private UserContextInterface _userContext;
        private String _domain;
        private boolean _callback;

        protected IdentityGetterAction(UserContextInterface userContext, String domain, boolean callback) {
            this._userContext = userContext;
            this._domain = domain;
            this._callback = callback;
        }

        public Object run() throws Exception {
            return this._domain != null ? this._userContext.getIdentitiesByDomain(this._domain, this._callback, null) : this._userContext.getIdentities();
        }
    }
}

