/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.omr;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.SASURI;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MdException;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdStore;
import com.sas.net.brg.orb.BrgOrb;
import com.sas.services.connection.AggregationKernel;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.PoolingKernel;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.omr.LocalUtil;
import com.sas.services.connection.omr.OMRAuthServer;
import com.sas.services.connection.omr.RB;
import com.sas.services.connection.omr.RemoteUtil;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class OMRConnectionFactoryConfiguration
extends ConnectionFactoryConfiguration {
    protected static final Integer typeFailover = 1;
    protected static final Integer typeLoadBalancing = 0;
    private IOMI _omrServer;
    private String _objectID;
    private String _repositoryID;
    private String _objectName;
    private com.sas.metadata.LogicalServer _object;
    private LogicalServer _remoteObject;
    private boolean _fullyFetched;
    private Cluster[] _clusters;
    private Puddle[] _puddles;
    private Properties _env;
    private String _domain;
    private String _logicalServerName;
    @SASScope
    public static final UsageVersion USAGE_VERSION_CURRENT = new UsageVersion(1, 0);
    @SASScope
    public static final UsageVersion USAGE_VERSION_OLDEST = null;
    public static final String longTemplate = "<Templates><LogicalServer Name=\"\" ClassIdentifier=\"\" UsageVersion=\"\"><ServiceTypes/><InitProcesses/><SoftwareTrees/><UsingComponents/><Properties/></LogicalServer><ServiceType Name=\"\"/><Transformation TransformRole=\"\"><TransformationSources/></Transformation><Tree TreeType=\"\"><Members/></Tree><ServerComponent Name=\"\" PublicType=\"\"><AssociatedMachine/><ServiceTypes/><SoftwareTrees/><SourceConnections/><Properties/></ServerComponent><Group><Members/><Properties/></Group><Login Password=\"\" UserID=\"\"><Domain/><AssociatedIdentity/></Login><AuthenticationDomain Name=\"\"/><Identity><Logins/></Identity><Person><Logins/></Person><IdentityGroup Name=\"\"><Logins/></IdentityGroup><Property PropertyName=\"\" DefaultValue=\"\"/><ServiceType Name=\"\"/><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" ApplicationProtocol=\"\" HostName=\"\" Port=\"\"><Properties/><Domain/></TCPIPConnection><Machine Name=\"\"><Implementors/></Machine><Implementor PublicType=\"\"><SourceConnections/></Implementor></Templates>";
    public static final int flags = 2308;

    public OMRConnectionFactoryConfiguration(IOMI omrServer, String objectID) {
        if (omrServer == null) {
            throw new IllegalArgumentException("\"omrServer\" cannot be null.");
        }
        if (objectID == null) {
            throw new IllegalArgumentException("\"objectID\" cannot be null.");
        }
        this._omrServer = omrServer;
        this._objectID = objectID;
    }

    public OMRConnectionFactoryConfiguration(IOMI omrServer, String repositoryID, String objectName) {
        if (omrServer == null) {
            throw new IllegalArgumentException("\"omrServer\" cannot be null.");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("\"objectName\" cannot be null.");
        }
        this._omrServer = omrServer;
        this._repositoryID = repositoryID;
        this._objectName = objectName;
    }

    public OMRConnectionFactoryConfiguration(com.sas.metadata.LogicalServer object) {
        this(object, false);
    }

    public OMRConnectionFactoryConfiguration(com.sas.metadata.LogicalServer object, boolean fullyFetched) {
        if (object == null) {
            throw new IllegalArgumentException("\"object\" cannot be null.");
        }
        this._object = object;
        this._fullyFetched = fullyFetched;
    }

    public OMRConnectionFactoryConfiguration(LogicalServer remoteObject) {
        this(remoteObject, false);
    }

    public OMRConnectionFactoryConfiguration(LogicalServer remoteObject, boolean fullyFetched) {
        if (remoteObject == null) {
            throw new IllegalArgumentException("\"remoteObject\" cannot be null.");
        }
        this._remoteObject = remoteObject;
        this._fullyFetched = fullyFetched;
    }

    public IOMI getOMRServer() {
        return this._omrServer;
    }

    public String getObjectID() {
        return this._objectID;
    }

    public String getRepositoryID() {
        return this._repositoryID;
    }

    public String getObjectName() {
        return this._objectName;
    }

    public com.sas.metadata.LogicalServer getObject() {
        return this._object;
    }

    public LogicalServer getRemoteObject() {
        return this._remoteObject;
    }

    public boolean isFullyFetched() {
        return this._fullyFetched;
    }

    public boolean equals(java.lang.Object that) {
        if (!super.equals(that)) {
            return false;
        }
        OMRConnectionFactoryConfiguration thatConfig = (OMRConnectionFactoryConfiguration)((java.lang.Object)that);
        IOMI thatOMRServer = thatConfig.getOMRServer();
        if (this._omrServer != thatOMRServer) {
            if (this._omrServer == null || thatOMRServer == null) {
                return false;
            }
            BrgOrb thisOrb = (BrgOrb)((ObjectImpl)this._omrServer)._orb();
            Properties thisEnv = thisOrb.objectToProperties((Object)this._omrServer);
            BrgOrb thatOrb = (BrgOrb)((ObjectImpl)this._omrServer)._orb();
            Properties thatEnv = thatOrb.objectToProperties((Object)thatOMRServer);
            if (thisEnv == null ? thatEnv != null : !thisEnv.equals(thatEnv)) {
                return false;
            }
        }
        String thatObjectID = thatConfig.getObjectID();
        if (this._objectID == null ? thatObjectID != null : !this._objectID.equals(thatObjectID)) {
            return false;
        }
        String thatRepositoryID = thatConfig.getRepositoryID();
        if (this._repositoryID == null ? thatRepositoryID != null : !this._repositoryID.equals(thatRepositoryID)) {
            return false;
        }
        String thatObjectName = thatConfig.getObjectName();
        if (this._objectName == null ? thatObjectName != null : !this._objectName.equals(thatObjectName)) {
            return false;
        }
        com.sas.metadata.LogicalServer thatObject = thatConfig.getObject();
        if (this._object != thatObject) {
            String thatFQID;
            if (this._object == null || thatObject == null) {
                return false;
            }
            String thisFQID = this._object.getFQID();
            if (!thisFQID.equals(thatFQID = thatObject.getFQID())) {
                return false;
            }
        }
        LogicalServer thatRemoteObject = thatConfig.getRemoteObject();
        try {
            if (this._remoteObject == null ? thatRemoteObject != null : !this._remoteObject.getFQID().equals(thatRemoteObject.getFQID())) {
                return false;
            }
        }
        catch (RemoteException re) {
            return false;
        }
        boolean thatFullyFetched = thatConfig.isFullyFetched();
        return this._fullyFetched == thatFullyFetched;
    }

    public int hashCode() {
        int hc = super.hashCode();
        if (this._omrServer != null) {
            BrgOrb thisOrb = (BrgOrb)((ObjectImpl)this._omrServer)._orb();
            Properties thisEnv = thisOrb.objectToProperties((Object)this._omrServer);
            hc ^= thisEnv.hashCode();
        }
        if (this._objectID != null) {
            hc ^= this._objectID.hashCode();
        }
        if (this._repositoryID != null) {
            hc ^= this._repositoryID.hashCode();
        }
        if (this._objectName != null) {
            hc ^= this._objectName.hashCode();
        }
        if (this._object != null) {
            hc ^= this._object.getFQID().hashCode();
            hc += 256;
        }
        if (this._remoteObject != null) {
            try {
                hc ^= this._remoteObject.getFQID().hashCode();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this._fullyFetched) {
            ++hc;
        }
        return hc;
    }

    public String toString() {
        String[] nvPairObj;
        String objStr;
        HashSet<String[]> nvPairSet = new HashSet<String[]>(8);
        if (this._omrServer != null) {
            String serverStr = null;
            ORB orb = ((ObjectImpl)this._omrServer)._orb();
            if (orb instanceof ORBBase) {
                SASURI uri = ((ORBBase)orb).object_to_uri((Object)this._omrServer);
                serverStr = uri.toBlottedString();
            } else {
                serverStr = orb.object_to_string((Object)this._omrServer);
            }
            String[] nvPairServer = new String[]{"omrServer", serverStr};
            nvPairSet.add(nvPairServer);
        }
        if (this._objectID != null) {
            String[] nvPairObjectID = new String[]{"objectID", this._objectID};
            nvPairSet.add(nvPairObjectID);
        }
        if (this._repositoryID != null) {
            String[] nvPairReposID = new String[]{"reposID", this._repositoryID};
            nvPairSet.add(nvPairReposID);
        }
        if (this._objectName != null) {
            String[] nvPairObjectName = new String[]{"objectName", this._objectName};
            nvPairSet.add(nvPairObjectName);
        }
        if (this._object != null) {
            objStr = this._object.getFQID();
            nvPairObj = new String[]{"localObject", objStr};
            nvPairSet.add(nvPairObj);
        }
        if (this._remoteObject != null) {
            objStr = null;
            try {
                objStr = this._remoteObject.getFQID();
            }
            catch (RemoteException re) {
                objStr = String.valueOf(null);
            }
            nvPairObj = new String[]{"remoteObject", objStr};
            nvPairSet.add(nvPairObj);
        }
        int nvPairSetL = nvPairSet.size();
        String[][] nvPairArr = new String[nvPairSetL][];
        nvPairArr = (String[][])nvPairSet.toArray((T[])nvPairArr);
        String str = ConnectionFactoryUtil.nvPairsToString((String[][])nvPairArr);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SASScope
    protected ConnectionFactoryKernel doGetKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        MdStore store;
        IOMI authMeta;
        ConnectionFactoryConfiguration cxfConfig;
        block30: {
            cxfConfig = cxfReq.getOriginalConfiguration();
            authMeta = null;
            store = null;
            if (this._clusters == null && this._puddles == null) {
                if (this._object == null) {
                    try {
                        MdOMRConnection omrConnection;
                        LogicalServer remobj = this._remoteObject;
                        MdFactoryImpl mdFactory = null;
                        try {
                            if (remobj == null) {
                                mdFactory = new MdFactoryImpl(false);
                                omrConnection = mdFactory.getConnection();
                                omrConnection.setCMRHandle(this._omrServer);
                                authMeta = this._omrServer;
                                remobj = this._objectID != null ? OMRConnectionFactoryConfiguration.findByID((MdFactory)mdFactory, this._objectID) : OMRConnectionFactoryConfiguration.findByName((MdFactory)mdFactory, this._repositoryID, this._objectName);
                            } else {
                                store = remobj.getObjectStore();
                                if (!this._fullyFetched) {
                                    MdFactory mdf = store.getFactory();
                                    if (mdf == null) {
                                        String messageIndex = "cxo.013.ex.txt";
                                        String message = RB.getStringResource(messageIndex);
                                        throw new ConnectionFactoryException(message);
                                    }
                                    MdOMIUtil omiUtil = mdf.getOMIUtil();
                                    omiUtil.getMetadataAllDepths((com.sas.metadata.remote.CMetadata)remobj, null, null, longTemplate, 2308);
                                }
                            }
                            this._logicalServerName = remobj.getName();
                            java.lang.Object res = RemoteUtil.resolve(remobj, cxfReq);
                            if (res instanceof Puddle[]) {
                                this._puddles = (Puddle[])res;
                                if (cxfConfig instanceof PlatformConnectionFactoryConfiguration) break block30;
                                MdOMRConnection omrConnection2 = remobj.getObjectStore().getFactory().getConnection();
                                try {
                                    this._env = omrConnection2.getCMRProperties();
                                    this._domain = (String)this._env.remove("domain");
                                    break block30;
                                }
                                catch (com.sas.metadata.remote.MdException rmde) {
                                    String messageIndex = "cxo.007.ex.txt";
                                    String message = RB.getStringResource(messageIndex);
                                    throw new ConnectionFactoryException(message, (Throwable)rmde);
                                }
                            }
                            this._clusters = (Cluster[])res;
                            break block30;
                        }
                        finally {
                            if (mdFactory != null) {
                                omrConnection = mdFactory.getConnection();
                                omrConnection.setCMRHandle(null);
                                mdFactory.dispose();
                            }
                        }
                    }
                    catch (RemoteException re) {
                        throw new ConnectionFactoryException((Throwable)re);
                    }
                    catch (com.sas.metadata.remote.MdException mde) {
                        throw new ConnectionFactoryException((Throwable)mde);
                    }
                }
                if (!this._fullyFetched) {
                    try {
                        MetadataUtil.getMetadataAllDepths((CMetadata)this._object, null, null, (String)longTemplate, (int)2308, (boolean)true);
                    }
                    catch (MdException mde) {
                        throw new ConnectionFactoryException((Throwable)mde);
                    }
                }
                this._logicalServerName = this._object.getName();
                java.lang.Object res = LocalUtil.resolve(this._object, cxfReq);
                if (res instanceof Puddle[]) {
                    this._puddles = (Puddle[])res;
                    if (!(cxfConfig instanceof PlatformConnectionFactoryConfiguration)) {
                        try {
                            MetadataWorkspace metadataWorkspace = MetadataWorkspace.getWorkspace();
                            authMeta = metadataWorkspace.getCMRHandle();
                            this._env = metadataWorkspace.getCMRProperties();
                            this._domain = (String)this._env.remove("domain");
                        }
                        catch (MdException mde) {
                            String messageIndex = "cxo.002.ex.txt";
                            String message = RB.getStringResource(messageIndex);
                            throw new ConnectionFactoryException(message, (Throwable)mde);
                        }
                    }
                } else {
                    this._clusters = (Cluster[])res;
                }
            }
        }
        if (this._puddles == null) {
            return new AggregationKernel(cxfReq, this._clusters);
        }
        PuddleEnvelope[] envs = new PuddleEnvelope[this._puddles.length];
        for (int i = 0; i < this._puddles.length; ++i) {
            envs[i] = new PuddleEnvelope(this._puddles[i]);
        }
        boolean cacheUsers = false;
        if (cxfConfig instanceof PlatformConnectionFactoryConfiguration) {
            try {
                PlatformConnectionFactoryConfiguration pcxfConfig = (PlatformConnectionFactoryConfiguration)cxfConfig;
                RepositoryInterface repos = pcxfConfig.getRepository();
                if (repos == null) {
                    LogicalServerInterface logicalServer = pcxfConfig.getLogicalServer();
                    repos = logicalServer.getRepository();
                }
                this._domain = repos.getDomain();
            }
            catch (RemoteException re) {
                throw new ConnectionFactoryException((Throwable)re);
            }
            cacheUsers = true;
        }
        OMRAuthServer authServer = new OMRAuthServer(authMeta, store, envs, this._env, this._domain, cacheUsers);
        ConnectionFactoryManager cxfManager = cxfReq.getManager();
        ConnectionResources cxResources = cxfManager.getConnectionResources();
        authServer.setConnectionResources(cxResources);
        return new PoolingKernel(cxfReq, envs, (AuthServer)authServer);
    }

    @SASScope
    protected String doGetLogicalServerName() {
        return this._logicalServerName;
    }

    private static LogicalServer findByID(MdFactory mdFactory, String objectID) throws ConnectionFactoryException {
        try {
            MdOMIUtil omiUtil = mdFactory.getOMIUtil();
            String t = "LogicalServer";
            return (LogicalServer)omiUtil.getMetadataAllDepths(null, t, objectID, null, null, longTemplate, 2308);
        }
        catch (com.sas.metadata.remote.MdException e) {
            throw new ConnectionFactoryException((Throwable)e);
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
    }

    private static LogicalServer findByName(MdFactory mdFactory, String repositoryID, String objectName) throws ConnectionFactoryException {
        try {
            int size;
            MdOMIUtil omiUtil = mdFactory.getOMIUtil();
            StringBuffer oBuffer = new StringBuffer(36 + objectName.length() + longTemplate.length());
            oBuffer.append("<XMLSELECT Search=\"@NAME='").append(objectName).append("'\"/>").append(longTemplate);
            String o = oBuffer.toString();
            int fl = 10628;
            String t = "LogicalServer";
            String rid = repositoryID != null ? repositoryID : "";
            List v = omiUtil.getMetadataObjectsSubset(null, rid, t, fl, o);
            int n = size = v != null ? v.size() : 0;
            if (size == 0) {
                String messageIndex = "cxo.003.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                String message = Message.format((String)messagePattern, (java.lang.Object)objectName);
                throw new ConnectionFactoryException(message);
            }
            return (LogicalServer)v.get(0);
        }
        catch (com.sas.metadata.remote.MdException e) {
            throw new ConnectionFactoryException((Throwable)e);
        }
        catch (RemoteException re) {
            throw new ConnectionFactoryException((Throwable)re);
        }
    }

    @SASScope
    protected static String createUsageVersionErrorMessage(String metadataType, String fqid, UsageVersion metadataVersion, UsageVersion currentVersion) {
        String messageIndex = "cxo.014.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        java.lang.Object[] argv = new java.lang.Object[]{metadataType, fqid, metadataVersion, currentVersion};
        String message = Message.format((String)messagePattern, (java.lang.Object[])argv);
        return message;
    }
}

