/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.Encoder;
import com.objectplanet.image.GrayScaleAlphaEncoder;
import com.objectplanet.image.GrayScaleEncoder;
import com.objectplanet.image.IndexedAlphaEncoder;
import com.objectplanet.image.IndexedEncoder;
import com.objectplanet.image.TrueColorAlphaEncoder;
import com.objectplanet.image.TrueColorEncoder;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PngEncoder {
    public static final int COLOR_GRAYSCALE = 0;
    public static final int COLOR_TRUECOLOR = 2;
    public static final int COLOR_INDEXED = 3;
    public static final int COLOR_GRAYSCALE_ALPHA = 4;
    public static final int COLOR_INDEXED_ALPHA = 5;
    public static final int COLOR_TRUECOLOR_ALPHA = 6;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] END_CHUNK;
    private int colorType;
    private int compression;
    private Encoder encoder;
    private String keyword = null;

    static {
        byte[] byArray = new byte[12];
        byArray[4] = 73;
        byArray[5] = 69;
        byArray[6] = 78;
        byArray[7] = 68;
        byArray[8] = -82;
        byArray[9] = 66;
        byArray[10] = 96;
        byArray[11] = -126;
        END_CHUNK = byArray;
    }

    public PngEncoder(String string) {
        this(string, 2);
    }

    public PngEncoder(String string, int n) {
        this(string, n, -1);
    }

    public PngEncoder(String string, int n, int n2) {
        this.compression = n2;
        this.keyword = string;
        this.initEncoder(n, n2);
    }

    private void initEncoder(int n, int n2) {
        this.colorType = n;
        switch (n) {
            case 3: {
                this.encoder = new IndexedEncoder(n2);
                break;
            }
            case 5: {
                this.encoder = new IndexedAlphaEncoder(n2);
                break;
            }
            case 2: {
                this.encoder = new TrueColorEncoder(n2);
                break;
            }
            case 6: {
                this.encoder = new TrueColorAlphaEncoder(n2);
                break;
            }
            case 0: {
                this.encoder = new GrayScaleEncoder(n2);
                break;
            }
            case 4: {
                this.encoder = new GrayScaleAlphaEncoder(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid colorType, must be COLOR_INDEXED, COLOR_TRUECOLOR, COLOR_GRAYSCALE, COLOR_INDEXED_ALPHA, COLOR_TRUECOLOR_ALPHA or COLOR_GRAYSCALE_ALPHA");
            }
        }
    }

    public synchronized void setColorType(int n) {
        this.initEncoder(n, this.compression);
    }

    public synchronized int getColorType() {
        return this.colorType;
    }

    public synchronized void setCompression(int n) {
        this.compression = n;
        this.encoder.setCompression(n);
    }

    public static String getVersion() {
        return "2.0";
    }

    public static void main(String[] stringArray) {
        System.out.println("Java PngEncoder " + PngEncoder.getVersion());
        System.out.println("Copyright 2003-2006, ObjectPlanet, Inc.");
    }

    public synchronized void encode(Image image, OutputStream outputStream) throws IOException {
        if (!"SASPNG92".equalsIgnoreCase(this.keyword)) {
            return;
        }
        if (image == null || image.getSource() == null || outputStream == null) {
            return;
        }
        outputStream.write(PNG_SIGNATURE);
        this.encoder.encode(image, new DataOutputStream(outputStream));
        outputStream.write(END_CHUNK);
        outputStream.flush();
    }
}

