/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import com.objectplanet.image.IndexedEncoder;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IndexedAlphaEncoder
extends IndexedEncoder {
    protected ByteArrayOutputStream trnsChunk = new ByteArrayOutputStream();
    private boolean transparency_set;

    IndexedAlphaEncoder(int n) {
        super(n);
        this.colorType = 5;
    }

    synchronized void encode(Image image, DataOutputStream dataOutputStream) throws IOException {
        this.trnsChunk.reset();
        this.trnsChunk.write("tRNS".getBytes());
        this.transparency_set = false;
        super.encode(image, dataOutputStream);
    }

    protected void writeChunks(DataOutputStream dataOutputStream) throws IOException {
        this.writeChunk(this.headerChunk, dataOutputStream);
        this.writeChunk(this.paletteChunk, dataOutputStream);
        this.writeChunk(this.trnsChunk, dataOutputStream);
        this.writeChunk(this.idatChunk, dataOutputStream);
    }

    public void setDimensions(int n, int n2) {
        this.headerChunk.reset();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.headerChunk);
            dataOutputStream.write("IHDR".getBytes());
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(8);
            dataOutputStream.write(3);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            dataOutputStream.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == null || nArray == null) {
            return;
        }
        if (!this.palette_set) {
            this.initPalette();
            this.palette_set = true;
        }
        if (!this.transparency_set) {
            this.trnsChunk.write(0);
            this.transparency_set = true;
        }
        int n7 = nArray.length / n6;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n7) {
            if (this.pngPixels == null || this.pngPixels.length < n6 + 1) {
                this.pngPixels = new byte[n6 + 1];
            }
            this.pngPixels[0] = 0;
            int n10 = 0;
            while (n10 < n6) {
                if (colorModel.getAlpha(nArray[n8]) == 0) {
                    this.pngPixels[n10 + 1] = 0;
                } else {
                    this.setPixel(colorModel, nArray[n8], n10);
                }
                ++n8;
                ++n10;
            }
            try {
                this.deflaterOut.write(this.pngPixels, 0, n6 + 1);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n9;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == null || byArray == null) {
            return;
        }
        if (!this.palette_set) {
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            byte[] byArray5 = new byte[256];
            ((IndexColorModel)colorModel).getAlphas(byArray2);
            ((IndexColorModel)colorModel).getReds(byArray3);
            ((IndexColorModel)colorModel).getGreens(byArray4);
            ((IndexColorModel)colorModel).getBlues(byArray5);
            int n7 = 0;
            while (n7 < 256) {
                this.paletteChunk.write(byArray3[n7]);
                this.paletteChunk.write(byArray4[n7]);
                this.paletteChunk.write(byArray5[n7]);
                this.trnsChunk.write(byArray2[n7]);
                ++n7;
            }
            this.palette_set = true;
        }
        try {
            this.deflaterOut.write(0);
            this.deflaterOut.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

