/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.identifiers.client;

import java.io.Serializable;

public class ObjectType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long id;
    public String code;
    public int container = 0;
    public int lifecyclable = 0;
    public int versionable = 0;

    public ObjectType(String csv) {
        int threeTokens = 3;
        int fourTokens = 4;
        String[] tokens = csv.split(",");
        this.id = Long.parseLong(tokens[0]);
        this.code = tokens[1];
        if (tokens.length > 2) {
            this.container = this.getBoolean(tokens[2]);
        }
        if (tokens.length > 3) {
            this.lifecyclable = this.getBoolean(tokens[3]);
        }
        if (tokens.length > 4) {
            this.versionable = this.getBoolean(tokens[4]);
        }
    }

    private int getBoolean(String val) {
        boolean boolVal = Boolean.parseBoolean(val);
        return boolVal ? 1 : 0;
    }

    public int hashCode() {
        int numShiftBits = 32;
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + this.container;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.lifecyclable;
        result = 31 * result + this.versionable;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectType other = (ObjectType)obj;
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.container != other.container) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lifecyclable != other.lifecyclable) {
            return false;
        }
        return this.versionable == other.versionable;
    }
}

