/*
 * Decompiled with CFR 0.152.
 */
package MITI.stitching;

import MITI.messages.MIRStitchingUtil.STCHU;
import MITI.server.services.common.mir.StitchingRule;
import MITI.stitching.Stitching;
import MITI.stitching.StitchingContext;
import MITI.stitching.StitchingLink;
import MITI.stitching.StitchingObject;
import MITI.stitching.StitchingObjectStatus;
import MITI.stitching.base.StitchingOptions;
import java.util.Collection;

public abstract class Stitcher<T extends StitchingObject<T>, E extends Exception> {
    private StitchingOptions options;
    private StitchingContext context;
    private Stitching stitching;

    public Stitcher(StitchingOptions stitchingOptions) {
        this.options = stitchingOptions;
    }

    public StitchingRule getStitchingRule() {
        return this.options.getStitchingRule();
    }

    public short getMatchingRule() {
        return this.options.getMatchingRule();
    }

    protected boolean isFile() {
        return this.options.getMatchingRule() == 2;
    }

    protected boolean isRelational() {
        return this.options.getMatchingRule() == 1;
    }

    public StitchingOptions.MatchCase getMatchCase() {
        return this.options.getMatchCase();
    }

    public boolean isHierarchical() {
        return this.options.isHierarchical();
    }

    public Stitching stitch(StitchingContext stitchingContext, T t, T t2) throws E {
        this.context = stitchingContext;
        this.stitching = new Stitching();
        this.stitchChildren(t, t2);
        return this.stitching;
    }

    protected StitchingLink match(T t, T t2) {
        StitchingLink stitchingLink = new StitchingLink((StitchingObject<?>)t, (StitchingObject<?>)t2);
        this.stitching.addLink(stitchingLink);
        return stitchingLink;
    }

    protected boolean isMatch(T t, T t2) {
        return this.options.match((StitchingObject<?>)t, (StitchingObject<?>)t2);
    }

    protected abstract void stitchChildren(T var1, T var2) throws E;

    protected abstract Collection<T> listChildren(T var1, boolean var2) throws E;

    protected final Collection<T> getChildren(T t, boolean bl) throws E {
        Collection collection = ((StitchingObject)t).getChildren();
        if (collection == null) {
            collection = this.listChildren(t, bl);
            ((StitchingObject)t).setChildren(collection);
        }
        return collection;
    }

    protected abstract Collection<T> listReferences(T var1) throws E;

    protected final Collection<T> getReferences(T t) throws E {
        Collection collection = ((StitchingObject)t).getReferences();
        if (collection == null) {
            collection = this.listReferences(t);
            ((StitchingObject)t).setReferences(collection);
        }
        return collection;
    }

    protected abstract String getPath(T var1) throws E;

    protected void warn(T t, StitchingObjectStatus stitchingObjectStatus) throws E {
        if (!(((StitchingObject)t).isAmbiguous() || ((StitchingObject)t).isCondition() || ((StitchingObject)t).isTemporary())) {
            if (this.stitching.getStatus() == 1) {
                STCHU.WRN_CONTEXT.log(this.context.getSupplierPath(), this.context.getClientPath(), this.context.getConnectionName());
            }
            if (stitchingObjectStatus == StitchingObjectStatus.MISSING_SUPPLIER) {
                STCHU.WRN_MISSING_CONNECTION_OBJECT.log(this.getPath(t));
            } else if (stitchingObjectStatus == StitchingObjectStatus.TOO_MANY_SUPPLIERS) {
                STCHU.WRN_MULTIPLE_MATCH_CONNECTION_OBJECT.log(this.getPath(t));
            }
            this.stitching.addFailedObject((StitchingObject<?>)t, stitchingObjectStatus);
        }
    }
}

