/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.mimb;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.config.MimbConfiguration;
import MITI.util.config.MitiConfig;
import java.io.File;

public class MIRSetup
extends MitiConfig {
    private static ThreadLocal<MIRSetup> defaultSetup = new ThreadLocal<MIRSetup>(){

        @Override
        protected synchronized MIRSetup initialValue() {
            try {
                return MIRSetup.loadSetup(MimbConfiguration.getMimbHome());
            }
            catch (MIRException mIRException) {
                return null;
            }
        }
    };

    public static void deinit() {
        defaultSetup.remove();
    }

    public static MIRSetup getDefault() throws MIRException {
        if (defaultSetup.get() == null) {
            throw new MIRException(MBCM.ERR_WRONG_MIMB_HOME_DIR.getMessage(new Object[0]));
        }
        return defaultSetup.get();
    }

    public static MIRSetup loadSetup(File file) throws MIRException {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new MIRException(MBCM.ERR_WRONG_MIMB_HOME_DIR.getMessage(new Object[0]));
        }
        return new MIRSetup(MitiConfig.loadConfig(file));
    }

    private MIRSetup(MitiConfig mitiConfig) {
        super(mitiConfig);
    }

    public File getJavaDirectory() {
        return new File(this.getHomeDirectory(), "java");
    }

    public File getBinDirectory() {
        return new File(this.getHomeDirectory(), "bin");
    }

    public File getConfDirectory() {
        return new File(this.getHomeDirectory(), "conf");
    }

    public File getBridgeTemplateDirectory() {
        return new File(this.getHomeDirectory(), "conf/MIRModelBridgeTemplate");
    }

    public File getDataHistoryDirectory() {
        File file = new File(this.getDataDirectory(), "MIMB/history");
        file.mkdirs();
        return file;
    }

    public File getDataParamsDirectory() {
        File file = new File(this.getDataDirectory(), "MIMB/parameters");
        file.mkdirs();
        return file;
    }

    public File getTempDirectory() {
        File file = new File(this.getDataDirectory(), "temp");
        file.mkdirs();
        if (!file.isDirectory()) {
            file = new File(System.getProperty("java.io.tmpdir"));
        }
        return file;
    }
}

