/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.MIRException;
import MITI.bridges.maven.Artifact;
import MITI.bridges.maven.ArtifactRef;
import MITI.bridges.maven.MavenArtifacts;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import java.io.File;
import org.w3c.dom.Element;

public class PomDb {
    private static final File getPomDb(File file) {
        return new File(file, "pomDb.xml");
    }

    public static void build(File file) throws MIRException {
        Element element = XmlUtil.parseString("<PomDb/>");
        PomDb.processDir(file, element);
        FileUtil.writeContent(PomDb.getPomDb(file), XmlUtil.getString(element), FileUtil.UTF8);
    }

    public static void clear(File file) throws MIRException {
        PomDb.getPomDb(file).delete();
    }

    public static void load(File file, MavenArtifacts mavenArtifacts) {
        Element element;
        File file2 = PomDb.getPomDb(file);
        if (file2.isFile() && (element = XmlUtil.parseString(FileUtil.readContent(file2, FileUtil.UTF8))) != null) {
            for (Element object : XmlUtil.getChildElements(element)) {
                Artifact artifact = Artifact.fromPom(object);
                if (artifact == null) continue;
                mavenArtifacts.put(artifact);
            }
            for (Artifact artifact : mavenArtifacts.list()) {
                for (ArtifactRef artifactRef : artifact.getManagementDependencies()) {
                    mavenArtifacts.resolve(artifactRef, artifact);
                }
                for (ArtifactRef artifactRef : artifact.getDependencies()) {
                    mavenArtifacts.resolve(artifactRef, artifact);
                }
            }
        }
    }

    private static void processDir(File file, Element element) {
        for (File file2 : FileUtil.list(file)) {
            if (file2.isDirectory()) {
                PomDb.processDir(file2, element);
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".pom")) continue;
            PomDb.processFile(file2, element);
        }
    }

    private static void processFile(File file, Element element) {
        Object object;
        Element element22;
        Element element3 = XmlUtil.parseString(FileUtil.readContent(file, FileUtil.UTF8));
        Element element4 = PomDb.copyNode(element3, element);
        PomDb.copyValue(XmlUtil.getFirstElement(element3, "name"), element4);
        PomDb.copyValue(XmlUtil.getFirstElement(element3, "description"), element4);
        PomDb.copyValue(XmlUtil.getFirstElement(element3, "url"), element4);
        PomDb.copyArtifactId(element3, element4);
        Element element5 = XmlUtil.getFirstElement(element3, "parent");
        PomDb.copyArtifactId(element5, PomDb.copyNode(element5, element4));
        Element element6 = XmlUtil.getFirstElement(element3, "licenses");
        Element element7 = PomDb.copyNode(element6, element4);
        for (Element element22 : XmlUtil.getChildElements(element6, "license")) {
            object = PomDb.copyNode(element22, element7);
            PomDb.copyValue(XmlUtil.getFirstElement(element22, "name"), (Element)object);
            PomDb.copyValue(XmlUtil.getFirstElement(element22, "url"), (Element)object);
        }
        Element element8 = XmlUtil.getFirstElement(element3, "properties");
        element22 = PomDb.copyNode(element8, element4);
        for (Element element9 : XmlUtil.getChildElements(element8)) {
            PomDb.copyValue(element9, element22);
        }
        object = XmlUtil.getFirstElement(element3, "dependencyManagement");
        PomDb.copyDependencies((Element)object, PomDb.copyNode((Element)object, element4));
        PomDb.copyDependencies(element3, element4);
    }

    private static Element copyNode(Element element, Element element2) {
        Element element3 = null;
        if (element != null) {
            element3 = element2.getOwnerDocument().createElement(element.getNodeName());
            element2.appendChild(element3);
        }
        return element3;
    }

    private static Element copyValue(Element element, Element element2) {
        Element element3 = null;
        if (element != null) {
            element3 = PomDb.copyNode(element, element2);
            XmlUtil.setElementValue(element3, XmlUtil.getElementValue(element));
        }
        return element3;
    }

    private static void copyArtifactId(Element element, Element element2) {
        if (element != null) {
            PomDb.copyValue(XmlUtil.getFirstElement(element, "groupId"), element2);
            PomDb.copyValue(XmlUtil.getFirstElement(element, "artifactId"), element2);
            PomDb.copyValue(XmlUtil.getFirstElement(element, "version"), element2);
            PomDb.copyValue(XmlUtil.getFirstElement(element, "packaging"), element2);
        }
    }

    private static void copyDependencies(Element element, Element element2) {
        if (element != null) {
            Element element3 = XmlUtil.getFirstElement(element, "dependencies");
            Element element4 = PomDb.copyNode(element3, element2);
            for (Element element5 : XmlUtil.getChildElements(element3, "dependency")) {
                PomDb.copyDependency(element5, PomDb.copyNode(element5, element4));
            }
        }
    }

    private static void copyDependency(Element element, Element element2) {
        if (element != null) {
            PomDb.copyArtifactId(element, element2);
            PomDb.copyValue(XmlUtil.getFirstElement(element, "scope"), element2);
            PomDb.copyValue(XmlUtil.getFirstElement(element, "optional"), element2);
            Element element3 = XmlUtil.getFirstElement(element, "exclusions");
            Element element4 = PomDb.copyNode(element3, element2);
            for (Element element5 : XmlUtil.getChildElements(element3, "exclusion")) {
                PomDb.copyArtifactId(element5, PomDb.copyNode(element5, element4));
            }
        }
    }
}

