/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.bridges.maven.Artifact;
import MITI.bridges.maven.ArtifactId;
import MITI.bridges.maven.ArtifactRef;
import MITI.bridges.maven.PomDb;
import MITI.util.file.FileCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;

public class MavenArtifacts {
    private static FileCache<MavenArtifacts> cache = new FileCache();
    private ConcurrentSkipListMap<ArtifactId, Artifact> artifacts = new ConcurrentSkipListMap();
    private static final String VARIABLE_PREFIX = "${";

    public static MavenArtifacts get(File file) {
        MavenArtifacts mavenArtifacts = cache.get(file);
        if (mavenArtifacts == null) {
            mavenArtifacts = new MavenArtifacts();
            PomDb.load(file, mavenArtifacts);
            cache.add(file, mavenArtifacts);
        }
        return mavenArtifacts;
    }

    public Artifact get(ArtifactId artifactId) {
        return this.artifacts.get(artifactId);
    }

    public Collection<Artifact> list() {
        return this.artifacts.values();
    }

    public void put(Artifact artifact) {
        if (artifact != null) {
            this.artifacts.put(artifact, artifact);
        }
    }

    public void resolve(ArtifactRef artifactRef, Artifact artifact) {
        artifactRef.getId().setGroup(this.resolveVariable(artifactRef.getId().getGroup(), artifact));
        artifactRef.getId().setName(this.resolveVariable(artifactRef.getId().getName(), artifact));
        artifactRef.getId().setVersion(this.resolveVariable(artifactRef.getId().getVersion(), artifact));
        artifactRef.addExclusions(this.getManagedDependency(artifactRef, artifact));
    }

    public Collection<ArtifactRef> getDependencies(Artifact artifact) {
        ArrayList<ArtifactRef> arrayList = new ArrayList<ArtifactRef>();
        Artifact artifact2 = artifact;
        while (artifact2 != null) {
            arrayList.addAll(artifact2.getDependencies());
            artifact2 = artifact2.getParentId() != null ? this.artifacts.get(artifact2.getParentId()) : null;
        }
        return arrayList;
    }

    public ArtifactRef getManagedDependency(ArtifactRef artifactRef, Artifact artifact) {
        Artifact artifact2 = artifact;
        while (artifact2 != null) {
            for (ArtifactRef artifactRef2 : artifact2.getManagementDependencies()) {
                if (artifactRef2.isImport() || ArtifactId.NO_VERSION.compare(artifactRef.getId(), artifactRef2.getId()) != 0) continue;
                return artifactRef2;
            }
            artifact2 = artifact2.getParentId() != null ? this.artifacts.get(artifact2.getParentId()) : null;
        }
        artifact2 = artifact;
        while (artifact2 != null) {
            for (ArtifactRef artifactRef2 : artifact2.getManagementDependencies()) {
                ArtifactRef artifactRef3;
                if (!artifactRef2.isImport() || (artifactRef3 = this.getManagedDependency(artifactRef, this.artifacts.get(artifactRef2.getId()))) == null) continue;
                return artifactRef3;
            }
            artifact2 = artifact2.getParentId() != null ? this.artifacts.get(artifact2.getParentId()) : null;
        }
        return null;
    }

    private String resolveVariable(String string, Artifact artifact) {
        int n = 0;
        while ((n = string.indexOf(VARIABLE_PREFIX, n)) != -1) {
            int n2 = string.indexOf("}", n);
            if (n2 > n) {
                String string2 = string.substring(n + 2, n2);
                String string3 = "";
                if ("project.version".equals(string2) || "pom.version".equals(string2) || "version".equals(string2)) {
                    string3 = artifact.getVersion();
                } else if ("project.groupId".equals(string2) || "pom.groupId".equals(string2) || "groupId".equals(string2)) {
                    string3 = artifact.getGroup();
                } else {
                    Artifact artifact2 = artifact;
                    while (artifact2 != null) {
                        String string4 = artifact2.getArtifactProperties().get(string2);
                        if (string4 != null) {
                            string3 = string4;
                            break;
                        }
                        if ((artifact2 = artifact2.getParentId() != null ? this.artifacts.get(artifact2.getParentId()) : null) != null) continue;
                        string3 = string2;
                    }
                }
                string = string.replace(VARIABLE_PREFIX + string2 + "}", string3);
                continue;
            }
            n = n2;
        }
        return string;
    }
}

