/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.bridges.maven.ArtifactId;
import java.util.SortedSet;
import java.util.TreeSet;

public class ArtifactRef {
    private ArtifactId id;
    private String scope;
    private TreeSet<ArtifactId> exclusions;

    public ArtifactRef(ArtifactId artifactId, String string) {
        this.id = artifactId;
        this.scope = string != null ? string : "";
        this.exclusions = new TreeSet();
    }

    public ArtifactRef(ArtifactRef artifactRef) {
        this.id = new ArtifactId(artifactRef.getId());
        this.scope = artifactRef.scope;
        this.exclusions = new TreeSet<ArtifactId>((SortedSet<ArtifactId>)artifactRef.exclusions);
    }

    public ArtifactId getId() {
        return this.id;
    }

    public String getScope() {
        return this.scope;
    }

    protected void setScope(String string) {
        this.scope = string;
    }

    public void addExclusion(ArtifactId artifactId) {
        this.exclusions.add(artifactId);
    }

    public void addExclusions(ArtifactRef artifactRef) {
        if (artifactRef != null) {
            this.exclusions.addAll(artifactRef.exclusions);
        }
    }

    public boolean isImport() {
        return "import".equals(this.scope);
    }

    public boolean isIncluded() {
        return !"junit".equals(this.id.getName()) && !"provided".equals(this.scope) && !"test".equals(this.scope) && !"system".equals(this.scope) && !"import".equals(this.scope);
    }

    public boolean isExcluded(ArtifactId artifactId) {
        for (ArtifactId artifactId2 : this.exclusions) {
            if (!artifactId2.getGroup().equals(artifactId.getGroup()) && !artifactId2.getGroup().equals("*") || !artifactId2.getName().equals(artifactId.getName()) && !artifactId2.getName().equals("*")) continue;
            return true;
        }
        return false;
    }
}

