/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.mimb.driver.operation.GenericOperationOption;
import MITI.util.Pair;
import MITI.util.StringUtil;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class MimbGenericOperationResult {
    private static final String XML_NAME = "name";
    private static final String XML_STATUS = "status";
    private static final String XML_MIMBOBJECTID = "mimbObjectId";
    private static final String XML_MMOBJECTID = "mmObjectId";
    private static final String XML_KEY = "key";
    private static final String XML_VALUE_ELEMENT = "Value";
    private static final String XML_VALUE = "value";
    private static final String XML_OPTION = "Option";
    private String name;
    private Status status;
    private String[] mimbObjectId;
    private String mmObjectId;
    private List<GenericOperationOption> resultOptions = new LinkedList<GenericOperationOption>();

    public MimbGenericOperationResult(String[] stringArray, String string, String string2, Status status) {
        this.name = string2;
        this.status = status;
        this.mimbObjectId = stringArray;
        this.mmObjectId = string;
    }

    public String[] getMimbObjectId() {
        return this.mimbObjectId;
    }

    public String getMmObjectId() {
        return this.mmObjectId;
    }

    public List<GenericOperationOption> getOptions() {
        return Collections.unmodifiableList(this.resultOptions);
    }

    public void addOption(GenericOperationOption genericOperationOption) {
        if (genericOperationOption != null) {
            this.resultOptions.add(genericOperationOption);
        }
    }

    public void addOption(String string, List<Pair<String, String>> list) {
        if (string != null && list != null) {
            GenericOperationOption genericOperationOption = new GenericOperationOption(string);
            for (Pair<String, String> pair : list) {
                genericOperationOption.addValue((String)pair.obj1, (String)pair.obj2);
            }
            this.addOption(genericOperationOption);
        }
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public static MimbGenericOperationResult parse(String string) {
        MimbGenericOperationResult mimbGenericOperationResult = null;
        Element element = XmlUtil.parseString(string);
        String string2 = element.getAttribute(XML_NAME);
        String string3 = element.getAttribute(XML_STATUS);
        String string4 = element.getAttribute(XML_MIMBOBJECTID);
        String string5 = element.getAttribute(XML_MMOBJECTID);
        if (string2 == null || string2.isEmpty() || string3 == null || string3.isEmpty() || string5 == null || string5.isEmpty()) {
            return mimbGenericOperationResult;
        }
        mimbGenericOperationResult = new MimbGenericOperationResult(string4.split("\u2028"), string5, string2, Status.valueOf(string3));
        for (Element element2 : XmlUtil.getChildElements(element)) {
            GenericOperationOption genericOperationOption = new GenericOperationOption(element2.getAttribute(XML_NAME));
            for (Element element3 : XmlUtil.getChildElements(element2)) {
                genericOperationOption.addValue(element3.getAttribute(XML_KEY), element3.getAttribute(XML_VALUE));
            }
            mimbGenericOperationResult.addOption(genericOperationOption);
        }
        return mimbGenericOperationResult;
    }

    private String serialize() {
        Element element = XmlUtil.parseString("<MimbGenericOperationResult/>");
        element.setAttribute(XML_NAME, this.name);
        element.setAttribute(XML_STATUS, this.status.name());
        element.setAttribute(XML_MIMBOBJECTID, StringUtil.join(this.mimbObjectId, "\u2028"));
        element.setAttribute(XML_MMOBJECTID, this.mmObjectId);
        for (GenericOperationOption genericOperationOption : this.resultOptions) {
            Element element2 = element.getOwnerDocument().createElement(XML_OPTION);
            element.appendChild(element2);
            element2.setAttribute(XML_NAME, genericOperationOption.getName());
            for (Map.Entry<String, String> entry : genericOperationOption.getValues().entrySet()) {
                Element element3 = element.getOwnerDocument().createElement(XML_VALUE_ELEMENT);
                element2.appendChild(element3);
                element3.setAttribute(XML_KEY, entry.getKey());
                element3.setAttribute(XML_VALUE, entry.getValue());
            }
        }
        return XmlUtil.getString(element);
    }

    public void send(File file) {
        String string = this.serialize();
        File file2 = new File(file, this.getMmObjectId() + ".tmp");
        FileUtil.writeContent(file2, string, FileUtil.UTF8);
        FileUtil.move(file2, new File(file, this.getMmObjectId()));
    }

    public static enum Status {
        SUCCESSFUL("Successful"),
        FAILED("Failed"),
        UP_TO_DATE("Uptodate");

        String label;

        private Status(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

