/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.util.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class DataQualityQueryOptions {
    private static final String TYPE = "Type";
    private static final String QUERY = "Query";
    private String query;
    private DataQualityQueryType type;

    public DataQualityQueryOptions(String string, DataQualityQueryType dataQualityQueryType) {
        this.query = string;
        this.type = dataQualityQueryType;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public DataQualityQueryType getType() {
        return this.type;
    }

    public void setType(DataQualityQueryType dataQualityQueryType) {
        this.type = dataQualityQueryType;
    }

    public static DataQualityQueryOptions parse(String string) {
        if (string == null || !string.startsWith("<")) {
            return new DataQualityQueryOptions(string, DataQualityQueryType.getQueryType(null));
        }
        Element element = XmlUtil.parseString(string);
        return new DataQualityQueryOptions(element.getAttribute(QUERY), DataQualityQueryType.getQueryType(element.getAttribute(TYPE)));
    }

    public String serialize() {
        Element element = XmlUtil.parseString("<queryOptions/>");
        element.setAttribute(QUERY, this.query != null ? this.query : "");
        element.setAttribute(TYPE, this.type != null ? this.type.name : "");
        return XmlUtil.getString(element);
    }

    public static enum DataQualityQueryType {
        TOP("top"),
        RANDOM("random"),
        CUSTOM("custom");

        String name;
        private static Map<String, DataQualityQueryType> nameToQueryType;

        private DataQualityQueryType(String string2) {
            this.name = string2;
        }

        public static DataQualityQueryType getQueryType(String string) {
            if (nameToQueryType == null) {
                nameToQueryType = new HashMap<String, DataQualityQueryType>();
                for (DataQualityQueryType dataQualityQueryType : DataQualityQueryType.values()) {
                    nameToQueryType.put(dataQualityQueryType.name, dataQualityQueryType);
                }
            }
            return nameToQueryType.get(string);
        }
    }
}

