/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridge;

import MITI.MIRException;
import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridge.BridgeOptions;
import MITI.bridges.javabridge.Browse;
import MITI.bridges.javabridge.DualModelImport;
import MITI.bridges.javabridge.GenericOperation;
import MITI.bridges.javabridge.ModelExport;
import MITI.bridges.javabridge.ModelImport;
import MITI.bridges.javabridge.ModelStatistics;
import MITI.bridges.javabridge.ModelTest;
import MITI.bridges.javabridge.MultiModelExport;
import MITI.bridges.javabridge.MultiModelImport;
import MITI.bridges.javabridgeinterface.AccessHistoryOptions;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbGenericKeyValueOptions;
import MITI.bridges.javabridgeinterface.MimbGenericOperationOptions;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.mimb.driver.operation.GenericOperationOption;
import MITI.mimb.message.XmlUtil;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.statistics.ProfileStatistics;
import MITI.util.Encryption;
import MITI.util.MiscParams;
import MITI.util.Shutdown;
import MITI.util.VersionInfo;
import MITI.util.VersionNumber;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.HiddenOption;
import MITI.util.cmd.Option;
import MITI.util.cmd.RepeatableOption;
import MITI.util.cmd.TypedOption;
import MITI.util.config.MimbConfiguration;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import MITI.util.memory.MemMonitor;
import MITI.util.memory.MemoryUnit;
import MITI.util.os.MachineInfo;
import MITI.util.text.BridgeOptionLiteral;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class JavaBridge {
    private static HelpOption helpOption = new HelpOption();
    private static Option mimbXmlOption = new Option(new String[]{"-r", "--runXml"}, MBCM.PARAM_DESCR_R.getText(), TypedOption.Type.FILE);
    private static Option mirXmlOption = new Option(new String[]{"-f", "--mirFile"}, MBCM.PARAM_DESCR_F.getText());
    private static Option bridgeClassOption = new Option(new String[]{"-c", "--bridgeClass"}, MBCM.PARAM_DESCR_C.getText());
    private static Option bridgeCommandOption = new Option(new String[]{"-x", "--executeCommand"}, MBCM.PARAM_DESCR_X.getText());
    private static Option bridgeBrowsingParameterIdOption = new Option(new String[]{"-b", "--browseParameter"}, MBCM.PARAM_DESCR_B.getText());
    private static RepeatableOption bridgeParameterOption = new RepeatableOption(new String[]{"-o", "--bridgeOption"}, MBCM.PARAM_DESCR_O.getText());
    private static Option validationLevelOption = new Option(new String[]{"-v", "--validation"}, MBCM.PARAM_DESCR_V.getText());
    private static Option resetCacheOption = new Option(new String[]{"-rc", "--resetCache"}, MBCM.PARAM_DESCR_RC.getText(), TypedOption.Type.INT);
    private static HiddenOption shutdownOption = new HiddenOption(new String[]{"-s", "--shutdown"});
    private static MIRMetadataOrigin cppOrigin = new MIRMetadataOrigin();
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, mimbXmlOption, mirXmlOption, bridgeClassOption, bridgeCommandOption, bridgeBrowsingParameterIdOption, bridgeParameterOption, validationLevelOption, resetCacheOption, shutdownOption};

    private boolean runTest(BridgeOptions bridgeOptions) throws MIRException {
        if (this instanceof ModelTest) {
            return ((ModelTest)((Object)this)).test(bridgeOptions);
        }
        return true;
    }

    private boolean isMultiModelImport(BridgeOptions bridgeOptions) throws MIRException {
        if (this instanceof DualModelImport) {
            return ((DualModelImport)((Object)this)).isMultiModel(bridgeOptions);
        }
        return this instanceof MultiModelImport;
    }

    private void runImport(File file, BridgeOptions bridgeOptions) throws MIRException {
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        File file2 = file;
        MIRModel mIRModel = null;
        if (this.isMultiModelImport(bridgeOptions)) {
            if (file.isDirectory()) {
                file2 = MIRMixManager.getMultiModelFile(file);
            }
            mIRModel = ((MultiModelImport)((Object)this)).run(bridgeOptions, mIRMixManager);
        } else if (this instanceof ModelImport) {
            if (file.isDirectory()) {
                file2 = MIRMixManager.getModelFile(file);
            }
            mIRModel = ((ModelImport)((Object)this)).run(bridgeOptions);
        } else {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "import"));
        }
        if (mIRModel == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        String string = this.getMiscellaneousOption(bridgeOptions, "-model.name");
        if (string != null) {
            mIRModel.setName(string);
        }
        mIRMixManager.writeFile(file2, mIRModel);
        this.printStatistics(mIRModel, mIRMixManager);
    }

    private void printStatistics(MIRModel mIRModel, MIRMixManager mIRMixManager) throws MIRException {
        MIRMixCache mIRMixCache = new MIRMixCache(mIRMixManager);
        ProfileStatistics profileStatistics = new ProfileStatistics(mIRModel, mIRMixCache);
        profileStatistics.compute();
        if (this instanceof ModelStatistics) {
            ((ModelStatistics)((Object)this)).printStatistics(profileStatistics);
        } else {
            profileStatistics.print(MIRLogger.getLogger());
        }
    }

    private void runExport(File file, BridgeOptions bridgeOptions) throws MIRException {
        MIRModel mIRModel;
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        File file2 = file;
        if (file.isDirectory() && !(file2 = MIRMixManager.getMultiModelFile(file)).isFile() && !(file2 = MIRMixManager.getModelFile(file)).isFile()) {
            file2 = file;
        }
        if ((mIRModel = mIRMixManager.readFile(file2)) == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        if (mIRModel instanceof MIRStoreModel && this instanceof ModelExport) {
            ((ModelExport)((Object)this)).run((MIRStoreModel)mIRModel, bridgeOptions, mIRMixManager);
        } else if (mIRModel instanceof MIRDirectoryStructureModel && this instanceof MultiModelExport) {
            ((MultiModelExport)((Object)this)).run((MIRDirectoryStructureModel)mIRModel, bridgeOptions, mIRMixManager);
        } else {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "export"));
        }
    }

    private void runBrowse(File file, BridgeOptions bridgeOptions, String string) throws MIRException {
        if (!(this instanceof Browse)) {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "browse"));
        }
        MIRMixManager mIRMixManager = new MIRMixManager(file, 2);
        File file2 = file.isDirectory() ? MIRMixManager.getModelFile(file) : file;
        MIRDirectoryStructureModel mIRDirectoryStructureModel = ((Browse)((Object)this)).browse(string, bridgeOptions);
        if (mIRDirectoryStructureModel == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        mIRMixManager.writeFile(file2, mIRDirectoryStructureModel);
        this.printStatistics(mIRDirectoryStructureModel, mIRMixManager);
    }

    private void runGenericOperation(BridgeOptions bridgeOptions, MimbGenericOperationOptions mimbGenericOperationOptions) throws MIRException {
        if (!(this instanceof GenericOperation)) {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "importGenericOperation"));
        }
        ((GenericOperation)((Object)this)).runGenericOperation(bridgeOptions, mimbGenericOperationOptions);
    }

    public static MIRMetadataOrigin generateMetadataOrigin(Class<? extends JavaBridge> clazz) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setFrom(cppOrigin);
        VersionInfo versionInfo = VersionInfo.loadMitiJar(clazz);
        if (versionInfo != null) {
            mIRMetadataOrigin.setBridgeName(cppOrigin.getBridgeName() + "; JAR " + versionInfo.getComponent());
            mIRMetadataOrigin.setBridgeVersion(cppOrigin.getBridgeVersion() + "; JAR " + versionInfo.getVersionString() + " build " + versionInfo.getDate());
        }
        return mIRMetadataOrigin;
    }

    public MIRMetadataOrigin generateMetadataOrigin() {
        return JavaBridge.generateMetadataOrigin(this.getClass());
    }

    private static void printUsage() {
        System.out.println(MBCM.TITLE1.getText());
        System.out.println(MBCM.TITLE2.getText());
        CommandLineParser.printUsage(options, System.out);
    }

    private static void printJavaInfo(VersionNumber versionNumber) {
        MBCM.MSG_STARTING_JVM.log(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions());
        VersionNumber versionNumber2 = VersionNumber.parse(System.getProperty("java.version"));
        if (versionNumber2.compareTo(versionNumber) < 0) {
            MBCM.MINIMUM_JAVA_VERSION_ERROR.log(versionNumber2.toString(), versionNumber.toString());
            System.exit(1);
        }
    }

    public static void printVersionInfos(MIRLogger mIRLogger) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        File file = new File(MimbConfiguration.getMimbHome(), "java");
        for (String string : System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (!string.endsWith(".jar") || !FileUtil.isSubPath(file, string)) continue;
            try (JarFile jarFile = new JarFile(string);){
                String string2;
                VersionInfo versionInfo = VersionInfo.loadManifest(jarFile.getManifest());
                if (versionInfo == null || versionInfo.getComponent() == null) continue;
                String string3 = versionInfo.getComponent() + ".jar";
                String string4 = "";
                if (versionInfo.getVersionString() != null) {
                    string4 = string4 + versionInfo.getVersionString();
                    if (versionInfo.getDate() != null) {
                        string4 = string4 + " - " + versionInfo.getDate().substring(0, versionInfo.getDate().length() - 9);
                    }
                }
                string2 = (string2 = (String)treeMap.get(string4)) == null ? string3 : string2 + ", " + string3;
                treeMap.put(string4, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String string : treeMap.keySet()) {
            String string5 = (String)treeMap.get(string);
            if (string.isEmpty()) {
                BLIB.MITI_COMPONENT_EMPTY_BUILD_VERSION.log(mIRLogger, string5);
                continue;
            }
            BLIB.MITI_COMPONENT_BUILD_VERSION.log(mIRLogger, string, string5);
        }
    }

    protected String getMiscellaneousOption(BridgeOptions bridgeOptions, String string) {
        BridgeOptionLiteral bridgeOptionLiteral = new BridgeOptionLiteral("Miscellaneous", BridgeOptionLiteral.BridgeOptionType.STRING, null, null, null);
        if (bridgeOptions.hasOption(bridgeOptionLiteral)) {
            String string2 = bridgeOptions.getValue(bridgeOptionLiteral);
            return MiscParams.parse(string2).getValue(string);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        MIRLogger.init(new XmlLogEventHandler(System.err));
        String string = null;
        String string2 = "Import";
        String string3 = null;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        File file = null;
        VersionNumber versionNumber = VersionNumber.parse("1.5");
        MimbGenericOperationOptions mimbGenericOperationOptions = null;
        try {
            CommandLineParser.process(stringArray, 0, options);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            JavaBridge.printJavaInfo(versionNumber);
            JavaBridge.printUsage();
            JavaBridge.exit(1, null);
            return;
        }
        if (helpOption.isSet()) {
            JavaBridge.printUsage();
            JavaBridge.exit(0, null);
            return;
        }
        if (shutdownOption.isSet()) {
            Shutdown.listen(shutdownOption.getFileValue());
        }
        if (mimbXmlOption.isSet()) {
            try {
                Object object4;
                String string4;
                Object object5;
                String string5;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder object42 = documentBuilderFactory.newDocumentBuilder();
                object3 = object42.parse(mimbXmlOption.getFileValue());
                object2 = object3.getDocumentElement();
                string2 = object2.getNodeName();
                string = object2.getAttribute("bridge").replace("/", ".");
                file = new File(object2.getAttribute("file"));
                object = object2.getAttribute("validationLevel");
                if (object != null && ((String)object).length() > 0) {
                    MIRValidationLevel.Enum enum_ = MIRValidationLevel.getByName((String)object);
                    MIRValidationLevel.setDefaultLevel(enum_);
                }
                string3 = object2.getAttribute("browseParameter");
                if (object2.hasAttribute("javaVersion")) {
                    versionNumber = VersionNumber.parse(object2.getAttribute("javaVersion"));
                }
                if ((string5 = object2.getAttribute("resetCache")) != null && string5.length() > 0) {
                    int n = Integer.parseInt(string5);
                    if ((n & 1) == 1) {
                        MIMBCache.setResetXmiCache(true);
                    }
                    if ((n & 2) == 2) {
                        MIMBCache.setResetNativeCache(true);
                    }
                }
                cppOrigin.setVendorName(object2.getAttribute("vendorName"));
                cppOrigin.setToolName(object2.getAttribute("toolName"));
                cppOrigin.setToolVersion(object2.getAttribute("toolVersion"));
                cppOrigin.setFormatVersion(object2.getAttribute("formatVersion"));
                cppOrigin.setBridgeName(object2.getAttribute("bridgeName"));
                cppOrigin.setBridgeVersion(object2.getAttribute("bridgeVersion"));
                NodeList nodeList = object2.getElementsByTagName("BridgeParameter");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    block45: {
                        object5 = (Element)nodeList.item(i);
                        string4 = object5.getAttribute("name");
                        object4 = null;
                        try {
                            object4 = object5.getTextContent();
                        }
                        catch (AbstractMethodError abstractMethodError) {
                            Node node = object5.getFirstChild();
                            if (node == null) break block45;
                            object4 = node.getNodeValue();
                        }
                    }
                    if ("true".equals(object5.getAttribute("encoded"))) {
                        object4 = Encryption.decrypt((String)object4);
                    }
                    hashMap.put(string4, (String)object4);
                }
                Element element = MITI.util.XmlUtil.getFirstElement((Element)object2, "GenericOperation");
                if (element != null) {
                    object5 = element.getAttribute("path");
                    string4 = element.getAttribute("name");
                    mimbGenericOperationOptions = "DataQuality".equals(string4) ? new DataQualityOptions() : ("AccessHistory".equals(string4) ? new AccessHistoryOptions() : new MimbGenericKeyValueOptions(string4));
                    object4 = XmlUtil.getGenericOperationOptions(element);
                    mimbGenericOperationOptions.setOutputPath((String)object5);
                    mimbGenericOperationOptions.valueOf((List<GenericOperationOption>)object4);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(exception, exception.toString());
                JavaBridge.exit(-1, null);
            }
        } else {
            string = bridgeClassOption.getStringValue();
            string2 = bridgeCommandOption.getStringValue();
            string3 = bridgeBrowsingParameterIdOption.getStringValue();
            if (mirXmlOption.isSet()) {
                file = mirXmlOption.getFileValue();
            }
            for (String string6 : bridgeParameterOption.getValues()) {
                int n = string6.indexOf("=");
                if (n < 1) {
                    MBCM.INVALID_PARAM_FORMAT.log(string6);
                    JavaBridge.exit(-1, null);
                    return;
                }
                object2 = string6.substring(0, n).trim();
                object = string6.substring(n + 1).trim();
                hashMap.put(object2, (String)object);
            }
            if (validationLevelOption.isSet()) {
                Object object8 = MIRValidationLevel.getByName(validationLevelOption.getStringValue());
                MIRValidationLevel.setDefaultLevel(object8);
            }
            if (resetCacheOption.isSet()) {
                int n = resetCacheOption.getIntValue();
                if ((n & 1) == 1) {
                    MIMBCache.setResetXmiCache(true);
                }
                if ((n & 2) == 2) {
                    MIMBCache.setResetNativeCache(true);
                }
            }
        }
        if (string == null) {
            MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("bridgeClass");
            JavaBridge.exit(-1, null);
            return;
        }
        if (string2 == null) {
            MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("command");
            JavaBridge.exit(-1, null);
            return;
        }
        JavaBridge.printJavaInfo(versionNumber);
        MemMonitor memMonitor = MemMonitor.start();
        Object var9_17 = null;
        try {
            MBCM.DBG_LOADING_JAVA_BRIDGE_CLASS.log(string);
            Class<?> clazz = Class.forName(string);
            try {
                JavaBridge.printVersionInfos(MIRLogger.getLogger());
                object3 = (JavaBridge)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                object2 = new BridgeOptions();
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((BridgeOptions)object2).addOption((String)entry.getKey(), (String)entry.getValue());
                }
                if (string2.equalsIgnoreCase("Import")) {
                    if (file == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("file");
                        JavaBridge.exit(-1, memMonitor);
                        return;
                    }
                    super.runImport(file, (BridgeOptions)object2);
                } else if (string2.equalsIgnoreCase("Export")) {
                    if (file == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("file");
                        JavaBridge.exit(-1, memMonitor);
                        return;
                    }
                    super.runExport(file, (BridgeOptions)object2);
                } else if (string2.equalsIgnoreCase("Test")) {
                    if (!super.runTest((BridgeOptions)object2)) {
                        JavaBridge.exit(1, memMonitor);
                        return;
                    }
                } else if (string2.equalsIgnoreCase("Browse")) {
                    if (file == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log("file");
                        JavaBridge.exit(-1, memMonitor);
                        return;
                    }
                    super.runBrowse(file, (BridgeOptions)object2, string3);
                } else if ("ImportGenericOperation".equalsIgnoreCase(string2) || "DataQuality".equalsIgnoreCase(string2)) {
                    super.runGenericOperation((BridgeOptions)object2, mimbGenericOperationOptions);
                }
            }
            catch (Error | Exception throwable) {
                MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(throwable, throwable.toString());
                JavaBridge.exit(1, memMonitor);
            }
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            MBCM.COULD_NOT_LOAD_JAVA_CLASS.log(string);
            MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(throwable, throwable.toString());
            System.exit(1);
        }
        JavaBridge.exit(0, memMonitor);
    }

    private static void exit(int n, MemMonitor memMonitor) {
        if (memMonitor != null) {
            memMonitor.stop();
            if (n == 0 && memMonitor.hasData()) {
                MBCM.MEMORY_USAGE_REPORT.log(MemoryUnit.getJvmString(memMonitor.getMaxCommittedMemory()), MemoryUnit.getJvmString(memMonitor.getMaxUsedMemory()), MemoryUnit.getJvmString(memMonitor.getRecommendedMemory()));
            }
        }
        System.exit(n);
    }
}

