/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridge;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.csv.SimpleCsvOptions;
import MITI.util.csv.SimpleCsvReader;
import MITI.util.csv.SimpleCsvWriter;
import MITI.util.text.BridgeOptionLiteral;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BridgeOptions {
    private HashMap<String, String> options = new HashMap();

    protected BridgeOptions addOption(String string, String string2) {
        this.options.put(string, string2 != null ? string2 : "");
        return this;
    }

    public BridgeOptions addOption(BridgeOptionLiteral bridgeOptionLiteral, String string) {
        return this.addOption(bridgeOptionLiteral.getParameterId(), string);
    }

    public boolean hasOption(BridgeOptionLiteral bridgeOptionLiteral) {
        return this.options.containsKey(bridgeOptionLiteral.getParameterId());
    }

    public boolean hasValue(BridgeOptionLiteral bridgeOptionLiteral) {
        return !this.getValue(bridgeOptionLiteral.getParameterId()).isEmpty();
    }

    public String getValue(BridgeOptionLiteral bridgeOptionLiteral) {
        return this.getValue(bridgeOptionLiteral.getParameterId());
    }

    public String getValue(BridgeOptionLiteral bridgeOptionLiteral, boolean bl) throws MIRException {
        String string = this.getValue(bridgeOptionLiteral.getParameterId());
        if (bl && string.isEmpty()) {
            throw new MIRException(MBCM.MISSING_REQUIRED_OPTION.getMessage(bridgeOptionLiteral.getText()));
        }
        return string;
    }

    public int getIntValue(BridgeOptionLiteral bridgeOptionLiteral) throws MIRException {
        try {
            return Integer.parseInt(this.getValue(bridgeOptionLiteral, false));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean getBooleanValue(BridgeOptionLiteral bridgeOptionLiteral) throws MIRException {
        return Boolean.parseBoolean(this.getValue(bridgeOptionLiteral, false));
    }

    private String getValue(String string) {
        String string2 = this.options.get(string);
        return string2 != null ? string2 : "";
    }

    public void save(File file, List<String> list) throws MIRException {
        try (SimpleCsvWriter simpleCsvWriter = new SimpleCsvWriter(file, SimpleCsvOptions.EXCEL_US);){
            for (Map.Entry<String, String> entry : this.options.entrySet()) {
                String string = entry.getKey();
                String string2 = list.contains(string) ? "***" : entry.getValue();
                simpleCsvWriter.printLine(string, string2);
            }
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    public void load(File file) throws MIRException {
        try (SimpleCsvReader simpleCsvReader = new SimpleCsvReader(file, SimpleCsvOptions.EXCEL_US);){
            simpleCsvReader.setColumnCount(2);
            List<String> list = null;
            while ((list = simpleCsvReader.getNextLine()) != null) {
                this.addOption(list.get(0), list.get(1));
            }
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }
}

