/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.DataStoreVersionInternal;
import MITI.bridges.datatypelib.DataTypeImportMapping;
import MITI.bridges.datatypelib.ExportDataTypeInfo;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.messages.MIRModelBridge.DTLIB;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRType;
import java.util.ArrayList;
import java.util.TreeSet;

class MIRDataStore {
    private static final MIRDerivedType undefinedTypeObj = new MIRDerivedType();
    private String type;
    TreeSet<String> aliases = null;
    private ArrayList<MIRDataStoreVersion> versions = new ArrayList();
    private static final String _UNDER = "_";

    String getType() {
        return this.type;
    }

    void addVersion(DataStoreVersionInternal dataStoreVersionInternal) {
        this.versions.add(dataStoreVersionInternal);
    }

    MIRDataStore(String string) {
        this.type = string;
    }

    void setAliases(TreeSet<String> treeSet) {
        this.aliases = treeSet;
    }

    TreeSet<String> getAliases() {
        return this.aliases;
    }

    int findMatchingVersionIndex(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        return MIRDataTypeLib.findClosestVersionIndex(this.versions, mIRDataStoreVersion);
    }

    int findMatchingImportVersionIndex(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        ArrayList<MIRDataStoreVersion> arrayList = new ArrayList<MIRDataStoreVersion>();
        int n = this.versions.size();
        for (int i = 0; i < n; ++i) {
            DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
            if (!dataStoreVersionInternal.hasImport()) continue;
            arrayList.add(dataStoreVersionInternal);
        }
        return MIRDataTypeLib.findClosestVersionIndex(arrayList, mIRDataStoreVersion);
    }

    int findMatchingExportVersionIndex(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        ArrayList<MIRDataStoreVersion> arrayList = new ArrayList<MIRDataStoreVersion>();
        int n = this.versions.size();
        for (int i = 0; i < n; ++i) {
            DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
            if (!dataStoreVersionInternal.hasExport()) continue;
            arrayList.add(dataStoreVersionInternal);
        }
        return MIRDataTypeLib.findClosestVersionIndex(arrayList, mIRDataStoreVersion);
    }

    MIRDataStoreVersion getDataStoreVersion(int n) {
        MIRDataStoreVersion mIRDataStoreVersion = null;
        if (n >= 0 && n < this.versions.size()) {
            mIRDataStoreVersion = this.versions.get(n);
        }
        return mIRDataStoreVersion;
    }

    private DataTypeImportMapping findImportMapping(int n, String string) {
        if (!MIRDataTypeLib.isEmpty(string)) {
            for (int i = n; i >= 0; --i) {
                DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
                DataTypeImportMapping dataTypeImportMapping = dataStoreVersionInternal.findImportMapping(string);
                if (dataTypeImportMapping == null) continue;
                return dataTypeImportMapping;
            }
        }
        return null;
    }

    private static void setTypeName(MIRType mIRType, String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (n != 0) {
            stringBuilder.append(_UNDER).append(n);
            if (n2 != 0) {
                stringBuilder.append(_UNDER).append(n2);
            }
        }
        mIRType.setName(stringBuilder.toString());
    }

    MIRDerivedType getImportType(int n, String string, int n2, int n3, String string2) {
        MIRDerivedType mIRDerivedType = new MIRDerivedType();
        mIRDerivedType.setNativeDataType(string2);
        mIRDerivedType.setLength(n2);
        mIRDerivedType.setScale(n3);
        DataTypeImportMapping dataTypeImportMapping = this.findImportMapping(n, string);
        if (dataTypeImportMapping != null) {
            String string3 = dataTypeImportMapping.getMirDatatype();
            String string4 = dataTypeImportMapping.getDisplayName();
            if (!MIRDataTypeLib.isEmpty(string4)) {
                mIRDerivedType.setName(string4);
            } else {
                MIRDataStore.setTypeName(mIRDerivedType, string, n2, n3);
            }
            mIRDerivedType.setDataType(string3);
            mIRDerivedType.setNativeLogicalDataType(dataTypeImportMapping.getDisplayName());
        } else {
            MIRDataStore.setTypeName(mIRDerivedType, "undefined", 0, 0);
            mIRDerivedType.setDataType("undefined");
        }
        return mIRDerivedType;
    }

    String getImportTypeName(int n, String string) {
        DataTypeImportMapping dataTypeImportMapping = this.findImportMapping(n, string);
        return dataTypeImportMapping != null ? dataTypeImportMapping.getMirDatatype() : "undefined";
    }

    private static ExportDataTypeInfo doSelectExportType(ExportDataTypeInfo exportDataTypeInfo, String string) {
        int n = exportDataTypeInfo.getOptionCount();
        for (int i = 0; i < n; ++i) {
            ExportDataTypeInfo exportDataTypeInfo2 = exportDataTypeInfo.getOptionAt(i);
            if (!string.equalsIgnoreCase(exportDataTypeInfo2.getNativeType())) continue;
            return exportDataTypeInfo2;
        }
        return null;
    }

    private ExportDataTypeInfo selectExportType(ExportDataTypeInfo exportDataTypeInfo, MIRType mIRType) {
        int n = exportDataTypeInfo.getOptionCount();
        if (n == 0) {
            return exportDataTypeInfo;
        }
        if (MIRDataTypeLib.isEmpty(mIRType.getNativeDataType())) {
            return exportDataTypeInfo;
        }
        String string = mIRType.getNativeDataType().trim();
        ExportDataTypeInfo exportDataTypeInfo2 = MIRDataStore.doSelectExportType(exportDataTypeInfo, string);
        if (exportDataTypeInfo2 == null) {
            string = MIRDataTypeLib.extractDataType(string).trim();
            exportDataTypeInfo2 = MIRDataStore.doSelectExportType(exportDataTypeInfo, string);
        }
        return exportDataTypeInfo2 != null ? exportDataTypeInfo2 : exportDataTypeInfo;
    }

    ExportDataTypeInfo getExportType(int n, MIRType mIRType, boolean bl) throws MIRException {
        if (mIRType == null) {
            mIRType = undefinedTypeObj;
        }
        ExportDataTypeInfo exportDataTypeInfo = null;
        for (int i = n; i >= 0; --i) {
            DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
            exportDataTypeInfo = dataStoreVersionInternal.findExportMapping(mIRType.getDataType());
            if (exportDataTypeInfo == null) continue;
            return bl ? this.selectExportType(exportDataTypeInfo, mIRType) : exportDataTypeInfo;
        }
        throw new MIRException(DTLIB.ERROR_EXPORT_MAPPING.getMessage(this.type, mIRType.getDataType()));
    }

    String getExportTypeName(int n, String string) throws MIRException {
        ExportDataTypeInfo exportDataTypeInfo = null;
        if (MIRDataTypeLib.isEmpty(string)) {
            string = undefinedTypeObj.getDataType();
        }
        for (int i = n; i >= 0; --i) {
            DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
            exportDataTypeInfo = dataStoreVersionInternal.findExportMapping(string);
            if (exportDataTypeInfo == null) continue;
            return exportDataTypeInfo.getStoreDatatype();
        }
        throw new MIRException(DTLIB.ERROR_EXPORT_MAPPING.getMessage(this.type, string));
    }

    void validate() throws MIRException {
        int n = this.versions.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DataStoreVersionInternal dataStoreVersionInternal = (DataStoreVersionInternal)this.versions.get(i);
            dataStoreVersionInternal.validate();
            int n3 = dataStoreVersionInternal.getExportMappingCount();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (n2 > 0 && n2 < MIRBaseTypeList.getMIRTypeCount()) {
            throw new MIRException(DTLIB.E_DATASTORE_MISSING_EXPORT_MIR_TYPES.getMessage(this.type));
        }
    }

    static {
        undefinedTypeObj.setDataType("undefined");
        undefinedTypeObj.setName("undefined");
    }
}

