/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.DataStoreVersionInternal;
import MITI.bridges.datatypelib.DataTypeImportMapping;
import MITI.bridges.datatypelib.ExportDataTypeInfo;
import MITI.bridges.datatypelib.MIRDTTool;
import MITI.bridges.datatypelib.MIRDataStore;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.DTLIB;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class MIRDTTools {
    private static final String TEXT_TRUE = "true";
    private static final String TAG_DATATYPE_IMPORT_MAPPING = "DataTypeImportMapping";
    private static final String TAG_DATATYPE_EXPORT_MAPPING = "DataTypeExportMapping";
    private static final String TAG_DATATYPE_EXPORT_OPTION = "DataTypeExportOption";
    private static final String TAG_STORE_DATATYPE = "storeDatatype";
    private static final String TAG_MIR_DATATYPE = "mirDatatype";
    private static final String TAG_NATIVE_TYPE = "nativeType";
    private static final String TAG_HAS_LENGTH = "hasLength";
    private static final String TAG_HAS_SCALE = "hasScale";
    private static final String TAG_MAJOR_VERSION = "MajorVersion";
    private static final String TAG_MINOR_VERSION = "MinorVersion";
    private static final String TAG_RELEASE_VERSION = "ReleaseVersion";
    private static final String TAG_IMPORT = "Import";
    private static final String TAG_EXPORT = "Export";
    private static final String TAG_TYPE = "type";
    private static final String TAG_DATASTORE_VERSION = "DataStoreVersion";
    private static final String TAG_TOOL_ID = "toolID";
    private static final String TAG_DATASTORE = "DataStore";
    private static final String TAG_ALIAS_DATASTORE = "AliasDataStore";
    private static final String TAG_TOOL = "Tool";
    private static final String TAG_TOOL_DATA = "toolData";
    private static final String TAG_DISPLAY_NAME = "displayName";
    private TreeMap<String, MIRDTTool> map = new TreeMap();
    private static MIRDTTools instance = null;
    private static final Pattern dotPattern = Pattern.compile("[.]");
    private static final String NAME_EXCLUDE = "MIRHummingbirdGenioDataType";

    private static int getIntAttribute(Element element, String string) {
        String string2;
        String string3 = "0";
        if (element != null && !MIRDataTypeLib.isEmpty(string) && !MIRDataTypeLib.isEmpty(string2 = element.getAttribute(string))) {
            string3 = string2.trim();
        }
        return Integer.parseInt(string3);
    }

    private static File getDatatypeXmlFolder() throws MIRException {
        MIRSetup mIRSetup = MIRSetup.getDefault();
        if (mIRSetup == null) {
            throw new MIRException(DTLIB.E_MIMB_HOME_NOT_SET.getMessage(new Object[0]));
        }
        File file = new File(mIRSetup.getConfDirectory(), "MIRDataTypeMapping");
        if (!file.exists()) {
            throw new MIRException(DTLIB.ERROR_READ_XML.getMessage(file.getAbsolutePath()));
        }
        return file;
    }

    static MIRDTTools getTools() throws MIRException {
        if (instance == null) {
            instance = new MIRDTTools(MIRDTTools.getDatatypeXmlFolder());
        }
        return instance;
    }

    private MIRDTTools(File file) throws MIRException {
        if (!file.isDirectory()) {
            throw new MIRException(DTLIB.E_NOT_A_FOLDER.getMessage(file.getAbsolutePath()));
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.getName() == null) {
                    return false;
                }
                String[] stringArray = dotPattern.split(file.getName());
                if (stringArray != null && stringArray.length >= 2) {
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    if ("xml".equalsIgnoreCase(string2)) {
                        return !MIRDTTools.NAME_EXCLUDE.equalsIgnoreCase(string);
                    }
                }
                return false;
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            String string = DTLIB.E_NO_XML_FILES.getMessage(file.getAbsolutePath());
            throw new MIRException(string);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.readFile(fileArray[i]);
        }
        if (this.map.size() <= 0) {
            throw new MIRException(DTLIB.E_NO_DATATYPES_IN_FOLDER.getMessage(file.getAbsolutePath()));
        }
    }

    private void readFile(File file) throws MIRException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MIRException(parserConfigurationException);
        }
        if (System.getProperty("mimb.debug") != null) {
            DTLIB.MSG_READING_FILE.log(file.getAbsolutePath());
        }
        Document document = null;
        try {
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            DTLIB.ERROR_READ_XML.log(sAXException.getMessage());
            return;
        }
        catch (IOException iOException) {
            DTLIB.ERROR_READ_XML.log(iOException.getMessage());
            return;
        }
        NodeList nodeList = document.getElementsByTagName(TAG_TOOL);
        int n = nodeList.getLength();
        if (n == 0) {
            DTLIB.MSG_NO_DATATYPES_IN_FILE.log(file.getAbsolutePath());
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            this.parseTool(element);
        }
    }

    private MIRDTTool getOrCreateTool(String string) {
        MIRDTTool mIRDTTool = this.map.get(string);
        if (mIRDTTool == null) {
            mIRDTTool = new MIRDTTool(string);
            this.map.put(string, mIRDTTool);
        }
        return mIRDTTool;
    }

    private void parseTool(Element element) {
        String string = element.getAttribute(TAG_TOOL_ID);
        boolean bl = "MIRGENERIC".equalsIgnoreCase(string);
        MIRDTTool mIRDTTool = this.getOrCreateTool(string);
        NodeList nodeList = element.getElementsByTagName(TAG_DATASTORE);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            MIRDataStore mIRDataStore = this.parseDataStore(bl, element2);
            mIRDTTool.addDataStore(mIRDataStore);
        }
    }

    private MIRDataStore parseDataStore(boolean bl, Element element) {
        Object object;
        Element element2;
        Object object2;
        String string = element.getAttribute(TAG_TYPE);
        String string2 = element.getAttribute(TAG_DISPLAY_NAME);
        MIRDataStore mIRDataStore = new MIRDataStore(string);
        NodeList nodeList = element.getElementsByTagName(TAG_ALIAS_DATASTORE);
        int n = nodeList.getLength();
        int n2 = 0;
        if (n > 0) {
            object2 = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            for (n2 = 0; n2 < n; ++n2) {
                element2 = (Element)nodeList.item(n2);
                object = element2.getAttribute(TAG_TYPE);
                ((TreeSet)object2).add(object);
            }
            mIRDataStore.setAliases((TreeSet<String>)object2);
        }
        object2 = element.getElementsByTagName(TAG_DATASTORE_VERSION);
        n = object2.getLength();
        for (n2 = 0; n2 < n; ++n2) {
            element2 = (Element)object2.item(n2);
            object = this.parseVersion(bl, string, element2);
            ((DataStoreVersionInternal)object).dataStoreDisplayName = string2;
            mIRDataStore.addVersion((DataStoreVersionInternal)object);
        }
        return mIRDataStore;
    }

    private DataStoreVersionInternal parseVersion(boolean bl, String string, Element element) {
        Object object;
        Object object2;
        int n = MIRDTTools.getIntAttribute(element, TAG_MAJOR_VERSION);
        int n2 = MIRDTTools.getIntAttribute(element, TAG_MINOR_VERSION);
        int n3 = MIRDTTools.getIntAttribute(element, TAG_RELEASE_VERSION);
        String string2 = element.getAttribute(TAG_DISPLAY_NAME);
        DataStoreVersionInternal dataStoreVersionInternal = new DataStoreVersionInternal(string, n, n2, n3);
        dataStoreVersionInternal.displayName = string2;
        NodeList nodeList = element.getElementsByTagName(TAG_IMPORT);
        if (nodeList != null && nodeList.getLength() > 0) {
            object2 = (Element)nodeList.item(0);
            object = object2.getElementsByTagName(TAG_DATATYPE_IMPORT_MAPPING);
            this.parseImportMappings(dataStoreVersionInternal, (NodeList)object);
        }
        if ((object2 = element.getElementsByTagName(TAG_EXPORT)) != null && object2.getLength() > 0) {
            object = (Element)object2.item(0);
            NodeList nodeList2 = object.getElementsByTagName(TAG_DATATYPE_EXPORT_MAPPING);
            this.parseExportMappings(bl, dataStoreVersionInternal, nodeList2);
        }
        return dataStoreVersionInternal;
    }

    private void parseImportMappings(DataStoreVersionInternal dataStoreVersionInternal, NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute(TAG_STORE_DATATYPE);
            String string2 = element.getAttribute(TAG_MIR_DATATYPE);
            String string3 = element.getAttribute(TAG_DISPLAY_NAME);
            DataTypeImportMapping dataTypeImportMapping = new DataTypeImportMapping(string, string2, string3);
            dataStoreVersionInternal.addImportMapping(dataTypeImportMapping);
        }
    }

    private void parseExportMappings(boolean bl, DataStoreVersionInternal dataStoreVersionInternal, NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute(TAG_STORE_DATATYPE);
            String string2 = element.getAttribute(TAG_MIR_DATATYPE);
            boolean bl2 = TEXT_TRUE.equalsIgnoreCase(element.getAttribute(TAG_HAS_LENGTH));
            boolean bl3 = TEXT_TRUE.equalsIgnoreCase(element.getAttribute(TAG_HAS_SCALE));
            ExportDataTypeInfo exportDataTypeInfo = new ExportDataTypeInfo(string2, string);
            exportDataTypeInfo.setHasLength(bl2);
            exportDataTypeInfo.setHasScale(bl3);
            if (!bl) {
                String string3 = element.getAttribute(TAG_TOOL_DATA);
                exportDataTypeInfo.setToolData(string3);
            }
            dataStoreVersionInternal.addExportMapping(exportDataTypeInfo);
            this.parseExportTypeOptions(bl, exportDataTypeInfo, element);
        }
    }

    private void parseExportTypeOptions(boolean bl, ExportDataTypeInfo exportDataTypeInfo, Element element) {
        NodeList nodeList = element.getElementsByTagName(TAG_DATATYPE_EXPORT_OPTION);
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(TAG_STORE_DATATYPE);
                String string2 = element2.getAttribute(TAG_NATIVE_TYPE);
                ExportDataTypeInfo exportDataTypeInfo2 = new ExportDataTypeInfo(exportDataTypeInfo.getMirDatatype(), string);
                String string3 = element2.getAttribute(TAG_HAS_LENGTH);
                boolean bl2 = false;
                bl2 = MIRDataTypeLib.isEmpty(string3) ? exportDataTypeInfo.getHasLength() : TEXT_TRUE.equalsIgnoreCase(string3);
                exportDataTypeInfo2.setHasLength(bl2);
                String string4 = element2.getAttribute(TAG_HAS_SCALE);
                boolean bl3 = false;
                bl3 = MIRDataTypeLib.isEmpty(string4) ? exportDataTypeInfo.getHasScale() : TEXT_TRUE.equalsIgnoreCase(string4);
                exportDataTypeInfo2.setHasScale(bl3);
                exportDataTypeInfo2.setNativeType(string2);
                if (!bl) {
                    String string5 = element2.getAttribute(TAG_TOOL_DATA);
                    exportDataTypeInfo2.setToolData(string5);
                }
                exportDataTypeInfo.addOption(exportDataTypeInfo2);
            }
        }
    }

    MIRDTTool findTool(String string) {
        return MIRDataTypeLib.isEmpty(string) ? null : this.map.get(string);
    }

    public Collection<MIRDTTool> getToolsCollection() {
        return this.map.values();
    }
}

