/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.database.filtering;

import MITI.bridges.database.filtering.DatabaseObjectIdentifier;
import MITI.bridges.database.filtering.FilterType;
import java.util.LinkedList;
import java.util.List;

public class FilterParameterParser {
    private static final String NOT_STR = "NOT";
    private static final String DELIMITER_SEMICOLON = ";";
    private static final String DELIMITER_COMMA = ",";
    private static final String DELIMITER_DOT = ".";
    protected static final String BRACKET_OPEN = "[";
    protected static final String BRACKET_CLOSE = "]";
    private List<DatabaseObjectIdentifier> negativePatternsDatabaseParameter = new LinkedList<DatabaseObjectIdentifier>();
    private List<DatabaseObjectIdentifier> negativePatternsSchemaParameter = new LinkedList<DatabaseObjectIdentifier>();
    private List<DatabaseObjectIdentifier> negativePatternsTableParameter = new LinkedList<DatabaseObjectIdentifier>();
    private List<DatabaseObjectIdentifier> positivePatternsDatabaseParameter = new LinkedList<DatabaseObjectIdentifier>();
    private List<DatabaseObjectIdentifier> positivePatternsSchemaParameter = new LinkedList<DatabaseObjectIdentifier>();
    private List<DatabaseObjectIdentifier> positivePatternsTableParameter = new LinkedList<DatabaseObjectIdentifier>();
    private boolean isCaseSensitiveDatabase = true;
    private boolean isCaseSensitiveSchema = true;
    private boolean isCaseSensitiveTable = true;

    public void parse(String string, FilterType filterType) {
        this.parse(string, filterType, true);
    }

    public void parse(String string, FilterType filterType, boolean bl) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (filterType == FilterType.DATABASE) {
            this.isCaseSensitiveDatabase = bl;
        } else if (filterType == FilterType.SCHEMA) {
            this.isCaseSensitiveSchema = bl;
        } else if (filterType == FilterType.TABLE) {
            this.isCaseSensitiveTable = bl;
        }
        this.clearPatterns(filterType);
        List<String> list = this.splitFilterItems(string);
        for (String string2 : list) {
            if (string2.isEmpty()) continue;
            String string3 = string2;
            boolean bl2 = false;
            if (string2.toUpperCase().startsWith(NOT_STR) && string2.length() > NOT_STR.length()) {
                bl2 = true;
                string3 = string2.substring(NOT_STR.length()).trim();
            }
            DatabaseObjectIdentifier databaseObjectIdentifier = null;
            boolean bl3 = false;
            switch (filterType) {
                case DATABASE: {
                    databaseObjectIdentifier = new DatabaseObjectIdentifier(string3, null, null, bl2, bl);
                    break;
                }
                case SCHEMA: {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    this.splitPatterns(string3, 2, string3.length(), linkedList);
                    if (2 == linkedList.size()) {
                        databaseObjectIdentifier = new DatabaseObjectIdentifier(linkedList.get(1), linkedList.get(0), null, bl2, bl);
                        break;
                    }
                    if (1 == linkedList.size()) {
                        databaseObjectIdentifier = new DatabaseObjectIdentifier(null, linkedList.get(0), null, bl2, bl);
                        break;
                    }
                    bl3 = true;
                    break;
                }
                case TABLE: {
                    LinkedList<String> linkedList = new LinkedList();
                    this.splitPatterns(string3, 3, string3.length(), linkedList);
                    if (3 == linkedList.size()) {
                        databaseObjectIdentifier = new DatabaseObjectIdentifier(linkedList.get(2), linkedList.get(1), linkedList.get(0), bl2, bl);
                        break;
                    }
                    if (2 == linkedList.size()) {
                        databaseObjectIdentifier = new DatabaseObjectIdentifier(null, linkedList.get(1), linkedList.get(0), bl2, bl);
                        break;
                    }
                    if (1 == linkedList.size()) {
                        databaseObjectIdentifier = new DatabaseObjectIdentifier(null, null, linkedList.get(0), bl2, bl);
                        break;
                    }
                    bl3 = true;
                    break;
                }
            }
            if (bl3) {
                throw new IllegalStateException("Can't parse filter parameter value '" + string2 + "'");
            }
            if (bl2) {
                if (filterType == FilterType.DATABASE) {
                    this.negativePatternsDatabaseParameter.add(databaseObjectIdentifier);
                    continue;
                }
                if (filterType == FilterType.SCHEMA) {
                    this.negativePatternsSchemaParameter.add(databaseObjectIdentifier);
                    continue;
                }
                if (filterType != FilterType.TABLE) continue;
                this.negativePatternsTableParameter.add(databaseObjectIdentifier);
                continue;
            }
            if (filterType == FilterType.DATABASE) {
                this.positivePatternsDatabaseParameter.add(databaseObjectIdentifier);
                continue;
            }
            if (filterType == FilterType.SCHEMA) {
                this.positivePatternsSchemaParameter.add(databaseObjectIdentifier);
                continue;
            }
            if (filterType != FilterType.TABLE) continue;
            this.positivePatternsTableParameter.add(databaseObjectIdentifier);
        }
    }

    private List<String> splitFilterItems(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        this.splitFilterItems(string, DELIMITER_SEMICOLON, 0, linkedList);
        this.splitFilterItems(string, DELIMITER_COMMA, 0, linkedList2);
        if (linkedList.size() >= linkedList2.size()) {
            return linkedList;
        }
        return linkedList2;
    }

    private void splitFilterItems(String string, String string2, int n, LinkedList<String> linkedList) {
        int n2 = string.indexOf(string2, n);
        if (n2 == -1) {
            if (!(string = string.trim()).isEmpty()) {
                linkedList.add(string);
            }
            return;
        }
        int n3 = this.getLastIndexOfSymbol(string, string2, n2, BRACKET_OPEN);
        if (n3 != -1) {
            int n4 = this.getLastIndexOfSymbol(string, string2, n2, BRACKET_CLOSE);
            if (n4 != -1 && n3 < n4) {
                String string3 = string.substring(0, n2);
                linkedList.add(string3.trim());
                string = string.substring(n2 + 1);
                n = 0;
            } else {
                n = n2 + 1;
            }
        } else {
            String string4 = string.substring(0, n2);
            linkedList.add(string4.trim());
            string = string.substring(n2 + 1);
            n = 0;
        }
        this.splitFilterItems(string, string2, n, linkedList);
    }

    private void splitPatterns(String string, int n, int n2, LinkedList<String> linkedList) {
        int n3 = string.lastIndexOf(DELIMITER_DOT, n2);
        if (n <= 0) {
            return;
        }
        if (n == 1 || n3 == -1) {
            if (!(string = string.trim()).isEmpty()) {
                linkedList.add(string);
            }
            return;
        }
        int n4 = this.getLastIndexOfSymbol(string, DELIMITER_DOT, n3, BRACKET_OPEN);
        if (n4 != -1) {
            int n5 = this.getLastIndexOfSymbol(string, DELIMITER_DOT, n3, BRACKET_CLOSE);
            if (n5 != -1 && n4 < n5) {
                String string2 = string.substring(n3 + 1, string.length());
                linkedList.add(string2.trim());
                string = string.substring(0, n3);
                n2 = string.length();
                --n;
            } else {
                n2 = n3 - 1;
            }
        } else {
            String string3 = string.substring(n3 + 1, string.length());
            linkedList.add(string3.trim());
            string = string.substring(0, n3);
            n2 = string.length();
            --n;
        }
        this.splitPatterns(string, n, n2, linkedList);
    }

    private int getLastIndexOfSymbol(String string, String string2, int n, String string3) {
        int n2 = string.substring(0, n).lastIndexOf(string3);
        if (n2 != -1) {
            if (string3.equals(BRACKET_OPEN) && (n2 == 0 || string.charAt(n2 - 1) == DELIMITER_DOT.charAt(0) && string.charAt(n2 - 1) != '\\')) {
                return n2;
            }
            if (string3.equals(BRACKET_CLOSE) && n2 != 0 && (n2 + 1 == n || string.charAt(n2 + 1) == DELIMITER_DOT.charAt(0) && string.charAt(n2 - 1) != '\\')) {
                return n2;
            }
            return this.getLastIndexOfSymbol(string, string2, n2 - 1, string3);
        }
        return n2;
    }

    public boolean match(String string, String string2, String string3) {
        if (this.matchNegativePatterns(string, string2, string3)) {
            return false;
        }
        return this.matchPositivePatternsDatabaseParameter(string, string2, string3);
    }

    private boolean matchNegativePatterns(String string, String string2, String string3) {
        LinkedList<DatabaseObjectIdentifier> linkedList = new LinkedList<DatabaseObjectIdentifier>();
        linkedList.addAll(this.negativePatternsDatabaseParameter);
        linkedList.addAll(this.negativePatternsSchemaParameter);
        linkedList.addAll(this.negativePatternsTableParameter);
        for (DatabaseObjectIdentifier databaseObjectIdentifier : linkedList) {
            if (!databaseObjectIdentifier.match(string, string2, string3)) continue;
            return true;
        }
        return false;
    }

    private boolean matchPositivePatternsDatabaseParameter(String string, String string2, String string3) {
        if (this.positivePatternsDatabaseParameter.size() > 0) {
            for (DatabaseObjectIdentifier databaseObjectIdentifier : this.positivePatternsDatabaseParameter) {
                if (!databaseObjectIdentifier.match(string, string2, string3)) continue;
                return this.matchPositivePatternsSchemaParameter(string, string2, string3);
            }
        } else {
            return this.matchPositivePatternsSchemaParameter(string, string2, string3);
        }
        return false;
    }

    private boolean matchPositivePatternsSchemaParameter(String string, String string2, String string3) {
        if (this.positivePatternsSchemaParameter.size() > 0) {
            for (DatabaseObjectIdentifier databaseObjectIdentifier : this.positivePatternsSchemaParameter) {
                if (!databaseObjectIdentifier.match(string, string2, string3)) continue;
                return this.matchPositivePatternsTableParameter(string, string2, string3);
            }
        } else {
            return this.matchPositivePatternsTableParameter(string, string2, string3);
        }
        return false;
    }

    private boolean matchPositivePatternsTableParameter(String string, String string2, String string3) {
        if (this.positivePatternsTableParameter.size() > 0) {
            for (DatabaseObjectIdentifier databaseObjectIdentifier : this.positivePatternsTableParameter) {
                if (!databaseObjectIdentifier.match(string, string2, string3)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void clearPatterns(FilterType filterType) {
        switch (filterType) {
            case DATABASE: {
                if (!this.negativePatternsDatabaseParameter.isEmpty()) {
                    this.negativePatternsDatabaseParameter.clear();
                }
                if (this.positivePatternsDatabaseParameter.isEmpty()) break;
                this.positivePatternsDatabaseParameter.clear();
                break;
            }
            case SCHEMA: {
                if (!this.negativePatternsSchemaParameter.isEmpty()) {
                    this.negativePatternsSchemaParameter.clear();
                }
                if (this.positivePatternsSchemaParameter.isEmpty()) break;
                this.positivePatternsSchemaParameter.clear();
                break;
            }
            case TABLE: {
                if (!this.negativePatternsTableParameter.isEmpty()) {
                    this.negativePatternsTableParameter.clear();
                }
                if (this.positivePatternsTableParameter.isEmpty()) break;
                this.positivePatternsTableParameter.clear();
            }
        }
    }

    public boolean isDatabaseCondtition() {
        return this.isNegativeDatabaseCondtition() || this.isPositiveDatabaseCondtition();
    }

    public boolean isNegativeDatabaseCondtition() {
        return !this.negativePatternsDatabaseParameter.isEmpty();
    }

    public boolean isPositiveDatabaseCondtition() {
        return !this.positivePatternsDatabaseParameter.isEmpty();
    }

    public boolean isSchemaCondtition() {
        return this.isNegativeSchemaCondtition() || this.isPositiveSchemaCondtition();
    }

    public boolean isNegativeSchemaCondtition() {
        return !this.negativePatternsSchemaParameter.isEmpty();
    }

    public boolean isPositiveSchemaCondtition() {
        return !this.positivePatternsSchemaParameter.isEmpty();
    }

    public void setMatchType(boolean bl) {
        this.setMatchTypeDatabase(bl);
        this.setMatchTypeSchema(bl);
        this.setMatchTypeTable(bl);
    }

    public void setMatchTypeDatabase(boolean bl) {
        if (this.isCaseSensitiveDatabase != bl) {
            this.isCaseSensitiveDatabase = bl;
            this.setMatchType(bl, this.negativePatternsDatabaseParameter);
            this.setMatchType(bl, this.positivePatternsDatabaseParameter);
        }
    }

    public void setMatchTypeSchema(boolean bl) {
        if (this.isCaseSensitiveSchema != bl) {
            this.isCaseSensitiveSchema = bl;
            this.setMatchType(bl, this.negativePatternsSchemaParameter);
            this.setMatchType(bl, this.positivePatternsSchemaParameter);
        }
    }

    public void setMatchTypeTable(boolean bl) {
        if (this.isCaseSensitiveTable != bl) {
            this.isCaseSensitiveTable = bl;
            this.setMatchType(bl, this.negativePatternsTableParameter);
            this.setMatchType(bl, this.positivePatternsTableParameter);
        }
    }

    private void setMatchType(boolean bl, List<DatabaseObjectIdentifier> list) {
        for (DatabaseObjectIdentifier databaseObjectIdentifier : list) {
            databaseObjectIdentifier.setMatchType(bl);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.getListPatterns(this.negativePatternsDatabaseParameter, NOT_STR));
        stringBuilder.append((CharSequence)this.getListPatterns(this.negativePatternsSchemaParameter, NOT_STR));
        stringBuilder.append((CharSequence)this.getListPatterns(this.negativePatternsTableParameter, NOT_STR));
        stringBuilder.append((CharSequence)this.getListPatterns(this.positivePatternsDatabaseParameter, ""));
        stringBuilder.append((CharSequence)this.getListPatterns(this.positivePatternsSchemaParameter, ""));
        stringBuilder.append((CharSequence)this.getListPatterns(this.positivePatternsTableParameter, ""));
        return stringBuilder.toString();
    }

    private StringBuilder getListPatterns(List<DatabaseObjectIdentifier> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            stringBuilder.append("(");
            if (NOT_STR.equals(string)) {
                stringBuilder.append("NOT ");
            }
            int n = 0;
            for (DatabaseObjectIdentifier databaseObjectIdentifier : list) {
                if (databaseObjectIdentifier == null) continue;
                stringBuilder.append(databaseObjectIdentifier.toString());
                if (++n >= list.size()) continue;
                stringBuilder.append("; ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    public List<DatabaseObjectIdentifier> getNegativePatternsDatabaseParameter() {
        return this.negativePatternsDatabaseParameter;
    }

    public List<DatabaseObjectIdentifier> getNegativePatternsSchemaParameter() {
        return this.negativePatternsSchemaParameter;
    }

    public List<DatabaseObjectIdentifier> getNegativePatternsTableParameter() {
        return this.negativePatternsTableParameter;
    }

    public List<DatabaseObjectIdentifier> getPositivePatternsDatabaseParameter() {
        return this.positivePatternsDatabaseParameter;
    }

    public List<DatabaseObjectIdentifier> getPositivePatternsSchemaParameter() {
        return this.positivePatternsSchemaParameter;
    }

    public List<DatabaseObjectIdentifier> getPositivePatternsTableParameter() {
        return this.positivePatternsTableParameter;
    }
}

