/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.cache;

import MITI.MIRException;
import MITI.bridges.FileHelper;
import MITI.bridges.cache.MIMBCacheResourceFile;
import MITI.bridges.cache.MIMBCacheUtil;
import MITI.messages.MIRModelBridge.MBCCH;
import MITI.sdk.MIRDate;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class MIMBCache {
    private static boolean resetXmiCache = false;
    private static boolean resetNativeCache = false;
    private String environmentId;
    private File nativeDirectory;
    private File internalDirectory;
    private static final Comparator<CacheFile> ByLatestTime = new Comparator<CacheFile>(){

        @Override
        public int compare(CacheFile cacheFile, CacheFile cacheFile2) {
            long l = cacheFile.time - cacheFile2.time;
            if (l < 0L) {
                return 1;
            }
            if (l > 0L) {
                return -1;
            }
            return 0;
        }
    };

    public static boolean isResetXmiCache() {
        return resetXmiCache;
    }

    public static void setResetXmiCache(boolean bl) {
        resetXmiCache = bl;
    }

    public static boolean isResetNativeCache() {
        return resetNativeCache;
    }

    public static void setResetNativeCache(boolean bl) {
        resetNativeCache = bl;
    }

    private void garbageCollectOldFiles(File file) throws IOException {
        HashMap<String, TreeSet<CacheFile>> hashMap = new HashMap<String, TreeSet<CacheFile>>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Serializable serializable = fileArray[i];
            if (!((File)serializable).exists()) continue;
            CacheFile cacheFile = new CacheFile((File)serializable);
            if (!cacheFile.isValid()) {
                ((File)serializable).delete();
                continue;
            }
            TreeSet<CacheFile> treeSet = (TreeSet<CacheFile>)hashMap.get(cacheFile.getId());
            if (treeSet == null) {
                treeSet = new TreeSet<CacheFile>(ByLatestTime);
                hashMap.put(cacheFile.getId(), treeSet);
            }
            treeSet.add(cacheFile);
        }
        for (Serializable serializable : hashMap.values()) {
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator = ((TreeSet)serializable).iterator();
            while (iterator.hasNext()) {
                CacheFile cacheFile = (CacheFile)iterator.next();
                if (cacheFile.isInternal()) continue;
                boolean bl3 = true;
                if (!bl) {
                    bl = true;
                    bl3 = false;
                }
                if (!bl2 && cacheFile.isReady()) {
                    bl2 = true;
                    bl3 = false;
                }
                if (!bl3) continue;
                cacheFile.getFile().delete();
            }
        }
    }

    private final String getRootPath(String string) throws MIRException {
        File file = MIMBCacheUtil.getMimbCacheDir();
        StringBuilder stringBuilder = new StringBuilder(file.getAbsolutePath());
        stringBuilder.append(File.separatorChar).append(string).append(File.separatorChar);
        return stringBuilder.toString();
    }

    public MIMBCache(String string, String string2, int n, int n2) throws MIRException {
        File[] fileArray;
        Object object;
        this.environmentId = string2.toLowerCase();
        Object object2 = this.getRootPath(string);
        if (!FileHelper.isValidFileName(new File((String)object2), this.environmentId)) {
            block17: {
                int n3 = 0;
                String string3 = MIMBCacheUtil.getStringHashCode(this.environmentId);
                do {
                    object = String.format("%s%s.%d", object2, string3, n3);
                    fileArray = new File((String)object);
                    File[] fileArray2 = new File((File)fileArray, "id.txt");
                    if (fileArray.exists()) {
                        String string4 = MIMBCacheUtil.readFile((File)fileArray2);
                        if (!this.environmentId.equals(string4)) {
                            ++n3;
                            continue;
                        }
                        break block17;
                    }
                    if (!fileArray.mkdirs()) {
                        throw new MIRException(MBCCH.ERR_CANT_CREATE_FOLDER.getMessage(fileArray.getPath()));
                    }
                    if (MIMBCacheUtil.createForWriting((File)fileArray2)) {
                        MIMBCacheUtil.writeFile((File)fileArray2, this.environmentId);
                        break block17;
                    }
                    ++n3;
                } while (n3 < 10000);
                throw new MIRException(MBCCH.ERR_GENERATE_FILE_NAME.getMessage("id.txt", (String)object2 + this.environmentId));
            }
            object2 = object;
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            if (!((String)object2).endsWith(File.separator)) {
                ((StringBuilder)object).append(File.separatorChar);
            }
            ((StringBuilder)object).append(this.environmentId);
            object2 = ((StringBuilder)object).toString();
        }
        object = new File((String)object2);
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            throw new MIRException(MBCCH.ERR_CANT_CREATE_FOLDER.getMessage(object2));
        }
        String string5 = "native_2";
        if (n2 > 0) {
            string5 = string5 + "." + n2;
        }
        this.nativeDirectory = new File((String)object2, string5);
        if (!this.nativeDirectory.exists() && !this.nativeDirectory.mkdirs()) {
            throw new MIRException(MBCCH.ERR_CANT_CREATE_FOLDER.getMessage(this.nativeDirectory.getAbsolutePath()));
        }
        this.internalDirectory = new File((String)object2, "mir_2." + n);
        if (!this.internalDirectory.exists() && !this.internalDirectory.mkdirs()) {
            throw new MIRException(MBCCH.ERR_CANT_CREATE_FOLDER.getMessage(this.internalDirectory.getAbsolutePath()));
        }
        if (resetXmiCache || resetNativeCache) {
            MBCCH.MSG_CLEARING_CACHE.log(new Object[0]);
        }
        for (File file : fileArray = ((File)object).listFiles()) {
            if (file.isDirectory()) {
                if (resetXmiCache && file.getName().equalsIgnoreCase(this.internalDirectory.getName())) {
                    this.deleteFiles(file);
                    continue;
                }
                if (resetNativeCache && file.getName().equalsIgnoreCase(this.nativeDirectory.getName())) {
                    this.deleteFiles(file);
                    continue;
                }
                if (file.getName().equalsIgnoreCase(this.nativeDirectory.getName()) || file.getName().equalsIgnoreCase(this.internalDirectory.getName())) continue;
                this.deleteFiles(file);
                file.delete();
                continue;
            }
            if (file.getName().equalsIgnoreCase("id.txt")) continue;
            file.delete();
        }
    }

    private void deleteFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.deleteFiles(file2);
                }
                file2.delete();
            }
        }
    }

    public void garbageCollectOldFiles() throws IOException {
        this.garbageCollectOldFiles(this.nativeDirectory);
        this.garbageCollectOldFiles(this.internalDirectory);
    }

    public MIMBCacheResourceFile getNativeFile(String string, MIRDate mIRDate, String string2) throws MIRException {
        assert (string2.indexOf(".") < 0);
        MIMBCacheResourceFile mIMBCacheResourceFile = new MIMBCacheResourceFile(this.nativeDirectory, string, mIRDate, "model." + string2.toLowerCase());
        return mIMBCacheResourceFile;
    }

    public MIMBCacheResourceFile getNativeFile(String string, String string2) throws MIRException {
        assert (string2.indexOf(".") < 0);
        MIRDate mIRDate = new MIRDate(0L);
        MIMBCacheResourceFile mIMBCacheResourceFile = new MIMBCacheResourceFile(this.nativeDirectory, string, mIRDate, "model." + string2.toLowerCase());
        return mIMBCacheResourceFile;
    }

    public MIMBCacheResourceFile getXmiFile(String string, MIRDate mIRDate) throws MIRException {
        MIMBCacheResourceFile mIMBCacheResourceFile = new MIMBCacheResourceFile(this.internalDirectory, string, mIRDate, "model.xml");
        return mIMBCacheResourceFile;
    }

    public MIMBCacheResourceFile getXmiFile(String string) throws MIRException {
        MIRDate mIRDate = new MIRDate(0L);
        MIMBCacheResourceFile mIMBCacheResourceFile = new MIMBCacheResourceFile(this.internalDirectory, string, mIRDate, "model.xml");
        return mIMBCacheResourceFile;
    }

    private class CacheFile {
        private String fileId = null;
        private long time = 0L;
        private boolean ready = false;
        private String resource = null;
        private File file = null;

        CacheFile(File file) {
            this.file = file;
            String[] stringArray = this.file.getName().split("\\.");
            if (stringArray.length == 6) {
                this.fileId = stringArray[0] + "." + stringArray[1];
                this.ready = stringArray[3].charAt(0) == 'r';
                this.resource = stringArray[4] + "." + stringArray[5];
                if (this.resource.equals("id.txt")) {
                    this.time = this.file.lastModified();
                }
            }
        }

        boolean isValid() {
            return this.fileId != null;
        }

        String getId() {
            return this.fileId;
        }

        boolean isInternal() {
            return this.resource.equals("id.txt");
        }

        boolean isReady() {
            return this.ready;
        }

        File getFile() {
            return this.file;
        }
    }
}

