/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.util.log.MIRLogger;

public abstract class RelationalParser
extends ParserBase {
    public static final String TEMP_SCHEMA_NAME = "__temp__";
    protected MIRStoreModel model;
    protected String defaultSchemaName;

    public RelationalParser(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, MIRNamespaceElement mIRNamespaceElement, int n, int n2, String string) {
        super(mIRLogger, mIRNamespaceElement, n, n2);
        this.model = mIRStoreModel;
        this.defaultSchemaName = MIRBridgeLib.removeQuotes(string);
    }

    @Override
    protected MIRDataPackage getDataPackage(ParserBase.QualifiedName qualifiedName, boolean bl) {
        String[] stringArray;
        String string = qualifiedName.getServer();
        String string2 = qualifiedName.getCatalog();
        String string3 = qualifiedName.getSchema();
        if ((string3 == null || string3.isEmpty()) && (stringArray = this.getAlternativeDataPackageNames()) != null && stringArray.length > 0) {
            string3 = stringArray[0];
        }
        if (this.model.getStoreType() == 0 && (string == null || string.isEmpty() || string.equalsIgnoreCase(MIRConnectionManager.getServerName(this.defaultCatalog))) && (string2 == null || string2.isEmpty() || string2.equalsIgnoreCase(MIRConnectionManager.getDatabaseName(this.defaultCatalog)))) {
            MIRDataPackage mIRDataPackage;
            MIRDataPackage mIRDataPackage2 = mIRDataPackage = string3.isEmpty() ? this.defaultSchema : this.getItem(string3, qualifiedName.isSchemaQuoted(), this.model.getDataPackages());
            if (mIRDataPackage instanceof MIRDatabaseSchema) {
                return mIRDataPackage;
            }
        }
        if (this.model.getStoreType() != 0 || bl) {
            MIRStoreConnection mIRStoreConnection;
            boolean bl2 = this.getCollationMode() == CollationMode.CaseInsensitive || this.getCollationMode() == CollationMode.QuotedCaseSensitive && !qualifiedName.isSchemaQuoted();
            String string4 = MIRConnectionManager.getInstance().getFormattedConnectionName(string2, string3, string, bl2);
            if (string4 == null || string4.isEmpty()) {
                string4 = "Database";
            }
            if ((mIRStoreConnection = this.getItem(string4, false, this.model.getStoreConnections())) != null && this.model.getStoreType() == 0) {
                int n = 0;
                String string5 = string4;
                while (mIRStoreConnection != null && mIRStoreConnection.getStoreType() != 0 && mIRStoreConnection.getStoreType() != 2) {
                    string4 = string5 + "_" + ++n;
                    mIRStoreConnection = this.getItem(string4, false, this.model.getStoreConnections());
                }
            }
            if (mIRStoreConnection == null && bl) {
                mIRStoreConnection = new MIRStoreConnection();
                mIRStoreConnection.setName(string4);
                if (MIRConnectionManager.getInstance().isCaseInsensitive(string4)) {
                    mIRStoreConnection.setSystemCase((byte)2);
                }
                if (MIRConnectionManager.getInstance().isCaseSensitive(string4)) {
                    mIRStoreConnection.setSystemCase((byte)1);
                }
                this.model.addStoreConnection(mIRStoreConnection);
                RelationalParser.setSystemType(this.getDatabaseType(), mIRStoreConnection);
                if (string != null && string.equalsIgnoreCase(MIRConnectionManager.getServerName(this.defaultCatalog))) {
                    MIRConnectionManager.getInstance().setServerName(mIRStoreConnection, string);
                } else {
                    MIRConnectionManager.setConnectionName(mIRStoreConnection, string);
                }
                MIRConnectionManager.setCatalogName(mIRStoreConnection, qualifiedName.getCatalog());
                MIRConnectionManager.setSchemaName(mIRStoreConnection, string3);
            }
            if (mIRStoreConnection != null) {
                MIRConnectionPackage mIRConnectionPackage = this.getItem(string3, qualifiedName.isSchemaQuoted(), mIRStoreConnection.getConnectionPackages());
                if (bl && mIRConnectionPackage == null) {
                    mIRConnectionPackage = new MIRConnectionPackage();
                    mIRConnectionPackage.setName(string3);
                    mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
                    this.setCollationLineageOption(mIRConnectionPackage, qualifiedName.isSchemaQuoted());
                }
                return mIRConnectionPackage;
            }
        }
        return null;
    }

    protected static String buildQualifiedName(MIRObject mIRObject, String ... stringArray) {
        if (mIRObject == null) {
            return "<null>";
        }
        String string = mIRObject.getPath(false);
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                stringBuilder.append("/" + string2);
            }
            string = string + stringBuilder.toString();
        }
        return string;
    }
}

