/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.expression.MIRExpressionLangType;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRType;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ParserBase
extends MIRExpressionAnalyzer {
    protected static final String DEF_CONNECTION = "Database";
    protected MIRDataPackage defaultSchema;
    protected MIRSystemPackage defaultCatalog;
    protected boolean isCatalogSupported;
    private static final MIRDataPackage[] NO_PACKAGES = new MIRDataPackage[0];
    private static ConcurrentHashMap<String, String> storeContentNames = new ConcurrentHashMap();

    public ParserBase(MIRLogger mIRLogger, MIRNamespaceElement mIRNamespaceElement, int n, int n2) {
        super(mIRLogger, n, n2);
        MIRObject mIRObject;
        this.defaultSchema = ParserBase.getDataPackage(mIRNamespaceElement);
        if (this.defaultSchema != null && (mIRObject = this.defaultSchema.getParent()) != null && mIRObject.isInstanceOf((short)267)) {
            this.defaultCatalog = (MIRSystemPackage)mIRObject;
        }
        this.setDatabaseType(this.detectDbType(n2));
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    public void setIsCatalogSupported(boolean bl) {
        this.isCatalogSupported = bl;
    }

    protected int detectDbType(int n) {
        if (this.defaultCatalog != null) {
            int n2;
            MIRDataStoreVersion mIRDataStoreVersion;
            String string = MIRConnectionManager.getInstance().getType(this.defaultCatalog.getName(), null);
            if (string == null && (mIRDataStoreVersion = MIRDataTypeLib.getDataStore(this.defaultCatalog)).isValid()) {
                string = mIRDataStoreVersion.getDataStoreType();
            }
            return (n2 = MIRExpressionAnalyzer.getExpressionDatabaseType(string)) == 0 ? n : n2;
        }
        return n;
    }

    private List<MIRElementNamePart> getElementNameParts(MIRExpressionNode mIRExpressionNode) {
        List<MIRElementNamePart> list = null;
        if (mIRExpressionNode instanceof MIRElementNode && (((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 75 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 66 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 49 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 23)) {
            list = ((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition();
        } else if (mIRExpressionNode instanceof MIROperationNode) {
            list = ((MIROperationNode)mIRExpressionNode).getElementNamePartByPosition();
        }
        return list;
    }

    protected QualifiedName getSchemaFullName(List<MIRElementNamePart> list, boolean bl) {
        Object object;
        int n;
        boolean bl2 = !this.isCatalogSupported && ParserBase.isSchemaBasedDatabase(this.getDatabaseType());
        String string = null;
        boolean bl3 = false;
        int n2 = n = bl ? list.size() - 3 : list.size() - 2;
        if (n >= 0) {
            object = list.get(n);
            string = ((MIRObject)object).getName();
            bl3 = ((MIRElementNamePart)object).getQuoted();
        } else {
            string = MIRConnectionManager.getSchemaName(this.defaultCatalog);
        }
        object = null;
        if (!bl2 && ((object = MIRConnectionManager.getDatabaseName(this.defaultCatalog)) == null || ((String)object).isEmpty())) {
            object = MIRConnectionManager.getCatalogName(this.defaultCatalog);
        }
        Object object2 = object;
        boolean bl4 = false;
        String string2 = null;
        if (this.defaultCatalog instanceof MIRStoreConnection) {
            string2 = MIRConnectionManager.getServerName(this.defaultCatalog);
        }
        if ((string2 == null || string2.isEmpty()) && MIRConnectionManager.getInstance().getIsLegacyMode() && !this.isRdbms(this.defaultCatalog)) {
            string2 = this.defaultCatalog.getName();
        }
        if (list.size() > 2) {
            int n3;
            if (bl2) {
                n3 = n - 1;
            } else {
                n3 = n - 2;
                if (n > 0) {
                    object2 = list.get(n - 1).getName();
                    bl4 = list.get(n - 1).getQuoted();
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= n3; ++i) {
                if (i != 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(MIRBridgeLib.removeQuotes(list.get(i).getName()));
            }
            if (stringBuilder.length() > 0) {
                MIRModel mIRModel = this.defaultCatalog != null ? this.defaultCatalog.getRootModel() : null;
                String string3 = MIRConnectionManager.getServerName(mIRModel);
                if (this.defaultCatalog == null || mIRModel instanceof MIRDiModel || this.defaultCatalog instanceof MIRModel && !stringBuilder.toString().equals(string3)) {
                    string2 = stringBuilder.toString();
                }
            }
        }
        if (bl2 && this.getDatabaseType() == 1 && string2 != null && string2.startsWith("@")) {
            string2 = string2.substring(1);
        }
        string2 = MIRBridgeLib.removeQuotes(string2);
        if (object != null && !((String)object).isEmpty() && ((String)object).equalsIgnoreCase(string2 + "." + (String)object2)) {
            object2 = object;
            string2 = null;
        }
        object2 = MIRExpressionAnalyzerHelper.getCanonicalName(MIRBridgeLib.removeQuotes((String)object2), bl4, this.getDatabaseType());
        string = MIRExpressionAnalyzerHelper.getCanonicalName(MIRBridgeLib.removeQuotes(string), bl3, this.getDatabaseType());
        return new QualifiedName(string2, false, (String)object2, bl4, string, bl3);
    }

    private boolean isRdbms(MIRSystemPackage mIRSystemPackage) {
        MIRModel mIRModel = mIRSystemPackage.getRootModel();
        if (mIRModel.getContent() == null && mIRModel instanceof MIRDiModel) {
            return true;
        }
        return mIRModel instanceof MIRStoreModel && ((MIRStoreModel)mIRModel).getStoreType() == 0 || mIRModel.getContent() != null && ((MIRDirectoryStructureModel)mIRModel.getContent().getRootModel()).getType() == 4;
    }

    protected abstract MIRDataPackage getDataPackage(QualifiedName var1, boolean var2);

    protected MIRDataPackage getDataPackage(MIRExpressionNode mIRExpressionNode, boolean bl) {
        MIRDataPackage mIRDataPackage = null;
        List<MIRElementNamePart> list = this.getElementNameParts(mIRExpressionNode);
        if (list != null) {
            if (list.size() == 1) {
                mIRDataPackage = this.defaultSchema;
            } else {
                QualifiedName qualifiedName = this.getSchemaFullName(list, this.getPackageName(mIRExpressionNode) != null);
                mIRDataPackage = this.getDataPackage(qualifiedName, bl);
            }
        }
        return mIRDataPackage;
    }

    protected String getPackageName(MIRExpressionNode mIRExpressionNode) {
        MIROperationNode mIROperationNode;
        if (this.getOptions().supportPackages() && mIRExpressionNode instanceof MIROperationNode && (mIROperationNode = (MIROperationNode)mIRExpressionNode).getElementNamePartCount() > 2) {
            return mIROperationNode.getElementNamePartByPosition().get(mIROperationNode.getElementNamePartCount() - 2).getName();
        }
        return null;
    }

    MIRDataPackage[] getAlternativeDataPackages(MIROperationNode mIROperationNode) {
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        if (!list.isEmpty() && (list.size() == 1 || list.get(list.size() - 2).getName().isEmpty())) {
            return this.getAlternativeDataPackagesInternal(mIROperationNode, false);
        }
        return NO_PACKAGES;
    }

    MIRDataPackage[] getAlternativeDataPackages(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        if (!list.isEmpty() && (list.size() == 1 || list.get(list.size() - 2).getName().isEmpty())) {
            return this.getAlternativeDataPackagesInternal(mIRElementNode, true);
        }
        return NO_PACKAGES;
    }

    protected MIRDataPackage[] getAlternativeDataPackagesInternal(MIRExpressionNode mIRExpressionNode, boolean bl) {
        Object object;
        String[] stringArray = this.getAlternativeDataPackageNames();
        if (stringArray == null) {
            return NO_PACKAGES;
        }
        String string = "";
        String string2 = null;
        if (!(mIRExpressionNode instanceof MIROperationNode || mIRExpressionNode instanceof MIRElementNode && ((MIRElementNode)mIRExpressionNode).getElementNamePartCount() == 1)) {
            object = this.getSchemaFullName(this.getElementNameParts(mIRExpressionNode), false);
            string = ((QualifiedName)object).getCatalog();
            string2 = ((QualifiedName)object).getServer();
        }
        object = new LinkedList();
        for (String string3 : stringArray) {
            object.add(this.getDataPackage(new QualifiedName(string2, false, string, false, string3, true), bl));
        }
        return object.toArray(new MIRDataPackage[object.size()]);
    }

    protected String[] getAlternativeDataPackageNames() {
        if (this.getDatabaseType() == 1) {
            return new String[]{"PUBLIC", "SYS"};
        }
        if (this.getDatabaseType() == 5) {
            return new String[]{"pg_catalog"};
        }
        if (this.getDatabaseType() == 2) {
            return new String[]{"dbo"};
        }
        return null;
    }

    protected MIRElement getClassifier(String string, boolean bl, MIRPackage mIRPackage) {
        if (mIRPackage == null) {
            return null;
        }
        MIRModelObject mIRModelObject = this.getItem(string, bl, mIRPackage.getNamespaceElements());
        if (mIRModelObject == null) {
            mIRModelObject = this.getItem(string, bl, mIRPackage.getImportedNamespaceElements());
        }
        if (mIRModelObject != null && (mIRModelObject.isInstanceOf((short)49) || mIRModelObject.isInstanceOf((short)75))) {
            return mIRModelObject;
        }
        return null;
    }

    protected List<MIRFeature> getFeatures(String string, boolean bl, Collection<MIRClassifier> collection) {
        return this.getFeatures(new String[]{string}, bl, collection);
    }

    protected List<MIRFeature> getFeatures(String[] stringArray, boolean bl, Collection<MIRClassifier> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ArrayList<MIRClassifier> arrayList2 = new ArrayList<MIRClassifier>();
            for (MIRClassifier mIRClassifier : collection) {
                MIRClassType mIRClassType;
                MIRFeature mIRFeature = this.getItem(string, bl, mIRClassifier.getFeatures());
                if (mIRFeature == null) continue;
                if (i == stringArray.length - 1 || (mIRClassType = ParserBase.getHierarchicalType(mIRFeature.getType())) == null) {
                    arrayList.add(mIRFeature);
                    continue;
                }
                if (mIRClassType == null) continue;
                arrayList2.add(mIRClassType.getAssociatedClass());
            }
            collection = arrayList2;
        }
        return arrayList;
    }

    private static MIRClassType getHierarchicalType(MIRType mIRType) {
        if (mIRType instanceof MIRDerivedType) {
            mIRType = ((MIRDerivedType)mIRType).getArrayOfType();
        }
        if (mIRType instanceof MIRClassType) {
            return (MIRClassType)mIRType;
        }
        return null;
    }

    protected List<MIRFeature> getFeaturesByPosition(int n, Collection<MIRClassifier> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (MIRClassifier mIRClassifier : collection) {
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (mIRFeature.getPosition() != n) continue;
                arrayList.add(mIRFeature);
            }
        }
        return arrayList;
    }

    protected List<MIRNamespaceElement> getOperations(String string, boolean bl, MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage == null) {
            return null;
        }
        List<MIRNamespaceElement> list = this.getItems(string, bl, mIRDataPackage.getNamespaceElements());
        if (list == null) {
            list = this.getItems(string, bl, mIRDataPackage.getImportedNamespaceElements());
        }
        return list;
    }

    protected int getStatementType(MIRObject mIRObject) {
        while (mIRObject.getElementType() != 134) {
            if ((mIRObject = mIRObject.getParent()) != null && mIRObject instanceof MIRExpressionNode) continue;
            return -1;
        }
        return ((MIRStatementNode)mIRObject).getStatementType();
    }

    protected void setCollationLineageOption(MIRObject mIRObject, boolean bl) {
        MIRExpressionAnalyzerHelper.setCollationLineageOption(mIRObject, bl, this.getCollationMode(mIRObject));
    }

    static void cleanupExpressions(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap.getExpression() == null) {
            return;
        }
        mIRClassifierMap.getExpression().delete();
        for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
            if (mIRFeatureMap.getExpression() == null) continue;
            mIRFeatureMap.getExpression().delete();
        }
    }

    public static void setSystemType(int n, MIRSystemPackage mIRSystemPackage) {
        MIRModel mIRModel = mIRSystemPackage.getRootModel();
        if (mIRModel != null && ParserBase.getExpressionDatabaseType(mIRModel.getSystemType()) == n && n != 0) {
            mIRSystemPackage.setSystemType(mIRModel.getSystemType());
        } else if (n == 1) {
            mIRSystemPackage.setSystemType("ORACLE");
        } else if (n == 4) {
            mIRSystemPackage.setSystemType("TERADATA");
        } else if (n == 11) {
            mIRSystemPackage.setSystemType("HIVE");
        } else if (n == 2) {
            mIRSystemPackage.setSystemType("MICROSOFT SQL SERVER");
        } else if (n == 5) {
            mIRSystemPackage.setSystemType("POSTGRESQL");
        } else if (n == 20) {
            mIRSystemPackage.setSystemType("SNOWFLAKE");
        } else if (n == 3) {
            mIRSystemPackage.setSystemType("DB2/UDB");
        } else if (n == 10) {
            mIRSystemPackage.setSystemType("MYSQL");
        } else if (n == 12) {
            mIRSystemPackage.setSystemType("ACCESS");
        } else if (n == 13) {
            mIRSystemPackage.setSystemType("TALEND.VECTORWISE");
        } else if (n == 14) {
            mIRSystemPackage.setSystemType("ORACLE BI SERVER");
        } else if (n == 15) {
            mIRSystemPackage.setSystemType("APACHE CASSANDRA");
        } else if (n == 16) {
            mIRSystemPackage.setSystemType("HP VERTICA");
        } else if (n == 17) {
            mIRSystemPackage.setSystemType("SALESFORCE");
        } else if (n == 18) {
            mIRSystemPackage.setSystemType("SAP HANA");
        } else if (n == 19) {
            mIRSystemPackage.setSystemType("PRESTO");
        } else if (n == 21) {
            mIRSystemPackage.setSystemType("REDSHIFT");
        } else if (n == 22) {
            mIRSystemPackage.setSystemType("DENODO");
        } else if (n == 23) {
            mIRSystemPackage.setSystemType("AMAZONAURORA");
        } else if (n == 24) {
            mIRSystemPackage.setSystemType("GOOGLE BIGQUERY");
        } else if (n == 25) {
            mIRSystemPackage.setSystemType("AMAZONATHENA");
        } else if (n == 26) {
            mIRSystemPackage.setSystemType("SYBASE AS ENTERPRISE");
        } else if (n == 9 || n == 0) {
            mIRSystemPackage.setSystemType("ODBC");
        } else {
            mIRSystemPackage.setSystemType(MIRExpressionLangType.getName(n));
        }
    }

    protected <T extends MIRObject> T getItem(String string, boolean bl, Collection<T> collection) {
        List<T> list = this.getItems(string, bl, collection);
        return (T)(list == null || list.isEmpty() ? null : (MIRObject)list.get(0));
    }

    protected <T extends MIRObject> List<T> getItems(String string, boolean bl, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        MIRObject mIRObject = (MIRObject)collection.iterator().next();
        return MIRExpressionAnalyzerHelper.getItems(string, bl, collection, this.getCollationMode(mIRObject));
    }

    private static MIRSystemPackage getCatalog(MIRObject mIRObject) {
        while (mIRObject != null && !(mIRObject instanceof MIRSystemPackage)) {
            if (mIRObject instanceof MIRNamespaceElement && !(mIRObject instanceof MIRDataPackage)) {
                mIRObject = ParserBase.getDataPackage((MIRNamespaceElement)mIRObject);
                continue;
            }
            mIRObject = mIRObject.getParent();
        }
        return (MIRSystemPackage)mIRObject;
    }

    private static MIRDataPackage getDataPackage(MIRNamespaceElement mIRNamespaceElement) {
        MIRConnectionDataPackage mIRConnectionDataPackage;
        if (mIRNamespaceElement instanceof MIRDataPackage) {
            return (MIRDataPackage)mIRNamespaceElement;
        }
        if (mIRNamespaceElement instanceof MIROperation && ((MIROperation)mIRNamespaceElement).getAssociatedClass() != null) {
            mIRNamespaceElement = ((MIROperation)mIRNamespaceElement).getAssociatedClass();
        }
        if (mIRNamespaceElement instanceof MIRClassifier && (mIRConnectionDataPackage = ((MIRClassifier)mIRNamespaceElement).getConnectionDataPackage()) != null) {
            return mIRConnectionDataPackage;
        }
        return mIRNamespaceElement != null ? mIRNamespaceElement.getDataPackage() : null;
    }

    protected CollationMode getCollationMode(MIRObject mIRObject) {
        CollationMode collationMode = null;
        if (this.getDatabaseType() == 10 && mIRObject instanceof MIRFeature) {
            collationMode = CollationMode.CaseInsensitive;
        } else if (this.getDatabaseType() == 24 && mIRObject instanceof MIRClassifier) {
            collationMode = CollationMode.CaseSensitive;
        } else {
            MIRSystemPackage mIRSystemPackage = ParserBase.getCatalog(mIRObject);
            if (mIRSystemPackage instanceof MIRModel && ((MIRModel)mIRSystemPackage).getSystemCase() == 1) {
                collationMode = CollationMode.CaseSensitive;
            } else if (MIRParserOptions.isConfigurableCollation(this.getDatabaseType(), this.getParserType()) && mIRSystemPackage instanceof MIRStoreConnection) {
                collationMode = this.getCollationMode(mIRSystemPackage.getName());
                if (collationMode == null) {
                    collationMode = this.getCollationMode(MIRConnectionManager.getConnectionName(mIRSystemPackage));
                }
                if (collationMode == null) {
                    String string2 = storeContentNames.computeIfAbsent(mIRSystemPackage.getName(), string -> MIRConnectionManager.getStoreContentName((MIRStoreConnection)mIRSystemPackage));
                    collationMode = this.getCollationMode(string2);
                }
            } else {
                MIRSystemPackage mIRSystemPackage2 = ParserBase.getCatalog(mIRObject);
                if (mIRSystemPackage2 instanceof MIRModel && ((MIRModel)mIRSystemPackage2).getSystemCase() == 2) {
                    collationMode = CollationMode.CaseInsensitive;
                }
            }
        }
        return collationMode != null ? collationMode : this.getCollationMode();
    }

    private CollationMode getCollationMode(String string) {
        if (MIRConnectionManager.getInstance().isCaseSensitive(string)) {
            return CollationMode.CaseSensitive;
        }
        if (MIRConnectionManager.getInstance().isCaseInsensitive(string)) {
            return CollationMode.CaseInsensitive;
        }
        return null;
    }

    public static class QualifiedName {
        private final String server;
        private final boolean serverQuoted;
        private final String catalog;
        private final boolean catalogQuoted;
        private final String schema;
        private final boolean schemaQuoted;

        public QualifiedName(String string, boolean bl, String string2, boolean bl2, String string3, boolean bl3) {
            this.server = string;
            this.serverQuoted = bl;
            this.catalog = string2;
            this.catalogQuoted = bl2;
            this.schema = string3;
            this.schemaQuoted = bl3;
        }

        public String getServer() {
            return this.server;
        }

        public boolean isServerQuoted() {
            return this.serverQuoted;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public boolean isCatalogQuoted() {
            return this.catalogQuoted;
        }

        public String getSchema() {
            return this.schema;
        }

        public boolean isSchemaQuoted() {
            return this.schemaQuoted;
        }

        public static QualifiedName getQualifiedName(MIRSystemPackage mIRSystemPackage, String string, String string2, boolean bl) {
            String string3 = MIRConnectionManager.getServerName(mIRSystemPackage);
            if (string == null || string.isEmpty()) {
                string = MIRConnectionManager.getDatabaseName(mIRSystemPackage);
            }
            return new QualifiedName(string3, false, string, false, string2, bl);
        }
    }
}

