/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIR_Object;
import java.util.ArrayList;
import java.util.Iterator;

public class MIRUdpLib {
    public static final String UDP_BRIDGE_TRANSFORMATION_USAGE = "Transformation Control";
    public static final String UDP_BRIDGE_TRANSFORMATION_JOIN_TYPE = "Join type";
    public static final String BRIDGE_TRANSFORMATION_JOIN_TYPE_NORMAL = "Normal join";
    public static final String BRIDGE_TRANSFORMATION_JOIN_TYPE_LEFT = "Left outer join";
    public static final String BRIDGE_TRANSFORMATION_JOIN_TYPE_RIGHT = "Right outer join";
    public static final String BRIDGE_TRANSFORMATION_JOIN_TYPE_FULL = "Full outer join";
    public static final String UDP_BRIDGE_TRANSFORMATION_JOINER_SORTED = "Is input sorted";
    public static final String UDP_BRIDGE_TRANSFORMATION_REUSABLE_NAME = "Reusable Transformation Name";
    public static final String UDP_BRIDGE_TRANSFORMATION_REUSABLE_LOGIC = "MIRReusableFunctionLogic";
    public static final String BRIDGE_TRANSFORMATION_JOINER_INPUT_LEFT = "LEFT";
    public static final String BRIDGE_TRANSFORMATION_JOINER_INPUT_RIGHT = "RIGHT";
    public static final String BRIDGE_TRANSFORMATION_LOOKUP_INPUT_CONTROL = "CONTROL";
    public static final String BRIDGE_TRANSFORMATION_LOOKUP_INPUT_DATA = "DATA";
    public static final String BRIDGE_TRANSFORMATION_INPUT = "INPUT";
    public static final String BRIDGE_TRANSFORMATION_OUTPUT = "OUTPUT";
    public static final String BRIDGE_TRANSFORMATION_VARIABLES = "VARIABLES";
    public static final String BRIDGE_TRANSFORMATION_SEQUENCE_NEXTVAL = "NEXTVAL";
    public static final String BRIDGE_TRANSFORMATION_SEQUENCE_CURRVAL = "CURRVAL";
    public static final String BRIDGE_CONDITION_FILTER = "FILTER CONDITION";
    public static final String BRIDGE_CONDITION_JOIN = "JOIN CONDITION";
    public static final String BRIDGE_CONDITION_LOOKUP = "LOOKUP CONDITION";
    public static final String BRIDGE_CONDITION_GROUPBY = "GROUP BY CONDITION";
    public static final String BRIDGE_CONDITION_SORT = "SORTING CONDITION";
    public static final String UDP_BRIDGE_CONNECTION_NAME = "Connection Name";

    public static MIRPropertyElementTypeScope fetchPropertyElementTypeScope(MIRObject mIRObject, short s, boolean bl) {
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = null;
        Iterator<MIRPropertyElementTypeScope> iterator = null;
        if (mIRObject instanceof MIRModel) {
            iterator = ((MIRModel)mIRObject).getPropertyElementTypeScopeIterator();
        } else if (mIRObject instanceof MIRRepository) {
            iterator = ((MIRRepository)mIRObject).getPropertyElementTypeScopeIterator();
        } else if (mIRObject instanceof MIRMappingModel) {
            iterator = ((MIRMappingModel)mIRObject).getPropertyElementTypeScopeIterator();
        } else {
            return null;
        }
        while (iterator.hasNext()) {
            mIRPropertyElementTypeScope = iterator.next();
            if (mIRPropertyElementTypeScope.getScope() != s) continue;
            return mIRPropertyElementTypeScope;
        }
        if (bl) {
            mIRPropertyElementTypeScope = new MIRPropertyElementTypeScope();
            mIRPropertyElementTypeScope.setScope(s);
            if (mIRObject instanceof MIRModel) {
                ((MIRModel)mIRObject).addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            } else if (mIRObject instanceof MIRRepository) {
                ((MIRRepository)mIRObject).addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            }
            return mIRPropertyElementTypeScope;
        }
        return null;
    }

    public static MIRPropertyType fetchPropertyType(MIRObject mIRObject, short s, String string, byte by, String string2, String string3, String string4, boolean bl) {
        return MIRUdpLib._fetchPropertyType(mIRObject, s, string, by, string2, string3, string4, bl, null);
    }

    public static MIRPropertyType fetchPropertyType(MIRModel mIRModel, short s, String string, byte by, String string2, String string3, String string4, boolean bl, String string5) {
        return MIRUdpLib._fetchPropertyType(mIRModel, s, string, by, string2, string3, string4, bl, string5);
    }

    public static MIRPropertyType fetchPropertyType(MIRRepository mIRRepository, short s, String string, byte by, String string2, String string3, String string4, boolean bl) {
        return MIRUdpLib._fetchPropertyType(mIRRepository, s, string, by, string2, string3, string4, bl, null);
    }

    private static MIRPropertyType _fetchPropertyType(MIRObject mIRObject, short s, String string, byte by, String string2, String string3, String string4, boolean bl, String string5) {
        MIRPropertyElementTypeScope mIRPropertyElementTypeScope = MIRUdpLib.fetchPropertyElementTypeScope(mIRObject, s, bl);
        if (mIRPropertyElementTypeScope == null) {
            return null;
        }
        MIRPropertyType mIRPropertyType = null;
        MIRPropertyType mIRPropertyType2 = null;
        Iterator<MIRPropertyType> iterator = mIRPropertyElementTypeScope.getPropertyTypeIterator();
        while (iterator.hasNext()) {
            mIRPropertyType2 = iterator.next();
            if (mIRPropertyType2.getName().compareTo(string) != 0 || mIRPropertyType2.getUsage().compareTo(string2) != 0 || mIRPropertyType2.getGroup().compareTo(string3) != 0) continue;
            if (mIRPropertyType2.getDesignLevel() == 0 || mIRPropertyType2.getDesignLevel() == by) {
                return mIRPropertyType2;
            }
            if (by != 0) continue;
            mIRPropertyType = mIRPropertyType2;
        }
        if (mIRPropertyType != null) {
            return mIRPropertyType;
        }
        if (bl) {
            mIRPropertyType = new MIRPropertyType();
            mIRPropertyType.setName(string);
            mIRPropertyType.setDesignLevel(by);
            mIRPropertyType.setUsage(string2);
            mIRPropertyType.setGroup(string3);
            mIRPropertyType.setDataType(string4);
            mIRPropertyType.addPropertyElementTypeScope(mIRPropertyElementTypeScope);
            if (string5 != null && string5.length() != 0) {
                mIRPropertyType.setInitialValue(string5);
            }
            return mIRPropertyType;
        }
        return null;
    }

    public static MIRPropertyValue setPropertyValue(MIRPropertyType mIRPropertyType, String string, MIRElement mIRElement) {
        MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRElement);
        if (mIRPropertyValue == null) {
            if (!mIRPropertyType.getInitialValue().equals(string)) {
                mIRPropertyValue = new MIRPropertyValue();
                mIRPropertyValue.setValue(string);
                mIRPropertyValue.addPropertyType(mIRPropertyType);
                mIRPropertyValue.addElement(mIRElement);
            }
        } else {
            mIRPropertyValue.setValue(string);
        }
        return mIRPropertyValue;
    }

    public static String getPropertyValueValue(MIRPropertyType mIRPropertyType, MIRElement mIRElement) {
        MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRElement);
        return mIRPropertyValue != null ? mIRPropertyValue.getValue() : "";
    }

    public static MIRPropertyValue getPropertyValue(MIRPropertyType mIRPropertyType, MIRElement mIRElement) {
        Iterator<MIRPropertyValue> iterator = mIRElement.getPropertyValueIterator();
        while (iterator.hasNext()) {
            MIRPropertyValue mIRPropertyValue = iterator.next();
            if (mIRPropertyValue.getPropertyType() != mIRPropertyType) continue;
            return mIRPropertyValue;
        }
        return null;
    }

    public static void copyPropertyValues(MIRElement mIRElement, MIRElement mIRElement2) {
        Iterator<MIRPropertyValue> iterator = mIRElement.getPropertyValueIterator();
        while (iterator.hasNext()) {
            MIRPropertyValue mIRPropertyValue = iterator.next();
            MIRPropertyValue mIRPropertyValue2 = new MIRPropertyValue(mIRPropertyValue);
            mIRPropertyValue2.addPropertyType(mIRPropertyValue.getPropertyType());
            mIRElement2.addPropertyValue(mIRPropertyValue2);
        }
    }

    public static String getUniqueUdpName(MIRPropertyType mIRPropertyType) {
        Object object;
        boolean bl = false;
        if (!mIRPropertyType.getGroup().isEmpty()) {
            object = mIRPropertyType.getPropertyElementTypeScope();
            Iterator<MIRPropertyType> iterator = ((MIRPropertyElementTypeScope)object).getPropertyTypeIterator();
            while (iterator.hasNext()) {
                MIRPropertyType mIRPropertyType2 = iterator.next();
                if (mIRPropertyType2 == mIRPropertyType || !mIRPropertyType2.getUsage().equals("USER") || !mIRPropertyType2.getName().equals(mIRPropertyType.getName())) continue;
                bl = true;
                break;
            }
        }
        object = bl && !mIRPropertyType.getGroup().isEmpty() ? mIRPropertyType.getGroup() + "." + mIRPropertyType.getName() : mIRPropertyType.getName();
        return object;
    }

    public static String getTransformationUdp(MIRTransformation mIRTransformation, String string) {
        MIRObject mIRObject = mIRTransformation;
        while (((MIR_Object)mIRObject).getParent() != null && !mIRObject.isInstanceOf((short)218)) {
            mIRObject = ((MIR_Object)mIRObject).getParent();
        }
        MIRModel mIRModel = (MIRModel)mIRObject;
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, (short)79, string, (byte)2, UDP_BRIDGE_TRANSFORMATION_USAGE, "", "undefined", false);
        if (mIRPropertyType == null) {
            return "";
        }
        MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRTransformation);
        if (mIRPropertyValue == null) {
            return "";
        }
        return mIRPropertyValue.getValue();
    }

    public static void processModelUDPs(MIRModel mIRModel, boolean bl, boolean bl2, boolean bl3) throws MIRException {
        ProcessModelUDPsTraversal processModelUDPsTraversal = new ProcessModelUDPsTraversal();
        processModelUDPsTraversal.migrateDefaultValues = bl;
        processModelUDPsTraversal.appendToDescription = bl2;
        processModelUDPsTraversal.cleanupPropertyValues = bl3;
        processModelUDPsTraversal.model = mIRModel;
        mIRModel.depthTraversal(processModelUDPsTraversal);
        processModelUDPsTraversal.cleanup();
    }

    private static class ProcessModelUDPsTraversal
    implements MIR_Object.MIRTraversalOperation {
        public boolean migrateDefaultValues;
        public boolean appendToDescription;
        public boolean cleanupPropertyValues;
        public MIRModel model;
        public ArrayList<ApplicableProperties> sortedApplicableProperties = new ArrayList();

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException {
            if (!bl || mIRObject.getElementType() == 9 && !((MIRDesignPackage)mIRObject).getUserDefined()) {
                return;
            }
            MIRModelObject mIRModelObject = (MIRModelObject)mIRObject;
            ApplicableProperties applicableProperties = this.findApplicableProperties(mIRModelObject);
            String string = mIRModelObject.getDescription();
            String string2 = mIRModelObject.getComment();
            for (MIRPropertyType mIRPropertyType : applicableProperties.propertyTypes) {
                MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRModelObject);
                if (mIRPropertyValue == null && this.migrateDefaultValues) {
                    mIRPropertyValue = new MIRPropertyValue();
                    mIRPropertyValue.setValue(mIRPropertyType.getInitialValue());
                    mIRPropertyValue.addPropertyType(mIRPropertyType);
                    mIRPropertyValue.addElement(mIRModelObject);
                }
                if (!this.appendToDescription || mIRPropertyValue == null) continue;
                if (mIRPropertyType.getDesignLevel() != 2 && mIRModelObject.getDesignLevel() != 2) {
                    if (!string.isEmpty()) {
                        string = string + "\n";
                    }
                    string = string + mIRPropertyType.getFullName() + "=" + mIRPropertyValue.getValue();
                }
                if (mIRPropertyType.getDesignLevel() == 1 || mIRModelObject.getDesignLevel() == 1) continue;
                if (!string2.isEmpty()) {
                    string2 = string2 + "\n";
                }
                string2 = string2 + mIRPropertyType.getFullName() + "=" + mIRPropertyValue.getValue();
            }
            mIRModelObject.setDescription(string);
            mIRModelObject.setComment(string2);
        }

        @Override
        public void post_process(MIRObject mIRObject) throws MIRException {
        }

        @Override
        public boolean traverse(MIRObject mIRObject) throws MIRException {
            return mIRObject.isInstanceOf((short)59) && mIRObject.getElementType() != 70 && (mIRObject.getElementType() != 5 || ((MIRDerivedType)mIRObject).getUserDefined());
        }

        public ApplicableProperties findApplicableProperties(MIRModelObject mIRModelObject) {
            ApplicableProperties applicableProperties = null;
            for (ApplicableProperties object : this.sortedApplicableProperties) {
                if (!mIRModelObject.isInstanceOf(object.elementType) || mIRModelObject.getDesignLevel() == 1 && object.designLevel == 2 || mIRModelObject.getDesignLevel() == 2 && object.designLevel == 1 || mIRModelObject.getDesignLevel() == 0 && object.designLevel != 0) continue;
                applicableProperties = object;
                break;
            }
            if (applicableProperties == null) {
                applicableProperties = new ApplicableProperties();
                applicableProperties.designLevel = mIRModelObject.getDesignLevel();
                applicableProperties.elementType = mIRModelObject.isInstanceOf((short)20) ? (short)20 : mIRModelObject.getElementType();
                for (MIRPropertyElementTypeScope mIRPropertyElementTypeScope : this.model.getPropertyElementTypeScopes()) {
                    if (mIRPropertyElementTypeScope.getScope() != applicableProperties.elementType) continue;
                    for (MIRPropertyType mIRPropertyType : mIRPropertyElementTypeScope.getPropertyTypeByPosition()) {
                        if (!mIRPropertyType.getUsage().equals("USER") || mIRPropertyType.getDesignLevel() == 1 && applicableProperties.designLevel == 2 || mIRPropertyType.getDesignLevel() == 2 && applicableProperties.designLevel == 1) continue;
                        applicableProperties.propertyTypes.add(mIRPropertyType);
                    }
                }
                this.sortedApplicableProperties.add(applicableProperties);
            }
            return applicableProperties;
        }

        public void cleanup() {
            for (ApplicableProperties object : this.sortedApplicableProperties) {
                object.propertyTypes.clear();
            }
            this.sortedApplicableProperties.clear();
            if (this.cleanupPropertyValues) {
                ArrayList arrayList = new ArrayList();
                ArrayList<MIRPropertyType> arrayList2 = new ArrayList<MIRPropertyType>();
                ArrayList<MIRPropertyValue> arrayList3 = new ArrayList<MIRPropertyValue>();
                for (MIRPropertyElementTypeScope mIRPropertyElementTypeScope : this.model.getPropertyElementTypeScopes()) {
                    boolean bl = true;
                    for (MIRPropertyType mIRPropertyType : mIRPropertyElementTypeScope.getPropertyTypes()) {
                        if (mIRPropertyType.getUsage().equals("USER")) {
                            arrayList2.add(mIRPropertyType);
                            for (MIRPropertyValue mIRPropertyValue : mIRPropertyType.getInstanciatedPropertyValues()) {
                                arrayList3.add(mIRPropertyValue);
                            }
                            continue;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    arrayList.add(mIRPropertyElementTypeScope);
                }
                for (MIRPropertyValue mIRPropertyValue : arrayList3) {
                    mIRPropertyValue.delete();
                }
                arrayList3.clear();
                for (MIRPropertyType mIRPropertyType : arrayList2) {
                    mIRPropertyType.delete();
                }
                arrayList2.clear();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    MIRPropertyElementTypeScope mIRPropertyElementTypeScope = (MIRPropertyElementTypeScope)iterator.next();
                    mIRPropertyElementTypeScope.delete();
                }
                arrayList.clear();
            }
        }

        private class ApplicableProperties {
            public short elementType;
            public byte designLevel;
            public ArrayList<MIRPropertyType> propertyTypes = new ArrayList();

            private ApplicableProperties() {
            }
        }
    }
}

