/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRRelationalLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.bridgelib.SAXErrorHandler;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.sdk.MIRAliasClassifier;
import MITI.sdk.MIRAliasFeature;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAssociationRoleNameMap;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassDiagram;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRDrillPath;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRHierarchy;
import MITI.sdk.MIRHierarchyLevelAssociation;
import MITI.sdk.MIRIndex;
import MITI.sdk.MIRIndexMember;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRLevel;
import MITI.sdk.MIRLineageSummaryContent;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRPhysicalTarget;
import MITI.sdk.MIRPhysicalTargetType;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRRelationship;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRType;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMIXExport;
import MITI.sdk.util.ObjectCollector;
import MITI.sdk.validation.MIRValidation;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.DateUtil;
import MITI.util.StringDigest;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import MITI.util.rest.RestUtil;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MIRBridgeLib {
    public static final String BRIDGE_TRANSFORMATION_JOINER_INPUT_LEFT = "LEFT";
    public static final String BRIDGE_TRANSFORMATION_JOINER_INPUT_RIGHT = "RIGHT";
    public static final String BRIDGE_TRANSFORMATION_LOOKUP_INPUT_CONTROL = "CONTROL";
    public static final String BRIDGE_TRANSFORMATION_LOOKUP_INPUT_DATA = "DATA";
    public static final String BRIDGE_TRANSFORMATION_INPUT = "INPUT";
    public static final String BRIDGE_TRANSFORMATION_OUTPUT = "OUTPUT";
    public static final String BRIDGE_TRANSFORMATION_VARIABLES = "VARIABLES";
    public static final String BRIDGE_TRANSFORMATION_SEQUENCE_NEXTVAL = "NEXTVAL";
    public static final String BRIDGE_TRANSFORMATION_SEQUENCE_CURRVAL = "CURRVAL";
    public static final String BRIDGE_CONDITION_FILTER = "FILTER CONDITION";
    public static final String BRIDGE_CONDITION_JOIN = "JOIN CONDITION";
    public static final String BRIDGE_CONDITION_LOOKUP = "LOOKUP CONDITION";
    public static final String BRIDGE_CONDITION_GROUPBY = "GROUP BY CONDITION";
    public static final String BRIDGE_CONDITION_SORT = "SORTING CONDITION";
    public static final String UDP_BRIDGE_CONNECTION_NAME = "Connection Name";
    public static final String DIAGRAM_NAME_SUFFIX_LOGICAL = " Logical";
    public static final String DIAGRAM_NAME_SUFFIX_PHYSICAL = " Physical";
    public static final String CARDINALITY_MIN = "min";
    public static final String CARDINALITY_MAX = "max";
    public static final String FLAT_FILE_WORKING_DIR = "Working directory";
    public static final String FLAT_FILE_FAKE_ROOT = "Fake Root";
    public static final String FIREFOX_USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.10) Gecko/20100914 Firefox/3.6.10";
    public static final String IE_11_USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko";
    public static int CARD_UNSPECIFIED = Integer.MAX_VALUE;
    public static int CARD_UNKNOWN = CARD_UNSPECIFIED - 1;
    public static int CARD_N = CARD_UNSPECIFIED - 2;
    private static final char[] quotes = "\"[]`'".toCharArray();

    public static String getPhysicalName(MIRObject mIRObject) {
        if (mIRObject != null) {
            MIRModelObject mIRModelObject;
            if (mIRObject instanceof MIRModelObject && !(mIRModelObject = (MIRModelObject)mIRObject).getPhysicalName().isEmpty()) {
                return mIRModelObject.getPhysicalName();
            }
            return mIRObject.getName();
        }
        return "";
    }

    public static String getQuotedPhysicalName(MIRModelObject mIRModelObject) {
        if (mIRModelObject.getPhysicalName().length() == 0) {
            return MIRBridgeLib.getQuotedString(mIRModelObject.getName());
        }
        return MIRBridgeLib.getQuotedString(mIRModelObject.getPhysicalName());
    }

    public static String getQuotedString(String string) {
        if (string.indexOf(" ") != -1) {
            String string2 = "\"" + string + "\"";
            return string2;
        }
        return string;
    }

    public static MIRDerivedType getDomain(MIRFeature mIRFeature) {
        MIRType mIRType = mIRFeature.getType();
        if (mIRType == null) {
            return null;
        }
        mIRType = mIRType.getActualType();
        while (mIRType != null && mIRType.getElementType() == 5 && !((MIRDerivedType)mIRType).getUserDefined()) {
            mIRType = ((MIRDerivedType)mIRType).getDerivedFromConcreteType();
        }
        if (mIRType != null && mIRType.getElementType() == 5) {
            return (MIRDerivedType)mIRType;
        }
        return null;
    }

    public static boolean decodeMultiplicity(String string, HashMap<String, Integer> hashMap) {
        if (string == null || string.length() == 0 || string.compareTo("0") == 0) {
            hashMap.put(CARDINALITY_MIN, CARD_UNSPECIFIED);
            hashMap.put(CARDINALITY_MAX, CARD_UNSPECIFIED);
            return true;
        }
        int n = string.indexOf("..");
        if (n == -1) {
            int n2 = MIRBridgeLib.decodeCardinality(string);
            if (n2 == CARD_UNKNOWN) {
                hashMap.put(CARDINALITY_MIN, CARD_UNKNOWN);
                hashMap.put(CARDINALITY_MAX, CARD_UNKNOWN);
                return false;
            }
            hashMap.put(CARDINALITY_MIN, n2);
            hashMap.put(CARDINALITY_MAX, n2);
            return true;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2, string.length());
        int n3 = MIRBridgeLib.decodeCardinality(string2);
        int n4 = MIRBridgeLib.decodeCardinality(string3);
        if (n3 == CARD_UNKNOWN || n4 == CARD_UNKNOWN) {
            hashMap.put(CARDINALITY_MIN, CARD_UNKNOWN);
            hashMap.put(CARDINALITY_MAX, CARD_UNKNOWN);
            return false;
        }
        hashMap.put(CARDINALITY_MIN, n3);
        hashMap.put(CARDINALITY_MAX, n4);
        return true;
    }

    private static int decodeCardinality(String string) {
        if (string.compareTo("*") == 0 || string.compareTo("n") == 0) {
            return CARD_N;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return CARD_UNKNOWN;
        }
    }

    public static String buildMultiplicity(int n, int n2) {
        if (n == CARD_UNSPECIFIED || n == CARD_UNKNOWN) {
            return "0";
        }
        if (n == CARD_N) {
            if (n2 == CARD_N) {
                return "n";
            }
            return "*.." + n2;
        }
        if (n2 == CARD_N) {
            return n + "..*";
        }
        if (n == n2) {
            return "" + n;
        }
        return n + ".." + n2;
    }

    public static boolean isMultiplicityMany(MIRAssociationRole mIRAssociationRole) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        MIRBridgeLib.decodeMultiplicity(mIRAssociationRole.getMultiplicity(), hashMap);
        return hashMap.get(CARDINALITY_MAX) > 1;
    }

    public static void setSourceProperty(MIRAssociationRole mIRAssociationRole, MIRAssociationRole mIRAssociationRole2) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        MIRBridgeLib.decodeMultiplicity(mIRAssociationRole.getMultiplicity(), hashMap);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        MIRBridgeLib.decodeMultiplicity(mIRAssociationRole2.getMultiplicity(), hashMap2);
        int n = hashMap.get(CARDINALITY_MIN);
        int n2 = hashMap.get(CARDINALITY_MAX);
        int n3 = hashMap2.get(CARDINALITY_MIN);
        int n4 = hashMap2.get(CARDINALITY_MAX);
        if (n2 == 1 && n4 != 1) {
            mIRAssociationRole.setSource(true);
            mIRAssociationRole2.setSource(false);
        } else if (n2 != 1 && n4 == 1) {
            mIRAssociationRole.setSource(false);
            mIRAssociationRole2.setSource(true);
        } else if (n2 == 1 && n4 == 1) {
            if (!mIRAssociationRole.getSource() && !mIRAssociationRole2.getSource()) {
                if (n3 <= n) {
                    mIRAssociationRole.setSource(true);
                    mIRAssociationRole2.setSource(false);
                } else {
                    mIRAssociationRole.setSource(false);
                    mIRAssociationRole2.setSource(true);
                }
            }
        } else if (n2 != CARD_UNSPECIFIED && n2 != CARD_UNKNOWN && n4 != CARD_UNSPECIFIED && n4 != CARD_UNKNOWN) {
            mIRAssociationRole.setSource(false);
            mIRAssociationRole2.setSource(false);
        }
    }

    public static MIRAssociationRole findSourceRole(MIRAssociation mIRAssociation) {
        Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            MIRAssociationRole mIRAssociationRole = iterator.next();
            if (!mIRAssociationRole.getSource()) continue;
            return mIRAssociationRole;
        }
        iterator = mIRAssociation.getAssociationRoleIterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static MIRAssociationRole findReverseRole(MIRAssociationRole mIRAssociationRole) {
        MIRAssociation mIRAssociation = mIRAssociationRole.getAssociation();
        Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            MIRAssociationRole mIRAssociationRole2 = iterator.next();
            if (mIRAssociationRole2 == mIRAssociationRole) continue;
            return mIRAssociationRole2;
        }
        return null;
    }

    public static boolean isMany(MIRAssociationRole mIRAssociationRole) {
        return mIRAssociationRole.getMultiplicity().compareTo("1") != 0 && mIRAssociationRole.getMultiplicity().compareTo("0") != 0 && mIRAssociationRole.getMultiplicity().compareTo("0..1") != 0;
    }

    public static boolean isMany(MIRJoinRole mIRJoinRole) {
        return mIRJoinRole.getMultiplicity().compareTo("1") != 0 && mIRJoinRole.getMultiplicity().compareTo("0") != 0 && mIRJoinRole.getMultiplicity().compareTo("0..1") != 0;
    }

    public static MIRBusinessRule findAssociatedBusinessRule(MIRModelObject mIRModelObject, byte by) {
        Iterator<MIRBusinessRule> iterator = mIRModelObject.getAssociatedBusinessRuleIterator();
        while (iterator.hasNext()) {
            MIRBusinessRule mIRBusinessRule = iterator.next();
            if (mIRBusinessRule.getType() != by) continue;
            return mIRBusinessRule;
        }
        return null;
    }

    public static MIRAttribute findParentAttribute(MIRAttribute mIRAttribute, MIRForeignKey mIRForeignKey) {
        Object object;
        if (mIRAttribute == null || mIRForeignKey == null) {
            return null;
        }
        MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
        if (mIRCandidateKey == null) {
            return null;
        }
        if (!mIRForeignKey.containsAttribute(mIRAttribute)) {
            return null;
        }
        MIRAttribute mIRAttribute2 = null;
        Iterator<MIRAssociationRoleNameMap> iterator = mIRAttribute.getDestinationOfAssociationRoleNameMapIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((MIRAssociationRoleNameMap)object).getForeignKey() != mIRForeignKey) continue;
            mIRAttribute2 = ((MIRAssociationRoleNameMap)object).getSourceAttribute();
            break;
        }
        if (mIRAttribute2 != null) {
            if (!mIRCandidateKey.containsAttribute(mIRAttribute2)) {
                return null;
            }
        } else {
            object = mIRCandidateKey.getAttributeIterator();
            while (object.hasNext()) {
                MIRAttribute mIRAttribute3 = (MIRAttribute)object.next();
                if (mIRAttribute3.getName().compareTo(mIRAttribute.getName()) != 0) continue;
                mIRAttribute2 = mIRAttribute3;
                break;
            }
        }
        return mIRAttribute2;
    }

    public static String getQualifiedName(MIRClassifier mIRClassifier) {
        String string = "";
        MIRDataPackage mIRDataPackage = mIRClassifier.getDataPackage();
        if (mIRDataPackage != null && MIRBridgeLib.getPhysicalName(mIRDataPackage).length() > 0 && (mIRDataPackage.getElementType() == 72 || mIRDataPackage.getElementType() == 215)) {
            string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
        }
        string = string + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier);
        return string;
    }

    public static String getQualifiedName(MIRFeature mIRFeature) {
        String string = MIRBridgeLib.getQualifiedName(mIRFeature.getClassifier());
        string = string + "." + MIRBridgeLib.getQuotedPhysicalName(mIRFeature);
        return string;
    }

    public static String computeSqlViewCreateStatement(MIRSQLViewEntity mIRSQLViewEntity) {
        String string = "CREATE ";
        if (mIRSQLViewEntity.getViewType() == 0) {
            string = string + "VIEW ";
        } else if (mIRSQLViewEntity.getViewType() == 1) {
            string = string + "SNAPSHOT ";
        } else if (mIRSQLViewEntity.getViewType() == 2) {
            string = string + "MATERIALIZED VIEW ";
        } else if (mIRSQLViewEntity.getViewType() == 3) {
            string = string + "TABLE ";
        }
        MIRDataPackage mIRDataPackage = mIRSQLViewEntity.getDataPackage();
        if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && MIRBridgeLib.getPhysicalName(mIRDataPackage).length() > 0) {
            string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
        }
        string = string + MIRBridgeLib.getQuotedPhysicalName(mIRSQLViewEntity);
        Iterator<MIRFeature> iterator = mIRSQLViewEntity.getFeatureByPosition().iterator();
        if (iterator.hasNext()) {
            string = string + " (";
        }
        boolean bl = true;
        while (iterator.hasNext()) {
            MIRFeature mIRFeature = iterator.next();
            if (!(mIRFeature instanceof MIRSQLViewAttribute)) continue;
            MIRSQLViewAttribute mIRSQLViewAttribute = (MIRSQLViewAttribute)mIRFeature;
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            string = string + MIRBridgeLib.getQuotedPhysicalName(mIRSQLViewAttribute);
        }
        if (!bl) {
            string = string + ") ";
        }
        string = string + " as\n";
        string = mIRSQLViewEntity.getViewStatement().length() > 0 && mIRSQLViewEntity.getViewStatementType() == 1 ? string + mIRSQLViewEntity.getViewStatement() : string + MIRBridgeLib.computeSqlViewSelectStatement(mIRSQLViewEntity);
        return string;
    }

    public static String computeSqlViewSelectStatement(MIRSQLViewEntity mIRSQLViewEntity) {
        MIRDataPackage mIRDataPackage;
        MIRModelElement mIRModelElement;
        MIRModelElement mIRModelElement2;
        Object object;
        Object object2;
        Cloneable cloneable;
        String string = "SELECT ";
        if (mIRSQLViewEntity.getSelectType() == 1) {
            string = string + "ALL ";
        } else if (mIRSQLViewEntity.getSelectType() == 2) {
            string = string + "DISTINCT ";
        } else if (mIRSQLViewEntity.getSelectType() == 3) {
            string = string + "DISTINCTROW ";
        } else if (mIRSQLViewEntity.getSelectType() == 4) {
            string = string + "UNIQUE ";
        }
        Iterator<MIRFeature> iterator = mIRSQLViewEntity.getFeatureByPosition().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            cloneable = iterator.next();
            if (!(cloneable instanceof MIRSQLViewAttribute)) continue;
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            object2 = (MIRSQLViewAttribute)cloneable;
            object = ((MIRSQLViewAttribute)object2).getSourceFeature();
            if (object != null) {
                mIRModelElement2 = ((MIRFeature)object).getClassifier();
                mIRModelElement = MIRBridgeLib.findSQLViewAssociation(mIRSQLViewEntity, (MIRClassifier)mIRModelElement2);
                if (mIRModelElement != null && ((MIRSQLViewAssociation)mIRModelElement).getAliasName().length() > 0) {
                    string = string + MIRBridgeLib.getQuotedString(((MIRSQLViewAssociation)mIRModelElement).getAliasName()) + ".";
                    string = string + MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)object);
                    continue;
                }
                mIRDataPackage = mIRModelElement2.getDataPackage();
                if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && MIRBridgeLib.getPhysicalName(mIRDataPackage).length() > 0) {
                    string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
                }
                string = string + MIRBridgeLib.getQuotedPhysicalName(mIRModelElement2) + ".";
                string = string + MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)object);
                continue;
            }
            string = string + ((MIRSQLViewAttribute)object2).getExpression();
        }
        string = string + " FROM ";
        cloneable = new TreeSet<MIRSQLViewAssociation>(new OrderedSQLViewAssVector());
        object2 = mIRSQLViewEntity.getDestinationOfSQLViewAssociationIterator();
        while (object2.hasNext()) {
            ((TreeSet)cloneable).add(object2.next());
        }
        object = ((TreeSet)cloneable).iterator();
        bl = true;
        while (object.hasNext()) {
            mIRModelElement2 = (MIRSQLViewAssociation)object.next();
            if (bl) {
                bl = false;
            } else {
                string = string + ", ";
            }
            mIRModelElement = ((MIRSQLViewAssociation)mIRModelElement2).getSourceClassifier();
            mIRDataPackage = mIRModelElement.getDataPackage();
            if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && MIRBridgeLib.getPhysicalName(mIRDataPackage).length() > 0) {
                string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
            }
            string = string + MIRBridgeLib.getQuotedPhysicalName(mIRModelElement);
            if (((MIRSQLViewAssociation)mIRModelElement2).getAliasName().length() <= 0) continue;
            string = string + " " + MIRBridgeLib.getQuotedString(((MIRSQLViewAssociation)mIRModelElement2).getAliasName());
        }
        if (mIRSQLViewEntity.getWhereClause().length() > 0) {
            string = string + " WHERE " + mIRSQLViewEntity.getWhereClause();
        }
        if (mIRSQLViewEntity.getGroupByClause().length() > 0) {
            string = string + " GROUP BY " + mIRSQLViewEntity.getGroupByClause();
        }
        if (mIRSQLViewEntity.getHavingClause().length() > 0) {
            string = string + " HAVING " + mIRSQLViewEntity.getHavingClause();
        }
        if (mIRSQLViewEntity.getOrderByClause().length() > 0) {
            string = string + " ORDER BY " + mIRSQLViewEntity.getOrderByClause();
        }
        return string;
    }

    private static MIRSQLViewAssociation findSQLViewAssociation(MIRSQLViewEntity mIRSQLViewEntity, MIRClassifier mIRClassifier) {
        Iterator<MIRSQLViewAssociation> iterator = mIRSQLViewEntity.getDestinationOfSQLViewAssociationIterator();
        while (iterator.hasNext()) {
            MIRSQLViewAssociation mIRSQLViewAssociation = iterator.next();
            if (mIRSQLViewAssociation.getSourceClassifier() != mIRClassifier) continue;
            return mIRSQLViewAssociation;
        }
        return null;
    }

    public static void serialize(MIRObject mIRObject, MIRLogger mIRLogger, String string) throws MIRException {
        if (mIRObject == null) {
            throw new IllegalArgumentException("Cannot serialize a null object");
        }
        if (!MIRValidation.validate(mIRObject, MIRValidationLevel.ADVANCED)) {
            throw new MIRException(MBCM.ERR_VALIDATION_ERROR.getMessage(new Object[0]));
        }
        File file = new File(string);
        if (string.toLowerCase().endsWith(".xml")) {
            MIRMIXExport mIRMIXExport = new MIRMIXExport(0);
            mIRMIXExport.run(file, mIRObject);
        }
    }

    public static MIRBusinessRule findBusinessRule(MIRModelObject mIRModelObject, byte by) {
        Iterator<MIRBusinessRule> iterator = mIRModelObject.getAssociatedBusinessRuleIterator();
        while (iterator.hasNext()) {
            MIRBusinessRule mIRBusinessRule = iterator.next();
            if (mIRBusinessRule.getType() != by) continue;
            return mIRBusinessRule;
        }
        return null;
    }

    public static boolean equivalentTypeValues(List<MIRTypeValue> list, List<MIRTypeValue> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            MIRTypeValue mIRTypeValue;
            MIRTypeValue mIRTypeValue2 = list.get(i);
            if (mIRTypeValue2.isSimilar(mIRTypeValue = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static MIRPresentationElement getPresentationElement(MIRModelObject mIRModelObject, MIRClassDiagram mIRClassDiagram) {
        Iterator<MIRPresentationElement> iterator = mIRModelObject.getPresentationPresentationElementIterator();
        while (iterator.hasNext()) {
            MIRPresentationElement mIRPresentationElement = iterator.next();
            if (mIRPresentationElement.getDiagram() != mIRClassDiagram) continue;
            return mIRPresentationElement;
        }
        return null;
    }

    public static final Color getColor(int n) {
        int n2 = n & 0xFF;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = (n & 0xFF0000) >> 16;
        return new Color(n2, n3, n4);
    }

    public static MIRGeneralizationRole getSubtypeGeneralizationRole(MIRGeneralization mIRGeneralization, MIRClass mIRClass, boolean bl) {
        MIRGeneralizationRole mIRGeneralizationRole = null;
        Iterator<MIRGeneralizationRole> iterator = mIRGeneralization.getSubtypeGeneralizationRoleIterator();
        while (iterator.hasNext()) {
            MIRGeneralizationRole mIRGeneralizationRole2 = iterator.next();
            if (mIRGeneralizationRole2.getAssociatedClass() != mIRClass) continue;
            mIRGeneralizationRole = mIRGeneralizationRole2;
            break;
        }
        if (mIRGeneralizationRole == null && bl) {
            mIRGeneralizationRole = new MIRGeneralizationRole();
            mIRGeneralizationRole.addAssociatedClass(mIRClass);
            mIRGeneralizationRole.addSubtypeOfGeneralization(mIRGeneralization);
        }
        return mIRGeneralizationRole;
    }

    public static MIRGeneralizationRole getSupertypeGeneralizationRole(MIRGeneralization mIRGeneralization, MIRClass mIRClass, boolean bl) {
        MIRGeneralizationRole mIRGeneralizationRole = null;
        Iterator<MIRGeneralizationRole> iterator = mIRGeneralization.getSupertypeGeneralizationRoleIterator();
        while (iterator.hasNext()) {
            MIRGeneralizationRole mIRGeneralizationRole2 = iterator.next();
            if (mIRGeneralizationRole2.getAssociatedClass() != mIRClass) continue;
            mIRGeneralizationRole = mIRGeneralizationRole2;
            break;
        }
        if (mIRGeneralizationRole == null && bl) {
            mIRGeneralizationRole = new MIRGeneralizationRole();
            mIRGeneralizationRole.addAssociatedClass(mIRClass);
            mIRGeneralizationRole.addSupertypeOfGeneralization(mIRGeneralization);
        }
        return mIRGeneralizationRole;
    }

    public static Calendar parseISODateString(String string) throws MIRException {
        MIRDate mIRDate = new MIRDate();
        if (!mIRDate.set(string)) {
            throw new MIRException(MBCM.UNSUPPORTED_DATE_FORMAT.getMessage(string, "yyyy-MM-dd HH:mm:ss"));
        }
        return mIRDate.get();
    }

    public static Set<MIRStoreContent> getDirectoryStoreContents(MIRDirectoryStructureModel mIRDirectoryStructureModel) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{295});
        return objectCollector.collect(mIRDirectoryStructureModel);
    }

    public static void stripUnusedFolders(MIRDirectoryStructureModel mIRDirectoryStructureModel) {
        MIRBridgeLib.stripUnusedFolders(mIRDirectoryStructureModel, null);
    }

    public static void stripUnusedFolders(MIRDirectoryStructureModel mIRDirectoryStructureModel, Set<MIRFolder> set) {
        ArrayList<MIRFolder> arrayList = new ArrayList<MIRFolder>();
        for (MIRFolderContent mIRFolderContent : mIRDirectoryStructureModel.getFolderContents()) {
            if (!(mIRFolderContent instanceof MIRFolder) || !MIRBridgeLib.stripUnusedFolders((MIRFolder)mIRFolderContent, set)) continue;
            arrayList.add((MIRFolder)mIRFolderContent);
        }
        for (MIRFolder mIRFolder : arrayList) {
            mIRDirectoryStructureModel.removeFolderContent(mIRFolder);
            mIRFolder.recursiveDelete();
        }
    }

    public static boolean stripUnusedFolders(MIRFolder mIRFolder, Set<MIRFolder> set) {
        ArrayList<MIRFolder> arrayList = new ArrayList<MIRFolder>();
        for (MIRFolderContent mIRFolderContent : mIRFolder.getFolderContents()) {
            if (!(mIRFolderContent instanceof MIRFolder) || !MIRBridgeLib.stripUnusedFolders((MIRFolder)mIRFolderContent, set)) continue;
            arrayList.add((MIRFolder)mIRFolderContent);
        }
        for (MIRFolder mIRFolder2 : arrayList) {
            mIRFolder.removeFolderContent(mIRFolder2);
            mIRFolder2.recursiveDelete();
        }
        if (mIRFolder.getFolderContentCount() == 0 && mIRFolder.getReferencedFolderContentCount() == 0) {
            if (set == null) {
                return true;
            }
            return !set.contains(mIRFolder);
        }
        return false;
    }

    public static String[] parseDataType(String string) {
        MIRDataTypeLib.MIRParsedType mIRParsedType = MIRDataTypeLib.MIRParsedType.parseSqlType(string);
        return new String[]{mIRParsedType.getTypeName(), mIRParsedType.getLength(), mIRParsedType.getScale()};
    }

    public static boolean copyFile(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            BLIB.DBG_ERROR_FILE_IS_DIR.log(file.getAbsolutePath());
            return false;
        }
        if (!file2.exists()) {
            try {
                if (!file2.createNewFile()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (FileUtil.copy(file, file2)) {
            file2.setLastModified(file.lastModified());
            return true;
        }
        BLIB.DBG_ERROR_COPYING_FILE.log(file.getAbsolutePath(), file2.getAbsolutePath());
        return false;
    }

    public static MIRAssociation buildFKeyAssociation(MIRForeignKey mIRForeignKey) {
        boolean bl;
        MIRClass mIRClass = mIRForeignKey.getAssociatedClass();
        MIRClass mIRClass2 = mIRForeignKey.getCandidateKey().getAssociatedClass();
        MIRAssociation mIRAssociation = new MIRAssociation();
        mIRAssociation.setAggregation(false);
        mIRAssociation.setUserDefined(false);
        MIRNamespace mIRNamespace = mIRClass.getNamespace();
        mIRNamespace.addNamespaceElement(mIRAssociation);
        MIRAssociationRole mIRAssociationRole = new MIRAssociationRole();
        mIRAssociationRole.setName(MIRBridgeLib.getPhysicalName(mIRClass2));
        mIRAssociationRole.addAssociatedClass(mIRClass2);
        mIRAssociationRole.setSource(true);
        mIRAssociationRole.setMultiplicity("0..1");
        mIRAssociation.addAssociationRole(mIRAssociationRole);
        MIRAssociationRole mIRAssociationRole2 = new MIRAssociationRole();
        mIRAssociationRole2.setName(MIRBridgeLib.getPhysicalName(mIRClass));
        mIRAssociationRole2.addAssociatedClass(mIRClass);
        mIRAssociationRole2.setSource(false);
        mIRAssociationRole2.setMultiplicity("0..*");
        mIRAssociationRole2.addForeignKey(mIRForeignKey);
        mIRAssociation.addAssociationRole(mIRAssociationRole2);
        Iterator<MIRAttribute> iterator = mIRForeignKey.getAttributeIterator();
        int n = mIRForeignKey.getAttributeCount();
        boolean bl2 = bl = n > 0;
        while (iterator.hasNext()) {
            if (!iterator.next().getOptional()) continue;
            bl = false;
            break;
        }
        if (bl) {
            mIRAssociationRole.setMultiplicity("1");
        }
        MIRBridgeLib.setAggregationProperty(mIRAssociation);
        return mIRAssociation;
    }

    public static void setAggregationProperty(MIRAssociation mIRAssociation) {
        Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            MIRAssociationRole mIRAssociationRole = iterator.next();
            MIRAssociationRole mIRAssociationRole2 = MIRBridgeLib.findReverseRole(mIRAssociationRole);
            MIRForeignKey mIRForeignKey = mIRAssociationRole.getForeignKey();
            if (mIRAssociationRole.getAssociatedClass() == mIRAssociationRole2.getAssociatedClass() || mIRForeignKey == null) continue;
            boolean bl = true;
            Iterator<MIRAttribute> iterator2 = mIRForeignKey.getAttributeIterator();
            while (iterator2.hasNext()) {
                MIRAttribute mIRAttribute = iterator2.next();
                if (mIRAttribute == null) continue;
                boolean bl2 = false;
                Iterator<MIRKey> iterator3 = mIRAttribute.getKeyIterator();
                while (iterator3.hasNext()) {
                    MIRKey mIRKey = iterator3.next();
                    if (mIRKey.getElementType() != 21 || ((MIRCandidateKey)mIRKey).getPrimaryOfClass() == null) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            mIRAssociation.setAggregation(bl);
        }
    }

    public static String getFormattedFullDescription(MIRModelObject mIRModelObject) {
        String string = "";
        if (mIRModelObject.getDescription().length() > 0) {
            string = string + mIRModelObject.getDescription() + "\n";
        }
        if (mIRModelObject.getComment().length() > 0) {
            string = string + mIRModelObject.getComment() + "\n";
        }
        for (MIRNote mIRNote : mIRModelObject.getNoteByPosition()) {
            if (mIRNote.getValue().length() <= 0) continue;
            string = string + mIRNote.getValue() + "\n";
        }
        return string;
    }

    public static MIRClassifierMap getDestinationOfClassifierMap(MIRClassifier mIRClassifier, boolean bl) {
        MIRClassifierMap mIRClassifierMap = mIRClassifier.getDestinationOfClassifierMap();
        if (mIRClassifierMap == null && bl) {
            mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.addDestinationClassifier(mIRClassifier);
            mIRClassifierMap.addClassifier(mIRClassifier);
        }
        return mIRClassifierMap;
    }

    public static MIRFeatureMap getDestinationOfFeatureMap(MIRFeature mIRFeature, boolean bl) {
        MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap == null && bl) {
            mIRFeatureMap = new MIRFeatureMap();
            mIRFeatureMap.addDestinationFeature(mIRFeature);
            MIRClassifierMap mIRClassifierMap = MIRBridgeLib.getDestinationOfClassifierMap(mIRFeature.getClassifier(), true);
            mIRFeatureMap.addClassifierMap(mIRClassifierMap);
        }
        return mIRFeatureMap;
    }

    public static void addSourceFeature(MIRFeatureMap mIRFeatureMap, MIRFeature mIRFeature) {
        if (mIRFeatureMap != null && mIRFeature != null && !mIRFeatureMap.containsSourceFeature(mIRFeature)) {
            mIRFeatureMap.addSourceFeature(mIRFeature);
            MIRBridgeLib.addSourceClassifier(mIRFeatureMap.getClassifierMap(), mIRFeature.getClassifier());
        }
    }

    public static void addSourceClassifier(MIRClassifierMap mIRClassifierMap, MIRClassifier mIRClassifier) {
        if (mIRClassifierMap != null && mIRClassifier != null && !mIRClassifierMap.containsSourceClassifier(mIRClassifier)) {
            mIRClassifierMap.addSourceClassifier(mIRClassifier);
        }
    }

    public static void addControlFeature(MIRFeatureMap mIRFeatureMap, MIRFeature mIRFeature) {
        if (mIRFeatureMap != null && mIRFeature != null && !mIRFeatureMap.containsControlFeature(mIRFeature)) {
            mIRFeatureMap.addControlFeature(mIRFeature);
            MIRBridgeLib.addControlClassifier(mIRFeatureMap.getClassifierMap(), mIRFeature.getClassifier());
        }
    }

    public static void addControlClassifier(MIRClassifierMap mIRClassifierMap, MIRClassifier mIRClassifier) {
        if (mIRClassifierMap != null && mIRClassifier != null && !mIRClassifierMap.containsControlClassifier(mIRClassifier)) {
            mIRClassifierMap.addControlClassifier(mIRClassifier);
        }
    }

    public static void addSourceFeature(MIRSummaryMap mIRSummaryMap, MIRFeature mIRFeature) {
        if (mIRSummaryMap != null && mIRFeature != null && !mIRSummaryMap.containsSourceFeature(mIRFeature)) {
            mIRSummaryMap.addSourceFeature(mIRFeature);
        }
    }

    private static void processConnectionPackageImportedObjects(MIRConnectionPackage mIRConnectionPackage) {
        if (mIRConnectionPackage == null || mIRConnectionPackage.getImportedNamespaceElementCount() == 0) {
            return;
        }
        while (mIRConnectionPackage.getImportedNamespaceElementCount() > 0) {
            MIRNamespaceElement mIRNamespaceElement = mIRConnectionPackage.getImportedNamespaceElementIterator().next();
            mIRNamespaceElement.removeNamespace();
            mIRNamespaceElement.removeImportedByPackage(mIRConnectionPackage);
            mIRNamespaceElement.addNamespace(mIRConnectionPackage);
        }
    }

    public static void processConnectionPackageImportedObjects(MIRStoreModel mIRStoreModel) {
        if (mIRStoreModel == null || mIRStoreModel.getStoreConnectionCount() == 0) {
            return;
        }
        Iterator<MIRStoreConnection> iterator = mIRStoreModel.getStoreConnectionIterator();
        while (iterator.hasNext()) {
            MIRStoreConnection mIRStoreConnection = iterator.next();
            if (mIRStoreConnection.getConnectionPackageCount() == 0) continue;
            Iterator<MIRConnectionPackage> iterator2 = mIRStoreConnection.getConnectionPackageIterator();
            while (iterator2.hasNext()) {
                MIRBridgeLib.processConnectionPackageImportedObjects(iterator2.next());
            }
        }
        MIRBridgeLib.deleteEmptyDesignPackages(mIRStoreModel);
    }

    public static String escape(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.1));
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2 || c3 == c) {
                stringBuffer.append(c2).append(c3);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static void writeXmlFile(String string, File file) throws FileNotFoundException, IOException {
        FileUtil.writeContent(file, (string.startsWith("<?") ? "" : "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n") + string + "\n", FileUtil.UTF8);
    }

    public static Document parseXmlFile(File file, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new FileInputStream(file));
        boolean bl = false;
        return MIRBridgeLib.parseXml(inputSource, bl, mIRLogger);
    }

    public static Document parseXmlFile(File file, boolean bl, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new FileInputStream(file));
        return MIRBridgeLib.parseXml(inputSource, bl, mIRLogger);
    }

    public static Document parseXmlString(String string, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(string));
        boolean bl = false;
        return MIRBridgeLib.parseXml(inputSource, bl, mIRLogger);
    }

    public static Document parseXmlString(String string, boolean bl, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(string));
        return MIRBridgeLib.parseXml(inputSource, bl, mIRLogger);
    }

    public static Document parseXmlStream(InputStream inputStream, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        boolean bl = false;
        return MIRBridgeLib.parseXml(inputSource, bl, mIRLogger);
    }

    private static Document parseXml(InputSource inputSource, boolean bl, MIRLogger mIRLogger) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = XmlUtil.getDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(bl);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new SAXErrorHandler(mIRLogger));
        return documentBuilder.parse(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) throws IOException {
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), FileUtil.UTF8));
            Properties properties = new Properties();
            properties.load(bufferedReader);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static String getLastModificationTime(File file) {
        try {
            return DateUtil.formatSimpleDate(file.lastModified(), false);
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public static MIRClassifier getSourceOfAliasClassifier(MIRAliasClassifier mIRAliasClassifier) {
        MIRClassifierMap mIRClassifierMap = mIRAliasClassifier.getDestinationOfClassifierMap();
        if (mIRClassifierMap == null || mIRClassifierMap.getSourceClassifierCount() != 1) {
            return null;
        }
        return mIRClassifierMap.getSourceClassifierIterator().next();
    }

    public static MIRFeature getSourceOfAliasFeature(MIRAliasFeature mIRAliasFeature) {
        MIRFeatureMap mIRFeatureMap = mIRAliasFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap == null || mIRFeatureMap.getSourceFeatureCount() != 1) {
            return null;
        }
        return mIRFeatureMap.getSourceFeatureIterator().next();
    }

    public static MIRJoinRole getLeftJoinRole(MIRJoin mIRJoin) {
        Iterator<MIRJoinRole> iterator = mIRJoin.getJoinRoleIterator();
        while (iterator.hasNext()) {
            MIRJoinRole mIRJoinRole = iterator.next();
            if (!mIRJoinRole.getLeft()) continue;
            return mIRJoinRole;
        }
        return null;
    }

    public static MIRJoinRole getRightJoinRole(MIRJoin mIRJoin) {
        Iterator<MIRJoinRole> iterator = mIRJoin.getJoinRoleIterator();
        while (iterator.hasNext()) {
            MIRJoinRole mIRJoinRole = iterator.next();
            if (mIRJoinRole.getLeft()) continue;
            return mIRJoinRole;
        }
        return null;
    }

    public static void setRelationshipLabel(MIRRelationship mIRRelationship, String string, MIRModel mIRModel) {
        if (mIRRelationship != null && mIRModel != null && string != null && !string.isEmpty()) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, mIRRelationship.getElementType(), "Label", (byte)0, "DataModeling", "", "SQL_VARCHAR", true);
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRRelationship);
        }
    }

    static boolean isEmptyPackage(MIRPackage mIRPackage) {
        if (mIRPackage.getNamespaceElementCount() == 0 && mIRPackage.getImportedNamespaceElementCount() == 0) {
            if (mIRPackage.getElementType() == 9) {
                return ((MIRDesignPackage)mIRPackage).getDiagramCount() == 0;
            }
            return true;
        }
        return false;
    }

    public static void deleteEmptyDesignPackages(MIRStoreModel mIRStoreModel) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{9});
        Set set = objectCollector.collect(mIRStoreModel);
        boolean bl = true;
        while (bl) {
            bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MIRDesignPackage mIRDesignPackage = (MIRDesignPackage)iterator.next();
                if (!MIRBridgeLib.isEmptyPackage(mIRDesignPackage)) continue;
                iterator.remove();
                bl = true;
                mIRDesignPackage.delete();
            }
        }
    }

    private static void deleteEmptyPackages(MIRPackage mIRPackage) {
        ArrayList<MIRPackage> arrayList = new ArrayList<MIRPackage>();
        for (MIRNamespaceElement mIRNamespaceElement : mIRPackage.getNamespaceElements()) {
            if (!mIRNamespaceElement.isInstanceOf((short)144)) continue;
            arrayList.add((MIRPackage)mIRNamespaceElement);
        }
        for (MIRPackage mIRPackage2 : arrayList) {
            MIRBridgeLib.deleteEmptyPackages(mIRPackage2);
        }
        boolean bl = MIRBridgeLib.isEmptyPackage(mIRPackage);
        if (mIRPackage.getElementType() == 72 && bl && mIRPackage.getAssociatedBusinessRuleCount() == 0 || mIRPackage.getElementType() != 72 && bl) {
            mIRPackage.delete();
        }
    }

    public static void deleteEmptyDataPackages(MIRStoreModel mIRStoreModel) {
        ArrayList<MIRDataPackage> arrayList = new ArrayList<MIRDataPackage>();
        arrayList.addAll(mIRStoreModel.getDataPackages());
        for (MIRStoreConnection mIRModelObject : mIRStoreModel.getStoreConnections()) {
            arrayList.addAll(mIRModelObject.getConnectionPackages());
        }
        for (MIRDataPackage mIRDataPackage : arrayList) {
            MIRBridgeLib.deleteEmptyPackages(mIRDataPackage);
        }
    }

    public static void deleteEmptyHierarchies(MIRStoreModel mIRStoreModel) {
        Object object22;
        ArrayList<MIRModelObject> arrayList = new ArrayList<MIRModelObject>();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{90});
        Set set = objectCollector.collect(mIRStoreModel);
        for (Object object22 : set) {
            if (((MIRHierarchy)object22).getHierarchyLevelAssociationCount() != 0) continue;
            arrayList.add((MIRModelObject)object22);
        }
        ObjectCollector objectCollector2 = new ObjectCollector(new short[]{108});
        object22 = objectCollector2.collect(mIRStoreModel);
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            MIRDrillPath mIRObject = (MIRDrillPath)iterator.next();
            if (mIRObject.getDrillPathLevelAssociationCount() != 0) continue;
            arrayList.add(mIRObject);
        }
        for (MIRObject mIRObject : arrayList) {
            mIRObject.delete();
        }
    }

    public static boolean isQuote(char c) {
        for (char c2 : quotes) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public static String removeQuotes(String string) {
        if (string == null || string.length() <= 2) {
            return string;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (MIRBridgeLib.isQuote(c) && MIRBridgeLib.isQuote(c2)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static MIRHierarchyLevelAssociation fetchHierarchyLevelAssociation(MIRHierarchy mIRHierarchy, MIRLevel mIRLevel, boolean bl) {
        MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation = null;
        for (MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation2 : mIRHierarchy.getHierarchyLevelAssociations()) {
            if (mIRHierarchyLevelAssociation2.getLevel() != mIRLevel) continue;
            mIRHierarchyLevelAssociation = mIRHierarchyLevelAssociation2;
            break;
        }
        if (mIRHierarchyLevelAssociation == null && bl) {
            mIRHierarchyLevelAssociation = new MIRHierarchyLevelAssociation();
            mIRHierarchyLevelAssociation.setName(mIRLevel.getName());
            mIRHierarchyLevelAssociation.addHierarchy(mIRHierarchy);
            mIRHierarchyLevelAssociation.addLevel(mIRLevel);
        }
        return mIRHierarchyLevelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileHeader(File file, String string) {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        char[] cArray = new char[1024];
        boolean bl = false;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        int n = 0;
        try {
            String string2;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("ASCII"));
            n = inputStreamReader.read(cArray, 0, 1024);
            if (n <= 0) {
                bl = false;
            }
            if ((string2 = new String(cArray)).indexOf(string) != -1) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private static void setModelModificationTime(MIRModel mIRModel, File file) {
        MIRDate mIRDate;
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                MIRBridgeLib.setModelModificationTime(mIRModel, file2);
            }
        } else if (file.isFile() && (mIRDate = new MIRDate(file.lastModified())).compareTo(mIRModel.getModificationTime()) > 0) {
            mIRModel.setModificationTime(mIRDate);
        }
    }

    public static void setModelModificationTime(MIRModel mIRModel, File[] fileArray) {
        if (mIRModel.getModificationTime().isNull()) {
            for (File file : fileArray) {
                if (file == null || !file.exists()) continue;
                MIRBridgeLib.setModelModificationTime(mIRModel, file);
            }
        }
    }

    public static MIRDate decodeErwinDate(String string) {
        if (string == null || string.isEmpty()) {
            return MIRDate.NONE;
        }
        try {
            double d = Double.parseDouble(string);
            double d2 = Math.signum(d) * Math.floor(Math.abs(d));
            double d3 = Math.abs(d - d2) * 24.0 * 60.0 * 60.0 * 1000.0;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1899, 11, 30, 0, 0, 0);
            calendar.add(5, (int)d2);
            calendar.add(14, (int)d3);
            MIRDate mIRDate = new MIRDate(calendar);
            return mIRDate;
        }
        catch (NumberFormatException numberFormatException) {
            return MIRDate.NONE;
        }
    }

    public static String encodeErwinDate(MIRDate mIRDate) {
        if (mIRDate.isNull()) {
            return "";
        }
        long l = mIRDate.get().getTimeInMillis() / 1000L;
        long l2 = l / 3600L / 24L;
        long l3 = l2 + 25569L;
        return Long.toString(l3);
    }

    public static void dispatchObjectToSubjectArea(MIRNamespaceElement mIRNamespaceElement) {
        MIRNamespace mIRNamespace = mIRNamespaceElement.getNamespace();
        if (mIRNamespace.getElementType() != 9) {
            return;
        }
        MIRDesignPackage mIRDesignPackage = MIRBridgeLib.getExclusiveSubjectArea(mIRNamespaceElement);
        if (mIRDesignPackage != null && mIRDesignPackage != mIRNamespace) {
            ((MIRDesignPackage)mIRNamespace).removeNamespaceElement(mIRNamespaceElement);
            ((MIRDesignPackage)mIRNamespace).addImportedNamespaceElement(mIRNamespaceElement);
            mIRDesignPackage.removeImportedNamespaceElement(mIRNamespaceElement);
            mIRDesignPackage.addNamespaceElementUniqueName(mIRNamespaceElement);
        }
    }

    public static MIRDesignPackage getExclusiveSubjectArea(MIRNamespaceElement mIRNamespaceElement) {
        MIRDesignPackage mIRDesignPackage = null;
        for (MIRPackage mIRPackage : mIRNamespaceElement.getImportedByPackages()) {
            MIRDesignPackage mIRDesignPackage2;
            if (mIRPackage.getElementType() != 9 || !(mIRDesignPackage2 = (MIRDesignPackage)mIRPackage).getUserDefined()) continue;
            if (mIRDesignPackage == null) {
                mIRDesignPackage = (MIRDesignPackage)mIRPackage;
                continue;
            }
            return null;
        }
        return mIRDesignPackage;
    }

    private static void deleteDuplicateColumns(MIRClass mIRClass, String string, MIRLogger mIRLogger) {
        MIRAttribute mIRAttribute;
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (MIRFeature mIRModelObject2 : mIRClass.getFeatures()) {
            Iterator iterator = MIRBridgeLib.getPhysicalName(mIRModelObject2);
            if (mIRModelObject2.getDesignLevel() == 1 || !((String)((Object)iterator)).equals(string)) continue;
            arrayList.add(mIRModelObject2);
        }
        Object object = null;
        MIRCandidateKey mIRCandidateKey = mIRClass.getPrimaryCandidateKey();
        if (mIRCandidateKey != null) {
            for (MIRFeature mIRFeature : arrayList) {
                if (mIRFeature.getElementType() != 14 || !mIRCandidateKey.containsAttribute(mIRAttribute = (MIRAttribute)mIRFeature)) continue;
                object = mIRAttribute;
                break;
            }
        }
        if (object == null) {
            for (MIRFeature mIRFeature : arrayList) {
                if (mIRFeature.getElementType() != 14) continue;
                mIRAttribute = (MIRAttribute)mIRFeature;
                for (MIRKey mIRKey : mIRAttribute.getKeys()) {
                    if (mIRKey.getElementType() != 21) continue;
                    object = mIRAttribute;
                    break;
                }
                if (object == null) continue;
                break;
            }
        }
        if (object == null && arrayList.size() > 0) {
            object = (MIRAttribute)arrayList.get(0);
        }
        for (MIRFeature mIRFeature : arrayList) {
            if (mIRFeature.getElementType() != 14 || (mIRAttribute = (MIRAttribute)mIRFeature) == object) continue;
            MIRBridgeLib.mergeDuplicateColumn(mIRClass, (MIRAttribute)object, mIRAttribute, mIRLogger);
        }
    }

    private static void deleteDuplicateColumns(MIRClass mIRClass, MIRLogger mIRLogger) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (MIRFeature object : mIRClass.getFeatures()) {
            String string = MIRBridgeLib.getPhysicalName(object);
            if (object.getDesignLevel() == 1) continue;
            if (hashSet.contains(string)) {
                hashSet2.add(string);
                continue;
            }
            hashSet.add(string);
        }
        for (String string : hashSet2) {
            BLIB.WRN_DUPLICATE_COLUMN_NAME.log(mIRLogger, mIRClass.getName(), string);
            MIRBridgeLib.deleteDuplicateColumns(mIRClass, string, mIRLogger);
        }
    }

    public static void deleteDuplicateColumns(MIRStoreModel mIRStoreModel, MIRLogger mIRLogger) throws MIRException {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{13});
        mIRStoreModel.depthTraversal(objectCollector);
        TreeSet<MIRClass> treeSet = new TreeSet<MIRClass>(new Comparator<MIRClass>(){

            @Override
            public int compare(MIRClass mIRClass, MIRClass mIRClass2) {
                String string;
                String string2 = MIRBridgeLib.getPhysicalName(mIRClass);
                if (string2.compareTo(string = MIRBridgeLib.getPhysicalName(mIRClass2)) == 0) {
                    return -1;
                }
                return string2.compareTo(string);
            }
        });
        treeSet.addAll(objectCollector.getObjects());
        for (MIRClass mIRClass : treeSet) {
            if (mIRClass.getDesignLevel() == 1) continue;
            MIRBridgeLib.deleteDuplicateColumns(mIRClass, mIRLogger);
        }
    }

    public static void mergeDuplicateColumn(MIRClass mIRClass, MIRAttribute mIRAttribute, MIRAttribute mIRAttribute2, MIRLogger mIRLogger) {
        MIRElement mIRElement;
        TreeSet<MIRIndexMember> treeSet = new TreeSet<MIRIndexMember>(mIRAttribute2.getIndexMembers());
        for (MIRIndexMember object2 : treeSet) {
            mIRElement = object2.getIndex();
            boolean bl = false;
            for (MIRModelObject mIRModelObject : ((MIRIndex)mIRElement).getIndexMembers()) {
                if (mIRModelObject.getAttribute() != mIRAttribute) continue;
                bl = true;
                break;
            }
            if (bl) {
                object2.delete();
                continue;
            }
            object2.removeAttribute();
            object2.addAttribute(mIRAttribute);
        }
        TreeSet<MIRKey> treeSet2 = new TreeSet<MIRKey>(mIRAttribute2.getKeys());
        Iterator iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            mIRElement = (MIRKey)iterator.next();
            if (((MIRKey)mIRElement).getElementType() == 22) {
                MIRModelObject mIRModelObject;
                MIRForeignKey mIRForeignKey = (MIRForeignKey)mIRElement;
                MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
                mIRModelObject = null;
                MIRAssociationRoleNameMap mIRAssociationRoleNameMap = null;
                for (MIRAssociationRoleNameMap mIRAssociationRoleNameMap2 : mIRAttribute2.getDestinationOfAssociationRoleNameMaps()) {
                    if (mIRAssociationRoleNameMap2.getForeignKey() != mIRForeignKey) continue;
                    mIRModelObject = mIRAssociationRoleNameMap2.getSourceAttribute();
                    mIRAssociationRoleNameMap = mIRAssociationRoleNameMap2;
                    break;
                }
                if (mIRModelObject == null) {
                    for (MIRAttribute mIRAttribute3 : mIRCandidateKey.getAttributes()) {
                        if (!mIRAttribute3.getName().equals(mIRAttribute2.getName())) continue;
                        mIRModelObject = mIRAttribute3;
                        break;
                    }
                }
                if (mIRModelObject != null) {
                    if (!mIRModelObject.getName().equals(mIRAttribute.getName())) {
                        MIRRelationalLib.createARNM((MIRAttribute)mIRModelObject, mIRAttribute, mIRForeignKey, false);
                    }
                    if (mIRAssociationRoleNameMap != null) {
                        mIRAssociationRoleNameMap.delete();
                    }
                }
            }
            ((MIRKey)mIRElement).removeAttribute(mIRAttribute2);
            if (((MIRKey)mIRElement).containsAttribute(mIRAttribute)) continue;
            ((MIRKey)mIRElement).addAttribute(mIRAttribute);
        }
        while (mIRAttribute2.getDestinationOfAssociationRoleNameMapCount() > 0) {
            MIRAssociationRoleNameMap mIRAssociationRoleNameMap = mIRAttribute2.getDestinationOfAssociationRoleNameMaps().first();
            mIRAssociationRoleNameMap.removeDestinationAttribute();
            mIRAssociationRoleNameMap.addDestinationAttribute(mIRAttribute);
        }
        while (mIRAttribute2.getSourceOfAssociationRoleNameMapCount() > 0) {
            MIRAssociationRoleNameMap mIRAssociationRoleNameMap = mIRAttribute2.getSourceOfAssociationRoleNameMaps().first();
            mIRAssociationRoleNameMap.removeSourceAttribute();
            mIRAssociationRoleNameMap.addSourceAttribute(mIRAttribute);
        }
        while (mIRAttribute2.getClientOfElementMapCount() > 0) {
            MIRElementMap mIRElementMap = mIRAttribute2.getClientOfElementMaps().first();
            while (mIRElementMap.getSupplierElementCount() > 0) {
                mIRElement = mIRElementMap.getSupplierElements().first();
                mIRElement.removeSupplierOfElementMap(mIRElementMap);
                if (mIRElement.getSupplierOfElementMapCount() != 0) continue;
                mIRElement.delete();
            }
            mIRElementMap.removeClientElement();
            mIRElementMap.delete();
        }
        mIRAttribute2.removeType();
        while (mIRAttribute2.getPropertyValueCount() > 0) {
            MIRPropertyValue mIRPropertyValue = mIRAttribute2.getPropertyValues().first();
            mIRAttribute2.removePropertyValue(mIRPropertyValue);
            mIRPropertyValue.delete();
        }
        while (mIRAttribute2.getDestinationOfFeatureMapCount() > 0) {
            MIRFeatureMap mIRFeatureMap = mIRAttribute2.getDestinationOfFeatureMap();
            mIRAttribute2.removeDestinationOfFeatureMap(mIRFeatureMap);
            mIRFeatureMap.delete();
        }
        mIRAttribute2.removeClassifier();
        mIRAttribute2.delete();
    }

    public static void renameDuplicateFeatures(MIRClassifier mIRClassifier, MIRLogger mIRLogger, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        TreeSet<MIRFeature> treeSet = new TreeSet<MIRFeature>(mIRClassifier.getFeatures());
        for (MIRFeature mIRFeature : treeSet) {
            String string2;
            String string3 = MIRBridgeLib.getPhysicalName(mIRFeature);
            if (!hashSet.contains(string3)) {
                hashSet.add(string3);
                continue;
            }
            int n = 1;
            while (hashSet.contains(string2 = String.format("%s%s%d", string3, string, n++))) {
            }
            if (mIRFeature.getDesignLevel() != 1 && !mIRFeature.getPhysicalName().isEmpty()) {
                BLIB.WRN_RENAMING_DUPLICATE_COLUMN_NAME.log(mIRLogger, MIRBridgeLib.getPhysicalName(mIRClassifier), string3);
            }
            hashSet.add(string2);
            mIRFeature.setPhysicalName(string2);
        }
    }

    public static void renameDuplicateFeatures(MIRModel mIRModel, MIRLogger mIRLogger) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{75});
        Set set = objectCollector.collect(mIRModel);
        for (MIRClassifier mIRClassifier : set) {
            MIRBridgeLib.renameDuplicateFeatures(mIRClassifier, mIRLogger, "/");
        }
    }

    public static String trimSpaces(String string) {
        int n;
        int n2;
        if (string == null || string.isEmpty()) {
            return "";
        }
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 == string.length()) {
            return "";
        }
        for (n = string.length() - 1; n > 0 && string.charAt(n) == ' '; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static File makeTempFile(String string, String string2) throws MIRException {
        return MIRBridgeLib.makeTempFile(MIRSetup.getDefault().getTempDirectory(), string, string2);
    }

    public static File makeTempFile(File file, String string, String string2) throws MIRException {
        File file2 = null;
        try {
            file2 = File.createTempFile(string, string2, file);
        }
        catch (IOException iOException) {
            String string3 = new File(file, string + string2).getAbsolutePath();
            throw new MIRException(BLIB.WRN_FILE_NOT_OPENED.getMessage(string3), iOException);
        }
        return file2;
    }

    public static File makeTempDir(String string) throws MIRException {
        return MIRBridgeLib.makeTempDir(MIRSetup.getDefault().getTempDirectory(), string);
    }

    public static File makeTempDir(File file, String string) throws MIRException {
        try {
            Path path = Files.createTempDirectory(file.toPath(), string, new FileAttribute[0]);
            return path.toFile();
        }
        catch (IOException iOException) {
            String string2 = BLIB.ERR_CANNOT_CREATE_TEMP_DIR.getMessage(file.getAbsolutePath(), iOException.getMessage());
            throw new MIRException(string2, iOException);
        }
    }

    public static boolean downloadWebPageToFile(URL uRL, File file, String string, MIRLogger mIRLogger) {
        return MIRBridgeLib.downloadWebPageToFile(uRL, file, string, null, mIRLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadWebPageToFile(URL uRL, File file, String string, Proxy proxy, MIRLogger mIRLogger) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = RestUtil.openConnection(uRL, proxy);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("User-Agent", string);
            httpURLConnection.setConnectTimeout(20000);
            httpURLConnection.setReadTimeout(20000);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());){
                    RestUtil.downloadFile(bufferedInputStream, file);
                }
                boolean bl = true;
                return bl;
            }
            BLIB.DBG_ERROR_DOWNLOADING_FROM_URL.log(mIRLogger, uRL.toString(), String.valueOf(n));
        }
        catch (IOException | IllegalStateException | GeneralSecurityException exception) {
            BLIB.DBG_ERROR_DOWNLOADING_FROM_URL.log(mIRLogger, exception, uRL.toString(), exception.getMessage());
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return false;
    }

    public static void removeInvalidXmlChars(File file, File file2) throws MIRException {
        MIRBridgeLib.removeInvalidXmlChars(file, file2, Charset.defaultCharset(), null);
    }

    public static void removeInvalidXmlChars(File file, File file2, Charset charset, BiConsumer<String, String> biConsumer) throws MIRException {
        try {
            String string;
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset));
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
            String string3 = string = bufferedReader.readLine();
            while (string != null) {
                string = string.replaceAll(string2, "_");
                string = string.replaceAll("&(?!.{2,4};)", "&amp;");
                if (biConsumer != null && !string3.equals(string)) {
                    biConsumer.accept(string3, string);
                }
                bufferedWriter.write(string);
                string3 = string = bufferedReader.readLine();
                if (string == null) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            ((Reader)inputStreamReader).close();
        }
        catch (IOException iOException) {
            String string = BLIB.DBG_ERROR_REMOVE_INVALID_CHARS.getMessage(file.getAbsolutePath(), file2.getAbsolutePath());
            throw new MIRException(string, iOException);
        }
    }

    public static void setUiId(MIRModel mIRModel, MIRElement mIRElement, String string) {
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, mIRElement.getElementType(), "UI ID", (byte)0, "BI", "", "SQL_VARCHAR", true, "");
        MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRElement);
    }

    public static void setUiId(MIRModel mIRModel, MIRElement mIRElement, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u2028");
            }
            stringBuilder.append(string);
        }
        MIRBridgeLib.setUiId(mIRModel, mIRElement, stringBuilder.toString());
    }

    public static void setViewerUrlID(MIRModel mIRModel, MIRElement mIRElement, String string) {
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, mIRElement.getElementType(), "URL ID", (byte)0, "BI", "", "SQL_VARCHAR", true);
        MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRElement);
    }

    @SafeVarargs
    public static HashSet<MIRObject> combineSets(SortedSet<? extends MIRObject> ... sortedSetArray) {
        HashSet<MIRObject> hashSet = new HashSet<MIRObject>();
        for (SortedSet<? extends MIRObject> sortedSet : sortedSetArray) {
            hashSet.addAll(sortedSet);
        }
        return hashSet;
    }

    public static MIRStoreConnection getStoreConnection(MIRConnectionDataPackage mIRConnectionDataPackage) {
        if (mIRConnectionDataPackage.isInstanceOf((short)215)) {
            return ((MIRConnectionPackage)mIRConnectionDataPackage).getStoreConnection();
        }
        MIRObject mIRObject = mIRConnectionDataPackage;
        while (mIRObject.getParent() != null) {
            if (!(mIRObject = mIRObject.getParent()).isInstanceOf((short)216)) continue;
            return (MIRStoreConnection)mIRObject;
        }
        return null;
    }

    public static byte getStoreType(MIRObject mIRObject) {
        while (mIRObject != null) {
            if (mIRObject instanceof MIRClassifier) {
                MIRClassifier mIRClassifier = (MIRClassifier)mIRObject;
                if (mIRClassifier.getConnectionDataPackage() != null) {
                    mIRObject = mIRClassifier.getConnectionDataPackage();
                    continue;
                }
                if (mIRClassifier.getDataPackage() != null) {
                    mIRObject = mIRClassifier.getDataPackage();
                    continue;
                }
                mIRObject = mIRObject.getParent();
                continue;
            }
            if (mIRObject instanceof MIRStoreModel) {
                return ((MIRStoreModel)mIRObject).getStoreType();
            }
            if (mIRObject instanceof MIRStoreConnection) {
                return ((MIRStoreConnection)mIRObject).getStoreType();
            }
            mIRObject = mIRObject.getParent();
        }
        return -1;
    }

    public static MIRConnectionNamespace getConnectionNamespace(MIRModel mIRModel, String string, StringBuilder stringBuilder) {
        FileConnectionOptions fileConnectionOptions = new FileConnectionOptions();
        return MIRBridgeLib.getConnectionNamespace(mIRModel, string, fileConnectionOptions, stringBuilder);
    }

    public static MIRStoreContent getFlatFileStoreContent(MIRDirectoryStructureModel mIRDirectoryStructureModel, String string) {
        MIRStoreModel mIRStoreModel;
        MIRStoreContent mIRStoreContent;
        StringBuilder stringBuilder = new StringBuilder();
        FileConnectionOptions fileConnectionOptions = new FileConnectionOptions();
        String string2 = MIRBridgeLib.getFileConnectionName(string, null, stringBuilder, fileConnectionOptions);
        if (string2.isEmpty()) {
            string2 = FLAT_FILE_WORKING_DIR;
        }
        if ((mIRStoreContent = mIRDirectoryStructureModel.getConnectionStoreContent(string2)) == null) {
            mIRStoreContent = new MIRStoreContent();
            mIRStoreContent.setName(string2);
            mIRDirectoryStructureModel.addConnectionStoreContent(mIRStoreContent);
        }
        if ((mIRStoreModel = (MIRStoreModel)mIRStoreContent.getModel()) == null) {
            mIRStoreModel = new MIRStoreModel();
            mIRStoreModel.setName(string2);
            mIRStoreModel.setStoreType((byte)2);
            mIRStoreModel.setSystemType("FILE");
            mIRStoreContent.addModel(mIRStoreModel);
        }
        return mIRStoreContent;
    }

    public static MIRFlatTextFile getFlatFile(MIRDirectoryStructureModel mIRDirectoryStructureModel, String string) {
        MIRStoreModel mIRStoreModel;
        MIRStoreContent mIRStoreContent;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        FileConnectionOptions fileConnectionOptions = new FileConnectionOptions();
        String string2 = MIRBridgeLib.getFileConnectionName(string, stringBuilder, stringBuilder2, fileConnectionOptions);
        if (string2.isEmpty()) {
            string2 = FLAT_FILE_WORKING_DIR;
        }
        if ((mIRStoreContent = mIRDirectoryStructureModel.getConnectionStoreContent(string2)) == null) {
            mIRStoreContent = new MIRStoreContent();
            mIRStoreContent.setName(string2);
        }
        if ((mIRStoreModel = (MIRStoreModel)mIRStoreContent.getModel()) == null) {
            mIRStoreModel = new MIRStoreModel();
            mIRStoreModel.setName(string2);
            mIRStoreModel.setStoreType((byte)2);
            mIRStoreModel.setSystemType("FILE");
        }
        MIRNamespace mIRNamespace = null;
        Object object = stringBuilder.toString().split("/");
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            MIRNamespaceElement mIRNamespaceElement;
            String string3 = object[i];
            MIRNamespaceElement mIRNamespaceElement2 = mIRNamespaceElement = mIRNamespace == null ? mIRStoreModel.getDataPackage(string3) : mIRNamespace.getNamespaceElement(string3);
            if (mIRNamespaceElement == null) {
                MIRFileDirectory mIRFileDirectory = new MIRFileDirectory();
                mIRFileDirectory.setName(string3);
                if (mIRNamespace == null) {
                    mIRStoreModel.addDataPackage(mIRFileDirectory);
                } else {
                    mIRNamespace.addNamespaceElement(mIRFileDirectory);
                }
                mIRNamespace = mIRFileDirectory;
                continue;
            }
            if (mIRNamespaceElement.isInstanceOf((short)207)) {
                mIRNamespace = (MIRFileDirectory)mIRNamespaceElement;
                continue;
            }
            throw new InvalidParameterException();
        }
        if (mIRNamespace == null) {
            object = mIRStoreModel.getDataPackage("");
            if (object != null && ((MIR_Object)object).isInstanceOf((short)207)) {
                mIRNamespace = (MIRFileDirectory)object;
            }
            if (mIRNamespace == null) {
                mIRNamespace = new MIRFileDirectory();
                mIRNamespace.setName("");
                mIRStoreModel.addDataPackage((MIRDataPackage)mIRNamespace);
            }
        }
        if ((object = mIRNamespace.getNamespaceElement(stringBuilder2.toString())) != null) {
            if (((MIR_Object)object).isInstanceOf((short)209)) {
                return (MIRFlatTextFile)object;
            }
            throw new InvalidParameterException();
        }
        object = new MIRFlatTextFile();
        ((MIRObject)object).setName(stringBuilder2.toString());
        mIRNamespace.addNamespaceElement((MIRNamespaceElement)object);
        return (MIRFlatTextFile)object;
    }

    public static String getFilePath(MIRElement mIRElement) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        MIRObject mIRObject = null;
        if (mIRElement.isInstanceOf((short)75)) {
            mIRObject = mIRElement.getParent().isInstanceOf((short)141) ? mIRElement.getParent() : (((MIRClassifier)mIRElement).getImportedByPackageCount() == 1 ? (MIRObject)((MIRClassifier)mIRElement).getImportedByPackages().first() : ((MIRClassifier)mIRElement).getConnectionDataPackage());
            stringBuilder.append(mIRElement.getName());
        } else if (mIRElement.isInstanceOf((short)141)) {
            mIRObject = mIRElement;
            if (mIRElement.isInstanceOf((short)207) && ((object = mIRElement.getRootModel()) == null || !((MIR_Object)object).isInstanceOf((short)2) || ((MIRStoreModel)object).getStoreType() != 2)) {
                mIRObject = null;
            }
        }
        while (mIRObject != null) {
            if (!(mIRObject.isInstanceOf((short)198) && mIRObject.getName().equals(FLAT_FILE_FAKE_ROOT) && ((MIRNamespace)mIRObject).getNativeType().equals(FLAT_FILE_FAKE_ROOT))) {
                if (mIRObject.isInstanceOf((short)216) && mIRObject.getName().equals(FLAT_FILE_WORKING_DIR) || !mIRObject.isInstanceOf((short)141) && !mIRObject.isInstanceOf((short)216) && !mIRObject.isInstanceOf((short)2)) break;
                if (!(stringBuilder.length() <= 0 || (mIRObject.isInstanceOf((short)216) || mIRObject.isInstanceOf((short)2)) && mIRObject.getName().endsWith("\\"))) {
                    stringBuilder.insert(0, "/");
                }
                stringBuilder.insert(0, mIRObject.getName());
            }
            if (!mIRObject.isInstanceOf((short)321) && !mIRObject.isInstanceOf((short)207)) break;
            mIRObject = mIRObject.getParent();
        }
        if (((String)(object = stringBuilder.toString())).indexOf("\\") >= 0) {
            object = ((String)object).replace("/", "\\");
        }
        return object;
    }

    public static MIRConnectionNamespace getConnectionNamespace(MIRModel mIRModel, String string, FileConnectionOptions fileConnectionOptions, StringBuilder stringBuilder) {
        MIRStoreConnection mIRStoreConnection;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = MIRBridgeLib.getFileConnectionName(string, stringBuilder2, stringBuilder, fileConnectionOptions);
        if (string2.isEmpty()) {
            string2 = fileConnectionOptions.getDefaultConnectionName();
        }
        if ((mIRStoreConnection = mIRModel.getStoreConnection(string2)) == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string2);
            mIRStoreConnection.setStoreType((byte)2);
            mIRStoreConnection.setSystemType("FILE");
            mIRModel.addStoreConnection(mIRStoreConnection);
        }
        return MIRBridgeLib.getConnectionNamespace(mIRStoreConnection, string, fileConnectionOptions, stringBuilder);
    }

    public static MIRConnectionNamespace getConnectionNamespace(MIRStoreConnection mIRStoreConnection, String string, FileConnectionOptions fileConnectionOptions, StringBuilder stringBuilder) {
        String[] stringArray;
        MIRConnectionNamespace mIRConnectionNamespace;
        StringBuilder stringBuilder2 = new StringBuilder();
        MIRBridgeLib.getFileConnectionName(string, stringBuilder2, stringBuilder, fileConnectionOptions);
        MIRConnectionNamespace mIRConnectionNamespace2 = mIRConnectionNamespace = MIRBridgeLib.createFakeRootNamespace(mIRStoreConnection);
        for (String string2 : stringArray = stringBuilder2.toString().split("[/\\\\]")) {
            if (string2.isEmpty()) continue;
            if (string2.equals("..")) {
                if (mIRConnectionNamespace2 == mIRConnectionNamespace) continue;
                mIRConnectionNamespace2 = (MIRConnectionNamespace)mIRConnectionNamespace2.getNamespace();
                continue;
            }
            MIRNamespaceElement mIRNamespaceElement = mIRConnectionNamespace2.getNamespaceElement(string2);
            if (mIRNamespaceElement == null) {
                MIRConnectionNamespace mIRConnectionNamespace3 = new MIRConnectionNamespace();
                mIRConnectionNamespace3.setNativeType(fileConnectionOptions.getNativeType());
                mIRConnectionNamespace3.setName(string2);
                mIRConnectionNamespace2.addNamespaceElement(mIRConnectionNamespace3);
                mIRConnectionNamespace2 = mIRConnectionNamespace3;
                continue;
            }
            if (mIRNamespaceElement.isInstanceOf((short)321)) {
                mIRConnectionNamespace2 = (MIRConnectionNamespace)mIRNamespaceElement;
                continue;
            }
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("ConnectionNamespace", mIRConnectionNamespace2.getPath(), MIRElementType.getName(mIRNamespaceElement.getElementType()), "Name", string2));
        }
        return mIRConnectionNamespace2;
    }

    public static MIRConnectionNamespace createFakeRootNamespace(MIRStoreConnection mIRStoreConnection) {
        MIRConnectionNamespace mIRConnectionNamespace = null;
        MIRConnectionNamespace mIRConnectionNamespace2 = mIRStoreConnection.getConnectionNamespace(FLAT_FILE_FAKE_ROOT);
        if (mIRConnectionNamespace2 != null && mIRConnectionNamespace2.isInstanceOf((short)321)) {
            mIRConnectionNamespace = mIRConnectionNamespace2;
        }
        if (mIRConnectionNamespace == null) {
            mIRConnectionNamespace = new MIRConnectionNamespace();
            mIRConnectionNamespace.setNativeType(FLAT_FILE_FAKE_ROOT);
            mIRConnectionNamespace.setName(FLAT_FILE_FAKE_ROOT);
            mIRStoreConnection.addConnectionNamespace(mIRConnectionNamespace);
        }
        return mIRConnectionNamespace;
    }

    public static String getFileConnectionName(String string, StringBuilder stringBuilder, StringBuilder stringBuilder2, FileConnectionOptions fileConnectionOptions) {
        int n;
        int n2;
        String string2 = "";
        String string3 = "";
        boolean bl = string.indexOf("\\") >= 0 && !string.startsWith("/");
        String string4 = string.replace("\\", "/");
        String string5 = "";
        int n3 = string4.indexOf(":");
        if (n3 > 0 && n3 + 1 < string4.length()) {
            n2 = string4.substring(n3 + 1).startsWith("//") ? 1 : 0;
            if (bl && n2 != 0 && n3 > 1) {
                bl = false;
            }
            if (!bl && n2 != 0) {
                n = 2;
                int n4 = n3 + 1;
                char[] cArray = string4.toCharArray();
                while (n4 + n < cArray.length && !bl && cArray[n4 + n] == '/') {
                    ++n;
                }
                string3 = string4.substring(n3 + 1 + n);
            } else {
                string3 = n3 != 1 && string4.substring(n3 + 1).startsWith("/") ? string4.substring(n3 + 2) : string4.substring(n3 + 1);
            }
            if (n3 != 1) {
                n = string3.indexOf("/");
                if (n >= 0) {
                    string3 = string3.substring(n);
                } else {
                    string2 = string4;
                    string3 = "";
                }
            }
            if (string2.isEmpty()) {
                string2 = string4.substring(0, string4.length() - string3.length());
            }
            if (string2.length() == 2 && string2.endsWith(":")) {
                string2 = string2 + "\\";
            }
        } else if (!bl && string4.startsWith("/")) {
            string2 = "/";
            string3 = string4.substring(1);
        } else if (bl && string4.startsWith("//")) {
            n2 = string4.indexOf("/", 2);
            string2 = "\\\\" + string4.substring(2, n2 >= 0 ? n2 : string4.length());
            string3 = string4.substring(string2.length());
        } else {
            string3 = string4;
        }
        if (!fileConnectionOptions.isAllowMergeByHostname()) {
            string2 = string;
        }
        if (!string3.endsWith("/")) {
            n2 = string3.lastIndexOf("/");
            if (n2 >= 0) {
                string5 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2);
                int n5 = n = fileConnectionOptions.isPartitional() && (string5.indexOf("*") > -1 || string5.indexOf("?") > -1) ? 1 : 0;
                if (n != 0) {
                    n2 = (string3 = string3.replaceAll("\\/$", "")).replaceAll("\\/$", "").lastIndexOf("/", n2);
                    if (n2 >= 0) {
                        string5 = string3.substring(n2 + 1);
                        string3 = string3.substring(0, n2);
                    } else {
                        string5 = string3;
                        string3 = "";
                    }
                }
            } else {
                string5 = string3;
                string3 = "";
            }
        }
        if (stringBuilder2 != null) {
            stringBuilder2.setLength(0);
            stringBuilder2.append(string5);
        }
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(string3);
        }
        return string2;
    }

    public static MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, short s) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getPosition() != s) continue;
            return mIRFeature;
        }
        return null;
    }

    public static void setStoreConnectionsModelKey(MIRDirectoryStructureModel mIRDirectoryStructureModel) throws MIRException {
        for (MIRStoreContent mIRFolderContent : mIRDirectoryStructureModel.getConnectionStoreContents()) {
            MIRBridgeLib.setModelKey(mIRFolderContent);
        }
        for (MIRFolderContent mIRFolderContent : mIRDirectoryStructureModel.getFolderContents()) {
            if (!mIRFolderContent.isInstanceOf((short)343)) continue;
            MIRBridgeLib.setModelKey((MIRContent)mIRFolderContent);
            break;
        }
    }

    public static void setModelKey(MIRContent mIRContent3) {
        StringDigest stringDigest = StringDigest.getMd5().update(mIRContent3.getModelKey());
        ArrayList<MIRContent> arrayList = new ArrayList<MIRContent>();
        if (mIRContent3.isInstanceOf((short)295)) {
            for (MIRConnection mIRObject : ((MIRStoreContent)mIRContent3).getSupplierOfConnections()) {
                arrayList.add(mIRObject.getClientContent());
            }
        } else if (mIRContent3.isInstanceOf((short)343)) {
            for (MIRConnection mIRConnection : ((MIRLineageSummaryContent)mIRContent3).getClientOfConnections()) {
                arrayList.add(mIRConnection.getSupplierStoreContent());
            }
        }
        Collections.sort(arrayList, (mIRContent, mIRContent2) -> mIRContent.getPath().compareTo(mIRContent2.getPath()));
        for (MIRContent mIRContent4 : arrayList) {
            stringDigest.update(mIRContent4.getModelKey());
        }
        mIRContent3.setModelKey(stringDigest.toString());
    }

    public static MIRPhysicalTarget getPhysicalTarget(MIRStoreModel mIRStoreModel, byte by, boolean bl) {
        MIRPhysicalTarget mIRPhysicalTarget = null;
        for (MIRPhysicalTarget mIRPhysicalTarget2 : mIRStoreModel.getPhysicalTargets()) {
            if (mIRPhysicalTarget2.getTargetType() != by) continue;
            mIRPhysicalTarget = mIRPhysicalTarget2;
            break;
        }
        if (mIRPhysicalTarget == null && bl) {
            mIRPhysicalTarget = new MIRPhysicalTarget();
            mIRPhysicalTarget.setName(MIRPhysicalTargetType.toCppString(by));
            mIRPhysicalTarget.setTargetType(by);
            mIRStoreModel.addPhysicalTargetUniqueName(mIRPhysicalTarget);
        }
        return mIRPhysicalTarget;
    }

    public static String getOperationUniqueName(MIROperation mIROperation) {
        String string = mIROperation.getName();
        String string2 = MIRBridgeLib.getOperationSignature(mIROperation);
        String string3 = string + string2;
        return string3;
    }

    public static String getOperationSignature(MIROperation mIROperation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        boolean bl = true;
        for (MIRArgument mIRArgument : mIROperation.getArgumentByPosition()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = MIRBridgeLib.getOperationArgumentSignature(mIRArgument);
            stringBuilder.append(string);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getOperationArgumentSignature(MIRArgument mIRArgument) {
        String string = MIRBridgeLib.getPhysicalName(mIRArgument);
        String string2 = "";
        MIRType mIRType = mIRArgument.getType();
        if (mIRType != null) {
            String string3 = string2 = mIRType.getNativeDataType().isEmpty() ? mIRType.getName() : mIRType.getNativeDataType();
        }
        if (string2.isEmpty()) {
            return string;
        }
        return string2;
    }

    public static class GlobMatcher {
        protected FileSystem fileSystem;
        protected PathMatcher pathMatcher;

        public GlobMatcher(String string) {
            if (string == null || string.isEmpty()) {
                string = "*";
            }
            string = string.replace(";", ",");
            while (string.contains(", ")) {
                string = string.replace(", ", ",");
            }
            while (string.contains(" ,")) {
                string = string.replace(" ,", ",");
            }
            if (string.contains(",")) {
                if (!string.contains("{")) {
                    string = "{" + string;
                }
                if (!string.contains("}")) {
                    string = string + "}";
                }
            }
            this.fileSystem = FileSystems.getDefault();
            this.pathMatcher = this.fileSystem.getPathMatcher("glob:" + string);
        }

        public boolean match(String string) {
            return this.pathMatcher.matches(this.fileSystem.getPath(string, new String[0]));
        }
    }

    public static class FileConnectionOptions {
        private String defaultConnectionName = "Working directory";
        private String nativeType = "";
        private boolean partitional = false;
        private boolean allowMergeByHostname = true;

        public String getDefaultConnectionName() {
            return this.defaultConnectionName;
        }

        public void setDefaultConnectionName(String string) {
            this.defaultConnectionName = string;
        }

        public String getNativeType() {
            return this.nativeType;
        }

        public void setNativeType(String string) {
            this.nativeType = string;
        }

        public boolean isPartitional() {
            return this.partitional;
        }

        public void setPartitional(boolean bl) {
            this.partitional = bl;
        }

        public boolean isAllowMergeByHostname() {
            return this.allowMergeByHostname;
        }

        public void setAllowMergeByHostname(boolean bl) {
            this.allowMergeByHostname = bl;
        }
    }

    public static class EntityComparator
    implements Comparator<MIRClass> {
        @Override
        public int compare(MIRClass mIRClass, MIRClass mIRClass2) {
            if (this.isAncestor(mIRClass, mIRClass2)) {
                return -1;
            }
            if (this.isDescendant(mIRClass, mIRClass2)) {
                return 1;
            }
            return mIRClass.getName().compareTo(mIRClass2.getName());
        }

        private boolean isAncestor(MIRClass mIRClass, MIRClass mIRClass2) {
            if (mIRClass.getGeneralizationRoleCount() > 0 && mIRClass2.getGeneralizationRoleCount() > 0) {
                Iterator<MIRGeneralizationRole> iterator = mIRClass2.getGeneralizationRoleIterator();
                while (iterator.hasNext()) {
                    MIRGeneralization mIRGeneralization = iterator.next().getSubtypeOfGeneralization();
                    if (mIRGeneralization == null) continue;
                    Iterator<MIRGeneralizationRole> iterator2 = mIRGeneralization.getSupertypeGeneralizationRoleIterator();
                    while (iterator2.hasNext()) {
                        MIRClass mIRClass3 = iterator2.next().getAssociatedClass();
                        boolean bl = false;
                        bl = mIRClass == mIRClass3 ? true : this.isAncestor(mIRClass, mIRClass3);
                        if (!bl) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isDescendant(MIRClass mIRClass, MIRClass mIRClass2) {
            return this.isAncestor(mIRClass2, mIRClass);
        }
    }

    public static class OrderedSQLViewAssVector
    implements Comparator<MIRSQLViewAssociation> {
        @Override
        public int compare(MIRSQLViewAssociation mIRSQLViewAssociation, MIRSQLViewAssociation mIRSQLViewAssociation2) {
            if (mIRSQLViewAssociation.getSQLTableSequence() - mIRSQLViewAssociation2.getSQLTableSequence() == 0) {
                return mIRSQLViewAssociation.getSourceClassifier().getName().compareTo(mIRSQLViewAssociation2.getSourceClassifier().getName());
            }
            return mIRSQLViewAssociation.getSQLTableSequence() - mIRSQLViewAssociation2.getSQLTableSequence();
        }
    }
}

